/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation;

import org.evosuite.instrumentation.LineNumberMethodAdapter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YieldAtLineNumberMethodAdapter
extends MethodVisitor {
    private static Logger logger = LoggerFactory.getLogger(LineNumberMethodAdapter.class);
    private final String className;
    private final String methodName;
    private boolean hadInvokeSpecial = false;
    int currentLine = 0;

    public YieldAtLineNumberMethodAdapter(MethodVisitor mv, String className, String methodName) {
        super(327680, mv);
        this.className = className;
        this.methodName = methodName;
        if (!methodName.equals("<init>")) {
            this.hadInvokeSpecial = true;
        }
    }

    public void visitLineNumber(int line, Label start) {
        super.visitLineNumber(line, start);
        this.currentLine = line;
        if (this.methodName.equals("<clinit>")) {
            return;
        }
        if (!this.hadInvokeSpecial) {
            return;
        }
        this.mv.visitMethodInsn(184, "org/evosuite/testcase/execution/ExecutionTracer", "checkTimeout", "()V", false);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (opcode == 183 && this.methodName.equals("<init>")) {
            this.hadInvokeSpecial = true;
        }
        super.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    public void visitInsn(int opcode) {
        if (opcode == 191) {
            super.visitInsn(89);
            this.visitLdcInsn(this.className);
            this.visitLdcInsn(this.methodName);
            this.mv.visitMethodInsn(184, "org/evosuite/testcase/execution/ExecutionTracer", "exceptionThrown", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;)V", false);
        }
        super.visitInsn(opcode);
    }
}

