/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation.coverage;

import java.util.HashMap;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.coverage.dataflow.DefUsePool;
import org.evosuite.graphs.GraphPool;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.graphs.cfg.RawControlFlowGraph;
import org.evosuite.instrumentation.coverage.MethodInstrumentation;
import org.evosuite.utils.ArrayUtil;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefUseInstrumentation
implements MethodInstrumentation {
    private static Logger logger = LoggerFactory.getLogger(DefUseInstrumentation.class);

    @Override
    public void analyze(ClassLoader classLoader, MethodNode mn, String className, String methodName, int access) {
        RawControlFlowGraph completeCFG = GraphPool.getInstance(classLoader).getRawCFG(className, methodName);
        logger.info("Applying DefUse instrumentation on CFG with " + completeCFG.vertexCount() + " nodes");
        for (AbstractInsnNode in : mn.instructions) {
            for (BytecodeInstruction v : completeCFG.vertexSet()) {
                if (!ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.DEFUSE) && !ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.ALLDEFS) || !in.equals(v.getASMNode()) || !v.isDefUse()) continue;
                boolean isValidDU = false;
                if (v.isMethodCallOfField()) {
                    isValidDU = DefUsePool.addAsFieldMethodCall(v);
                } else {
                    if (v.isUse()) {
                        isValidDU = DefUsePool.addAsUse(v);
                    }
                    if (v.isDefinition()) {
                        boolean bl = isValidDU = DefUsePool.addAsDefinition(v) || isValidDU;
                    }
                }
                if (!isValidDU) continue;
                boolean staticContext = v.isStaticDefUse() || (access & 8) > 0;
                InsnList instrumentation = this.getInstrumentation(v, staticContext, className, methodName, mn);
                if (instrumentation == null) {
                    throw new IllegalStateException("error instrumenting node " + v.toString());
                }
                if (v.isMethodCallOfField()) {
                    mn.instructions.insertBefore(v.getASMNode(), instrumentation);
                    continue;
                }
                if (v.isArrayStoreInstruction()) {
                    mn.instructions.insertBefore(v.getSourceOfArrayReference().getASMNode(), instrumentation);
                    continue;
                }
                if (v.isUse()) {
                    mn.instructions.insert(v.getASMNode(), instrumentation);
                    continue;
                }
                mn.instructions.insertBefore(v.getASMNode(), instrumentation);
            }
        }
    }

    private InsnList getInstrumentation(BytecodeInstruction v, boolean staticContext, String className, String methodName, MethodNode mn) {
        InsnList instrumentation = new InsnList();
        if (!v.isDefUse()) {
            logger.warn("unexpected DefUseInstrumentation call for a non-DU-instruction");
            return instrumentation;
        }
        if (DefUsePool.isKnownAsFieldMethodCall(v)) {
            return this.getMethodInstrumentation(v, staticContext, instrumentation, mn);
        }
        if (DefUsePool.isKnownAsUse(v)) {
            this.addObjectInstrumentation(v, instrumentation, mn);
            this.addCallingObjectInstrumentation(staticContext, instrumentation);
            instrumentation.add((AbstractInsnNode)new LdcInsnNode((Object)DefUsePool.getUseCounter()));
            instrumentation.add((AbstractInsnNode)new MethodInsnNode(184, "org/evosuite/testcase/execution/ExecutionTracer", "passedUse", "(Ljava/lang/Object;Ljava/lang/Object;I)V"));
        }
        if (DefUsePool.isKnownAsDefinition(v)) {
            this.addObjectInstrumentation(v, instrumentation, mn);
            this.addCallingObjectInstrumentation(staticContext, instrumentation);
            instrumentation.add((AbstractInsnNode)new LdcInsnNode((Object)DefUsePool.getDefCounter()));
            instrumentation.add((AbstractInsnNode)new MethodInsnNode(184, "org/evosuite/testcase/execution/ExecutionTracer", "passedDefinition", "(Ljava/lang/Object;Ljava/lang/Object;I)V"));
        }
        return instrumentation;
    }

    private void addCallingObjectInstrumentation(boolean staticContext, InsnList instrumentation) {
        if (staticContext) {
            instrumentation.add((AbstractInsnNode)new InsnNode(1));
        } else {
            instrumentation.add((AbstractInsnNode)new VarInsnNode(25, 0));
        }
    }

    private int getNextLocalVariable(MethodNode mn) {
        int var = 1;
        List nodes = mn.localVariables;
        for (LocalVariableNode varNode : nodes) {
            if (varNode.index < var) continue;
            var = varNode.index + 1;
        }
        return var;
    }

    private void addObjectInstrumentation(BytecodeInstruction instruction, InsnList instrumentation, MethodNode mn) {
        if (instruction.isLocalVariableDefinition()) {
            if (instruction.getASMNode().getOpcode() == 25) {
                instrumentation.add((AbstractInsnNode)new InsnNode(89));
            } else {
                instrumentation.add((AbstractInsnNode)new InsnNode(1));
            }
        } else if (instruction.isLocalVariableUse()) {
            if (instruction.getASMNode().getOpcode() == 58) {
                instrumentation.add((AbstractInsnNode)new InsnNode(89));
            } else {
                instrumentation.add((AbstractInsnNode)new InsnNode(1));
            }
        } else if (instruction.isArrayStoreInstruction()) {
            instrumentation.add((AbstractInsnNode)new InsnNode(89));
        } else if (instruction.isFieldNodeDU()) {
            Type type = Type.getType((String)instruction.getFieldType());
            if (type.getSort() == 10) {
                instrumentation.add((AbstractInsnNode)new InsnNode(89));
            } else {
                instrumentation.add((AbstractInsnNode)new InsnNode(1));
            }
        } else if (instruction.isMethodCall()) {
            Type type = Type.getReturnType((String)instruction.getMethodCallDescriptor());
            if (type.getSort() == 10) {
                instrumentation.add((AbstractInsnNode)new InsnNode(89));
            } else {
                instrumentation.add((AbstractInsnNode)new InsnNode(1));
            }
        }
    }

    private int getNextLocalNum(MethodNode mn) {
        List variables = mn.localVariables;
        int max = 0;
        for (LocalVariableNode node : variables) {
            if (node.index <= max) continue;
            max = node.index;
        }
        return max + 1;
    }

    private InsnList getMethodInstrumentation(BytecodeInstruction call, boolean staticContext, InsnList instrumentation, MethodNode mn) {
        Type type;
        int i;
        String descriptor = call.getMethodCallDescriptor();
        Type[] args = Type.getArgumentTypes((String)descriptor);
        int loc = this.getNextLocalNum(mn);
        HashMap<Integer, Integer> to = new HashMap<Integer, Integer>();
        for (i = args.length - 1; i >= 0; --i) {
            type = args[i];
            instrumentation.add((AbstractInsnNode)new VarInsnNode(type.getOpcode(54), loc));
            to.put(i, loc);
            ++loc;
        }
        this.addObjectInstrumentation(call, instrumentation, mn);
        this.addCallingObjectInstrumentation(staticContext, instrumentation);
        instrumentation.add((AbstractInsnNode)new LdcInsnNode((Object)DefUsePool.getDefUseCounter()));
        instrumentation.add((AbstractInsnNode)new MethodInsnNode(184, "org/evosuite/testcase/execution/ExecutionTracer", "passedFieldMethodCall", "(Ljava/lang/Object;Ljava/lang/Object;I)V"));
        for (i = 0; i < args.length; ++i) {
            type = args[i];
            instrumentation.add((AbstractInsnNode)new VarInsnNode(type.getOpcode(21), ((Integer)to.get(i)).intValue()));
        }
        return instrumentation;
    }

    @Override
    public boolean executeOnExcludedMethods() {
        return false;
    }

    @Override
    public boolean executeOnMainMethod() {
        return false;
    }
}

