/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation.error;

import java.util.HashMap;
import java.util.Map;
import org.evosuite.instrumentation.ErrorConditionMethodAdapter;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorBranchInstrumenter {
    protected static final Logger logger = LoggerFactory.getLogger(ErrorBranchInstrumenter.class);
    protected ErrorConditionMethodAdapter mv;
    protected String methodName;

    public ErrorBranchInstrumenter(ErrorConditionMethodAdapter mv) {
        this.mv = mv;
        this.methodName = mv.getMethodName();
    }

    public Map<Integer, Integer> getMethodCallee(String desc) {
        Type[] args = Type.getArgumentTypes((String)desc);
        HashMap<Integer, Integer> to = new HashMap<Integer, Integer>();
        for (int i = args.length - 1; i >= 0; --i) {
            int loc = this.mv.newLocal(args[i]);
            this.mv.storeLocal(loc);
            to.put(i, loc);
        }
        this.mv.dup();
        return to;
    }

    public void restoreMethodParameters(Map<Integer, Integer> to, String desc) {
        Type[] args = Type.getArgumentTypes((String)desc);
        for (int i = 0; i < args.length; ++i) {
            this.mv.loadLocal(to.get(i));
        }
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        throw new RuntimeException("This method should not be called since ASM5 API is used");
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
    }

    public void visitTypeInsn(int opcode, String type) {
    }

    public void visitInsn(int opcode) {
    }

    public void visitIntInsn(int opcode, int operand) {
    }

    protected void insertBranch(int opcode, String exception) {
        Label origTarget = new Label();
        this.mv.tagBranch();
        this.mv.visitJumpInsn(opcode, origTarget);
        this.mv.visitTypeInsn(187, exception);
        this.mv.visitInsn(89);
        this.mv.visitMethodInsn(183, exception, "<init>", "()V", false);
        this.mv.visitInsn(191);
        this.mv.visitLabel(origTarget);
        this.mv.tagBranchExit();
    }

    protected void insertBranchWithoutTag(int opcode, String exception) {
        Label origTarget = new Label();
        this.mv.visitJumpInsn(opcode, origTarget);
        this.mv.visitTypeInsn(187, exception);
        this.mv.visitInsn(89);
        this.mv.visitMethodInsn(183, exception, "<init>", "()V", false);
        this.mv.visitInsn(191);
        this.mv.visitLabel(origTarget);
    }

    protected void tagBranchStart() {
        this.mv.tagBranch();
    }

    protected void tagBranchEnd() {
        this.mv.tagBranchExit();
    }
}

