/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation.mutation;

import java.util.LinkedList;
import java.util.List;
import org.evosuite.coverage.mutation.Mutation;
import org.evosuite.coverage.mutation.MutationPool;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.instrumentation.mutation.MutationOperator;
import org.evosuite.instrumentation.mutation.ReplaceVariable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Frame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteField
implements MutationOperator {
    private static Logger logger = LoggerFactory.getLogger(DeleteField.class);

    @Override
    public List<Mutation> apply(MethodNode mn, String className, String methodName, BytecodeInstruction instruction, Frame frame) {
        LinkedList<Mutation> mutations = new LinkedList<Mutation>();
        FieldInsnNode node = (FieldInsnNode)instruction.getASMNode();
        Type fieldType = Type.getType((String)node.desc);
        InsnList mutation = new InsnList();
        logger.debug("Mutation deletefield for statement " + node.name + node.desc);
        if (node.getOpcode() == 180) {
            logger.debug("Deleting source of type " + node.owner);
            mutation.add((AbstractInsnNode)new InsnNode(87));
        }
        mutation.add(DeleteField.getDefault(fieldType));
        Mutation mutationObject = MutationPool.addMutation(className, methodName, "DeleteField: " + node.name + node.desc, instruction, mutation, this.getInfectionDistance(node, mutation));
        mutations.add(mutationObject);
        return mutations;
    }

    private static AbstractInsnNode getDefault(Type type) {
        if (type.equals((Object)Type.BOOLEAN_TYPE)) {
            return new LdcInsnNode((Object)0);
        }
        if (type.equals((Object)Type.INT_TYPE)) {
            return new LdcInsnNode((Object)0);
        }
        if (type.equals((Object)Type.BYTE_TYPE)) {
            return new LdcInsnNode((Object)0);
        }
        if (type.equals((Object)Type.CHAR_TYPE)) {
            return new LdcInsnNode((Object)0);
        }
        if (type.equals((Object)Type.DOUBLE_TYPE)) {
            return new LdcInsnNode((Object)0.0);
        }
        if (type.equals((Object)Type.FLOAT_TYPE)) {
            return new LdcInsnNode((Object)Float.valueOf(0.0f));
        }
        if (type.equals((Object)Type.INT_TYPE)) {
            return new LdcInsnNode((Object)0);
        }
        if (type.equals((Object)Type.LONG_TYPE)) {
            return new LdcInsnNode((Object)0L);
        }
        if (type.equals((Object)Type.SHORT_TYPE)) {
            return new LdcInsnNode((Object)0);
        }
        if (type.equals((Object)Type.VOID_TYPE)) {
            return new LabelNode();
        }
        return new InsnNode(1);
    }

    public InsnList getInfectionDistance(FieldInsnNode original, InsnList mutant) {
        InsnList distance = new InsnList();
        if (original.getOpcode() == 180) {
            distance.add((AbstractInsnNode)new InsnNode(89));
        }
        distance.add((AbstractInsnNode)new FieldInsnNode(original.getOpcode(), original.owner, original.name, original.desc));
        Type type = Type.getType((String)original.desc);
        if (type.getDescriptor().startsWith("L") || type.getDescriptor().startsWith("[")) {
            ReplaceVariable.addReferenceDistanceCheck(distance, type, mutant);
        } else {
            ReplaceVariable.addPrimitiveDistanceCheck(distance, type, mutant);
        }
        return distance;
    }

    public static double getDistance(double val1, double val2) {
        return val1 == val2 ? 1.0 : 0.0;
    }

    public static double getDistance(Object obj1, Object obj2) {
        if (obj1 == null) {
            return obj2 == null ? 1.0 : 0.0;
        }
        return obj1.equals(obj2) ? 1.0 : 0.0;
    }

    @Override
    public boolean isApplicable(BytecodeInstruction instruction) {
        return instruction.getASMNode().getOpcode() == 180 || instruction.getASMNode().getOpcode() == 178;
    }
}

