/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation.mutation;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.evosuite.coverage.mutation.Mutation;
import org.evosuite.coverage.mutation.MutationPool;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.instrumentation.BooleanValueInterpreter;
import org.evosuite.instrumentation.mutation.MutationOperator;
import org.evosuite.instrumentation.mutation.VariableNotFoundException;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.tree.analysis.Frame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsertUnaryOperator
implements MutationOperator {
    private static final Logger logger = LoggerFactory.getLogger(InsertUnaryOperator.class);

    /*
     * Unable to fully structure code
     */
    @Override
    public List<Mutation> apply(MethodNode mn, String className, String methodName, BytecodeInstruction instruction, Frame frame) {
        mutations = new LinkedList<Mutation>();
        mutationCode = new LinkedList<InsnList>();
        descriptions = new LinkedList<String>();
        if (instruction.getASMNode() instanceof VarInsnNode) {
            try {
                mutation = new InsnList();
                node = (VarInsnNode)instruction.getASMNode();
                mutation.add((AbstractInsnNode)new VarInsnNode(node.getOpcode(), node.var));
                mutation.add((AbstractInsnNode)new InsnNode(this.getNegation(node.getOpcode())));
                mutationCode.add(mutation);
                if (!mn.localVariables.isEmpty()) {
                    descriptions.add("Negation of " + this.getName(mn, (AbstractInsnNode)node));
                } else {
                    descriptions.add("Negation");
                }
                if (node.getOpcode() != 21 || frame.getStack(frame.getStackSize() - 1) == BooleanValueInterpreter.BOOLEAN_VALUE) ** GOTO lbl71
                mutation = new InsnList();
                mutation.add((AbstractInsnNode)new IincInsnNode(node.var, 1));
                mutation.add((AbstractInsnNode)new VarInsnNode(node.getOpcode(), node.var));
                if (!mn.localVariables.isEmpty()) {
                    descriptions.add("IINC 1 " + this.getName(mn, (AbstractInsnNode)node));
                } else {
                    descriptions.add("IINC 1");
                }
                mutationCode.add(mutation);
                mutation = new InsnList();
                mutation.add((AbstractInsnNode)new IincInsnNode(node.var, -1));
                mutation.add((AbstractInsnNode)new VarInsnNode(node.getOpcode(), node.var));
                if (!mn.localVariables.isEmpty()) {
                    descriptions.add("IINC -1 " + this.getName(mn, (AbstractInsnNode)node));
                } else {
                    descriptions.add("IINC -1");
                }
                mutationCode.add(mutation);
            }
            catch (VariableNotFoundException e) {
                InsertUnaryOperator.logger.info("Could not find variable: " + e);
                return new ArrayList<Mutation>();
            }
        } else {
            mutation = new InsnList();
            node = (FieldInsnNode)instruction.getASMNode();
            type = Type.getType((String)node.desc);
            mutation.add((AbstractInsnNode)new FieldInsnNode(node.getOpcode(), node.owner, node.name, node.desc));
            mutation.add((AbstractInsnNode)new InsnNode(this.getNegation(type)));
            descriptions.add("Negation");
            mutationCode.add(mutation);
            if (type == Type.INT_TYPE) {
                mutation = new InsnList();
                mutation.add((AbstractInsnNode)new FieldInsnNode(node.getOpcode(), node.owner, node.name, node.desc));
                mutation.add((AbstractInsnNode)new InsnNode(4));
                mutation.add((AbstractInsnNode)new InsnNode(96));
                descriptions.add("+1");
                mutationCode.add(mutation);
                mutation = new InsnList();
                mutation.add((AbstractInsnNode)new FieldInsnNode(node.getOpcode(), node.owner, node.name, node.desc));
                mutation.add((AbstractInsnNode)new InsnNode(2));
                mutation.add((AbstractInsnNode)new InsnNode(96));
                descriptions.add("-1");
                mutationCode.add(mutation);
            }
        }
lbl71:
        // 5 sources

        i = 0;
        for (InsnList mutation : mutationCode) {
            mutationObject = MutationPool.addMutation(className, methodName, "InsertUnaryOp " + (String)descriptions.get(i++), instruction, mutation, Mutation.getDefaultInfectionDistance());
            mutations.add(mutationObject);
        }
        return mutations;
    }

    @Override
    public boolean isApplicable(BytecodeInstruction instruction) {
        AbstractInsnNode node = instruction.getASMNode();
        switch (node.getOpcode()) {
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                return true;
            }
            case 178: 
            case 180: {
                FieldInsnNode fieldNode = (FieldInsnNode)instruction.getASMNode();
                Type type = Type.getType((String)fieldNode.desc);
                if (type != Type.BYTE_TYPE && type != Type.SHORT_TYPE && type != Type.LONG_TYPE && type != Type.FLOAT_TYPE && type != Type.DOUBLE_TYPE && type != Type.BOOLEAN_TYPE && type != Type.INT_TYPE) break;
                return true;
            }
        }
        return false;
    }

    private int getNegation(Type type) {
        if (type.equals((Object)Type.BYTE_TYPE)) {
            return 116;
        }
        if (type == Type.SHORT_TYPE) {
            return 116;
        }
        if (type == Type.LONG_TYPE) {
            return 117;
        }
        if (type == Type.FLOAT_TYPE) {
            return 118;
        }
        if (type == Type.DOUBLE_TYPE) {
            return 119;
        }
        if (type == Type.BOOLEAN_TYPE) {
            return 116;
        }
        if (type == Type.INT_TYPE) {
            return 116;
        }
        throw new RuntimeException("Don't know how to negate type " + type);
    }

    private int getNegation(int opcode) {
        switch (opcode) {
            case 21: {
                return 116;
            }
            case 22: {
                return 117;
            }
            case 23: {
                return 118;
            }
            case 24: {
                return 119;
            }
        }
        throw new RuntimeException("Invalid opcode for negation: " + opcode);
    }

    private String getName(MethodNode mn, AbstractInsnNode node) throws VariableNotFoundException {
        if (node instanceof VarInsnNode) {
            LocalVariableNode var = this.getLocal(mn, node, ((VarInsnNode)node).var);
            return var.name;
        }
        if (node instanceof FieldInsnNode) {
            return ((FieldInsnNode)node).name;
        }
        if (node instanceof IincInsnNode) {
            IincInsnNode incNode = (IincInsnNode)node;
            LocalVariableNode var = this.getLocal(mn, node, incNode.var);
            return var.name;
        }
        throw new RuntimeException("Unknown variable node: " + node);
    }

    private LocalVariableNode getLocal(MethodNode mn, AbstractInsnNode node, int index) throws VariableNotFoundException {
        int currentId = mn.instructions.indexOf(node);
        for (Object v : mn.localVariables) {
            LocalVariableNode localVar = (LocalVariableNode)v;
            int startId = mn.instructions.indexOf((AbstractInsnNode)localVar.start);
            int endId = mn.instructions.indexOf((AbstractInsnNode)localVar.end);
            if (currentId < startId || currentId > endId || localVar.index != index) continue;
            return localVar;
        }
        throw new VariableNotFoundException("Could not find local variable " + index + " at position " + currentId + ", have variables: " + mn.localVariables.size());
    }
}

