/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation.mutation;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.evosuite.Properties;
import org.evosuite.coverage.mutation.Mutation;
import org.evosuite.coverage.mutation.MutationPool;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.instrumentation.mutation.MutationOperator;
import org.evosuite.instrumentation.mutation.VariableNotFoundException;
import org.evosuite.setup.TestClusterGenerator;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Frame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplaceVariable
implements MutationOperator {
    private static Logger logger = LoggerFactory.getLogger(ReplaceVariable.class);

    @Override
    public List<Mutation> apply(MethodNode mn, String className, String methodName, BytecodeInstruction instruction, Frame frame) {
        LinkedList<Mutation> mutations = new LinkedList<Mutation>();
        if (mn.localVariables.isEmpty()) {
            logger.debug("Have no information about local variables - recompile with full debug information");
            return mutations;
        }
        logger.debug("Starting variable replacement in " + methodName);
        try {
            String origName = this.getName(mn, instruction.getASMNode());
            int numReplacements = 0;
            for (Map.Entry<String, InsnList> mutation : this.getReplacements(mn, className, instruction.getASMNode(), frame).entrySet()) {
                if (numReplacements++ > Properties.MAX_REPLACE_MUTANTS) {
                    logger.info("Reached maximum number of variable replacements");
                    break;
                }
                Mutation mutationObject = MutationPool.addMutation(className, methodName, "ReplaceVariable " + origName + " -> " + mutation.getKey(), instruction, mutation.getValue(), this.getInfectionDistance(this.getType(mn, instruction.getASMNode()), instruction.getASMNode(), mutation.getValue()));
                mutations.add(mutationObject);
            }
        }
        catch (VariableNotFoundException e) {
            logger.info("Variable not found: " + instruction);
        }
        logger.debug("Finished variable replacement in " + methodName);
        return mutations;
    }

    private Type getType(MethodNode mn, AbstractInsnNode node) throws VariableNotFoundException {
        if (node instanceof VarInsnNode) {
            LocalVariableNode var = this.getLocal(mn, node, ((VarInsnNode)node).var);
            return Type.getType((String)var.desc);
        }
        if (node instanceof FieldInsnNode) {
            return Type.getType((String)((FieldInsnNode)node).desc);
        }
        if (node instanceof IincInsnNode) {
            IincInsnNode incNode = (IincInsnNode)node;
            LocalVariableNode var = this.getLocal(mn, node, incNode.var);
            return Type.getType((String)var.desc);
        }
        throw new RuntimeException("Unknown variable node: " + node);
    }

    private String getName(MethodNode mn, AbstractInsnNode node) throws VariableNotFoundException {
        if (node instanceof VarInsnNode) {
            LocalVariableNode var = this.getLocal(mn, node, ((VarInsnNode)node).var);
            return var.name;
        }
        if (node instanceof FieldInsnNode) {
            return ((FieldInsnNode)node).name;
        }
        if (node instanceof IincInsnNode) {
            IincInsnNode incNode = (IincInsnNode)node;
            LocalVariableNode var = this.getLocal(mn, node, incNode.var);
            return var.name;
        }
        throw new RuntimeException("Unknown variable node: " + node);
    }

    public static InsnList copy(InsnList orig) {
        ListIterator it = orig.iterator();
        InsnList copy = new InsnList();
        while (it.hasNext()) {
            AbstractInsnNode node = (AbstractInsnNode)it.next();
            if (node instanceof VarInsnNode) {
                VarInsnNode vn = (VarInsnNode)node;
                copy.add((AbstractInsnNode)new VarInsnNode(vn.getOpcode(), vn.var));
                continue;
            }
            if (node instanceof FieldInsnNode) {
                FieldInsnNode fn = (FieldInsnNode)node;
                copy.add((AbstractInsnNode)new FieldInsnNode(fn.getOpcode(), fn.owner, fn.name, fn.desc));
                continue;
            }
            if (node instanceof InsnNode) {
                if (node.getOpcode() == 87) continue;
                copy.add((AbstractInsnNode)new InsnNode(node.getOpcode()));
                continue;
            }
            if (node instanceof LdcInsnNode) {
                copy.add((AbstractInsnNode)new LdcInsnNode(((LdcInsnNode)node).cst));
                continue;
            }
            throw new RuntimeException("Unexpected node type: " + node.getClass());
        }
        return copy;
    }

    public static void addPrimitiveDistanceCheck(InsnList distance, Type type, InsnList mutant) {
        distance.add(ReplaceVariable.cast(type, Type.DOUBLE_TYPE));
        distance.add(ReplaceVariable.copy(mutant));
        distance.add(ReplaceVariable.cast(type, Type.DOUBLE_TYPE));
        distance.add((AbstractInsnNode)new MethodInsnNode(184, "org/evosuite/instrumentation/mutation/ReplaceVariable", "getDistance", "(DD)D", false));
    }

    public static void addReferenceDistanceCheck(InsnList distance, Type type, InsnList mutant) {
        distance.add(ReplaceVariable.copy(mutant));
        distance.add((AbstractInsnNode)new MethodInsnNode(184, "org/evosuite/instrumentation/mutation/ReplaceVariable", "getDistance", "(Ljava/lang/Object;Ljava/lang/Object;)D", false));
    }

    public InsnList getInfectionDistance(Type type, AbstractInsnNode original, InsnList mutant) {
        InsnList distance = new InsnList();
        if (original instanceof VarInsnNode) {
            VarInsnNode node = (VarInsnNode)original;
            distance.add((AbstractInsnNode)new VarInsnNode(node.getOpcode(), node.var));
            if (type.getDescriptor().startsWith("L") || type.getDescriptor().startsWith("[")) {
                ReplaceVariable.addReferenceDistanceCheck(distance, type, mutant);
            } else {
                ReplaceVariable.addPrimitiveDistanceCheck(distance, type, mutant);
            }
        } else if (original instanceof FieldInsnNode) {
            if (original.getOpcode() == 180) {
                distance.add((AbstractInsnNode)new InsnNode(89));
            }
            FieldInsnNode node = (FieldInsnNode)original;
            distance.add((AbstractInsnNode)new FieldInsnNode(node.getOpcode(), node.owner, node.name, node.desc));
            if (type.getDescriptor().startsWith("L") || type.getDescriptor().startsWith("[")) {
                ReplaceVariable.addReferenceDistanceCheck(distance, type, mutant);
            } else {
                ReplaceVariable.addPrimitiveDistanceCheck(distance, type, mutant);
            }
        } else if (original instanceof IincInsnNode) {
            distance.add(Mutation.getDefaultInfectionDistance());
        }
        return distance;
    }

    public static double getDistance(double val1, double val2) {
        return val1 == val2 ? 1.0 : 0.0;
    }

    public static double getDistance(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return 1.0;
        }
        return 0.0;
    }

    private Map<String, InsnList> getReplacements(MethodNode mn, String className, AbstractInsnNode node, Frame frame) {
        HashMap<String, InsnList> variables = new HashMap<String, InsnList>();
        if (node instanceof VarInsnNode) {
            VarInsnNode var = (VarInsnNode)node;
            try {
                LocalVariableNode origVar = this.getLocal(mn, node, var.var);
                logger.debug("Looking for replacements for " + origVar.name + " of type " + origVar.desc + " at index " + origVar.index);
                variables.putAll(this.getLocalReplacements(mn, origVar.desc, node, frame));
                variables.putAll(this.getFieldReplacements(mn, className, origVar.desc, node));
            }
            catch (VariableNotFoundException e) {
                logger.info("Could not find variable, not replacing it: " + var.var);
                for (LocalVariableNode n : mn.localVariables) {
                    logger.info(n.index + ": " + n.name);
                }
                logger.info(e.toString());
                e.printStackTrace();
            }
        } else if (node instanceof FieldInsnNode) {
            FieldInsnNode field = (FieldInsnNode)node;
            if (field.owner.replace("/", ".").equals(className)) {
                logger.info("Looking for replacements for static field " + field.name + " of type " + field.desc);
                variables.putAll(this.getLocalReplacements(mn, field.desc, node, frame));
                variables.putAll(this.getFieldReplacements(mn, className, field.desc, node));
            }
        } else if (node instanceof IincInsnNode) {
            IincInsnNode incNode = (IincInsnNode)node;
            try {
                LocalVariableNode origVar = this.getLocal(mn, node, incNode.var);
                variables.putAll(this.getLocalReplacementsInc(mn, origVar.desc, incNode, frame));
            }
            catch (VariableNotFoundException e) {
                logger.info("Could not find variable, not replacing it: " + incNode.var);
            }
        }
        return variables;
    }

    private LocalVariableNode getLocal(MethodNode mn, AbstractInsnNode node, int index) throws VariableNotFoundException {
        int currentId = mn.instructions.indexOf(node);
        for (Object v : mn.localVariables) {
            LocalVariableNode localVar = (LocalVariableNode)v;
            int startId = mn.instructions.indexOf((AbstractInsnNode)localVar.start);
            int endId = mn.instructions.indexOf((AbstractInsnNode)localVar.end);
            logger.info("Checking " + localVar.index + " in scope " + startId + " - " + endId);
            if (currentId < startId || currentId > endId || localVar.index != index) continue;
            return localVar;
        }
        throw new VariableNotFoundException("Could not find local variable " + index + " at position " + currentId + ", have variables: " + mn.localVariables.size());
    }

    private Map<String, InsnList> getLocalReplacements(MethodNode mn, String desc, AbstractInsnNode node, Frame frame) {
        HashMap<String, InsnList> replacements = new HashMap<String, InsnList>();
        int otherNum = -1;
        if (node instanceof VarInsnNode) {
            VarInsnNode vNode = (VarInsnNode)node;
            otherNum = vNode.var;
        }
        if (otherNum == -1) {
            return replacements;
        }
        int currentId = mn.instructions.indexOf(node);
        logger.info("Looking for replacements at position " + currentId + " of variable " + otherNum + " of type " + desc);
        for (Object v : mn.localVariables) {
            BasicValue newValue;
            LocalVariableNode localVar = (LocalVariableNode)v;
            int startId = mn.instructions.indexOf((AbstractInsnNode)localVar.start);
            int endId = mn.instructions.indexOf((AbstractInsnNode)localVar.end);
            logger.info("Checking local variable " + localVar.name + " of type " + localVar.desc + " at index " + localVar.index);
            if (!localVar.desc.equals(desc)) {
                logger.info("- Types do not match");
            }
            if (localVar.index == otherNum) {
                logger.info("- Replacement = original");
            }
            if (currentId < startId) {
                logger.info("- Out of scope (start)");
            }
            if (currentId > endId) {
                logger.info("- Out of scope (end)");
            }
            if ((newValue = (BasicValue)frame.getLocal(localVar.index)) == BasicValue.UNINITIALIZED_VALUE) {
                logger.info("- Not initialized");
            }
            if (!localVar.desc.equals(desc) || localVar.index == otherNum || currentId < startId || currentId > endId || newValue == BasicValue.UNINITIALIZED_VALUE) continue;
            logger.info("Adding local variable " + localVar.name + " of type " + localVar.desc + " at index " + localVar.index + ",  " + startId + "-" + endId + ", " + currentId);
            InsnList list = new InsnList();
            if (node.getOpcode() == 180) {
                list.add((AbstractInsnNode)new InsnNode(87));
            }
            list.add((AbstractInsnNode)new VarInsnNode(this.getLoadOpcode(localVar), localVar.index));
            replacements.put(localVar.name, list);
        }
        return replacements;
    }

    private Map<String, InsnList> getLocalReplacementsInc(MethodNode mn, String desc, IincInsnNode node, Frame frame) {
        HashMap<String, InsnList> replacements = new HashMap<String, InsnList>();
        int otherNum = -1;
        otherNum = node.var;
        int currentId = mn.instructions.indexOf((AbstractInsnNode)node);
        for (Object v : mn.localVariables) {
            BasicValue newValue;
            LocalVariableNode localVar = (LocalVariableNode)v;
            int startId = mn.instructions.indexOf((AbstractInsnNode)localVar.start);
            int endId = mn.instructions.indexOf((AbstractInsnNode)localVar.end);
            logger.info("Checking local variable " + localVar.name + " of type " + localVar.desc + " at index " + localVar.index);
            if (!localVar.desc.equals(desc)) {
                logger.info("- Types do not match: " + localVar.name);
            }
            if (localVar.index == otherNum) {
                logger.info("- Replacement = original " + localVar.name);
            }
            if (currentId < startId) {
                logger.info("- Out of scope (start) " + localVar.name);
            }
            if (currentId > endId) {
                logger.info("- Out of scope (end) " + localVar.name);
            }
            if ((newValue = (BasicValue)frame.getLocal(localVar.index)) == BasicValue.UNINITIALIZED_VALUE) {
                logger.info("- Not initialized");
            }
            if (!localVar.desc.equals(desc) || localVar.index == otherNum || currentId < startId || currentId > endId || newValue == BasicValue.UNINITIALIZED_VALUE) continue;
            logger.info("Adding local variable " + localVar.name + " of type " + localVar.desc + " at index " + localVar.index);
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new IincInsnNode(localVar.index, node.incr));
            replacements.put(localVar.name, list);
        }
        return replacements;
    }

    private int getLoadOpcode(LocalVariableNode var) {
        Type type = Type.getType((String)var.desc);
        return type.getOpcode(21);
    }

    private Map<String, InsnList> getFieldReplacements(MethodNode mn, String className, String desc, AbstractInsnNode node) {
        HashMap<String, InsnList> alternatives = new HashMap<String, InsnList>();
        boolean isStatic = (mn.access & 8) == 8;
        String otherName = "";
        if (node instanceof FieldInsnNode) {
            FieldInsnNode fNode = (FieldInsnNode)node;
            otherName = fNode.name;
        }
        try {
            logger.info("Checking class " + className);
            Class<?> clazz = Class.forName(className, false, ReplaceVariable.class.getClassLoader());
            for (Field field : TestClusterGenerator.getFields(clazz)) {
                if (!TestClusterGenerator.canUse(field)) continue;
                Type type = Type.getType(field.getType());
                logger.info("Checking replacement field variable " + field.getName());
                if (field.getName().equals(otherName) || isStatic && !Modifier.isStatic(field.getModifiers())) continue;
                if (type.getDescriptor().equals(desc)) {
                    logger.info("Adding replacement field variable " + field.getName());
                    InsnList list = new InsnList();
                    if (node.getOpcode() == 180) {
                        list.add((AbstractInsnNode)new InsnNode(87));
                    }
                    if (Modifier.isStatic(field.getModifiers())) {
                        list.add((AbstractInsnNode)new FieldInsnNode(178, className.replace(".", "/"), field.getName(), type.getDescriptor()));
                    } else {
                        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                        list.add((AbstractInsnNode)new FieldInsnNode(180, className.replace(".", "/"), field.getName(), type.getDescriptor()));
                    }
                    alternatives.put(field.getName(), list);
                    continue;
                }
                logger.info("Descriptor does not match: " + field.getName() + " - " + type.getDescriptor());
            }
        }
        catch (Throwable t) {
            logger.info("Class not found: " + className);
        }
        return alternatives;
    }

    public static InsnList cast(Type from, Type to) {
        InsnList list = new InsnList();
        if (from != to) {
            if (from == Type.DOUBLE_TYPE) {
                if (to == Type.FLOAT_TYPE) {
                    list.add((AbstractInsnNode)new InsnNode(144));
                } else if (to == Type.LONG_TYPE) {
                    list.add((AbstractInsnNode)new InsnNode(143));
                } else {
                    list.add((AbstractInsnNode)new InsnNode(142));
                    list.add(ReplaceVariable.cast(Type.INT_TYPE, to));
                }
            } else if (from == Type.FLOAT_TYPE) {
                if (to == Type.DOUBLE_TYPE) {
                    list.add((AbstractInsnNode)new InsnNode(141));
                } else if (to == Type.LONG_TYPE) {
                    list.add((AbstractInsnNode)new InsnNode(140));
                } else {
                    list.add((AbstractInsnNode)new InsnNode(139));
                    list.add(ReplaceVariable.cast(Type.INT_TYPE, to));
                }
            } else if (from == Type.LONG_TYPE) {
                if (to == Type.DOUBLE_TYPE) {
                    list.add((AbstractInsnNode)new InsnNode(138));
                } else if (to == Type.FLOAT_TYPE) {
                    list.add((AbstractInsnNode)new InsnNode(137));
                } else {
                    list.add((AbstractInsnNode)new InsnNode(136));
                    list.add(ReplaceVariable.cast(Type.INT_TYPE, to));
                }
            } else if (to == Type.BYTE_TYPE) {
                list.add((AbstractInsnNode)new InsnNode(145));
            } else if (to == Type.CHAR_TYPE) {
                list.add((AbstractInsnNode)new InsnNode(146));
            } else if (to == Type.DOUBLE_TYPE) {
                list.add((AbstractInsnNode)new InsnNode(135));
            } else if (to == Type.FLOAT_TYPE) {
                list.add((AbstractInsnNode)new InsnNode(134));
            } else if (to == Type.LONG_TYPE) {
                list.add((AbstractInsnNode)new InsnNode(133));
            } else if (to == Type.SHORT_TYPE) {
                list.add((AbstractInsnNode)new InsnNode(147));
            }
        }
        return list;
    }

    @Override
    public boolean isApplicable(BytecodeInstruction instruction) {
        return instruction.isLocalVariableUse() || instruction.getASMNode().getOpcode() == 178 || instruction.getASMNode().getOpcode() == 180;
    }
}

