/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation.testability;

import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.evosuite.graphs.GraphPool;
import org.evosuite.graphs.cdg.ControlDependenceGraph;
import org.evosuite.graphs.cfg.BasicBlock;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.graphs.cfg.BytecodeInstructionFactory;
import org.evosuite.graphs.cfg.BytecodeInstructionPool;
import org.evosuite.graphs.cfg.ControlDependency;
import org.evosuite.instrumentation.BooleanTestabilityTransformation;
import org.evosuite.instrumentation.DescriptorMapping;
import org.evosuite.instrumentation.TransformationStatistics;
import org.evosuite.instrumentation.testability.MethodNodeTransformer;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ImplicitElseTransformer
extends MethodNodeTransformer {
    private final BooleanTestabilityTransformation booleanTestabilityTransformation;
    private final Set<ControlDependency> addedNodes = new HashSet<ControlDependency>();
    private final Set<AbstractInsnNode> addedInsns = new HashSet<AbstractInsnNode>();

    public ImplicitElseTransformer(BooleanTestabilityTransformation booleanTestabilityTransformation) {
        this.booleanTestabilityTransformation = booleanTestabilityTransformation;
    }

    private boolean isDefinedBefore(MethodNode mn, VarInsnNode var, AbstractInsnNode position) {
        List localVar = mn.localVariables;
        if (localVar.isEmpty()) {
            for (AbstractInsnNode pos = position.getPrevious(); pos != mn.instructions.getFirst(); pos = pos.getPrevious()) {
                if (!(pos instanceof VarInsnNode)) continue;
                VarInsnNode vn = (VarInsnNode)pos;
                if (var.var != vn.var) continue;
                return true;
            }
        } else {
            int current = mn.instructions.indexOf(position);
            for (LocalVariableNode local : localVar) {
                if (local.index != var.var) continue;
                int start = mn.instructions.indexOf((AbstractInsnNode)local.start);
                int end = mn.instructions.indexOf((AbstractInsnNode)local.end);
                if (current < start || current > end) continue;
                return true;
            }
        }
        return false;
    }

    private void handleDependency(ControlDependency dependency, ControlDependenceGraph cdg, MethodNode mn, FieldInsnNode varNode, BytecodeInstruction parentLevel) {
        if (this.addedNodes.contains(dependency)) {
            return;
        }
        Set<BasicBlock> blocks = cdg.getAlternativeBlocks(dependency);
        this.addedNodes.add(dependency);
        Set<ControlDependency> dependencies = dependency.getBranch().getInstruction().getControlDependencies();
        for (ControlDependency dep : dependencies) {
            if (this.addedNodes.contains(dep) || dep == dependency) continue;
            this.handleDependency(dep, cdg, mn, varNode, dependency.getBranch().getInstruction());
        }
        boolean hasAssignment = false;
        for (BasicBlock block : blocks) {
            for (BytecodeInstruction instruction : block) {
                if (instruction.getASMNode().getOpcode() != 181 && instruction.getASMNode().getOpcode() != 179) continue;
                FieldInsnNode otherFieldNode = (FieldInsnNode)instruction.getASMNode();
                FieldInsnNode thisFieldNode = varNode;
                if (!otherFieldNode.owner.equals(thisFieldNode.owner) || !otherFieldNode.name.equals(thisFieldNode.name)) continue;
                hasAssignment = true;
                break;
            }
            if (!hasAssignment) continue;
            break;
        }
        if (!hasAssignment) {
            if (dependency.getBranch().getInstruction().isSwitch()) {
                BooleanTestabilityTransformation.logger.warn("Don't know how to handle Switches yet");
                return;
            }
            TransformationStatistics.transformedImplicitElse();
            JumpInsnNode jumpNode = (JumpInsnNode)dependency.getBranch().getInstruction().getASMNode();
            FieldInsnNode newLoad = new FieldInsnNode(varNode.getOpcode() == 179 ? 178 : 180, varNode.owner, varNode.name, varNode.desc);
            FieldInsnNode newStore = new FieldInsnNode(varNode.getOpcode(), varNode.owner, varNode.name, varNode.desc);
            VarInsnNode newOwnerLoad1 = null;
            VarInsnNode newOwnerLoad2 = null;
            if (varNode.getOpcode() == 181) {
                newOwnerLoad1 = new VarInsnNode(25, 0);
                newOwnerLoad2 = new VarInsnNode(25, 0);
            }
            if (dependency.getBranchExpressionValue()) {
                BooleanTestabilityTransformation.logger.info("Inserting after if");
                mn.instructions.insert((AbstractInsnNode)jumpNode, (AbstractInsnNode)newStore);
                mn.instructions.insert((AbstractInsnNode)jumpNode, (AbstractInsnNode)newLoad);
                if (newOwnerLoad1 != null) {
                    mn.instructions.insert((AbstractInsnNode)jumpNode, (AbstractInsnNode)newOwnerLoad1);
                    this.registerInstruction(mn, (AbstractInsnNode)varNode, (AbstractInsnNode)newOwnerLoad1);
                }
                if (newOwnerLoad2 != null) {
                    mn.instructions.insert((AbstractInsnNode)jumpNode, (AbstractInsnNode)newOwnerLoad2);
                    this.registerInstruction(mn, (AbstractInsnNode)varNode, (AbstractInsnNode)newOwnerLoad2);
                }
                this.registerInstruction(mn, (AbstractInsnNode)varNode, (AbstractInsnNode)newStore);
                this.registerInstruction(mn, (AbstractInsnNode)varNode, (AbstractInsnNode)newLoad);
            } else {
                BooleanTestabilityTransformation.logger.info("Inserting as jump target");
                LabelNode target = jumpNode.label;
                LabelNode newTarget = new LabelNode(new Label());
                this.registerInstruction(mn, (AbstractInsnNode)target, (AbstractInsnNode)newStore);
                this.registerInstruction(mn, (AbstractInsnNode)target, (AbstractInsnNode)newLoad);
                InsnList assignment = new InsnList();
                assignment.add((AbstractInsnNode)new JumpInsnNode(167, target));
                assignment.add((AbstractInsnNode)newTarget);
                if (newOwnerLoad1 != null) {
                    assignment.add((AbstractInsnNode)newOwnerLoad1);
                    this.registerInstruction(mn, (AbstractInsnNode)target, (AbstractInsnNode)newOwnerLoad1);
                }
                if (newOwnerLoad2 != null) {
                    assignment.add((AbstractInsnNode)newOwnerLoad2);
                    this.registerInstruction(mn, (AbstractInsnNode)target, (AbstractInsnNode)newOwnerLoad2);
                }
                assignment.add((AbstractInsnNode)newLoad);
                assignment.add((AbstractInsnNode)newStore);
                jumpNode.label = newTarget;
                mn.instructions.insertBefore((AbstractInsnNode)target, assignment);
            }
            this.addedInsns.add((AbstractInsnNode)newStore);
            this.addedInsns.add((AbstractInsnNode)newLoad);
        }
    }

    private void registerInstruction(MethodNode mn, AbstractInsnNode oldValue, AbstractInsnNode newValue) {
        BytecodeInstruction oldInstruction = BytecodeInstructionPool.getInstance(this.booleanTestabilityTransformation.classLoader).getInstruction(this.booleanTestabilityTransformation.className, mn.name + mn.desc, oldValue);
        BytecodeInstruction instruction = BytecodeInstructionFactory.createBytecodeInstruction(this.booleanTestabilityTransformation.classLoader, this.booleanTestabilityTransformation.className, mn.name + mn.desc, oldInstruction.getInstructionId(), 0, newValue);
        instruction.setBasicBlock(oldInstruction.getBasicBlock());
        BytecodeInstructionPool.getInstance(this.booleanTestabilityTransformation.classLoader).registerInstruction(instruction);
    }

    private void handleDependency(ControlDependency dependency, ControlDependenceGraph cdg, MethodNode mn, VarInsnNode varNode, BytecodeInstruction parentLevel) {
        if (this.addedNodes.contains(dependency)) {
            return;
        }
        Set<BasicBlock> blocks = cdg.getAlternativeBlocks(dependency);
        this.addedNodes.add(dependency);
        Set<ControlDependency> dependencies = dependency.getBranch().getInstruction().getControlDependencies();
        for (ControlDependency dep : dependencies) {
            if (this.addedNodes.contains(dep) || dep == dependency) continue;
            this.handleDependency(dep, cdg, mn, varNode, dependency.getBranch().getInstruction());
        }
        boolean hasAssignment = false;
        for (BasicBlock block : blocks) {
            for (BytecodeInstruction instruction : block) {
                if (instruction.getASMNode().getOpcode() != 54) continue;
                VarInsnNode otherVarNode = (VarInsnNode)instruction.getASMNode();
                VarInsnNode thisVarNode = varNode;
                if (otherVarNode.var != thisVarNode.var) continue;
                hasAssignment = true;
                break;
            }
            if (!hasAssignment) continue;
            break;
        }
        if (!hasAssignment) {
            TransformationStatistics.transformedImplicitElse();
            if (dependency.getBranch().getInstruction().isSwitch()) {
                BooleanTestabilityTransformation.logger.warn("Don't know how to handle Switches yet");
                return;
            }
            JumpInsnNode jumpNode = (JumpInsnNode)dependency.getBranch().getInstruction().getASMNode();
            VarInsnNode newStore = new VarInsnNode(54, varNode.var);
            VarInsnNode newLoad = new VarInsnNode(21, varNode.var);
            if (dependency.getBranchExpressionValue()) {
                BooleanTestabilityTransformation.logger.info("Inserting else branch directly after if");
                if (this.isDefinedBefore(mn, varNode, (AbstractInsnNode)jumpNode)) {
                    mn.instructions.insert((AbstractInsnNode)jumpNode, (AbstractInsnNode)newStore);
                    mn.instructions.insert((AbstractInsnNode)jumpNode, (AbstractInsnNode)newLoad);
                    this.registerInstruction(mn, (AbstractInsnNode)varNode, (AbstractInsnNode)newStore);
                    this.registerInstruction(mn, (AbstractInsnNode)varNode, (AbstractInsnNode)newLoad);
                }
            } else {
                BooleanTestabilityTransformation.logger.info("Inserting else branch as jump target");
                if (this.isDefinedBefore(mn, varNode, (AbstractInsnNode)jumpNode)) {
                    LabelNode target = jumpNode.label;
                    LabelNode newTarget = new LabelNode(new Label());
                    this.registerInstruction(mn, jumpNode.getNext(), (AbstractInsnNode)newStore);
                    this.registerInstruction(mn, jumpNode.getNext(), (AbstractInsnNode)newLoad);
                    InsnList assignment = new InsnList();
                    assignment.add((AbstractInsnNode)new JumpInsnNode(167, target));
                    assignment.add((AbstractInsnNode)newTarget);
                    assignment.add((AbstractInsnNode)newLoad);
                    assignment.add((AbstractInsnNode)newStore);
                    jumpNode.label = newTarget;
                    mn.instructions.insertBefore((AbstractInsnNode)target, assignment);
                }
            }
        }
    }

    @Override
    protected AbstractInsnNode transformFieldInsnNode(MethodNode mn, FieldInsnNode fieldNode) {
        if ((fieldNode.getOpcode() == 181 || fieldNode.getOpcode() == 179) && DescriptorMapping.getInstance().isTransformedOrBooleanField(fieldNode.owner, fieldNode.name, fieldNode.desc)) {
            if (this.addedInsns.contains(fieldNode)) {
                return fieldNode;
            }
            if (fieldNode.getOpcode() == 181) {
                AbstractInsnNode previous = fieldNode.getPrevious();
                while (previous instanceof LineNumberNode || previous instanceof FrameNode || previous.getOpcode() == 3 || previous.getOpcode() == 4) {
                    previous = previous.getPrevious();
                }
                if (previous.getOpcode() != 25) {
                    BooleanTestabilityTransformation.logger.info("Can't handle case of " + previous);
                    return fieldNode;
                }
                VarInsnNode varNode = (VarInsnNode)previous;
                if (varNode.var != 0) {
                    BooleanTestabilityTransformation.logger.info("Can't handle case of " + previous);
                    return fieldNode;
                }
            }
            BooleanTestabilityTransformation.logger.info("Handling PUTFIELD case!");
            ControlDependenceGraph cdg = GraphPool.getInstance(this.booleanTestabilityTransformation.classLoader).getCDG(this.booleanTestabilityTransformation.className.replace("/", "."), mn.name + mn.desc);
            int index = mn.instructions.indexOf((AbstractInsnNode)fieldNode);
            BooleanTestabilityTransformation.logger.info("Getting bytecode instruction for " + fieldNode.name + "/" + ((FieldInsnNode)mn.instructions.get((int)index)).name);
            InsnList nodes = mn.instructions;
            ListIterator it = nodes.iterator();
            while (it.hasNext()) {
                BytecodeInstruction in = new BytecodeInstruction(this.booleanTestabilityTransformation.classLoader, this.booleanTestabilityTransformation.className, mn.name, 0, 0, (AbstractInsnNode)it.next());
                BooleanTestabilityTransformation.logger.info(in.toString());
            }
            BytecodeInstruction insn = BytecodeInstructionPool.getInstance(this.booleanTestabilityTransformation.classLoader).getInstruction(this.booleanTestabilityTransformation.className.replace("/", "."), mn.name + mn.desc, index);
            if (insn == null) {
                insn = BytecodeInstructionPool.getInstance(this.booleanTestabilityTransformation.classLoader).getInstruction(this.booleanTestabilityTransformation.className.replace("/", "."), mn.name + mn.desc, (AbstractInsnNode)fieldNode);
            }
            if (insn == null) {
                BooleanTestabilityTransformation.logger.info("ERROR: Could not find node");
                return fieldNode;
            }
            if (insn.getASMNode().getOpcode() != fieldNode.getOpcode()) {
                BooleanTestabilityTransformation.logger.info("Found wrong bytecode instruction at this index!");
                BytecodeInstructionPool.getInstance(this.booleanTestabilityTransformation.classLoader).getInstruction(this.booleanTestabilityTransformation.className, mn.name + mn.desc, (AbstractInsnNode)fieldNode);
            }
            if (insn.getBasicBlock() == null) {
                BooleanTestabilityTransformation.logger.info("ERROR: Problematic node found");
                return fieldNode;
            }
            Set<ControlDependency> dependencies = insn.getControlDependencies();
            BooleanTestabilityTransformation.logger.info("Found flag assignment: " + insn + ", checking " + dependencies.size() + " control dependencies");
            for (ControlDependency dep : dependencies) {
                if (this.addedNodes.contains(dep)) continue;
                this.handleDependency(dep, cdg, mn, fieldNode, insn);
            }
        }
        return fieldNode;
    }

    @Override
    protected AbstractInsnNode transformVarInsnNode(MethodNode mn, VarInsnNode varNode) {
        if (varNode.getOpcode() == 54 && this.booleanTestabilityTransformation.isBooleanVariable(varNode.var, mn)) {
            ControlDependenceGraph cdg = GraphPool.getInstance(this.booleanTestabilityTransformation.classLoader).getCDG(this.booleanTestabilityTransformation.className.replace("/", "."), mn.name + mn.desc);
            int index = mn.instructions.indexOf((AbstractInsnNode)varNode);
            BytecodeInstruction insn = BytecodeInstructionPool.getInstance(this.booleanTestabilityTransformation.classLoader).getInstruction(this.booleanTestabilityTransformation.className.replace("/", "."), mn.name + mn.desc, index);
            if (insn == null) {
                BooleanTestabilityTransformation.logger.info("WARNING: Instruction not found!");
                return varNode;
            }
            if (insn.getASMNode().getOpcode() != varNode.getOpcode()) {
                BooleanTestabilityTransformation.logger.info("Found wrong bytecode instruction at this index!");
                insn = BytecodeInstructionPool.getInstance(this.booleanTestabilityTransformation.classLoader).getInstruction(this.booleanTestabilityTransformation.className, mn.name + mn.desc, (AbstractInsnNode)varNode);
                if (insn == null) {
                    BooleanTestabilityTransformation.logger.info("WARNING: Instruction not found!");
                    return varNode;
                }
            }
            Set<ControlDependency> dependencies = insn.getControlDependencies();
            BooleanTestabilityTransformation.logger.info("Found flag assignment: " + insn + ", checking " + dependencies.size() + " control dependencies");
            for (ControlDependency dep : dependencies) {
                if (this.addedNodes.contains(dep)) continue;
                this.handleDependency(dep, cdg, mn, varNode, insn);
            }
        }
        return varNode;
    }
}

