/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.junit;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.TestSuiteGenerator;
import org.evosuite.classpath.ClassPathHandler;
import org.evosuite.classpath.ResourceList;
import org.evosuite.coverage.mutation.Mutation;
import org.evosuite.coverage.mutation.MutationObserver;
import org.evosuite.coverage.mutation.MutationPool;
import org.evosuite.junit.CoverageReportGenerator;
import org.evosuite.junit.JUnitResult;
import org.evosuite.junit.JUnitRunner;
import org.evosuite.rmi.ClientServices;
import org.evosuite.runtime.sandbox.Sandbox;
import org.evosuite.setup.DependencyAnalysis;
import org.evosuite.setup.TestCluster;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.ExecutionTrace;
import org.evosuite.utils.ArrayUtil;
import org.evosuite.utils.ExternalProcessUtilities;
import org.evosuite.utils.LoggingUtils;
import org.junit.Test;
import org.junit.runners.Suite;
import org.objectweb.asm.ClassReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoverageAnalysis {
    private final ExternalProcessUtilities util = new ExternalProcessUtilities();
    private static final Logger logger = LoggerFactory.getLogger(CoverageAnalysis.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void analyzeCoverage() {
        Sandbox.goingToExecuteSUTCode();
        TestGenerationContext.getInstance().goingToExecuteSUTCode();
        Sandbox.goingToExecuteUnsafeCodeOnSameThread();
        try {
            String cp = ClassPathHandler.getInstance().getTargetProjectClasspath();
            DependencyAnalysis.analyze(Properties.TARGET_CLASS, Arrays.asList(cp.split(File.pathSeparator)));
            LoggingUtils.getEvoLogger().info("* Finished analyzing classpath");
        }
        catch (Throwable e) {
            LoggingUtils.getEvoLogger().error("* Error while initializing target class: " + (e.getMessage() != null ? e.getMessage() : e.toString()));
            logger.error("Problem for " + Properties.TARGET_CLASS + ". Full stack:", e);
            return;
        }
        finally {
            Sandbox.doneWithExecutingUnsafeCodeOnSameThread();
            Sandbox.doneWithExecutingSUTCode();
            TestGenerationContext.getInstance().doneWithExecuteingSUTCode();
        }
        List<Class<?>> junitTests = CoverageAnalysis.getClasses();
        LoggingUtils.getEvoLogger().info("* Found " + junitTests.size() + " unit test classes");
        if (junitTests.isEmpty()) {
            return;
        }
        CoverageAnalysis.sortTestClasses(junitTests);
        Class[] classes = junitTests.toArray(new Class[junitTests.size()]);
        LoggingUtils.getEvoLogger().info("* Executing tests");
        if (ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.MUTATION) || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.STRONGMUTATION)) {
            CoverageAnalysis.junitMutationAnalysis(classes);
        } else {
            long startTime = System.currentTimeMillis();
            List<JUnitResult> results = CoverageAnalysis.executeTests(classes);
            CoverageAnalysis.printReport(results, junitTests, startTime);
        }
    }

    public static void junitMutationAnalysis(Class<?>[] classes) {
        long startTime = System.currentTimeMillis();
        Set<Mutation> killed = CoverageAnalysis.executeTestsForMutationAnalysis(classes);
        List<Mutation> mutants = MutationPool.getMutants();
        if (Properties.NEW_STATISTICS) {
            ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Total_Goals, mutants.size());
            ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Covered_Goals, killed.size());
            if (mutants.isEmpty()) {
                ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.BranchCoverage, 0.0);
                ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Coverage, 1.0);
                ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.MutationScore, 1.0);
            } else {
                ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.BranchCoverage, 0.0);
                ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Coverage, (double)killed.size() / (double)mutants.size());
                ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.MutationScore, (double)killed.size() / (double)mutants.size());
            }
            ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Total_Time, System.currentTimeMillis() - startTime);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static double getCoverage() {
        TestCluster.getInstance();
        List<Class<?>> junitTests = CoverageAnalysis.getClasses();
        LoggingUtils.getEvoLogger().info("* Found " + junitTests.size() + " unit test classes");
        if (junitTests.isEmpty()) {
            return 0.0;
        }
        Class[] classes = new Class[junitTests.size()];
        junitTests.toArray(classes);
        LoggingUtils.getEvoLogger().info("* Executing tests");
        List<JUnitResult> result = CoverageAnalysis.executeTests(classes);
        return CoverageAnalysis.getCoverage(result);
    }

    private static double getCoverage(List<JUnitResult> results) {
        LoggingUtils.getEvoLogger().info("* Executed " + results.size() + " tests");
        TestChromosome dummy = new TestChromosome();
        ExecutionResult executionResult = new ExecutionResult(dummy.getTestCase());
        dummy.setChanged(false);
        int covered = 0;
        List<? extends TestFitnessFunction> goals = TestSuiteGenerator.getFitnessFactory().get(0).getCoverageGoals();
        for (JUnitResult testResult : results) {
            executionResult.setTrace(testResult.getExecutionTrace());
            dummy.setLastExecutionResult(executionResult);
            for (TestFitnessFunction testFitnessFunction : goals) {
                if (!testFitnessFunction.isCovered(dummy)) continue;
                ++covered;
            }
        }
        return (double)covered / (double)goals.size();
    }

    public static List<TestFitnessFunction> getCoveredGoals(Class<?> testClass, List<TestFitnessFunction> allGoals) {
        TestChromosome dummy = new TestChromosome();
        dummy.setChanged(false);
        ExecutionResult executionResult = new ExecutionResult(dummy.getTestCase());
        ArrayList<TestFitnessFunction> coveredGoals = new ArrayList<TestFitnessFunction>();
        List<JUnitResult> results = CoverageAnalysis.executeTests(testClass);
        for (JUnitResult testResult : results) {
            executionResult.setTrace(testResult.getExecutionTrace());
            dummy.setLastExecutionResult(executionResult);
            for (TestFitnessFunction goal : allGoals) {
                if (!goal.isCovered(dummy)) continue;
                coveredGoals.add(goal);
            }
        }
        return coveredGoals;
    }

    private static List<Class<?>> getClassesFromClasspath() {
        ArrayList classes = new ArrayList();
        for (String prefix : Properties.JUNIT_PREFIX.split(":")) {
            Set<String> suts = ResourceList.getAllClasses(ClassPathHandler.getInstance().getTargetProjectClasspath(), prefix, false);
            LoggingUtils.getEvoLogger().info("* Found " + suts.size() + " classes with prefix " + prefix);
            if (suts.isEmpty()) continue;
            for (String sut : suts) {
                try {
                    Class<?> clazz = Class.forName(sut, true, TestGenerationContext.getInstance().getClassLoaderForSUT());
                    if (!CoverageAnalysis.isTest(clazz)) continue;
                    classes.add(clazz);
                }
                catch (ClassNotFoundException e2) {
                    logger.info("Could not find class " + sut);
                }
                catch (Throwable t) {
                    logger.info("Error while initialising class " + sut);
                }
            }
        }
        return classes;
    }

    private static List<Class<?>> getClasses() {
        ArrayList classes = new ArrayList();
        logger.debug("JUNIT_PREFIX: " + Properties.JUNIT_PREFIX);
        for (String prefix : Properties.JUNIT_PREFIX.split(":")) {
            LoggingUtils.getEvoLogger().info("* Analyzing entry: " + prefix);
            File path = new File(prefix);
            if (path.exists()) {
                if (Properties.JUNIT_PREFIX.endsWith(".jar")) {
                    classes.addAll(CoverageAnalysis.getClassesJar(path));
                    continue;
                }
                classes.addAll(CoverageAnalysis.getClasses(path));
                continue;
            }
            try {
                Class<?> junitClass = Class.forName(prefix, true, TestGenerationContext.getInstance().getClassLoaderForSUT());
                classes.add(junitClass);
            }
            catch (ClassNotFoundException e) {
                classes.addAll(CoverageAnalysis.getClassesFromClasspath());
            }
        }
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Class<?>> getClasses(File directory) {
        if (directory.getName().endsWith(".class")) {
            ArrayList classes = new ArrayList();
            LoggingUtils.muteCurrentOutAndErrStream();
            try {
                File file = new File(directory.getPath());
                byte[] array = new byte[(int)file.length()];
                ByteArrayOutputStream out = new ByteArrayOutputStream(array.length);
                try (FileInputStream in = new FileInputStream(file);){
                    int length = ((InputStream)in).read(array);
                    while (length > 0) {
                        out.write(array, 0, length);
                        length = ((InputStream)in).read(array);
                    }
                }
                ClassReader reader = new ClassReader(array);
                String className = reader.getClassName();
                Class<?> clazz = Class.forName(className.replace("/", "."), true, TestGenerationContext.getInstance().getClassLoaderForSUT());
                LoggingUtils.restorePreviousOutAndErrStream();
                if (CoverageAnalysis.isTest(clazz)) {
                    classes.add(clazz);
                }
            }
            catch (IllegalAccessError e) {
                LoggingUtils.restorePreviousOutAndErrStream();
                System.out.println("  Cannot access class " + directory.getName().substring(0, directory.getName().length() - 6) + ": " + e);
            }
            catch (NoClassDefFoundError e) {
                LoggingUtils.restorePreviousOutAndErrStream();
                System.out.println("  Error while loading " + directory.getName().substring(0, directory.getName().length() - 6) + ": Cannot find " + e.getMessage());
            }
            catch (ExceptionInInitializerError e) {
                LoggingUtils.restorePreviousOutAndErrStream();
                System.out.println("  Exception in initializer of " + directory.getName().substring(0, directory.getName().length() - 6));
            }
            catch (ClassNotFoundException e) {
                LoggingUtils.restorePreviousOutAndErrStream();
                System.out.println("  Class not found in classpath: " + directory.getName().substring(0, directory.getName().length() - 6) + ": " + e);
            }
            catch (Throwable e) {
                LoggingUtils.restorePreviousOutAndErrStream();
                System.out.println("  Unexpected error: " + directory.getName().substring(0, directory.getName().length() - 6) + ": " + e);
            }
            return classes;
        }
        if (directory.isDirectory()) {
            ArrayList classes = new ArrayList();
            for (File file : directory.listFiles()) {
                classes.addAll(CoverageAnalysis.getClasses(file));
            }
            return classes;
        }
        return new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Class<?>> getClassesJar(File file) {
        ZipFile zf;
        ArrayList classes = new ArrayList();
        try {
            zf = new ZipFile(file);
        }
        catch (ZipException e) {
            throw new Error(e);
        }
        catch (IOException e) {
            throw new Error(e);
        }
        Enumeration<? extends ZipEntry> e = zf.entries();
        while (e.hasMoreElements()) {
            ZipEntry ze = e.nextElement();
            String fileName = ze.getName();
            if (!fileName.endsWith(".class")) continue;
            PrintStream old_out = System.out;
            PrintStream old_err = System.err;
            try {
                Class<?> clazz = Class.forName(fileName.replace(".class", "").replace("/", "."), true, TestGenerationContext.getInstance().getClassLoaderForSUT());
                if (!CoverageAnalysis.isTest(clazz)) continue;
                classes.add(clazz);
            }
            catch (IllegalAccessError ex) {
                System.setOut(old_out);
                System.setErr(old_err);
                System.out.println("Cannot access class " + file.getName().substring(0, file.getName().length() - 6));
            }
            catch (NoClassDefFoundError ex) {
                System.setOut(old_out);
                System.setErr(old_err);
                System.out.println("Cannot find dependent class " + ex);
            }
            catch (ExceptionInInitializerError ex) {
                System.setOut(old_out);
                System.setErr(old_err);
                System.out.println("Exception in initializer of " + file.getName().substring(0, file.getName().length() - 6));
            }
            catch (ClassNotFoundException ex) {
                System.setOut(old_out);
                System.setErr(old_err);
                System.out.println("Cannot find class " + file.getName().substring(0, file.getName().length() - 6) + ": " + ex);
            }
            catch (Throwable t) {
                System.setOut(old_out);
                System.setErr(old_err);
                System.out.println("  Unexpected error: " + file.getName().substring(0, file.getName().length() - 6) + ": " + t);
            }
            finally {
                System.setOut(old_out);
                System.setErr(old_err);
            }
        }
        try {
            zf.close();
        }
        catch (IOException e1) {
            throw new Error(e1);
        }
        return classes;
    }

    private static void printReport(List<JUnitResult> results, List<Class<?>> classes, long startTime) {
        LoggingUtils.getEvoLogger().info("* Executed " + results.size() + " tests");
        List<? extends TestFitnessFunction> goals = TestSuiteGenerator.getFitnessFactory().get(0).getCoverageGoals();
        TestChromosome dummy = new TestChromosome();
        dummy.setChanged(false);
        ExecutionResult executionResult = new ExecutionResult(dummy.getTestCase());
        HashSet<Integer> coveredLines = new HashSet<Integer>();
        HashSet<String> explicitExceptionNames = new HashSet<String>();
        int numTests = 0;
        boolean[][] coverage = new boolean[results.size()][goals.size() + 1];
        int index_test = 0;
        BitSet coveredGoals = new BitSet();
        for (JUnitResult tR : results) {
            executionResult.setTrace(tR.getExecutionTrace());
            dummy.setLastExecutionResult(executionResult);
            coveredLines.addAll(tR.getExecutionTrace().getCoveredLines());
            if (tR.getExecutionTrace().getExplicitException() != null) {
                explicitExceptionNames.add(tR.getExecutionTrace().getExplicitException().getClass().getName());
            }
            boolean hasCoverage = false;
            int index_component = 0;
            for (TestFitnessFunction testFitnessFunction : goals) {
                if (testFitnessFunction.isCovered(dummy)) {
                    hasCoverage = true;
                    coveredGoals.set(index_component);
                    coverage[index_test][index_component] = true;
                } else {
                    coverage[index_test][index_component] = false;
                }
                ++index_component;
            }
            if (hasCoverage) {
                ++numTests;
            }
            coverage[index_test++][goals.size()] = tR.wasSuccessful();
        }
        LoggingUtils.getEvoLogger().info("* Covered " + coveredGoals.cardinality() + "/" + goals.size() + " coverage goals: " + NumberFormat.getPercentInstance().format((double)coveredGoals.cardinality() / (double)goals.size()));
        if (Properties.NEW_STATISTICS) {
            ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Minimized_Size, numTests);
            ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Result_Size, results.size());
            ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Total_Goals, goals.size());
            ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Covered_Goals, coveredGoals.size());
            if (goals.isEmpty()) {
                ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.BranchCoverage, 1.0);
                ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Coverage, 1.0);
            } else {
                ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.BranchCoverage, (double)coveredGoals.size() / (double)goals.size());
                ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Coverage, (double)coveredGoals.size() / (double)goals.size());
            }
            ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Total_Time, System.currentTimeMillis() - startTime);
            ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Explicit_TypeExceptions, explicitExceptionNames.size());
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (Properties.COVERAGE_MATRIX) {
            CoverageReportGenerator.writeCoverage(coverage);
        }
    }

    private static List<JUnitResult> executeTests(Class<?> ... junitClasses) {
        ArrayList<JUnitResult> results = new ArrayList<JUnitResult>();
        for (Class<?> junitClass : junitClasses) {
            logger.info("Running test " + junitClass.getSimpleName());
            JUnitRunner jR = new JUnitRunner();
            jR.run(junitClass);
            results.addAll(jR.getTestResults());
        }
        return results;
    }

    private static Set<Mutation> executeTestsForMutationAnalysis(Class<?> ... junitClasses) {
        LinkedHashSet<Mutation> allMutants = new LinkedHashSet<Mutation>(MutationPool.getMutants());
        HashSet<Mutation> killed = new HashSet<Mutation>();
        for (Class<?> clazz : junitClasses) {
            try {
                logger.info("Remaining mutants: " + allMutants.size());
                logger.info("Running test class: " + clazz.getSimpleName());
                List<JUnitResult> results = CoverageAnalysis.executeTests(clazz);
                for (JUnitResult tR : results) {
                    ExecutionTrace trace = tR.getExecutionTrace();
                    for (Integer mutationID : trace.getTouchedMutants()) {
                        Mutation m = MutationPool.getMutant(mutationID);
                        if (!allMutants.contains(m)) continue;
                        MutationObserver.activateMutation(mutationID);
                        List<JUnitResult> mutationResults = CoverageAnalysis.executeTests(clazz);
                        MutationObserver.deactivateMutation();
                        for (JUnitResult mR : mutationResults) {
                            if (mR.getFailureCount() == tR.getFailureCount()) continue;
                            logger.info("Mutation killed: " + mutationID);
                            allMutants.remove(m);
                            killed.add(m);
                        }
                    }
                }
            }
            catch (Throwable t) {
                logger.warn("Error during test execution: " + t + ", " + t.getMessage());
                for (StackTraceElement elem : t.getStackTrace()) {
                    logger.warn(elem.toString());
                }
            }
        }
        return killed;
    }

    public static boolean isTest(Class<?> clazz) {
        Class<?> superClazz = clazz.getSuperclass();
        while (superClazz != null && !superClazz.equals(Object.class) && !superClazz.equals(clazz)) {
            if (superClazz.equals(Suite.class)) {
                return true;
            }
            if (superClazz.equals(TestSuite.class)) {
                return true;
            }
            if (superClazz.equals(Test.class)) {
                return true;
            }
            if (superClazz.equals(TestCase.class)) {
                return true;
            }
            if (superClazz.equals(clazz.getSuperclass())) break;
            superClazz = clazz.getSuperclass();
        }
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Test.class)) continue;
            return true;
        }
        return false;
    }

    private static void sortTestClasses(List<Class<?>> tests) {
        Collections.sort(tests, new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> t0, Class<?> t1) {
                return Integer.valueOf(t1.getName().length()).compareTo(t0.getName().length());
            }
        });
    }

    public void run() {
        LoggingUtils.getEvoLogger().info("* Connecting to master process on port " + Properties.PROCESS_COMMUNICATION_PORT);
        if (!this.util.connectToMainProcess()) {
            throw new RuntimeException("Could not connect to master process on port " + Properties.PROCESS_COMMUNICATION_PORT);
        }
        CoverageAnalysis.analyzeCoverage();
        this.util.informSearchIsFinished(null);
    }

    @Deprecated
    public static void main(String[] args) {
        LoggingUtils.getEvoLogger().error("Cannot start CoverageAnalysis directly");
    }
}

