/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.junit;

import java.util.List;
import java.util.Map;
import org.evosuite.Properties;
import org.evosuite.junit.UnitTestAdapter;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestCodeVisitor;

public class JUnit4TestAdapter
implements UnitTestAdapter {
    private String getJUnitTestShortName() {
        if (Properties.TARGET_CLASS.equals("Test")) {
            return "org.junit.Test";
        }
        return "Test";
    }

    @Override
    public String getImports() {
        String imports = "import static org.junit.Assert.*;\n";
        if (Properties.ECLIPSE_PLUGIN) {
            imports = imports + "import org.evosuite.annotations.EvoSuiteTest;\n";
        }
        if (!Properties.TARGET_CLASS.equals("Test")) {
            imports = imports + "import org.junit.Test;\n";
        }
        return imports;
    }

    @Override
    public String getClassDefinition(String testName) {
        return "public class " + testName;
    }

    @Override
    public String getMethodDefinition(String testName) {
        StringBuilder builder = new StringBuilder();
        if (Properties.ECLIPSE_PLUGIN) {
            builder.append("  @EvoSuiteTest\n");
        }
        builder.append("  @" + this.getJUnitTestShortName() + "\n");
        builder.append("  public void " + testName + "() ");
        return builder.toString();
    }

    @Override
    public String getSuite(List<String> suites) {
        StringBuilder builder = new StringBuilder();
        builder.append("import org.junit.runner.RunWith;\n");
        builder.append("import org.junit.runners.Suite;\n\n");
        for (String suite : suites) {
            if (!suite.contains(".")) continue;
            builder.append("import ");
            builder.append(suite);
            builder.append(";\n");
        }
        builder.append("\n");
        builder.append("@RunWith(Suite.class)\n");
        builder.append("@Suite.SuiteClasses({\n");
        boolean first = true;
        for (String suite : suites) {
            if (!first) {
                builder.append(",\n");
            }
            first = false;
            builder.append("  ");
            builder.append(suite.substring(suite.lastIndexOf(".") + 1));
            builder.append(".class");
        }
        builder.append("})\n");
        builder.append(this.getClassDefinition("GeneratedTestSuite"));
        builder.append(" {\n");
        builder.append("}\n");
        return builder.toString();
    }

    @Override
    public String getTestString(int id, TestCase test, Map<Integer, Throwable> exceptions) {
        return test.toCode(exceptions);
    }

    @Override
    public String getTestString(int id, TestCase test, Map<Integer, Throwable> exceptions, TestCodeVisitor visitor) {
        visitor.setExceptions(exceptions);
        test.accept(visitor);
        visitor.clearExceptions();
        return visitor.getCode();
    }
}

