/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.junit;

import org.evosuite.junit.CoverageAnalysis;
import org.evosuite.junit.JUnitResult;
import org.evosuite.junit.JUnitRunner;
import org.evosuite.testcase.execution.ExecutionTracer;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JUnitRunListener
extends RunListener {
    private static final Logger logger = LoggerFactory.getLogger(CoverageAnalysis.class);
    private JUnitRunner junitRunner = null;
    private JUnitResult testResult = null;
    private long start;

    public JUnitRunListener(JUnitRunner jR) {
        this.junitRunner = jR;
    }

    public void testRunStarted(Description description) {
        logger.debug("Number of test cases to execute: " + description.testCount());
    }

    public void testRunFinished(Result result) {
        logger.debug("Number of test cases to executed: " + result.getRunCount());
    }

    public void testStarted(Description description) {
        logger.debug("* Started: ClassName: " + description.getClassName() + ", MethodName: " + description.getMethodName());
        this.start = System.nanoTime();
        this.testResult = new JUnitResult(description.getClassName() + "#" + description.getMethodName());
        ExecutionTracer.enable();
        ExecutionTracer.enableTraceCalls();
        ExecutionTracer.setCheckCallerThread(false);
    }

    public void testFinished(Description description) {
        logger.debug("* Finished: ClassName: " + description.getClassName() + ", MethodName: " + description.getMethodName());
        ExecutionTracer.disable();
        this.testResult.setRuntime(System.nanoTime() - this.start);
        this.testResult.setExecutionTrace(ExecutionTracer.getExecutionTracer().getTrace());
        this.testResult.incrementRunCount();
        ExecutionTracer.getExecutionTracer().clear();
        this.junitRunner.addResult(this.testResult);
    }

    public void testFailure(Failure failure) {
        logger.debug("* Failure: " + failure.getMessage());
        this.testResult.setSuccessful(false);
        this.testResult.setTrace(failure.getTrace());
        this.testResult.incrementFailureCount();
    }

    public void testIgnored(Description description) throws Exception {
        logger.debug("Execution of test case ignored: " + description.getMethodName());
    }
}

