/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.regression;

import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.ga.localsearch.LocalSearchObjective;
import org.evosuite.testcase.DefaultTestCase;
import org.evosuite.testcase.ExecutableChromosome;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testsuite.TestSuiteFitnessFunction;

public class RegressionTestChromosome
extends ExecutableChromosome {
    private static final long serialVersionUID = -6345178117840330196L;
    private TestChromosome theTest;
    private TestChromosome theSameTestForTheOtherClassLoader;
    private ClassLoader theClassLoader = null;

    @Override
    protected void copyCachedResults(ExecutableChromosome other) {
        RegressionTestChromosome otherChromosome = (RegressionTestChromosome)other;
        this.theTest.copyCachedResults(otherChromosome.theTest);
        this.theSameTestForTheOtherClassLoader.copyCachedResults(otherChromosome.theSameTestForTheOtherClassLoader);
    }

    @Override
    public ExecutionResult executeForFitnessFunction(TestSuiteFitnessFunction testSuiteFitnessFunction) {
        return null;
    }

    @Override
    public Chromosome clone() {
        RegressionTestChromosome copy = new RegressionTestChromosome();
        copy.theClassLoader = this.theClassLoader;
        copy.theTest = (TestChromosome)this.theTest.clone();
        copy.theSameTestForTheOtherClassLoader = (TestChromosome)this.theSameTestForTheOtherClassLoader.clone();
        return copy;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.theClassLoader == null ? 0 : this.theClassLoader.hashCode());
        result = 31 * result + (this.theTest == null ? 0 : this.theTest.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegressionTestChromosome other = (RegressionTestChromosome)obj;
        if (this.theClassLoader == null ? other.theClassLoader != null : !this.theClassLoader.equals(other.theClassLoader)) {
            return false;
        }
        return !(this.theTest == null ? other.theTest != null : !this.theTest.equals(other.theTest));
    }

    public int compareSecondaryObjective(Chromosome o) {
        RegressionTestChromosome otherChromosome = (RegressionTestChromosome)o;
        return this.theTest.compareSecondaryObjective(otherChromosome.theTest);
    }

    @Override
    public void mutate() {
        this.theTest.mutate();
        if (this.theTest.isChanged()) {
            this.updateClassloader();
        }
    }

    @Override
    public void crossOver(Chromosome other, int position1, int position2) throws ConstructionFailedException {
        RegressionTestChromosome otherChromosome = (RegressionTestChromosome)other;
        this.theTest.crossOver(otherChromosome.theTest, position1, position2);
        this.updateClassloader();
    }

    private void updateClassloader() {
        if (this.theTest.isChanged()) {
            this.theSameTestForTheOtherClassLoader = (TestChromosome)this.theTest.clone();
            ((DefaultTestCase)this.theSameTestForTheOtherClassLoader.getTestCase()).changeClassLoader(this.theClassLoader);
        }
    }

    public boolean localSearch(LocalSearchObjective objective) {
        boolean result = this.theTest.localSearch(objective);
        this.updateClassloader();
        return result;
    }

    @Override
    public int size() {
        return this.theTest.size();
    }

    public void setTest(TestChromosome theTest) {
        this.theTest = theTest;
        this.updateClassloader();
    }

    public TestChromosome getTheTest() {
        return this.theTest;
    }

    public TestChromosome getTheSameTestForTheOtherClassLoader() {
        return this.theSameTestForTheOtherClassLoader;
    }
}

