/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.rmi;

import java.rmi.NoSuchObjectException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import org.evosuite.Properties;
import org.evosuite.rmi.UtilsRMI;
import org.evosuite.rmi.service.ClientNodeImpl;
import org.evosuite.rmi.service.ClientNodeLocal;
import org.evosuite.rmi.service.ClientNodeRemote;
import org.evosuite.rmi.service.DummyClientNodeImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientServices {
    private static Logger logger = LoggerFactory.getLogger(ClientServices.class);
    private static ClientServices instance = new ClientServices();
    private volatile ClientNodeImpl clientNode = new DummyClientNodeImpl();

    protected ClientServices() {
    }

    public static ClientServices getInstance() {
        return instance;
    }

    public boolean registerServices() {
        UtilsRMI.ensureRegistryOnLoopbackAddress();
        try {
            int port = Properties.PROCESS_COMMUNICATION_PORT;
            Registry registry = LocateRegistry.getRegistry(port);
            this.clientNode = new ClientNodeImpl(registry);
            ClientNodeRemote stub = (ClientNodeRemote)UtilsRMI.exportObject(this.clientNode);
            registry.rebind(this.clientNode.getClientRmiIdentifier(), stub);
            return this.clientNode.init();
        }
        catch (Exception e) {
            logger.error("Failed to register client services", (Throwable)e);
            return false;
        }
    }

    public ClientNodeLocal getClientNode() {
        return this.clientNode;
    }

    public void stopServices() {
        if (this.clientNode != null) {
            this.clientNode.stop();
            int i = 0;
            int tries = 10;
            boolean done = false;
            try {
                while (!done) {
                    done = UnicastRemoteObject.unexportObject(this.clientNode, false);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    if (++i < 10) continue;
                    logger.error("Tried 10 times to stop RMI ClientNode, giving up");
                    break;
                }
            }
            catch (NoSuchObjectException e) {
                logger.debug("Failed to delete ClientNode RMI instance", (Throwable)e);
            }
            this.clientNode = new DummyClientNodeImpl();
        }
    }
}

