/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.seeding;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.seeding.ConstantPool;
import org.evosuite.utils.LoggingUtils;
import org.evosuite.utils.Randomness;
import org.objectweb.asm.Type;

public class StaticConstantPool
implements ConstantPool {
    private final Set<String> stringPool = Collections.synchronizedSet(new LinkedHashSet());
    private final Set<Type> typePool = Collections.synchronizedSet(new LinkedHashSet());
    private final Set<Integer> intPool = Collections.synchronizedSet(new LinkedHashSet());
    private final Set<Double> doublePool = Collections.synchronizedSet(new LinkedHashSet());
    private final Set<Long> longPool = Collections.synchronizedSet(new LinkedHashSet());
    private final Set<Float> floatPool = Collections.synchronizedSet(new LinkedHashSet());

    public StaticConstantPool() {
        this.stringPool.add("");
        if (Properties.TARGET_CLASS != null && !Properties.TARGET_CLASS.isEmpty()) {
            this.typePool.add(Type.getObjectType((String)Properties.TARGET_CLASS));
        } else {
            this.typePool.add(Type.getType(Object.class));
        }
        this.intPool.add(0);
        this.intPool.add(1);
        this.intPool.add(-1);
        this.longPool.add(0L);
        this.longPool.add(1L);
        this.longPool.add(-1L);
        this.floatPool.add(Float.valueOf(0.0f));
        this.floatPool.add(Float.valueOf(1.0f));
        this.floatPool.add(Float.valueOf(-1.0f));
        this.doublePool.add(0.0);
        this.doublePool.add(1.0);
        this.doublePool.add(-1.0);
    }

    @Override
    public String getRandomString() {
        return Randomness.choice(this.stringPool);
    }

    @Override
    public Type getRandomType() {
        return Randomness.choice(this.typePool);
    }

    @Override
    public int getRandomInt() {
        int r = Randomness.choice(this.intPool);
        return r;
    }

    @Override
    public float getRandomFloat() {
        return Randomness.choice(this.floatPool).floatValue();
    }

    @Override
    public double getRandomDouble() {
        return Randomness.choice(this.doublePool);
    }

    @Override
    public long getRandomLong() {
        return Randomness.choice(this.longPool);
    }

    @Override
    public void add(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() > 65535) {
                return;
            }
            this.stringPool.add(string);
        } else if (object instanceof Type) {
            while (((Type)object).getSort() == 9) {
                object = ((Type)object).getElementType();
            }
            this.typePool.add((Type)object);
        } else if (object instanceof Integer) {
            if (Properties.RESTRICT_POOL) {
                int val = (Integer)object;
                if (Math.abs(val) < Properties.MAX_INT) {
                    this.intPool.add((Integer)object);
                }
            } else {
                this.intPool.add((Integer)object);
            }
        } else if (object instanceof Long) {
            if (Properties.RESTRICT_POOL) {
                long val = (Long)object;
                if (Math.abs(val) < (long)Properties.MAX_INT) {
                    this.longPool.add((Long)object);
                }
            } else {
                this.longPool.add((Long)object);
            }
        } else if (object instanceof Float) {
            if (Properties.RESTRICT_POOL) {
                float val = ((Float)object).floatValue();
                if (Math.abs(val) < (float)Properties.MAX_INT) {
                    this.floatPool.add((Float)object);
                }
            } else {
                this.floatPool.add((Float)object);
            }
        } else if (object instanceof Double) {
            if (Properties.RESTRICT_POOL) {
                double val = (Double)object;
                if (Math.abs(val) < (double)Properties.MAX_INT) {
                    this.doublePool.add((Double)object);
                }
            } else {
                this.doublePool.add((Double)object);
            }
        } else {
            LoggingUtils.getEvoLogger().info("Constant of unknown type: " + object.getClass());
        }
    }
}

