/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.setup;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.evosuite.setup.Call;

public class CallContext
implements Serializable {
    private static final long serialVersionUID = 8650619230188403356L;
    private final List<Call> context;
    private final int hcode;

    public boolean isEmpty() {
        return this.context.isEmpty();
    }

    public CallContext(StackTraceElement[] stackTrace) {
        int startPos = stackTrace.length - 1;
        ArrayList<Call> context = new ArrayList<Call>();
        while (stackTrace[startPos].getClassName().startsWith("java") || stackTrace[startPos].getClassName().startsWith("sun") || stackTrace[startPos].getClassName().startsWith("org.evosuite")) {
            --startPos;
        }
        int endPos = 0;
        while (stackTrace[endPos].getClassName().startsWith("java") || stackTrace[endPos].getClassName().startsWith("sun") || stackTrace[endPos].getClassName().startsWith("org.evosuite")) {
            ++endPos;
        }
        for (int i = startPos; i >= endPos; --i) {
            StackTraceElement element = stackTrace[i];
            context.add(new Call(element.getClassName(), element.getMethodName()));
        }
        this.context = context;
        this.hcode = this.context.hashCode();
    }

    public CallContext(String className, String methodName) {
        ArrayList<Call> context = new ArrayList<Call>();
        context.add(new Call(className, methodName));
        this.context = context;
        this.hcode = this.context.hashCode();
    }

    public CallContext() {
        ArrayList<Call> context = new ArrayList<Call>();
        this.context = context;
        this.hcode = this.context.hashCode();
    }

    public CallContext(Collection<Call> contextt) {
        ArrayList<Call> context = new ArrayList<Call>();
        context.addAll(contextt);
        this.context = context;
        this.hcode = this.context.hashCode();
    }

    public int size() {
        return this.context.size();
    }

    @Deprecated
    public CallContext getSuperContext(String className, String methodName) {
        throw new IllegalStateException("YET TO IMPLEMENT, DEPRECATED");
    }

    public String getRootClassName() {
        return this.context.get(0).getClassName();
    }

    public String getRootMethodName() {
        return this.context.get(0).getMethodName();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Call call : this.context) {
            builder.append(call.toString());
            builder.append(" ");
        }
        String tmp = builder.toString();
        return tmp.trim();
    }

    public int hashCode() {
        return this.hcode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CallContext other = (CallContext)obj;
        return this.hcode == other.hcode;
    }

    public boolean oldMatches(CallContext other) {
        if (this.context.size() != other.context.size()) {
            return false;
        }
        if (other.hcode == this.hcode) {
            return true;
        }
        for (int i = 0; i < this.context.size(); ++i) {
            Call call2;
            Call call1 = this.context.get(i);
            if (call1.matches(call2 = other.context.get(i))) continue;
            return false;
        }
        return false;
    }

    public boolean matches(CallContext other) {
        return this.context.isEmpty() || other.context.isEmpty() || other.hcode == this.hcode;
    }

    public List<Call> getContext() {
        return this.context;
    }
}

