/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.setup;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.coverage.branch.BranchPool;
import org.evosuite.coverage.dataflow.DefUsePool;
import org.evosuite.coverage.mutation.MutationPool;
import org.evosuite.graphs.cfg.CFGMethodAdapter;
import org.evosuite.instrumentation.LinePool;
import org.evosuite.rmi.ClientServices;
import org.evosuite.setup.InheritanceTree;
import org.evosuite.setup.InheritanceTreeGenerator;
import org.evosuite.setup.TestClusterGenerator;
import org.evosuite.setup.callgraph.CallGraph;
import org.evosuite.setup.callgraph.CallGraphGenerator;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.utils.ArrayUtil;
import org.junit.Test;
import org.junit.runners.Suite;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyAnalysis {
    private static Logger logger = LoggerFactory.getLogger(DependencyAnalysis.class);
    private static Map<String, ClassNode> classCache = new LinkedHashMap<String, ClassNode>();
    private static CallGraph callGraph = null;
    private static InheritanceTree inheritanceTree = null;

    public static InheritanceTree getInheritanceTree() {
        return inheritanceTree;
    }

    public static void analyze(String className, List<String> classPath) throws RuntimeException, ClassNotFoundException {
        logger.debug("Calculate inheritance hierarchy");
        inheritanceTree = InheritanceTreeGenerator.createFromClassPath(classPath);
        InheritanceTreeGenerator.gatherStatistics(inheritanceTree);
        if (!inheritanceTree.hasClass(Properties.TARGET_CLASS)) {
            throw new ClassNotFoundException("Target class not found in inheritance tree");
        }
        logger.debug("Calculate call tree");
        callGraph = CallGraphGenerator.analyze(className);
        DependencyAnalysis.loadCallTreeClasses();
        if (ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.IBRANCH) || Properties.INSTRUMENT_CONTEXT) {
            for (String classn : inheritanceTree.getAllClasses()) {
                if (!DependencyAnalysis.isTargetProject(classn)) continue;
                CallGraphGenerator.analyzeOtherClasses(callGraph, classn);
            }
        }
        logger.debug("Update call tree with calls to overridden methods");
        CallGraphGenerator.update(callGraph, inheritanceTree);
        logger.debug("Create test cluster");
        TestClusterGenerator clusterGenerator = new TestClusterGenerator();
        clusterGenerator.generateCluster(className, inheritanceTree, callGraph);
        DependencyAnalysis.gatherStatistics();
    }

    private static void loadCallTreeClasses() {
        for (String className : callGraph.getClasses()) {
            if (!className.startsWith(Properties.TARGET_CLASS + "$")) continue;
            try {
                Class.forName(className, true, TestGenerationContext.getInstance().getClassLoaderForSUT());
            }
            catch (ClassNotFoundException e) {
                logger.debug("Error loading " + className + ": " + e);
            }
        }
    }

    public static CallGraph getCallGraph() {
        return callGraph;
    }

    private static boolean isTest(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            Class<?> superClazz = clazz.getSuperclass();
            while (!superClazz.equals(Object.class)) {
                if (superClazz.equals(Suite.class)) {
                    return true;
                }
                if (superClazz.equals(Test.class)) {
                    return true;
                }
                superClazz = clazz.getSuperclass();
            }
            for (Method method : clazz.getMethods()) {
                if (!method.isAnnotationPresent(Test.class)) continue;
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isTargetClassName(String className) {
        if (!Properties.TARGET_CLASS_PREFIX.isEmpty() && className.startsWith(Properties.TARGET_CLASS_PREFIX)) {
            return !DependencyAnalysis.isTest(className);
        }
        return className.equals(Properties.TARGET_CLASS) || className.startsWith(Properties.TARGET_CLASS + "$");
    }

    public static boolean isTargetProject(String className) {
        return (className.startsWith(Properties.PROJECT_PREFIX) || !Properties.TARGET_CLASS_PREFIX.isEmpty() && className.startsWith(Properties.TARGET_CLASS_PREFIX)) && !className.startsWith("java.") && !className.startsWith("sun.") && !className.startsWith("org.evosuite") && !className.startsWith("org.exsyst") && !className.startsWith("de.unisb.cs.st.evosuite") && !className.startsWith("de.unisb.cs.st.specmate") && !className.startsWith("javax.") && !className.startsWith("org.xml") && !className.startsWith("org.w3c") && !className.startsWith("apple.") && !className.startsWith("com.apple.") && !className.startsWith("org.omg.") && !className.startsWith("sunw.") && !className.startsWith("org.jcp.") && !className.startsWith("org.ietf.") && !className.startsWith("daikon.");
    }

    public static boolean shouldAnalyze(String className) {
        if (DependencyAnalysis.isTargetClassName(className)) {
            return true;
        }
        if (inheritanceTree == null) {
            return false;
        }
        if (Properties.INSTRUMENT_PARENT && inheritanceTree.getSuperclasses(Properties.TARGET_CLASS).contains(className)) {
            return true;
        }
        return (Properties.INSTRUMENT_CONTEXT || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.DEFUSE)) && callGraph.isCalledClass(className);
    }

    public static boolean shouldInstrument(String className, String methodName) {
        if (DependencyAnalysis.isTargetClassName(className)) {
            return true;
        }
        if (Properties.INSTRUMENT_PARENT && inheritanceTree.getSuperclasses(Properties.TARGET_CLASS).contains(className)) {
            return true;
        }
        return Properties.INSTRUMENT_CONTEXT && callGraph.isCalledMethod(className, methodName) && (Properties.INSTRUMENT_LIBRARIES || DependencyAnalysis.isTargetProject(className));
    }

    public static ClassNode getClassNode(String className) {
        if (!classCache.containsKey(className)) {
            try {
                classCache.put(className, DependencyAnalysis.loadClassNode(className));
            }
            catch (IOException e) {
                classCache.put(className, null);
            }
        }
        return classCache.get(className);
    }

    public static Collection<ClassNode> getAllClassNodes() {
        return classCache.values();
    }

    private static ClassNode loadClassNode(String className) throws IOException {
        ClassReader reader = new ClassReader(className);
        ClassNode cn = new ClassNode();
        reader.accept((ClassVisitor)cn, 4);
        return cn;
    }

    private static void gatherStatistics() {
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Predicates, BranchPool.getBranchCounter());
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.CoveredBranchesBitString, BranchPool.getBranchCounter() * 2);
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Total_Branches, BranchPool.getBranchCounter() * 2);
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Branchless_Methods, BranchPool.getBranchlessMethods().size());
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Total_Methods, CFGMethodAdapter.getNumMethods());
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Lines, LinePool.getNumLines());
        block4: for (Properties.Criterion pc : Properties.CRITERION) {
            switch (pc) {
                case DEFUSE: 
                case ALLDEFS: {
                    ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Definitions, DefUsePool.getDefCounter());
                    ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Uses, DefUsePool.getUseCounter());
                    continue block4;
                }
                case WEAKMUTATION: 
                case STRONGMUTATION: 
                case MUTATION: {
                    ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Mutants, MutationPool.getMutantCounter());
                    continue block4;
                }
            }
        }
    }
}

