/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.setup;

import java.lang.reflect.Method;
import org.evosuite.Properties;
import org.evosuite.runtime.Random;
import org.evosuite.runtime.System;
import org.evosuite.runtime.testdata.EvoSuiteLocalAddress;
import org.evosuite.runtime.testdata.EvoSuiteRemoteAddress;
import org.evosuite.runtime.testdata.EvoSuiteURL;
import org.evosuite.runtime.testdata.FileSystemHandling;
import org.evosuite.runtime.testdata.NetworkHandling;
import org.evosuite.runtime.util.SystemInUtil;
import org.evosuite.runtime.vfs.VirtualFileSystem;
import org.evosuite.runtime.vnet.EndPointInfo;
import org.evosuite.runtime.vnet.VirtualNetwork;
import org.evosuite.setup.TestCluster;
import org.evosuite.testcase.TestCase;
import org.evosuite.utils.GenericClass;
import org.evosuite.utils.GenericMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentTestClusterAugmenter {
    private static final Logger logger = LoggerFactory.getLogger(EnvironmentTestClusterAugmenter.class);
    private volatile boolean hasAddedRandom;
    private volatile boolean hasAddedSystem;
    private volatile boolean hasAddedFiles;
    private volatile boolean hasAddedSystemIn;
    private volatile boolean hasAddedRemoteURLs;
    private volatile boolean hasAddedUdpSupport;
    private volatile boolean hasAddedTcpListeningSupport;
    private volatile boolean hasAddedTcpRemoteSupport;
    private final TestCluster cluster;

    public EnvironmentTestClusterAugmenter(TestCluster cluster) {
        this.cluster = cluster;
    }

    public void handleRuntimeAccesses(TestCase test) {
        test.getAccessedEnvironment().clear();
        if (Properties.REPLACE_CALLS) {
            this.handleReplaceCalls();
        }
        if (Properties.VIRTUAL_FS) {
            this.handleVirtualFS(test);
        }
        if (Properties.REPLACE_SYSTEM_IN) {
            this.handleSystemIn();
        }
        if (Properties.VIRTUAL_NET) {
            this.handleNetwork(test);
        }
    }

    private void handleNetwork(TestCase test) {
        test.getAccessedEnvironment().addLocalListeningPorts(VirtualNetwork.getInstance().getViewOfLocalListeningPorts());
        test.getAccessedEnvironment().addRemoteURLs(VirtualNetwork.getInstance().getViewOfRemoteAccessedFiles());
        test.getAccessedEnvironment().addRemoteContactedPorts(VirtualNetwork.getInstance().getViewOfRemoteContactedPorts());
        if (!this.hasAddedRemoteURLs && test.getAccessedEnvironment().getViewOfRemoteURLs().size() > 0) {
            this.hasAddedRemoteURLs = true;
            try {
                TestCluster.getInstance().addTestCall(new GenericMethod(NetworkHandling.class.getMethod("createRemoteTextFile", EvoSuiteURL.class, String.class), new GenericClass(NetworkHandling.class)));
            }
            catch (Exception e) {
                logger.error("Error while handling hasAddedRemoteURLs: " + e.getMessage(), (Throwable)e);
            }
        }
        boolean openedTCP = false;
        boolean openedUDP = false;
        for (EndPointInfo info : test.getAccessedEnvironment().getViewOfLocalListeningPorts()) {
            if (info.getType().equals((Object)VirtualNetwork.ConnectionType.TCP)) {
                openedTCP = true;
            } else if (info.getType().equals((Object)VirtualNetwork.ConnectionType.UDP)) {
                openedUDP = true;
            }
            if (!openedTCP || !openedUDP) continue;
            break;
        }
        if (!this.hasAddedUdpSupport && openedUDP) {
            this.hasAddedUdpSupport = true;
            try {
                TestCluster.getInstance().addTestCall(new GenericMethod(NetworkHandling.class.getMethod("sendUdpPacket", EvoSuiteLocalAddress.class, EvoSuiteRemoteAddress.class, byte[].class), new GenericClass(NetworkHandling.class)));
                TestCluster.getInstance().addTestCall(new GenericMethod(NetworkHandling.class.getMethod("sendUdpPacket", EvoSuiteLocalAddress.class, byte[].class), new GenericClass(NetworkHandling.class)));
            }
            catch (Exception e) {
                logger.error("Error while handling hasAddedUdpSupport: " + e.getMessage(), (Throwable)e);
            }
        }
        if (!this.hasAddedTcpListeningSupport && openedTCP) {
            this.hasAddedTcpListeningSupport = true;
            try {
                TestCluster.getInstance().addTestCall(new GenericMethod(NetworkHandling.class.getMethod("sendDataOnTcp", EvoSuiteLocalAddress.class, byte[].class), new GenericClass(NetworkHandling.class)));
                TestCluster.getInstance().addTestCall(new GenericMethod(NetworkHandling.class.getMethod("sendMessageOnTcp", EvoSuiteLocalAddress.class, String.class), new GenericClass(NetworkHandling.class)));
            }
            catch (Exception e) {
                logger.error("Error while handling hasAddedTcpListeningSupport: " + e.getMessage(), (Throwable)e);
            }
        }
        if (!this.hasAddedTcpRemoteSupport && test.getAccessedEnvironment().getViewOfRemoteContactedPorts().size() > 0) {
            this.hasAddedTcpRemoteSupport = true;
            try {
                TestCluster.getInstance().addTestCall(new GenericMethod(NetworkHandling.class.getMethod("openRemoteTcpServer", EvoSuiteRemoteAddress.class), new GenericClass(NetworkHandling.class)));
            }
            catch (Exception e) {
                logger.error("Error while handling hasAddedTcpRemoteSupport: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private void handleSystemIn() {
        if (!this.hasAddedSystemIn && SystemInUtil.getInstance().hasBeenUsed()) {
            this.hasAddedSystemIn = true;
            try {
                TestCluster.getInstance().addTestCall(new GenericMethod(SystemInUtil.class.getMethod("addInputLine", String.class), new GenericClass(SystemInUtil.class)));
            }
            catch (SecurityException e) {
                logger.error("Error while handling Random: " + e.getMessage(), (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                logger.error("Error while handling Random: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private void handleVirtualFS(TestCase test) {
        test.getAccessedEnvironment().addLocalFiles(VirtualFileSystem.getInstance().getAccessedFiles());
        if (!this.hasAddedFiles && VirtualFileSystem.getInstance().getAccessedFiles().size() > 0) {
            logger.info("Adding EvoSuiteFile calls to cluster");
            this.hasAddedFiles = true;
            try {
                for (Method m : FileSystemHandling.class.getMethods()) {
                    this.cluster.addTestCall(new GenericMethod(m, new GenericClass(FileSystemHandling.class)));
                }
            }
            catch (Exception e) {
                logger.error("Error while handling virtual file system: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private void handleReplaceCalls() {
        if (!this.hasAddedRandom && Random.wasAccessed()) {
            this.hasAddedRandom = true;
            try {
                this.cluster.addTestCall(new GenericMethod(Random.class.getMethod("setNextRandom", Integer.TYPE), new GenericClass(Random.class)));
            }
            catch (SecurityException e) {
                logger.error("Error while handling Random: " + e.getMessage(), (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                logger.error("Error while handling Random: " + e.getMessage(), (Throwable)e);
            }
        }
        if (!this.hasAddedSystem && System.wasTimeAccessed()) {
            this.hasAddedSystem = true;
            try {
                this.cluster.addTestCall(new GenericMethod(System.class.getMethod("setCurrentTimeMillis", Long.TYPE), new GenericClass(System.class)));
            }
            catch (SecurityException e) {
                logger.error("Error while handling System: " + e.getMessage(), (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                logger.error("Error while handling System: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

