/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.setup;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.seeding.CastClassManager;
import org.evosuite.setup.EnvironmentTestClusterAugmenter;
import org.evosuite.setup.InheritanceTree;
import org.evosuite.setup.TestClusterGenerator;
import org.evosuite.testcase.TestCase;
import org.evosuite.utils.GenericAccessibleObject;
import org.evosuite.utils.GenericClass;
import org.evosuite.utils.GenericConstructor;
import org.evosuite.utils.GenericMethod;
import org.evosuite.utils.Randomness;
import org.junit.Test;
import org.junit.runners.Suite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCluster {
    protected static final Logger logger = LoggerFactory.getLogger(TestCluster.class);
    private static TestCluster instance = null;
    @Deprecated
    private static final Set<Class<?>> analyzedClasses = new LinkedHashSet();
    private static final Set<GenericAccessibleObject<?>> testMethods = new LinkedHashSet();
    private static final Map<GenericClass, Set<GenericAccessibleObject<?>>> generators = new LinkedHashMap();
    private static final Map<GenericClass, Set<GenericAccessibleObject<?>>> generatorCache = new LinkedHashMap();
    private static final Map<GenericClass, Set<GenericAccessibleObject<?>>> modifiers = new LinkedHashMap();
    private static InheritanceTree inheritanceTree = null;
    private final EnvironmentTestClusterAugmenter environmentAugmenter = new EnvironmentTestClusterAugmenter(this);

    protected TestCluster() {
    }

    public void handleRuntimeAccesses(TestCase test) {
        this.environmentAugmenter.handleRuntimeAccesses(test);
    }

    public static InheritanceTree getInheritanceTree() {
        return inheritanceTree;
    }

    public static synchronized TestCluster getInstance() {
        if (instance == null) {
            instance = new TestCluster();
        }
        return instance;
    }

    public static boolean isTargetClassName(String className) {
        if (!Properties.TARGET_CLASS_PREFIX.isEmpty() && className.startsWith(Properties.TARGET_CLASS_PREFIX)) {
            return !TestCluster.isTest(className);
        }
        if (className.equals(Properties.TARGET_CLASS) || className.startsWith(Properties.TARGET_CLASS + "$")) {
            return true;
        }
        if (Properties.INSTRUMENT_PARENT) {
            return inheritanceTree.getSubclasses(Properties.TARGET_CLASS).contains(className);
        }
        return false;
    }

    private static boolean isTest(String className) {
        try {
            Class<?> clazz = TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass(className);
            Class<?> superClazz = clazz.getSuperclass();
            while (!superClazz.equals(Object.class)) {
                if (superClazz.equals(Suite.class)) {
                    return true;
                }
                if (superClazz.equals(Test.class)) {
                    return true;
                }
                superClazz = clazz.getSuperclass();
            }
            for (Method method : clazz.getMethods()) {
                if (!method.isAnnotationPresent(Test.class)) continue;
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            logger.info("Could not load class: ", (Object)className);
        }
        return false;
    }

    public static void reset() {
        analyzedClasses.clear();
        testMethods.clear();
        generators.clear();
        generatorCache.clear();
        modifiers.clear();
        CastClassManager.getInstance().clear();
        instance = null;
    }

    protected static void setInheritanceTree(InheritanceTree inheritancetree) {
        inheritanceTree = inheritancetree;
    }

    public void addGenerator(GenericClass target, GenericAccessibleObject<?> call) {
        if (!generators.containsKey(target)) {
            generators.put(target, new LinkedHashSet());
        }
        logger.debug("Adding generator for class " + target + ": " + call);
        generators.get(target).add(call);
    }

    public void addModifier(GenericClass target, GenericAccessibleObject<?> call) {
        if (!modifiers.containsKey(target)) {
            modifiers.put(target, new LinkedHashSet());
        }
        modifiers.get(target).add(call);
    }

    public void addTestCall(GenericAccessibleObject<?> call) {
        testMethods.add(call);
    }

    public void removeTestCall(GenericAccessibleObject<?> call) {
        testMethods.remove(call);
    }

    public void addCastClassForContainer(Class<?> clazz) {
        if (TestClusterGenerator.canUse(clazz)) {
            CastClassManager.getInstance().addCastClass(clazz, 1);
            this.clearGeneratorCache(new GenericClass(clazz));
        }
    }

    private void cacheGenerators(GenericClass clazz) throws ConstructionFailedException {
        if (generatorCache.containsKey(clazz)) {
            return;
        }
        logger.debug("1. Caching generators for " + clazz);
        LinkedHashSet<Object> targetGenerators = new LinkedHashSet<Object>();
        if (clazz.isObject()) {
            logger.debug("2. Target class is object: " + clazz);
            for (GenericClass genericClass : generators.keySet()) {
                if (!genericClass.isObject()) continue;
                targetGenerators.addAll((Collection)generators.get(genericClass));
            }
        } else {
            logger.debug("2. Target class is not object: " + clazz);
            for (GenericClass genericClass : generators.keySet()) {
                logger.debug("3. Considering original generator: " + genericClass + " for " + clazz);
                if (genericClass.canBeInstantiatedTo(clazz)) {
                    logger.debug("4. generator " + genericClass + " can be instantiated to " + clazz);
                    GenericClass instantiatedGeneratorClazz = genericClass.getWithParametersFromSuperclass(clazz);
                    logger.debug("Instantiated type: " + instantiatedGeneratorClazz + " for " + genericClass + " and superclass " + clazz);
                    for (GenericAccessibleObject<?> generator : generators.get(genericClass)) {
                        logger.debug("5. current instantiated generator: " + generator);
                        try {
                            Object newGenerator = generator.copyWithOwnerFromReturnType(instantiatedGeneratorClazz);
                            boolean hadTypeParameters = false;
                            if (((GenericAccessibleObject)newGenerator).getOwnerClass().hasWildcardOrTypeVariables()) {
                                logger.debug("Instantiating type parameters of owner type: " + ((GenericAccessibleObject)newGenerator).getOwnerClass());
                                GenericClass concreteClass = ((GenericAccessibleObject)newGenerator).getOwnerClass().getGenericInstantiation(clazz.getTypeVariableMap());
                                newGenerator = ((GenericAccessibleObject)newGenerator).copyWithNewOwner(concreteClass);
                                hadTypeParameters = true;
                            }
                            if (((GenericAccessibleObject)newGenerator).hasTypeParameters()) {
                                logger.debug("Instantiating type parameters");
                                newGenerator = ((GenericAccessibleObject)newGenerator).getGenericInstantiationFromReturnValue(clazz);
                                hadTypeParameters = true;
                            }
                            logger.debug("Current generator: " + newGenerator);
                            if (!hadTypeParameters && genericClass.equals(clazz) || clazz.isAssignableFrom(((GenericAccessibleObject)newGenerator).getGeneratedType())) {
                                logger.debug("Got new generator: " + newGenerator + " which generated: " + ((GenericAccessibleObject)newGenerator).getGeneratedClass());
                                targetGenerators.add(newGenerator);
                                continue;
                            }
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug("New generator not assignable: " + newGenerator);
                            logger.debug("Had type parameters: " + hadTypeParameters);
                            logger.debug("generatorClazz.equals(clazz): " + genericClass.equals(clazz));
                            try {
                                logger.debug("clazz.isAssignableFrom(" + ((GenericAccessibleObject)newGenerator).getGeneratedType() + "): ");
                                logger.debug("                        " + clazz.isAssignableFrom(((GenericAccessibleObject)newGenerator).getGeneratedType()));
                            }
                            catch (Throwable t) {
                                logger.debug("Error: " + t);
                            }
                        }
                        catch (ConstructionFailedException e) {
                            logger.debug("5. ERROR: " + e);
                        }
                    }
                    continue;
                }
                logger.debug("4. generator " + genericClass + " CANNOT be instantiated to " + clazz);
                for (GenericClass boundClass : genericClass.getGenericBounds()) {
                    CastClassManager.getInstance().addCastClass(boundClass, 0);
                }
            }
            logger.debug("Found generators for " + clazz + ": " + targetGenerators.size());
        }
        for (GenericAccessibleObject genericAccessibleObject : targetGenerators) {
            logger.debug("XXX Setting generator cache " + clazz + ": " + String.valueOf(genericAccessibleObject));
        }
        logger.debug("]");
        generatorCache.put(clazz, targetGenerators);
    }

    public void clearGeneratorCache(GenericClass target) {
        generatorCache.clear();
    }

    private Set<GenericAccessibleObject<?>> determineGenericModifiersFor(GenericClass clazz) throws ConstructionFailedException {
        LinkedHashSet genericModifiers = new LinkedHashSet();
        if (clazz.isParameterizedType()) {
            logger.debug("Is parameterized class");
            for (Map.Entry<GenericClass, Set<GenericAccessibleObject<?>>> entry : modifiers.entrySet()) {
                logger.debug("Considering " + entry.getKey());
                if (entry.getKey().getWithWildcardTypes().isGenericSuperTypeOf(clazz)) {
                    logger.debug(entry.getKey() + " can be instantiated to " + clazz);
                    for (GenericAccessibleObject<?> modifier : entry.getValue()) {
                        try {
                            Object newModifier = modifier.getGenericInstantiation(clazz);
                            logger.debug("Adding new modifier: " + newModifier);
                            genericModifiers.add((GenericAccessibleObject<?>)newModifier);
                        }
                        catch (ConstructionFailedException e) {
                            logger.debug("Cannot be added: " + modifier);
                        }
                    }
                    continue;
                }
                logger.debug("Nope");
            }
        } else {
            logger.debug("Is NOT parameterized class!");
        }
        return genericModifiers;
    }

    public Set<Class<?>> getAnalyzedClasses() {
        return analyzedClasses;
    }

    public Set<GenericAccessibleObject<?>> getCallsFor(GenericClass clazz, boolean resolve) throws ConstructionFailedException {
        logger.debug("Getting calls for " + clazz);
        if (clazz.hasWildcardOrTypeVariables()) {
            logger.debug("Resolving generic type before getting modifiers");
            GenericClass concreteClass = clazz.getGenericInstantiation();
            if (!concreteClass.equals(clazz)) {
                return this.getCallsFor(concreteClass, false);
            }
        }
        if (this.isSpecialCase(clazz)) {
            logger.debug("Getting modifiers for special case " + clazz);
            return this.getCallsForSpecialCase(clazz);
        }
        logger.debug("Getting modifiers for regular case " + clazz);
        if (!modifiers.containsKey(clazz)) {
            return this.determineGenericModifiersFor(clazz);
        }
        return modifiers.get(clazz);
    }

    public GenericAccessibleObject<?> getRandomCallFor(GenericClass clazz) throws ConstructionFailedException {
        Set<GenericAccessibleObject<?>> calls = this.getCallsFor(clazz, true);
        if (calls.isEmpty()) {
            throw new ConstructionFailedException("No modifiers for " + clazz);
        }
        logger.debug("Possible modifiers for " + clazz + ": " + calls);
        GenericAccessibleObject<?> call = Randomness.choice(calls);
        if (call.hasTypeParameters()) {
            logger.debug("Modifier has type parameters");
            call = call.getGenericInstantiation(clazz);
        }
        return call;
    }

    private Set<GenericAccessibleObject<?>> getCallsForSpecialCase(GenericClass clazz) throws ConstructionFailedException {
        LinkedHashSet all = new LinkedHashSet();
        if (!modifiers.containsKey(clazz)) {
            logger.debug("Don't have that specific class, so have to check generic modifiers");
            all.addAll(this.determineGenericModifiersFor(clazz));
        } else {
            logger.debug("Got modifiers");
            all.addAll((Collection)modifiers.get(clazz));
        }
        LinkedHashSet calls = new LinkedHashSet();
        if (clazz.isAssignableTo((Type)((Object)Collection.class))) {
            for (GenericAccessibleObject genericAccessibleObject : all) {
                if (genericAccessibleObject.isConstructor() && genericAccessibleObject.getNumParameters() == 0) {
                    calls.add(genericAccessibleObject);
                    continue;
                }
                if (genericAccessibleObject.isMethod() && ((GenericMethod)genericAccessibleObject).getName().equals("add") && genericAccessibleObject.getNumParameters() == 1) {
                    calls.add(genericAccessibleObject);
                    continue;
                }
                if (!(Randomness.nextDouble() < Properties.P_SPECIAL_TYPE_CALL)) continue;
                calls.add(genericAccessibleObject);
            }
        } else if (clazz.isAssignableTo((Type)((Object)Map.class))) {
            for (GenericAccessibleObject genericAccessibleObject : all) {
                if (genericAccessibleObject.isConstructor() && genericAccessibleObject.getNumParameters() == 0) {
                    calls.add(genericAccessibleObject);
                    continue;
                }
                if (genericAccessibleObject.isMethod() && ((GenericMethod)genericAccessibleObject).getName().equals("put")) {
                    calls.add(genericAccessibleObject);
                    continue;
                }
                if (!(Randomness.nextDouble() < Properties.P_SPECIAL_TYPE_CALL)) continue;
                calls.add(genericAccessibleObject);
            }
        } else if (clazz.isAssignableTo((Type)((Object)Number.class))) {
            if (modifiers.containsKey(clazz)) {
                for (GenericAccessibleObject<?> genericAccessibleObject : modifiers.get(clazz)) {
                    if (genericAccessibleObject.getName().startsWith("java.lang") && !(Randomness.nextDouble() < Properties.P_SPECIAL_TYPE_CALL)) continue;
                    calls.add(genericAccessibleObject);
                }
            }
            return calls;
        }
        return calls;
    }

    public Class<?> getClass(String name) throws ClassNotFoundException {
        for (Class<?> clazz : analyzedClasses) {
            if (!clazz.getName().equals(name) && !clazz.getName().equals(Properties.CLASS_PREFIX + "." + name) && !clazz.getName().equals(Properties.CLASS_PREFIX + "." + name.replace(".", "$"))) continue;
            return clazz;
        }
        for (Class<?> clazz : analyzedClasses) {
            if (!clazz.getName().endsWith("." + name)) continue;
            return clazz;
        }
        try {
            TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass("java.lang." + name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        throw new ClassNotFoundException(name);
    }

    public Set<GenericAccessibleObject<?>> getGenerators() {
        LinkedHashSet calls = new LinkedHashSet();
        for (Set<GenericAccessibleObject<?>> generatorCalls : generators.values()) {
            calls.addAll(generatorCalls);
        }
        return calls;
    }

    public Set<GenericAccessibleObject<?>> getGenerators(GenericClass clazz, boolean resolve) throws ConstructionFailedException {
        GenericClass concreteClass;
        if (clazz.hasWildcardOrTypeVariables() && !(concreteClass = clazz.getGenericInstantiation()).equals(clazz)) {
            return this.getGenerators(concreteClass, false);
        }
        if (this.isSpecialCase(clazz)) {
            return this.getGeneratorsForSpecialCase(clazz);
        }
        if (!this.hasGenerator(clazz)) {
            throw new ConstructionFailedException("No generators of type " + clazz);
        }
        return generatorCache.get(clazz);
    }

    private Set<GenericAccessibleObject<?>> getGeneratorsForSpecialCase(GenericClass clazz) throws ConstructionFailedException {
        logger.debug("Getting generator for special case: " + clazz);
        LinkedHashSet calls = new LinkedHashSet();
        if (clazz.isAssignableTo((Type)((Object)Collection.class)) || clazz.isAssignableTo((Type)((Object)Map.class))) {
            LinkedHashSet all = new LinkedHashSet();
            if (!generatorCache.containsKey(clazz)) {
                this.cacheGenerators(clazz);
            }
            if (!this.hasGenerator(clazz)) {
                throw new ConstructionFailedException("No generators of type " + clazz);
            }
            all.addAll(generatorCache.get(clazz));
            for (GenericAccessibleObject call : all) {
                if (call.isConstructor() && call.getNumParameters() == 0) {
                    calls.add(call);
                    continue;
                }
                if (!Collection.class.isAssignableFrom(call.getDeclaringClass()) && !Map.class.isAssignableFrom(call.getDeclaringClass())) {
                    calls.add(call);
                    continue;
                }
                if (!call.getDeclaringClass().getName().startsWith("java")) {
                    calls.add(call);
                    continue;
                }
                if (!(Randomness.nextDouble() < Properties.P_SPECIAL_TYPE_CALL)) continue;
                calls.add(call);
            }
            if (calls.isEmpty()) {
                calls.addAll(all);
            }
        } else if (clazz.isAssignableTo((Type)((Object)Number.class))) {
            logger.debug("Found special case " + clazz);
            LinkedHashSet all = new LinkedHashSet();
            if (!generatorCache.containsKey(clazz)) {
                this.cacheGenerators(clazz);
            }
            all.addAll(generatorCache.get(clazz));
            if (all.isEmpty()) {
                this.addNumericConstructor(clazz);
                all.addAll(generatorCache.get(clazz));
            }
            for (GenericAccessibleObject call : all) {
                if (call.isConstructor() && call.getNumParameters() == 1) {
                    if (((GenericConstructor)call).getRawParameterTypes()[0].equals(String.class)) continue;
                    calls.add(call);
                    continue;
                }
                if (call.isField()) {
                    calls.add(call);
                    continue;
                }
                if (!(Randomness.nextDouble() < Properties.P_SPECIAL_TYPE_CALL)) continue;
                calls.add(call);
            }
            logger.debug("Generators for special case " + clazz + ": " + calls);
            if (calls.isEmpty()) {
                this.addNumericConstructor(clazz);
                return generatorCache.get(clazz);
            }
        }
        return calls;
    }

    private void addNumericConstructor(GenericClass clazz) {
        if (!generatorCache.containsKey(clazz)) {
            generatorCache.put(clazz, new LinkedHashSet());
        }
        if (!generators.containsKey(clazz)) {
            generators.put(clazz, new LinkedHashSet());
        }
        logger.info("addNumericConstructor for class " + clazz);
        for (Constructor<?> constructor : clazz.getRawClass().getConstructors()) {
            Class<?> parameterClass;
            if (constructor.getParameterTypes().length != 1 || (parameterClass = constructor.getParameterTypes()[0]).equals(String.class)) continue;
            GenericConstructor genericConstructor = new GenericConstructor(constructor, clazz);
            generatorCache.get(clazz).add(genericConstructor);
            generators.get(clazz).add(genericConstructor);
        }
        logger.info("Constructors for class " + clazz + ": " + generators.get(clazz).size());
    }

    public Collection<Class<?>> getKnownMatchingClasses(String name) {
        LinkedHashSet classes = new LinkedHashSet();
        for (Class<?> c : analyzedClasses) {
            if (!c.getName().endsWith(name)) continue;
            classes.add(c);
        }
        return classes;
    }

    public Set<GenericAccessibleObject<?>> getModifiers() {
        LinkedHashSet calls = new LinkedHashSet();
        for (Set<GenericAccessibleObject<?>> modifierCalls : modifiers.values()) {
            calls.addAll(modifierCalls);
        }
        return calls;
    }

    public Set<GenericAccessibleObject<?>> getObjectGenerators() {
        LinkedHashSet result = new LinkedHashSet();
        ArrayList<GenericClass> classes = new ArrayList<GenericClass>(CastClassManager.getInstance().getCastClasses());
        for (GenericClass clazz : classes) {
            try {
                result.addAll(this.getGenerators(clazz, true));
            }
            catch (ConstructionFailedException e) {}
        }
        try {
            result.addAll(this.getGenerators(new GenericClass(Object.class), true));
        }
        catch (ConstructionFailedException constructionFailedException) {
            // empty catch block
        }
        return result;
    }

    public GenericAccessibleObject<?> getRandomGenerator(GenericClass clazz) throws ConstructionFailedException {
        if (clazz.hasWildcardOrTypeVariables()) {
            GenericClass concreteClass = clazz.getGenericInstantiation();
            if (concreteClass.hasWildcardOrTypeVariables()) {
                throw new ConstructionFailedException("Could not found concrete instantiation of generic type");
            }
            return this.getRandomGenerator(concreteClass);
        }
        GenericAccessibleObject generator = null;
        if (this.isSpecialCase(clazz)) {
            Set<GenericAccessibleObject<?>> generators = this.getGeneratorsForSpecialCase(clazz);
            if (generators.isEmpty()) {
                logger.warn("No generators for class: " + clazz);
            }
            generator = Randomness.choice(generators);
        } else {
            if (!this.hasGenerator(clazz)) {
                throw new ConstructionFailedException("No generators of type " + clazz);
            }
            generator = (GenericAccessibleObject)Randomness.choice((Collection)generatorCache.get(clazz));
        }
        if (generator == null) {
            throw new ConstructionFailedException("No generators of type " + clazz);
        }
        if (generator.hasTypeParameters()) {
            generator = generator.getGenericInstantiation(clazz);
        }
        return generator;
    }

    public GenericAccessibleObject<?> getRandomGenerator(GenericClass clazz, Set<GenericAccessibleObject<?>> excluded) throws ConstructionFailedException {
        logger.debug("Getting random generator for " + clazz);
        if (clazz.hasWildcardOrTypeVariables()) {
            logger.debug("Target class is generic: " + clazz);
            GenericClass concreteClass = clazz.getGenericInstantiation();
            if (!concreteClass.equals(clazz)) {
                logger.debug("Target class is generic: " + clazz + ", getting instantiation " + concreteClass);
                return this.getRandomGenerator(concreteClass, excluded);
            }
        }
        GenericAccessibleObject<?> generator = null;
        if (this.isSpecialCase(clazz)) {
            generator = Randomness.choice(this.getGeneratorsForSpecialCase(clazz));
            if (generator == null) {
                logger.warn("No generator for special case class: " + clazz);
                throw new ConstructionFailedException("Have no generators for special case: " + clazz);
            }
        } else {
            this.cacheGenerators(clazz);
            LinkedHashSet candidates = new LinkedHashSet(generatorCache.get(clazz));
            int before = candidates.size();
            candidates.removeAll(excluded);
            logger.debug("Candidate generators for " + clazz + ": " + candidates.size());
            if (candidates.isEmpty()) {
                throw new ConstructionFailedException("No generators left for " + clazz + " - in total there are " + before);
            }
            generator = (GenericAccessibleObject)Randomness.choice(candidates);
            logger.debug("Chosen generator: " + generator);
        }
        if (generator.getOwnerClass().hasWildcardOrTypeVariables()) {
            logger.debug("Owner class has a wildcard: " + clazz.getTypeName());
            generator = generator.copyWithNewOwner(generator.getOwnerClass().getGenericInstantiation());
        }
        if (generator.hasTypeParameters()) {
            logger.debug("Generator has a type parameter: " + generator);
            generator = generator.getGenericInstantiationFromReturnValue(clazz);
            if (!generator.getGeneratedClass().isAssignableTo(clazz)) {
                throw new ConstructionFailedException("Generics error");
            }
        }
        return generator;
    }

    public GenericAccessibleObject<?> getRandomObjectGenerator() throws ConstructionFailedException {
        logger.debug("Getting random object generator");
        GenericAccessibleObject<?> generator = Randomness.choice(this.getObjectGenerators());
        if (generator == null) {
            logger.warn("Random object generator is null");
            throw new ConstructionFailedException("Random object generator is null");
        }
        if (generator.getOwnerClass().hasWildcardOrTypeVariables()) {
            logger.debug("Generator has wildcard or type: " + generator);
            GenericClass concreteClass = generator.getOwnerClass().getGenericInstantiation();
            generator = generator.copyWithNewOwner(concreteClass);
        }
        if (generator.hasTypeParameters()) {
            logger.debug("Generator has type parameters");
            generator = generator.getGenericInstantiation();
        }
        return generator;
    }

    public GenericAccessibleObject<?> getRandomTestCall() throws ConstructionFailedException {
        if (testMethods.isEmpty()) {
            logger.debug("No more calls");
            return null;
        }
        GenericAccessibleObject<?> choice = Randomness.choice(testMethods);
        logger.debug("Chosen call: " + choice);
        if (choice.getOwnerClass().hasWildcardOrTypeVariables()) {
            GenericClass concreteClass = choice.getOwnerClass().getGenericInstantiation();
            logger.debug("Concrete class is: " + concreteClass.getTypeName());
            choice = choice.copyWithNewOwner(concreteClass);
            logger.debug("Concrete class is: " + choice.getOwnerClass().getTypeName());
            logger.debug("Type variables: " + choice.getOwnerClass().getTypeVariableMap());
            logger.debug(Arrays.asList(choice.getTypeParameters()).toString());
            logger.debug("Chosen call with generic parameter set: " + choice);
            logger.debug("Call owner type: " + choice.getOwnerClass().getTypeName());
        }
        if (choice.hasTypeParameters()) {
            logger.debug("Instantiating chosen call: " + choice);
            choice = choice.getGenericInstantiation();
            logger.debug("Chosen instantiation: " + choice);
        }
        return choice;
    }

    public int getNumTestCalls() {
        return testMethods.size();
    }

    public List<GenericAccessibleObject<?>> getTestCalls() {
        ArrayList result = new ArrayList();
        for (GenericAccessibleObject<?> ao : testMethods) {
            if (ao.getOwnerClass().hasWildcardOrTypeVariables()) {
                try {
                    GenericClass concreteClass = ao.getOwnerClass().getGenericInstantiation();
                    result.add((GenericAccessibleObject<?>)ao.copyWithNewOwner(concreteClass));
                }
                catch (ConstructionFailedException e) {
                    logger.debug("Failed to instantiate " + ao);
                }
                continue;
            }
            result.add(ao);
        }
        return result;
    }

    public boolean hasGenerator(GenericClass clazz) {
        try {
            this.cacheGenerators(clazz);
        }
        catch (ConstructionFailedException constructionFailedException) {
            // empty catch block
        }
        if (!generatorCache.containsKey(clazz)) {
            return false;
        }
        return !generatorCache.get(clazz).isEmpty();
    }

    public boolean hasGenerator(Type type) {
        return this.hasGenerator(new GenericClass(type));
    }

    public Class<?> importClass(String name) throws ClassNotFoundException {
        throw new RuntimeException("Not implemented");
    }

    private boolean isSpecialCase(GenericClass clazz) {
        if (clazz.isAssignableTo((Type)((Object)Collection.class))) {
            return true;
        }
        if (clazz.isAssignableTo((Type)((Object)Map.class))) {
            return true;
        }
        return clazz.isAssignableTo((Type)((Object)Number.class));
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Analyzed classes:\n");
        for (Class<?> clazz : analyzedClasses) {
            result.append(clazz.getName());
            result.append("\n");
        }
        result.append("Generators:\n");
        for (GenericClass genericClass : generators.keySet()) {
            result.append(" Generators for " + genericClass.getTypeName() + ": " + generators.get(genericClass).size() + "\n");
            for (GenericAccessibleObject<?> o : generators.get(genericClass)) {
                result.append("  " + genericClass.getTypeName() + " <- " + o + " " + "\n");
            }
        }
        result.append("Modifiers:\n");
        for (GenericClass genericClass : modifiers.keySet()) {
            result.append(" Modifiers for " + genericClass.getSimpleName() + ": " + modifiers.get(genericClass).size() + "\n");
            for (GenericAccessibleObject<?> o : modifiers.get(genericClass)) {
                result.append(" " + genericClass.getSimpleName() + " <- " + o + "\n");
            }
        }
        result.append("Test calls\n");
        for (GenericAccessibleObject genericAccessibleObject : testMethods) {
            result.append(" " + genericAccessibleObject + "\n");
        }
        return result.toString();
    }
}

