/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.setup.callgraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.classpath.ResourceList;
import org.evosuite.setup.Call;
import org.evosuite.setup.CallContext;
import org.evosuite.setup.callgraph.CallGraphEntry;
import org.evosuite.setup.callgraph.Graph;
import org.evosuite.setup.callgraph.PathFinder;
import org.evosuite.setup.callgraph.PathFinderDFSIterator;
import org.evosuite.setup.callgraph.ReverseCallGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallGraph
implements Iterable<CallGraphEntry> {
    private ReverseCallGraph graph = new ReverseCallGraph();
    private static final Logger logger = LoggerFactory.getLogger(CallGraph.class);
    private final String className;
    private final Set<CallGraphEntry> cutNodes = Collections.synchronizedSet(new LinkedHashSet());
    private final Set<String> callGraphClasses = Collections.synchronizedSet(new LinkedHashSet());
    private final Set<String> toTestClasses = Collections.synchronizedSet(new LinkedHashSet());
    private final Set<String> toTestMethods = Collections.synchronizedSet(new LinkedHashSet());
    private final Set<String> notToTestClasses = Collections.synchronizedSet(new LinkedHashSet());
    private final Set<CallContext> publicMethods = Collections.synchronizedSet(new LinkedHashSet());

    public CallGraph(String className) {
        this.className = className;
    }

    public ReverseCallGraph getGraph() {
        return this.graph;
    }

    public void removeClasses(Collection<CallGraphEntry> vertexes) {
        for (CallGraphEntry vertex : vertexes) {
            this.graph.removeVertex(vertex);
        }
    }

    public void removeClass(CallGraphEntry vertex) {
        this.graph.removeVertex(vertex);
    }

    public void addPublicMethod(String className, String methodName) {
        this.publicMethods.add(new CallContext(ResourceList.getClassNameFromResourcePath(className), methodName));
    }

    public boolean addCall(String sourceClass, String sourceMethod, String targetClass, String targetMethod) {
        CallGraphEntry from = new CallGraphEntry(targetClass, targetMethod);
        CallGraphEntry to = new CallGraphEntry(sourceClass, sourceMethod);
        if (sourceClass.equals(this.className)) {
            this.cutNodes.add(to);
        }
        if (!this.graph.containsEdge(from, to)) {
            this.graph.addEdge(from, to);
            this.callGraphClasses.add(targetClass.replaceAll("/", "."));
            return true;
        }
        return false;
    }

    public boolean hasMethod(String classname, String methodName) {
        return this.graph.containsVertex(new CallGraphEntry(classname, methodName));
    }

    public boolean hasCall(String owner, String methodName, String targetClass, String targetMethod) {
        CallGraphEntry from = new CallGraphEntry(targetClass, targetMethod);
        CallGraphEntry to = new CallGraphEntry(owner, methodName);
        return this.graph.getEdges().containsKey(to) && this.graph.getEdges().get(to).contains(from);
    }

    public Set<CallGraphEntry> getCallsFrom(String owner, String methodName) {
        CallGraphEntry call = new CallGraphEntry(owner, methodName);
        return this.getCallsFromMethod(call);
    }

    public Set<CallGraphEntry> getCallsFromMethod(CallGraphEntry call) {
        if (this.graph.getEdges().containsKey(call)) {
            return this.graph.getEdges().get(call);
        }
        return new HashSet<CallGraphEntry>();
    }

    public Set<CallContext> getMethodEntryPoint(String className, String methodName) {
        HashSet<CallContext> contexts = new HashSet<CallContext>();
        ArrayList<Call> cont = new ArrayList<Call>();
        cont.add(new Call(className, methodName));
        CallContext context = new CallContext(cont);
        if (this.publicMethods.contains(context)) {
            contexts.add(context);
        } else {
            contexts.add(new CallContext());
        }
        return contexts;
    }

    public Set<CallContext> getAllContextsFromTargetClass(String className, String methodName) {
        CallGraphEntry root = new CallGraphEntry(className, methodName);
        Set<List<CallGraphEntry>> paths = PathFinder.getPahts(this.graph, root);
        Set<CallContext> contexts = this.convertIntoCallContext(paths);
        if (!Properties.EXCLUDE_IBRANCHES_CUT) {
            this.addPublicClassMethod(className, methodName, contexts);
        }
        return contexts;
    }

    private void addPublicClassMethod(String className, String methodName, Set<CallContext> contexts) {
        ArrayList<Call> calls = new ArrayList<Call>();
        Call call = new Call(className, methodName);
        calls.add(call);
        CallContext context = new CallContext(calls);
        if (this.publicMethods.contains(context) && className.equals(this.className)) {
            contexts.add(context);
        }
    }

    private Set<CallContext> convertIntoCallContext(Set<List<CallGraphEntry>> paths) {
        HashSet<CallContext> contexts = new HashSet<CallContext>();
        for (List<CallGraphEntry> list : paths) {
            boolean insert = false;
            ArrayList<Call> cont = new ArrayList<Call>();
            for (int i = list.size() - 1; i >= 0; --i) {
                if (!insert && list.get(i).getClassName().equals(this.className)) {
                    insert = true;
                }
                if (!insert) continue;
                cont.add(new Call(list.get(i).getClassName(), list.get(i).getMethodName()));
            }
            contexts.add(new CallContext(cont));
        }
        return contexts;
    }

    public String getClassName() {
        return this.className;
    }

    public Set<String> getClassesUnderTest() {
        if (this.toTestClasses.isEmpty()) {
            this.computeInterestingClasses(this.graph);
        }
        return this.toTestClasses;
    }

    public boolean isCalledClass(String className) {
        if (this.toTestClasses.isEmpty()) {
            this.computeInterestingClasses(this.graph);
        }
        return this.toTestClasses.contains(className);
    }

    public boolean isCalledClassOld(String className) {
        if (this.toTestClasses.contains(className)) {
            return true;
        }
        if (this.notToTestClasses.contains(className)) {
            return false;
        }
        for (CallGraphEntry e : this.graph.getEdges().keySet()) {
            if (!e.getClassName().equals(className) || !this.checkClassInPaths(this.className, this.graph, e)) continue;
            return true;
        }
        return false;
    }

    private boolean computeInterestingClasses(Graph<CallGraphEntry> g) {
        HashSet<CallGraphEntry> startingVertices = new HashSet<CallGraphEntry>();
        for (CallGraphEntry e : this.graph.getVertexSet()) {
            if (!e.getClassName().equals(this.className)) continue;
            startingVertices.add(e);
        }
        HashSet<String> classes = new HashSet<String>();
        HashSet<String> methodclasses = new HashSet<String>();
        for (CallGraphEntry startingVertex : startingVertices) {
            PathFinderDFSIterator<CallGraphEntry> dfs = new PathFinderDFSIterator<CallGraphEntry>(g, startingVertex, true);
            while (dfs.hasNext()) {
                CallGraphEntry e = dfs.next();
                classes.add(e.getClassName());
                methodclasses.add(e.getClassName() + e.getMethodName());
            }
        }
        this.toTestMethods.addAll(methodclasses);
        this.toTestClasses.addAll(classes);
        return true;
    }

    private boolean checkClassInPaths(String targetClass, Graph<CallGraphEntry> g, CallGraphEntry startingVertex) {
        if (!g.containsVertex(startingVertex)) {
            return false;
        }
        HashSet<String> classes = new HashSet<String>();
        PathFinderDFSIterator<CallGraphEntry> dfs = new PathFinderDFSIterator<CallGraphEntry>(g, startingVertex);
        while (dfs.hasNext()) {
            CallGraphEntry e = dfs.next();
            classes.add(e.getClassName());
            if (!e.getClassName().equals(targetClass)) continue;
            this.toTestClasses.addAll(classes);
            return true;
        }
        this.notToTestClasses.addAll(classes);
        return false;
    }

    public boolean isCalledMethod(String className, String methodName) {
        if (this.toTestMethods.isEmpty()) {
            this.computeInterestingClasses(this.graph);
        }
        return this.toTestMethods.contains(className + methodName);
    }

    public boolean isCalledMethodOld(String className, String methodName) {
        CallGraphEntry tmp = new CallGraphEntry(className, methodName);
        for (CallGraphEntry e : this.graph.getEdges().keySet()) {
            if (!e.equals(tmp)) continue;
            for (List<CallGraphEntry> c : PathFinder.getPahts(this.graph, e)) {
                for (CallGraphEntry entry : c) {
                    if (!entry.getClassName().equals(this.className)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public Iterator<CallGraphEntry> iterator() {
        return this.graph.getVertexSet().iterator();
    }

    public Set<CallGraphEntry> getViewOfCurrentMethods() {
        return new LinkedHashSet<CallGraphEntry>(this.graph.getVertexSet());
    }

    public Set<String> getClasses() {
        return this.callGraphClasses;
    }
}

