/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.statistics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.evosuite.Properties;
import org.evosuite.coverage.exception.ExceptionCoverageSuiteFitness;
import org.evosuite.ga.Chromosome;
import org.evosuite.rmi.ClientServices;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.ExecutionTrace;
import org.evosuite.testcase.execution.TestCaseExecutor;
import org.evosuite.testsuite.TestSuiteChromosome;

public class StatisticsSender {
    public static void sendIndividualToMaster(Chromosome individual) throws IllegalArgumentException {
        if (individual == null) {
            throw new IllegalArgumentException("No defined individual to send");
        }
        if (!Properties.NEW_STATISTICS) {
            return;
        }
        ClientServices.getInstance().getClientNode().updateStatistics(individual);
    }

    public static void executedAndThenSendIndividualToMaster(TestSuiteChromosome testSuite) throws IllegalArgumentException {
        if (testSuite == null) {
            throw new IllegalArgumentException("No defined test suite to send");
        }
        if (!Properties.NEW_STATISTICS) {
            return;
        }
        for (TestChromosome test : testSuite.getTestChromosomes()) {
            if (test.getLastExecutionResult() != null) continue;
            ExecutionResult result = TestCaseExecutor.runTest(test.getTestCase());
            test.setLastExecutionResult(result);
        }
        StatisticsSender.sendCoveredInfo(testSuite);
        StatisticsSender.sendExceptionInfo(testSuite);
        StatisticsSender.sendIndividualToMaster(testSuite);
    }

    private static void sendExceptionInfo(TestSuiteChromosome testSuite) {
        ArrayList<ExecutionResult> results = new ArrayList<ExecutionResult>();
        for (TestChromosome testChromosome : testSuite.getTestChromosomes()) {
            results.add(testChromosome.getLastExecutionResult());
        }
        HashMap implicitTypesOfExceptions = new HashMap();
        HashMap explicitTypesOfExceptions = new HashMap();
        HashMap declaredTypesOfExceptions = new HashMap();
        ExceptionCoverageSuiteFitness.calculateExceptionInfo(results, implicitTypesOfExceptions, explicitTypesOfExceptions, declaredTypesOfExceptions);
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Explicit_MethodExceptions, ExceptionCoverageSuiteFitness.getNumExceptions(explicitTypesOfExceptions));
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Explicit_TypeExceptions, ExceptionCoverageSuiteFitness.getNumClassExceptions(explicitTypesOfExceptions));
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Implicit_MethodExceptions, ExceptionCoverageSuiteFitness.getNumExceptions(implicitTypesOfExceptions));
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Implicit_TypeExceptions, ExceptionCoverageSuiteFitness.getNumClassExceptions(implicitTypesOfExceptions));
    }

    private static void sendCoveredInfo(TestSuiteChromosome testSuite) {
        HashSet<String> coveredMethods = new HashSet<String>();
        HashSet<Integer> coveredTrueBranches = new HashSet<Integer>();
        HashSet<Integer> coveredFalseBranches = new HashSet<Integer>();
        HashSet<String> coveredBranchlessMethods = new HashSet<String>();
        HashSet<Integer> coveredLines = new HashSet<Integer>();
        for (TestChromosome test : testSuite.getTestChromosomes()) {
            ExecutionTrace trace = test.getLastExecutionResult().getTrace();
            coveredMethods.addAll(trace.getCoveredMethods());
            coveredTrueBranches.addAll(trace.getCoveredTrueBranches());
            coveredFalseBranches.addAll(trace.getCoveredFalseBranches());
            coveredBranchlessMethods.addAll(trace.getCoveredBranchlessMethods());
            coveredLines.addAll(trace.getCoveredLines());
        }
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Covered_Goals, testSuite.getCoveredGoals().size());
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Covered_Methods, coveredMethods.size());
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Covered_Branches, coveredTrueBranches.size() + coveredFalseBranches.size());
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Covered_Branchless_Methods, coveredBranchlessMethods.size());
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Covered_Lines, coveredLines);
    }
}

