/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic;

import java.text.NumberFormat;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.symbolic.ConstraintTypeCounter;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.expr.IntegerConstraint;
import org.evosuite.symbolic.expr.RealConstraint;
import org.evosuite.symbolic.expr.StringConstraint;
import org.evosuite.symbolic.solver.ConstraintCache;
import org.evosuite.utils.LoggingUtils;

public abstract class DSEStats {
    private static long nrOfUNSATs = 0L;
    private static long nrOfSATs = 0L;
    private static long nrOfTimeouts = 0L;
    private static long nrOfSolutionWithNoImprovement = 0L;
    private static long nrOfNewTestFound = 0L;
    private static int max_path_condition_length;
    private static int min_path_condition_length;
    private static double avg_path_condition_length;
    private static int max_constraint_size;
    private static int min_constraint_size;
    private static double avg_constraint_size;
    private static int constraint_count;
    private static int path_condition_count;
    private static final ConstraintTypeCounter constraintTypeCounter;
    private static long totalSolvingTimeMillis;
    private static long totalConcolicExecutionTimeMillis;
    private static int constraintTooLongCounter;
    private static List<Boolean> changes;

    public static void clear() {
        nrOfUNSATs = 0L;
        nrOfSATs = 0L;
        nrOfSolutionWithNoImprovement = 0L;
        nrOfNewTestFound = 0L;
        constraintTypeCounter.clear();
    }

    public static void reportNewUNSAT() {
        ++nrOfUNSATs;
    }

    public static void reportNewSAT() {
        ++nrOfSATs;
    }

    public static void reportNewTestUnuseful() {
        ++nrOfSolutionWithNoImprovement;
    }

    public static long getUNSAT() {
        return nrOfUNSATs;
    }

    public static long getSAT() {
        return nrOfSATs;
    }

    public static long getUnusefulTests() {
        return nrOfSolutionWithNoImprovement;
    }

    public static void reportNewTestUseful() {
        ++nrOfNewTestFound;
    }

    public static long getUsefulTests() {
        return nrOfNewTestFound;
    }

    public static void printStatistics() {
        LoggingUtils.getEvoLogger().info("* DSE Statistics");
        DSEStats.printSolvingStatistics();
        LoggingUtils.getEvoLogger().info("");
        DSEStats.printConstraintSizeStatistics();
        LoggingUtils.getEvoLogger().info("");
        DSEStats.printPathConditionLengthStatistics();
        LoggingUtils.getEvoLogger().info("");
        DSEStats.printTimeStatistics();
        LoggingUtils.getEvoLogger().info("");
        DSEStats.printCacheStatistics();
        LoggingUtils.getEvoLogger().info("");
        LoggingUtils.getEvoLogger().info("");
        DSEStats.printAdaptationStatistics();
        LoggingUtils.getEvoLogger().info("");
    }

    private static void printAdaptationStatistics() {
        StringBuffer buff = new StringBuffer();
        buff.append("[");
        for (Boolean change : changes) {
            if (change.booleanValue()) {
                buff.append("+");
                continue;
            }
            buff.append("-");
        }
        buff.append("]");
        LoggingUtils.getEvoLogger().info("* DSE) Adaptation statistics");
        LoggingUtils.getEvoLogger().info("* DSE)   Adaptations: " + buff.toString());
    }

    private static void printCacheStatistics() {
        LoggingUtils.getEvoLogger().info("* DSE) Constraint Cache Statistics");
        int numberOfSATs = ConstraintCache.getInstance().getNumberOfSATs();
        int numberOfUNSATs = ConstraintCache.getInstance().getNumberOfUNSATs();
        if (numberOfSATs == 0 || numberOfUNSATs == 0) {
            LoggingUtils.getEvoLogger().info("* DSE)   Constraint Cache was not used.");
        } else {
            LoggingUtils.getEvoLogger().info(String.format("* DSE)   Stored SAT constraints: %s", numberOfSATs));
            LoggingUtils.getEvoLogger().info(String.format("* DSE)   Stored UNSAT constraints: %s", numberOfUNSATs));
            NumberFormat percentFormat = NumberFormat.getPercentInstance();
            percentFormat.setMaximumFractionDigits(1);
            String hit_rate_str = percentFormat.format(ConstraintCache.getInstance().getHitRate());
            LoggingUtils.getEvoLogger().info(String.format("* DSE)   Cache hit rate: %s", hit_rate_str));
        }
    }

    private static void printTimeStatistics() {
        LoggingUtils.getEvoLogger().info("* DSE) Time Statistics");
        LoggingUtils.getEvoLogger().info(String.format("* DSE)   Time spent solving constraints: %sms", totalSolvingTimeMillis));
        LoggingUtils.getEvoLogger().info(String.format("* DSE)   Time spent executing test concolically: %sms", totalConcolicExecutionTimeMillis));
    }

    private static void printSolvingStatistics() {
        long total_constraint_solvings = DSEStats.getSAT() + DSEStats.getUNSAT() + DSEStats.getTimeouts();
        String SAT_ratio_str = "Nan";
        String UNSAT_ratio_str = "Nan";
        String useful_tests_ratio_str = "Nan";
        String unuseful_tests_ratio_str = "Nan";
        String timeout_ratio_str = "Nan";
        if (total_constraint_solvings > 0L) {
            double SAT_ratio = (double)DSEStats.getSAT() / (double)total_constraint_solvings;
            double UNSAT_ratio = (double)DSEStats.getUNSAT() / (double)total_constraint_solvings;
            double useful_tests_ratio = (double)DSEStats.getUsefulTests() / (double)total_constraint_solvings;
            double unuseful_tests_ratio = (double)DSEStats.getUnusefulTests() / (double)total_constraint_solvings;
            double timeout_ratio = (double)DSEStats.getTimeouts() / (double)total_constraint_solvings;
            NumberFormat percentFormat = NumberFormat.getPercentInstance();
            percentFormat.setMaximumFractionDigits(1);
            SAT_ratio_str = percentFormat.format(SAT_ratio);
            UNSAT_ratio_str = percentFormat.format(UNSAT_ratio);
            useful_tests_ratio_str = percentFormat.format(useful_tests_ratio);
            unuseful_tests_ratio_str = percentFormat.format(unuseful_tests_ratio);
            timeout_ratio_str = percentFormat.format(timeout_ratio);
        }
        LoggingUtils.getEvoLogger().info("* DSE) Solving statistics");
        LoggingUtils.getEvoLogger().info(String.format("* DSE)   SAT: %s (%s)", DSEStats.getSAT(), SAT_ratio_str));
        LoggingUtils.getEvoLogger().info(String.format("* DSE) \t  Useful Tests: %s (%s)", DSEStats.getUsefulTests(), useful_tests_ratio_str));
        LoggingUtils.getEvoLogger().info(String.format("* DSE) \t  Unuseful Tests:  %s (%s)", DSEStats.getUnusefulTests(), unuseful_tests_ratio_str));
        LoggingUtils.getEvoLogger().info(String.format("* DSE)   UNSAT: %s (%s)", DSEStats.getUNSAT(), UNSAT_ratio_str));
        LoggingUtils.getEvoLogger().info(String.format("* DSE)   Timeouts: %s (%s)", timeout_ratio_str, DSEStats.getTimeouts()));
        LoggingUtils.getEvoLogger().info(String.format("* DSE)   # Constraint solvings: %s (%s+%s)", total_constraint_solvings, DSEStats.getSAT(), DSEStats.getUNSAT()));
    }

    private static void printConstraintTypeStatistics() {
        int total = constraintTypeCounter.getTotalNumberOfConstraints();
        int integerOnly = constraintTypeCounter.getIntegerOnlyConstraints();
        int realOnly = constraintTypeCounter.getRealOnlyConstraints();
        int stringOnly = constraintTypeCounter.getStringOnlyConstraints();
        int integerRealOnly = constraintTypeCounter.getIntegerAndRealConstraints();
        int integerStringOnly = constraintTypeCounter.getIntegerAndStringConstraints();
        int realStringOnly = constraintTypeCounter.getRealAndStringConstraints();
        int integerRealStringConstraints = constraintTypeCounter.getIntegerRealAndStringConstraints();
        if (total == 0) {
            LoggingUtils.getEvoLogger().info(String.format("* DSE)   no constraints", avg_constraint_size));
        } else {
            String line1 = String.format("* DSE)   Number of integer only constraints : %s / %s ", integerOnly, total);
            String line2 = String.format("* DSE)   Number of real only constraints : %s", realOnly, total);
            String line3 = String.format("* DSE)   Number of string only constraints : %s", stringOnly, total);
            String line4 = String.format("* DSE)   Number of integer+real constraints : %s / %s ", integerRealOnly, total);
            String line5 = String.format("* DSE)   Number of integer+string constraints : %s / %s ", integerStringOnly, total);
            String line6 = String.format("* DSE)   Number of real+string constraints : %s / %s ", realStringOnly, total);
            String line7 = String.format("* DSE)   Number of integer+real+string constraints : %s / %s ", integerRealStringConstraints, total);
            LoggingUtils.getEvoLogger().info(line1);
            LoggingUtils.getEvoLogger().info(line2);
            LoggingUtils.getEvoLogger().info(line3);
            LoggingUtils.getEvoLogger().info(line4);
            LoggingUtils.getEvoLogger().info(line5);
            LoggingUtils.getEvoLogger().info(line6);
            LoggingUtils.getEvoLogger().info(line7);
        }
    }

    private static void printConstraintSizeStatistics() {
        LoggingUtils.getEvoLogger().info("* DSE) Constraint size:");
        LoggingUtils.getEvoLogger().info(String.format("* DSE)   max constraint size: %s", max_constraint_size));
        LoggingUtils.getEvoLogger().info(String.format("* DSE)   min constraint size: %s", min_constraint_size));
        LoggingUtils.getEvoLogger().info(String.format("* DSE)   avg constraint size: %s", avg_constraint_size));
        LoggingUtils.getEvoLogger().info(String.format("* DSE)   Too big constraints: %s (max size %s)", DSEStats.getConstraintTooLongCounter(), Properties.DSE_CONSTRAINT_LENGTH));
    }

    private static void printPathConditionLengthStatistics() {
        LoggingUtils.getEvoLogger().info("* DSE) Path condition length:");
        LoggingUtils.getEvoLogger().info(String.format("* DSE)   max path condition length: %s", max_path_condition_length));
        LoggingUtils.getEvoLogger().info(String.format("* DSE)   min path condition length: %s", min_path_condition_length));
        LoggingUtils.getEvoLogger().info(String.format("* DSE)   avg path condition length: %s", avg_path_condition_length));
    }

    private static int getConstraintTooLongCounter() {
        return constraintTooLongCounter;
    }

    public static void reportNewConstraints(Collection<Constraint<?>> constraints) {
        if (path_condition_count == 0) {
            min_path_condition_length = constraints.size();
            max_path_condition_length = constraints.size();
            avg_path_condition_length = constraints.size();
        } else {
            double new_avg_size;
            avg_path_condition_length = new_avg_size = avg_path_condition_length + ((double)constraints.size() - avg_path_condition_length) / ((double)path_condition_count + 1.0);
            if (constraints.size() > max_path_condition_length) {
                max_path_condition_length = constraints.size();
            }
            if (constraints.size() < min_path_condition_length) {
                min_path_condition_length = constraints.size();
            }
        }
        ++path_condition_count;
        for (Constraint<?> c : constraints) {
            if (constraint_count == 0) {
                min_constraint_size = c.getSize();
                max_constraint_size = c.getSize();
                avg_constraint_size = c.getSize();
            } else {
                double new_avg_size;
                avg_constraint_size = new_avg_size = avg_constraint_size + ((double)c.getSize() - avg_constraint_size) / ((double)constraint_count + 1.0);
                if (c.getSize() > max_constraint_size) {
                    max_constraint_size = c.getSize();
                }
                if (c.getSize() < min_constraint_size) {
                    min_constraint_size = c.getSize();
                }
            }
            ++constraint_count;
        }
        DSEStats.countTypesOfConstraints(constraints);
    }

    private static void countTypesOfConstraints(Collection<Constraint<?>> constraints) {
        boolean hasIntegerConstraint = false;
        boolean hasRealConstraint = false;
        boolean hasStringConstraint = false;
        for (Constraint<?> constraint : constraints) {
            if (constraint instanceof StringConstraint) {
                hasStringConstraint = true;
                continue;
            }
            if (constraint instanceof IntegerConstraint) {
                hasIntegerConstraint = true;
                continue;
            }
            if (constraint instanceof RealConstraint) {
                hasRealConstraint = true;
                continue;
            }
            throw new IllegalArgumentException("The constraint type " + constraint.getClass().getCanonicalName() + " is not considered!");
        }
        constraintTypeCounter.addNewConstraint(hasIntegerConstraint, hasRealConstraint, hasStringConstraint);
    }

    public static void reportNewSolvingTime(long solvingTimeMillis) {
        totalSolvingTimeMillis += solvingTimeMillis;
    }

    public static void reportNewConcolicExecutionTime(long concolicExecutionTimeMillis) {
        totalConcolicExecutionTimeMillis += concolicExecutionTimeMillis;
    }

    public static void reportConstraintTooLong(int size) {
        ++constraintTooLongCounter;
    }

    public static void reportNewTimeout() {
        ++nrOfTimeouts;
    }

    public static long getTimeouts() {
        return nrOfTimeouts;
    }

    public static void reportNewIncrease() {
        changes.add(true);
    }

    public static void reportNewDecrease() {
        changes.add(false);
    }

    static {
        max_constraint_size = 0;
        min_constraint_size = 0;
        avg_constraint_size = 0.0;
        constraint_count = 0;
        path_condition_count = 0;
        constraintTypeCounter = new ConstraintTypeCounter();
        totalSolvingTimeMillis = 0L;
        totalConcolicExecutionTimeMillis = 0L;
        constraintTooLongCounter = 0;
        changes = new LinkedList<Boolean>();
    }
}

