/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.expr;

import org.evosuite.Properties;
import org.evosuite.symbolic.ConstraintTooLongException;
import org.evosuite.symbolic.DSEStats;
import org.evosuite.symbolic.expr.Comparator;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.expr.ConstraintVisitor;
import org.evosuite.symbolic.expr.Expression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IntegerConstraint
extends Constraint<Long> {
    static Logger log = LoggerFactory.getLogger(IntegerConstraint.class);
    private static final long serialVersionUID = 5345957507046422507L;
    private final Expression<Long> left;
    private final Comparator cmp;
    private final Expression<Long> right;

    public IntegerConstraint(Expression<Long> left, Comparator cmp, Expression<Long> right) {
        this.left = left;
        this.cmp = cmp;
        this.right = right;
        if (this.getSize() > Properties.DSE_CONSTRAINT_LENGTH) {
            DSEStats.reportConstraintTooLong(this.getSize());
            throw new ConstraintTooLongException(this.getSize());
        }
    }

    @Override
    public Comparator getComparator() {
        return this.cmp;
    }

    @Override
    public Expression<?> getLeftOperand() {
        return this.left;
    }

    @Override
    public Expression<?> getRightOperand() {
        return this.right;
    }

    public String toString() {
        return this.left + this.cmp.toString() + this.right;
    }

    @Override
    public Constraint<Long> negate() {
        return new IntegerConstraint(this.left, this.cmp.not(), this.right);
    }

    @Override
    public <K, V> K accept(ConstraintVisitor<K, V> v, V arg) {
        return v.visit(this, arg);
    }
}

