/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.expr.bv;

import java.util.HashSet;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.symbolic.ConstraintTooLongException;
import org.evosuite.symbolic.DSEStats;
import org.evosuite.symbolic.expr.AbstractExpression;
import org.evosuite.symbolic.expr.Expression;
import org.evosuite.symbolic.expr.ExpressionVisitor;
import org.evosuite.symbolic.expr.Operator;
import org.evosuite.symbolic.expr.UnaryExpression;
import org.evosuite.symbolic.expr.Variable;
import org.evosuite.symbolic.expr.bv.IntegerValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RealUnaryToIntegerExpression
extends AbstractExpression<Long>
implements IntegerValue,
UnaryExpression<Double> {
    private static final long serialVersionUID = 9086637495150131445L;
    protected static final Logger log = LoggerFactory.getLogger(RealUnaryToIntegerExpression.class);
    private final Operator op;
    private final Expression<Double> expr;

    public RealUnaryToIntegerExpression(Expression<Double> e, Operator op2, Long con) {
        super(con, 1 + e.getSize(), e.containsSymbolicVariable());
        this.expr = e;
        this.op = op2;
        if (this.getSize() > Properties.DSE_CONSTRAINT_LENGTH) {
            DSEStats.reportConstraintTooLong(this.getSize());
            throw new ConstraintTooLongException(this.getSize());
        }
    }

    @Override
    public Expression<Double> getOperand() {
        return this.expr;
    }

    @Override
    public Operator getOperator() {
        return this.op;
    }

    public String toString() {
        return this.op.toString() + "(" + this.expr + ")";
    }

    public boolean equals(Object obj) {
        if (obj instanceof RealUnaryToIntegerExpression) {
            RealUnaryToIntegerExpression v = (RealUnaryToIntegerExpression)obj;
            return this.op.equals((Object)v.op) && this.getSize() == v.getSize() && this.expr.equals(v.expr);
        }
        return false;
    }

    @Override
    public Set<Variable<?>> getVariables() {
        HashSet variables = new HashSet();
        variables.addAll(this.expr.getVariables());
        return variables;
    }

    @Override
    public Set<Object> getConstants() {
        return this.expr.getConstants();
    }

    public int hashCode() {
        return this.op.hashCode() + this.getSize() + this.expr.hashCode();
    }

    @Override
    public <K, V> K accept(ExpressionVisitor<K, V> v, V arg) {
        return v.visit(this, arg);
    }
}

