/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.expr.bv;

import java.util.HashSet;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.symbolic.ConstraintTooLongException;
import org.evosuite.symbolic.DSEStats;
import org.evosuite.symbolic.expr.AbstractExpression;
import org.evosuite.symbolic.expr.Expression;
import org.evosuite.symbolic.expr.ExpressionVisitor;
import org.evosuite.symbolic.expr.Operator;
import org.evosuite.symbolic.expr.Variable;
import org.evosuite.symbolic.expr.bv.StringComparison;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StringBinaryComparison
extends AbstractExpression<Long>
implements StringComparison {
    private static final long serialVersionUID = -2959676064390810341L;
    protected static final Logger log = LoggerFactory.getLogger(StringBinaryComparison.class);
    private final Expression<String> left;
    private final Operator op;
    private final Expression<?> right;

    public StringBinaryComparison(Expression<String> left, Operator op, Expression<?> right, Long con) {
        super(con, 1 + left.getSize() + right.getSize(), left.containsSymbolicVariable() || right.containsSymbolicVariable());
        this.left = left;
        this.op = op;
        this.right = right;
        if (this.getSize() > Properties.DSE_CONSTRAINT_LENGTH) {
            DSEStats.reportConstraintTooLong(this.getSize());
            throw new ConstraintTooLongException(this.getSize());
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof StringBinaryComparison) {
            StringBinaryComparison other = (StringBinaryComparison)obj;
            return this.op.equals((Object)other.op) && this.left.equals(other.left) && this.right.equals(other.right);
        }
        return false;
    }

    public int hashCode() {
        return this.left.hashCode() + this.op.hashCode() + this.right.hashCode();
    }

    public Expression<?> getRightOperand() {
        return this.right;
    }

    public Expression<String> getLeftOperand() {
        return this.left;
    }

    public String toString() {
        return "(" + this.left + this.op.toString() + this.right + ")";
    }

    public Operator getOperator() {
        return this.op;
    }

    @Override
    public Set<Variable<?>> getVariables() {
        HashSet variables = new HashSet();
        variables.addAll(this.left.getVariables());
        variables.addAll(this.right.getVariables());
        return variables;
    }

    @Override
    public Set<Object> getConstants() {
        HashSet<Object> result = new HashSet<Object>();
        result.addAll(this.left.getConstants());
        result.addAll(this.right.getConstants());
        return result;
    }

    @Override
    public <K, V> K accept(ExpressionVisitor<K, V> v, V arg) {
        return v.visit(this, arg);
    }
}

