/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.expr.fp;

import java.util.HashSet;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.symbolic.ConstraintTooLongException;
import org.evosuite.symbolic.expr.AbstractExpression;
import org.evosuite.symbolic.expr.BinaryExpression;
import org.evosuite.symbolic.expr.Expression;
import org.evosuite.symbolic.expr.ExpressionVisitor;
import org.evosuite.symbolic.expr.Operator;
import org.evosuite.symbolic.expr.Variable;
import org.evosuite.symbolic.expr.fp.RealValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RealBinaryExpression
extends AbstractExpression<Double>
implements RealValue,
BinaryExpression<Double> {
    private static final long serialVersionUID = 3095108718393239244L;
    protected static final Logger log = LoggerFactory.getLogger(RealBinaryExpression.class);
    private final Operator op;
    private final Expression<Double> left;
    private final Expression<?> right;

    public RealBinaryExpression(Expression<Double> left, Operator op2, Expression<?> right, Double con) {
        super(con, 1 + left.getSize() + right.getSize(), left.containsSymbolicVariable() || right.containsSymbolicVariable());
        this.left = left;
        this.right = right;
        this.op = op2;
        if (this.getSize() > Properties.DSE_CONSTRAINT_LENGTH) {
            throw new ConstraintTooLongException(this.getSize());
        }
    }

    @Override
    public Operator getOperator() {
        return this.op;
    }

    @Override
    public Expression<Double> getLeftOperand() {
        return this.left;
    }

    @Override
    public Expression<?> getRightOperand() {
        return this.right;
    }

    public String toString() {
        return "(" + this.left + this.op.toString() + this.right + ")";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RealBinaryExpression) {
            RealBinaryExpression other = (RealBinaryExpression)obj;
            return this.op.equals((Object)other.op) && this.left.equals(other.left) && this.right.equals(other.right);
        }
        return false;
    }

    public int hashCode() {
        return this.left.hashCode() + this.op.hashCode() + this.right.hashCode();
    }

    @Override
    public Set<Variable<?>> getVariables() {
        HashSet variables = new HashSet();
        variables.addAll(this.left.getVariables());
        variables.addAll(this.right.getVariables());
        return variables;
    }

    @Override
    public Set<Object> getConstants() {
        HashSet<Object> result = new HashSet<Object>();
        result.addAll(this.left.getConstants());
        result.addAll(this.right.getConstants());
        return result;
    }

    @Override
    public <K, V> K accept(ExpressionVisitor<K, V> v, V arg) {
        return v.visit(this, arg);
    }
}

