/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.expr.fp;

import java.util.HashSet;
import java.util.Set;
import org.evosuite.symbolic.expr.AbstractExpression;
import org.evosuite.symbolic.expr.ExpressionVisitor;
import org.evosuite.symbolic.expr.Variable;
import org.evosuite.symbolic.expr.fp.RealValue;

public final class RealVariable
extends AbstractExpression<Double>
implements RealValue,
Variable<Double> {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final double minValue;
    private final double maxValue;

    public RealVariable(String name, double conV, double minValue, double maxValue) {
        super(conV, 1, true);
        this.name = name;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public final void setConcreteValue(double conV) {
        this.concreteValue = conV;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Double getMinValue() {
        return this.minValue;
    }

    @Override
    public Double getMaxValue() {
        return this.maxValue;
    }

    public String toString() {
        return this.name + "(" + this.concreteValue + ")";
    }

    public boolean equals(Object obj) {
        if (obj instanceof RealVariable) {
            RealVariable v = (RealVariable)obj;
            return this.getName().equals(v.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public Set<Variable<?>> getVariables() {
        HashSet variables = new HashSet();
        variables.add(this);
        return variables;
    }

    @Override
    public Set<Object> getConstants() {
        return new HashSet<Object>();
    }

    @Override
    public <K, V> K accept(ExpressionVisitor<K, V> v, V arg) {
        return v.visit(this, arg);
    }
}

