/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.solver.ConstraintSolverTimeoutException;
import org.evosuite.symbolic.solver.Solver;

public final class ConstraintCache {
    private static final ConstraintCache instance = new ConstraintCache();
    private HashMap<Collection<Constraint<?>>, Map<String, Object>> cached_sat_constraints = new HashMap();
    private int cached_sat_constraints_count = 0;
    private HashSet<Collection<Constraint<?>>> cached_unsat_constraints = new HashSet();
    private int cached_unsat_constraints_count = 0;
    private int number_of_accesses = 0;
    private int number_of_hits = 0;
    private boolean valid_cached_solution = false;
    private Map<String, Object> cached_solution = null;

    public Map<String, Object> solve(Solver solver, Collection<Constraint<?>> constraints) {
        Map<String, Object> solution;
        if (this.hasCachedResult(constraints)) {
            Map<String, Object> cached_solution = this.getCachedResult();
            if (cached_solution != null) {
                return cached_solution;
            }
            return null;
        }
        try {
            solution = solver.solve(constraints);
        }
        catch (ConstraintSolverTimeoutException e) {
            solution = null;
        }
        if (solution == null) {
            this.addUNSAT(constraints);
        } else {
            this.addSAT(constraints, solution);
        }
        return solution;
    }

    public int getNumberOfUNSATs() {
        return this.cached_unsat_constraints_count;
    }

    public int getNumberOfSATs() {
        return this.cached_sat_constraints_count;
    }

    private ConstraintCache() {
    }

    public static ConstraintCache getInstance() {
        return instance;
    }

    private void addUNSAT(Collection<Constraint<?>> unsat_constraints) {
        this.cached_unsat_constraints.add(unsat_constraints);
        ++this.cached_unsat_constraints_count;
    }

    private void addSAT(Collection<Constraint<?>> sat_constraints, Map<String, Object> solution) {
        this.cached_sat_constraints.put(sat_constraints, solution);
        ++this.cached_sat_constraints_count;
    }

    private boolean hasCachedResult(Collection<Constraint<?>> constraints) {
        ++this.number_of_accesses;
        if (this.cached_sat_constraints.containsKey(constraints)) {
            this.valid_cached_solution = true;
            this.cached_solution = this.cached_sat_constraints.get(constraints);
            ++this.number_of_hits;
            return true;
        }
        if (this.cached_unsat_constraints.contains(constraints)) {
            this.valid_cached_solution = true;
            this.cached_solution = null;
            ++this.number_of_hits;
            return true;
        }
        this.valid_cached_solution = false;
        return false;
    }

    public double getHitRate() {
        return (double)this.number_of_hits / (double)this.number_of_accesses;
    }

    public Map<String, Object> getCachedResult() {
        if (!this.valid_cached_solution) {
            throw new IllegalArgumentException("The constraint is not cached!");
        }
        this.valid_cached_solution = false;
        return this.cached_solution;
    }
}

