/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.expr.Variable;
import org.evosuite.symbolic.expr.bv.IntegerVariable;
import org.evosuite.symbolic.expr.fp.RealVariable;
import org.evosuite.symbolic.expr.str.StringVariable;
import org.evosuite.symbolic.solver.ConstraintSolverTimeoutException;
import org.evosuite.symbolic.solver.DistanceEstimator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Solver {
    static Logger logger = LoggerFactory.getLogger(Solver.class);
    private static final double DELTA = 1.0E-15;

    public abstract Map<String, Object> solve(Collection<Constraint<?>> var1) throws ConstraintSolverTimeoutException;

    protected static Map<String, Object> getConcreteValues(Set<Variable<?>> variables) {
        HashMap<String, Object> concrete_values = new HashMap<String, Object>();
        for (Variable<?> v : variables) {
            String var_name = v.getName();
            Object concrete_value = v.getConcreteValue();
            concrete_values.put(var_name, concrete_value);
        }
        return concrete_values;
    }

    protected static Set<Variable<?>> getVariables(Collection<Constraint<?>> constraints) {
        HashSet variables = new HashSet();
        for (Constraint<?> c : constraints) {
            variables.addAll(c.getLeftOperand().getVariables());
            variables.addAll(c.getRightOperand().getVariables());
        }
        return variables;
    }

    protected static void setConcreteValues(Set<Variable<?>> variables, Map<String, Object> concrete_values) {
        for (Variable<?> v : variables) {
            String var_name = v.getName();
            Object concreteValue = concrete_values.get(var_name);
            if (v instanceof StringVariable) {
                StringVariable sv = (StringVariable)v;
                String concreteString = (String)concreteValue;
                sv.setConcreteValue(concreteString);
                continue;
            }
            if (v instanceof IntegerVariable) {
                IntegerVariable iv = (IntegerVariable)v;
                Long concreteInteger = (Long)concreteValue;
                iv.setConcreteValue(concreteInteger);
                continue;
            }
            if (v instanceof RealVariable) {
                RealVariable ir = (RealVariable)v;
                Double concreteReal = (Double)concreteValue;
                ir.setConcreteValue(concreteReal);
                continue;
            }
            logger.warn("unknow variable type " + v.getClass().getName());
        }
    }

    protected static boolean checkSolution(Collection<Constraint<?>> constraints, Map<String, Object> solution) {
        Set<Variable<?>> variables = Solver.getVariables(constraints);
        Map<String, Object> initialValues = Solver.getConcreteValues(variables);
        Solver.setConcreteValues(variables, solution);
        double distance = DistanceEstimator.getDistance(constraints);
        Solver.setConcreteValues(variables, initialValues);
        return distance <= 1.0E-15;
    }
}

