/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver.cvc4;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CVC4ModelParser {
    private final Map<String, Object> initialValues;
    static Logger logger = LoggerFactory.getLogger(CVC4ModelParser.class);

    public CVC4ModelParser(Map<String, Object> initialValues) {
        this.initialValues = initialValues;
    }

    public Map<String, Object> parse(String cvc4ResultStr) {
        HashMap<String, Object> solution = new HashMap<String, Object>();
        StringTokenizer tokenizer = new StringTokenizer(cvc4ResultStr, "() \n\t", true);
        String token = tokenizer.nextToken();
        token = tokenizer.nextToken();
        token = tokenizer.nextToken();
        token = tokenizer.nextToken();
        token = tokenizer.nextToken();
        while (tokenizer.hasMoreTokens() && !(token = tokenizer.nextToken()).equals(")")) {
            String stringToken;
            token = tokenizer.nextToken();
            if (!token.equals("define-fun")) continue;
            token = tokenizer.nextToken();
            String fun_name = tokenizer.nextToken();
            token = tokenizer.nextToken();
            token = tokenizer.nextToken();
            token = tokenizer.nextToken();
            token = tokenizer.nextToken();
            String typeName = tokenizer.nextToken();
            if (typeName.equals("Int")) {
                Long value;
                String integerValueStr;
                token = tokenizer.nextToken();
                token = tokenizer.nextToken();
                boolean neg = false;
                if (token.equals("(")) {
                    neg = true;
                    token = tokenizer.nextToken();
                    token = tokenizer.nextToken();
                    integerValueStr = tokenizer.nextToken();
                } else {
                    integerValueStr = token;
                }
                if (neg) {
                    String absoluteIntegerValue = integerValueStr;
                    value = Long.parseLong("-" + absoluteIntegerValue);
                } else {
                    value = Long.parseLong(integerValueStr);
                }
                solution.put(fun_name, value);
                if (neg) {
                    token = tokenizer.nextToken();
                }
                token = tokenizer.nextToken();
                token = tokenizer.nextToken();
                continue;
            }
            if (typeName.equals("Real")) {
                Double value;
                token = tokenizer.nextToken();
                token = tokenizer.nextToken();
                if (!token.equals("(")) {
                    value = Double.parseDouble(token);
                } else {
                    double denominator;
                    String denominatorStr;
                    String numeratorStr;
                    token = tokenizer.nextToken();
                    if (token.equals("-")) {
                        token = tokenizer.nextToken();
                        token = tokenizer.nextToken();
                        if (token.equals("(")) {
                            token = tokenizer.nextToken();
                            token = tokenizer.nextToken();
                            numeratorStr = tokenizer.nextToken();
                            token = tokenizer.nextToken();
                            denominatorStr = tokenizer.nextToken();
                            double numerator = Double.parseDouble(numeratorStr);
                            denominator = Double.parseDouble(denominatorStr);
                            value = -(numerator / denominator);
                            token = tokenizer.nextToken();
                            token = tokenizer.nextToken();
                        } else {
                            String absoluteValueStr = token;
                            value = Double.parseDouble("-" + absoluteValueStr);
                            token = tokenizer.nextToken();
                        }
                    } else if (token.equals("/")) {
                        token = tokenizer.nextToken();
                        numeratorStr = tokenizer.nextToken();
                        token = tokenizer.nextToken();
                        denominatorStr = tokenizer.nextToken();
                        double numerator = Double.parseDouble(numeratorStr);
                        denominator = Double.parseDouble(denominatorStr);
                        value = numerator / denominator;
                        token = tokenizer.nextToken();
                    } else {
                        value = Double.parseDouble(token);
                    }
                }
                solution.put(fun_name, value);
                token = tokenizer.nextToken();
                token = tokenizer.nextToken();
                continue;
            }
            if (!typeName.equals("String")) continue;
            token = tokenizer.nextToken();
            StringBuffer value = new StringBuffer();
            do {
                stringToken = tokenizer.nextToken();
                value.append(stringToken);
            } while (!stringToken.endsWith("\""));
            String stringWithQuotes = value.toString();
            String stringWithoutQuotes = stringWithQuotes.substring(1, stringWithQuotes.length() - 1);
            solution.put(fun_name, stringWithoutQuotes);
            token = tokenizer.nextToken();
            token = tokenizer.nextToken();
        }
        if (solution.isEmpty()) {
            logger.warn("The CVC4 model has no variables");
            return null;
        }
        logger.debug("Parsed values from CVC4 output");
        for (String varName : solution.keySet()) {
            String valueOf = String.valueOf(solution.get(varName));
            logger.debug(varName + ":" + valueOf);
        }
        if (!solution.keySet().equals(this.initialValues.keySet())) {
            logger.debug("Adding missing values to Solver solution");
            CVC4ModelParser.addMissingValues(this.initialValues, solution);
        }
        return solution;
    }

    private static void addMissingValues(Map<String, Object> initialValues, Map<String, Object> solution) {
        for (String otherVarName : initialValues.keySet()) {
            if (solution.containsKey(otherVarName)) continue;
            solution.put(otherVarName, initialValues.get(otherVarName));
        }
    }
}

