/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver.cvc4;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.evosuite.Properties;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.expr.Variable;
import org.evosuite.symbolic.solver.ConstraintSolverTimeoutException;
import org.evosuite.symbolic.solver.SmtStringExprBuilder;
import org.evosuite.symbolic.solver.Solver;
import org.evosuite.symbolic.solver.cvc4.CVC4ModelParser;
import org.evosuite.symbolic.solver.cvc4.ConstraintToCVC4Visitor;
import org.evosuite.symbolic.solver.cvc4.NonLinearConstraintVisitor;
import org.evosuite.symbolic.solver.smt.SmtExpr;
import org.evosuite.symbolic.solver.smt.SmtExprPrinter;
import org.evosuite.symbolic.solver.smt.SmtIntVariable;
import org.evosuite.symbolic.solver.smt.SmtOperation;
import org.evosuite.symbolic.solver.smt.SmtOperatorCollector;
import org.evosuite.symbolic.solver.smt.SmtRealVariable;
import org.evosuite.symbolic.solver.smt.SmtStringVariable;
import org.evosuite.symbolic.solver.smt.SmtVariable;
import org.evosuite.symbolic.solver.smt.SmtVariableCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CVC4Solver
extends Solver {
    private static final String CVC4_LOGIC = "QF_SLIRA";
    static Logger logger = LoggerFactory.getLogger(CVC4Solver.class);
    private static final int ASCII_TABLE_LENGTH = 256;

    @Override
    public Map<String, Object> solve(Collection<Constraint<?>> constraints) throws ConstraintSolverTimeoutException {
        if (CVC4Solver.hasNonLinearConstraints(constraints)) {
            return null;
        }
        long cvcTimeout = Properties.DSE_CONSTRAINT_SOLVER_TIMEOUT_MILLIS * 10L;
        long processTimeout = cvcTimeout * 2L;
        HashSet variables = new HashSet();
        for (Constraint<?> c : constraints) {
            Set<Variable<?>> c_variables = c.getVariables();
            variables.addAll(c_variables);
        }
        String smtQuery = CVC4Solver.buildSmtQuery(constraints);
        if (smtQuery == null) {
            logger.warn("No variables found during constraint solving. Returning NULL as solution");
            return null;
        }
        logger.debug("CVC4 Query:");
        logger.debug(smtQuery);
        if (Properties.CVC4_PATH == null) {
            String errMsg = "Property CVC4_PATH should be setted in order to use the CVC4 Solver!";
            logger.error(errMsg);
            throw new IllegalStateException(errMsg);
        }
        String cvc4Cmd = Properties.CVC4_PATH + "  --lang smt " + " --tlimit=" + cvcTimeout;
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        ByteArrayOutputStream stderr = new ByteArrayOutputStream();
        try {
            CVC4Solver.launchNewProcess(cvc4Cmd, smtQuery, (int)processTimeout, stdout, stderr);
            String cvc4ResultStr = stdout.toString("UTF-8");
            String errorStr = stderr.toString("UTF-8");
            if (errorStr.contains("error")) {
                logger.error("An error occurred while executing CVC4!");
                return null;
            }
            if (cvc4ResultStr.startsWith("sat")) {
                logger.debug("CVC4 outcome was SAT");
                Map<String, Object> initialValues = CVC4Solver.getConcreteValues(variables);
                CVC4ModelParser modelParser = new CVC4ModelParser(initialValues);
                Map<String, Object> solution = modelParser.parse(cvc4ResultStr);
                boolean check = CVC4Solver.checkSolution(constraints, solution);
                if (!check) {
                    logger.warn("CVC4 solution does not solve the constraint system!");
                    return null;
                }
                return solution;
            }
            if (cvc4ResultStr.startsWith("unsat")) {
                logger.debug("CVC4 outcome was UNSAT");
                return null;
            }
            if (cvc4ResultStr.startsWith("unknown")) {
                logger.debug("CVC4 outcome was UNKNOWN (probably due to timeout)");
                return null;
            }
            if (cvc4ResultStr.startsWith("(error")) {
                logger.error("An error (probably parsing error) occurred while executing CVC4");
                return null;
            }
            logger.error("CVC4 output is unknown. We are unable to parse it to a proper solution!");
            return null;
        }
        catch (IOException e) {
            logger.error("IO Exception during launching of CVC4 command");
            return null;
        }
    }

    private static boolean hasNonLinearConstraints(Collection<Constraint<?>> constraints) {
        NonLinearConstraintVisitor v = new NonLinearConstraintVisitor();
        for (Constraint<?> constraint : constraints) {
            Boolean ret_val = constraint.accept(v, null);
            if (!ret_val.booleanValue()) continue;
            return true;
        }
        return false;
    }

    private static String buildSmtQuery(Collection<Constraint<?>> constraints) {
        ConstraintToCVC4Visitor v = new ConstraintToCVC4Visitor();
        LinkedList<SmtExpr> smtExpressions = new LinkedList<SmtExpr>();
        for (Constraint<?> c : constraints) {
            SmtExpr smtExpr = c.accept(v, null);
            if (smtExpr == null) continue;
            smtExpressions.add(smtExpr);
        }
        SmtExprPrinter printer = new SmtExprPrinter();
        LinkedList<String> cvc4StrAssertions = new LinkedList<String>();
        for (SmtExpr smtExpr : smtExpressions) {
            String smtExprStr = smtExpr.accept(printer, null);
            String assertionStr = SmtStringExprBuilder.mkAssert(smtExprStr);
            cvc4StrAssertions.add(assertionStr);
        }
        SmtVariableCollector varCollector = new SmtVariableCollector();
        for (SmtExpr smtExpr : smtExpressions) {
            smtExpr.accept(varCollector, null);
        }
        Set<SmtVariable> variables = varCollector.getSmtVariables();
        if (variables.isEmpty()) {
            return null;
        }
        SmtOperatorCollector funCollector = new SmtOperatorCollector();
        for (SmtExpr smtExpr : smtExpressions) {
            smtExpr.accept(funCollector, null);
        }
        boolean addCharToInt = funCollector.getOperators().contains((Object)SmtOperation.Operator.CHAR_TO_INT);
        boolean addIntToChar = funCollector.getOperators().contains((Object)SmtOperation.Operator.INT_TO_CHAR);
        return CVC4Solver.createSmtString(cvc4StrAssertions, variables, addCharToInt, addIntToChar);
    }

    private static String createSmtString(List<String> cvc4StrAssertions, Set<SmtVariable> variables, boolean addCharToInt, boolean addIntToChar) {
        StringBuffer smtQuery = new StringBuffer();
        smtQuery.append("\n");
        smtQuery.append("(set-logic QF_SLIRA)");
        smtQuery.append("\n");
        smtQuery.append("(set-option :produce-models true)");
        smtQuery.append("\n");
        smtQuery.append("(set-option :strings-exp true)");
        smtQuery.append("\n");
        if (addCharToInt) {
            String charToIntFunction = CVC4Solver.buildCharToIntFunction();
            smtQuery.append(charToIntFunction);
            smtQuery.append("\n");
        }
        if (addIntToChar) {
            String intToCharFunction = CVC4Solver.buildIntToCharFunction();
            smtQuery.append(intToCharFunction);
            smtQuery.append("\n");
        }
        for (SmtVariable var : variables) {
            String varName = var.getName();
            if (var instanceof SmtIntVariable) {
                String intVar = SmtStringExprBuilder.mkIntFunction(varName);
                smtQuery.append(intVar);
                smtQuery.append("\n");
                continue;
            }
            if (var instanceof SmtRealVariable) {
                String realVar = SmtStringExprBuilder.mkRealFunction(varName);
                smtQuery.append(realVar);
                smtQuery.append("\n");
                continue;
            }
            if (var instanceof SmtStringVariable) {
                String stringVar = SmtStringExprBuilder.mkStringFunction(varName);
                smtQuery.append(stringVar);
                smtQuery.append("\n");
                continue;
            }
            throw new RuntimeException("Unknown variable type " + var.getClass().getCanonicalName());
        }
        for (String cvc4assert : cvc4StrAssertions) {
            smtQuery.append(cvc4assert);
            smtQuery.append("\n");
        }
        smtQuery.append("(check-sat)");
        smtQuery.append("\n");
        smtQuery.append("(get-model)");
        smtQuery.append("\n");
        smtQuery.append("(exit)");
        smtQuery.append("\n");
        return smtQuery.toString();
    }

    private static int launchNewProcess(String cvc4Cmd, String smtQuery, int timeout, OutputStream outputStream, OutputStream errorStream) throws IOException {
        Process process = Runtime.getRuntime().exec(cvc4Cmd);
        InputStream stdout = process.getInputStream();
        InputStream stderr = process.getErrorStream();
        OutputStream stdin = process.getOutputStream();
        stdin.write(smtQuery.getBytes());
        stdin.flush();
        stdin.close();
        logger.debug("Process output:");
        Timer t = new Timer();
        t.schedule((TimerTask)new TimeoutTask(process, timeout), timeout);
        do {
            CVC4Solver.readInputStream(stdout, outputStream);
            CVC4Solver.readInputStream(stderr, errorStream);
        } while (!CVC4Solver.isFinished(process));
        int exitValue = process.exitValue();
        return exitValue;
    }

    private static void readInputStream(InputStream in, OutputStream out) throws IOException {
        InputStreamReader is = new InputStreamReader(in);
        BufferedReader br = new BufferedReader(is);
        String read = br.readLine();
        while (read != null) {
            logger.debug(read);
            if (out != null) {
                byte[] bytes = (read + "\n").getBytes();
                out.write(bytes);
            }
            read = br.readLine();
        }
    }

    private static String buildIntToCharFunction() {
        int i;
        StringBuffer buff = new StringBuffer();
        buff.append("(define-fun " + (Object)((Object)SmtOperation.Operator.INT_TO_CHAR) + "((!x Int)) String");
        buff.append("\n");
        for (i = 0; i < 256; ++i) {
            String hexStr = i < 16 ? "0" + Integer.toHexString(i) : Integer.toHexString(i);
            String escapedHexStr = "\\x" + hexStr;
            if (i < 255) {
                String iteStr = String.format("(ite (= !x %s) \"%s\"", i, escapedHexStr);
                buff.append(iteStr);
                buff.append("\n");
                continue;
            }
            buff.append(String.format("\"%s\"", escapedHexStr));
        }
        for (i = 0; i < 255; ++i) {
            buff.append(")");
        }
        buff.append(")");
        buff.append("\n");
        return buff.toString();
    }

    private static String buildCharToIntFunction() {
        int i;
        StringBuffer buff = new StringBuffer();
        buff.append("(define-fun " + (Object)((Object)SmtOperation.Operator.CHAR_TO_INT) + "((!x String)) Int");
        buff.append("\n");
        for (i = 0; i < 256; ++i) {
            String hexStr = i < 16 ? "0" + Integer.toHexString(i) : Integer.toHexString(i);
            String escapedHexStr = "\\x" + hexStr;
            if (i < 255) {
                String iteStr = String.format("(ite (= !x \"%s\") %s", escapedHexStr, i);
                buff.append(iteStr);
                buff.append("\n");
                continue;
            }
            buff.append(i);
        }
        for (i = 0; i < 255; ++i) {
            buff.append(")");
        }
        buff.append(")");
        buff.append("\n");
        return buff.toString();
    }

    private static boolean isFinished(Process process) {
        try {
            process.exitValue();
            return true;
        }
        catch (IllegalThreadStateException ex) {
            return false;
        }
    }

    private static final class TimeoutTask
    extends TimerTask {
        private final Process process;
        private final long timeout;

        private TimeoutTask(Process process, long timeout) {
            this.process = process;
            this.timeout = timeout;
        }

        @Override
        public void run() {
            logger.debug("CVC4 timeout was reached after " + this.timeout + " milliseconds ");
            this.process.destroy();
        }
    }
}

