/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver.search;

import java.util.Collection;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.expr.bv.IntegerVariable;
import org.evosuite.symbolic.solver.DistanceEstimator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class IntegerAVM {
    static Logger log = LoggerFactory.getLogger(IntegerAVM.class);
    private long checkpointedConcreteValue;
    private double checkpointedDistance = Double.MAX_VALUE;
    private final IntegerVariable intVar;
    private final Collection<Constraint<?>> cnstr;

    public IntegerAVM(IntegerVariable intVar, Collection<Constraint<?>> cnstr) {
        this.intVar = intVar;
        this.cnstr = cnstr;
    }

    private void checkpointVar(double newDist) {
        this.checkpointedDistance = newDist;
        this.checkpointedConcreteValue = (Long)this.intVar.getConcreteValue();
    }

    private void incrementVar(long i) {
        long oldVal = (Long)this.intVar.getConcreteValue();
        long newVal = i > 0L ? (oldVal <= this.intVar.getMaxValue() - i ? oldVal + i : this.intVar.getMaxValue()) : (oldVal >= this.intVar.getMinValue() - i ? oldVal + i : this.intVar.getMinValue());
        this.intVar.setConcreteValue(newVal);
    }

    private boolean distImpr(double newDistance) {
        return newDistance < this.checkpointedDistance;
    }

    public boolean applyAVM() {
        boolean improvement;
        block7: {
            improvement = false;
            log.debug("Initial distance calculation " + this.intVar);
            double initial_distance = DistanceEstimator.getDistance(this.cnstr);
            this.checkpointVar(initial_distance);
            log.debug("Initial distance calculation done");
            if (initial_distance == 0.0) {
                return false;
            }
            while (true) {
                log.debug("Trying to increment " + this.intVar);
                this.incrementVar(1L);
                double newDist = DistanceEstimator.getDistance(this.cnstr);
                log.debug("newDist: " + newDist + " oldDist: " + this.checkpointedDistance);
                if (this.distImpr(newDist)) {
                    improvement = true;
                    this.checkpointVar(newDist);
                    if (newDist != 0.0) {
                        this.iterateVar(2L);
                        continue;
                    }
                } else {
                    this.restoreVar();
                    log.debug("Trying to decrement " + this.intVar);
                    this.incrementVar(-1L);
                    newDist = DistanceEstimator.getDistance(this.cnstr);
                    log.debug("newDist: " + newDist + " oldDist: " + this.checkpointedDistance);
                    if (!this.distImpr(newDist)) break;
                    improvement = true;
                    this.checkpointVar(newDist);
                    if (newDist != 0.0) {
                        this.iterateVar(-2L);
                        continue;
                    }
                }
                break block7;
                break;
            }
            this.restoreVar();
        }
        if (improvement) {
            log.debug("Finished long local search with new value " + this.intVar);
            return true;
        }
        return false;
    }

    private void restoreVar() {
        log.debug("restoring to: " + this.intVar + " with dist: " + this.checkpointedDistance);
        this.intVar.setConcreteValue(this.checkpointedConcreteValue);
    }

    private void iterateVar(long delta) {
        log.debug("Trying increment " + delta + " of " + this.intVar.toString());
        this.incrementVar(delta);
        double newDist = DistanceEstimator.getDistance(this.cnstr);
        log.debug("newDist: " + newDist + " oldDist: " + this.checkpointedDistance);
        while (this.distImpr(newDist)) {
            this.checkpointVar(newDist);
            if (newDist == 0.0) {
                return;
            }
            delta = 2L * delta;
            log.debug("Trying increment " + delta + " of " + this.intVar);
            this.incrementVar(delta);
            newDist = DistanceEstimator.getDistance(this.cnstr);
            log.debug("newDist: " + newDist + " oldDist: " + this.checkpointedDistance);
        }
        log.debug("No improvement on " + this.intVar);
        this.restoreVar();
        log.debug("Final value of this iteration: " + this.intVar);
    }
}

