/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver.search;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.expr.fp.RealVariable;
import org.evosuite.symbolic.solver.DistanceEstimator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RealAVM {
    static Logger log = LoggerFactory.getLogger(RealAVM.class);
    private double checkpointedConcreteValue;
    private double checkpointedDistance = Double.MAX_VALUE;
    private final RealVariable realVar;
    private final Collection<Constraint<?>> cnstr;

    public RealAVM(RealVariable realVar, Collection<Constraint<?>> cnstr) {
        this.realVar = realVar;
        this.cnstr = cnstr;
    }

    public boolean applyAVM() {
        boolean improvement = false;
        improvement = this.doRealSearch(1.0, 2.0);
        if (this.checkpointedDistance > 0.0 && this.afterCommaSearch(this.realVar, this.cnstr)) {
            improvement = true;
        }
        if (improvement) {
            log.debug("Finished real local search with new value " + this.realVar);
            return true;
        }
        return false;
    }

    private boolean doRealSearch(double delta, double factor) {
        boolean improvement;
        block6: {
            improvement = false;
            double initial_distance = DistanceEstimator.getDistance(this.cnstr);
            this.checkpointVar(initial_distance);
            if (initial_distance == 0.0) {
                return false;
            }
            while (true) {
                log.debug("Trying to increment " + this.realVar + " with: " + delta);
                this.incrementVar(delta);
                double newDist = DistanceEstimator.getDistance(this.cnstr);
                log.debug("Old distance: " + this.checkpointedDistance + ", new distance: " + newDist);
                if (this.distImpr(newDist)) {
                    improvement = true;
                    this.checkpointVar(newDist);
                    if (newDist != 0.0) {
                        this.iterateVar(factor * delta, factor);
                        continue;
                    }
                } else {
                    this.restoreVar();
                    log.debug("Trying to decrement " + this.realVar + " with: " + delta);
                    this.incrementVar(-delta);
                    newDist = DistanceEstimator.getDistance(this.cnstr);
                    if (!this.distImpr(newDist)) break;
                    improvement = true;
                    this.checkpointVar(newDist);
                    if (newDist != 0.0) {
                        this.iterateVar(-factor * delta, factor);
                        continue;
                    }
                }
                break block6;
                break;
            }
            this.restoreVar();
        }
        return improvement;
    }

    private void checkpointVar(double newDist) {
        this.checkpointedDistance = newDist;
        this.checkpointedConcreteValue = (Double)this.realVar.getConcreteValue();
    }

    private void incrementVar(double i) {
        double oldVal = (Double)this.realVar.getConcreteValue();
        double newVal = i > 0.0 ? (oldVal <= this.realVar.getMaxValue() - i ? oldVal + i : this.realVar.getMaxValue()) : (oldVal >= this.realVar.getMinValue() - i ? oldVal + i : this.realVar.getMinValue());
        this.realVar.setConcreteValue(newVal);
    }

    private boolean distImpr(double newDistance) {
        return newDistance < this.checkpointedDistance;
    }

    private void restoreVar() {
        log.debug("restoring to: " + this.realVar + " with dist: " + this.checkpointedDistance);
        this.realVar.setConcreteValue(this.checkpointedConcreteValue);
    }

    private boolean afterCommaSearch(RealVariable realVar, Collection<Constraint<?>> cnstr) {
        boolean improvement = false;
        int maxPrecision = realVar.getMaxValue() > 3.4028234663852886E38 ? 15 : 7;
        for (int precision = 1; precision <= maxPrecision; ++precision) {
            this.chopOffPrecision(precision, maxPrecision == 7);
            log.debug("Current precision: " + precision);
            double delta = Math.pow(10.0, -precision);
            double factor = 2.0;
            if (this.doRealSearch(delta, 2.0)) {
                improvement = true;
            }
            if (this.checkpointedDistance <= 0.0) break;
        }
        return improvement;
    }

    private void chopOffPrecision(int precision, boolean isFloat) {
        double value = (Double)this.realVar.getConcreteValue();
        BigDecimal bd = new BigDecimal(value).setScale(precision, RoundingMode.HALF_EVEN);
        double newValue = bd.doubleValue();
        if (newValue == value) {
            return;
        }
        this.realVar.setConcreteValue(newValue);
        log.debug("Trying to chop precision " + precision + ": " + value + " -> " + newValue);
        double dist = DistanceEstimator.getDistance(this.cnstr);
        if (!this.distWrsn(dist)) {
            this.checkpointVar(dist);
            return;
        }
        this.restoreVar();
    }

    private boolean distWrsn(double newDistance) {
        return newDistance > this.checkpointedDistance;
    }

    private void iterateVar(double delta, double factor) {
        log.debug("[Loop] Trying increment " + delta + " of " + this.realVar.toString());
        this.incrementVar(delta);
        double newDist = DistanceEstimator.getDistance(this.cnstr);
        log.debug("[Loop] Old distance: " + this.checkpointedDistance + ", new distance: " + newDist);
        while (this.distImpr(newDist)) {
            this.checkpointVar(newDist);
            if (newDist == 0.0) {
                return;
            }
            delta = factor * delta;
            log.debug("[Loop] Trying increment " + delta + " of " + this.realVar);
            this.incrementVar(delta);
            newDist = DistanceEstimator.getDistance(this.cnstr);
        }
        log.debug("No improvement on " + this.realVar);
        this.restoreVar();
        log.debug("Final value of this iteration: " + this.realVar);
    }
}

