/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver.z3str;

import java.util.HashMap;
import java.util.Map;

class Z3StrModelParser {
    Z3StrModelParser() {
    }

    public Map<String, Object> parse(String z3Model, Map<String, Object> initialValues) {
        String[] lines;
        HashMap<String, Object> solution = new HashMap<String, Object>();
        if (z3Model.contains("(error")) {
            return null;
        }
        if (z3Model.contains("> Error:")) {
            return null;
        }
        if (!z3Model.contains(">> SAT")) {
            return null;
        }
        for (String line : lines = z3Model.split("\n")) {
            if (line.trim().equals("") || line.startsWith("_t_") || line.startsWith("unique-value!") || line.startsWith("**************") || line.startsWith(">>") || line.startsWith("--------------") || !line.contains(" -> ")) continue;
            String[] fields = line.split(" -> ");
            String[] varSec = fields[0].split(":");
            String varName = varSec[0].trim();
            String varType = varSec[1].trim();
            String value = fields[1].trim();
            if (varType.equals("string")) {
                String noQuotationMarks = value.substring(1, value.length() - 1);
                String valueStr = Z3StrModelParser.removeSlashX(noQuotationMarks);
                solution.put(varName, valueStr);
                continue;
            }
            if (varType.equals("real")) {
                Double doubleVal;
                if (value.contains("/")) {
                    String[] fraction = value.split("/");
                    String numeratorStr = fraction[0];
                    String denominatorStr = fraction[1];
                    Long numerator = Long.valueOf(numeratorStr);
                    Long denominator = Long.valueOf(denominatorStr);
                    doubleVal = (double)numerator.longValue() / (double)denominator.longValue();
                } else {
                    doubleVal = Double.valueOf(value);
                }
                solution.put(varName, doubleVal);
                continue;
            }
            if (!varType.equals("int")) continue;
            Long longVal = Long.valueOf(value);
            solution.put(varName, longVal);
        }
        Z3StrModelParser.addMissingValues(initialValues, solution);
        return solution;
    }

    private static String removeSlashX(String str) {
        StringBuffer buff = new StringBuffer();
        char[] charArray = str.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (c == '\\' && i + 3 < charArray.length) {
                char d = charArray[i + 1];
                char e = charArray[i + 2];
                char f = charArray[i + 3];
                if (d == 'x' && Z3StrModelParser.isHexDigit(e) && Z3StrModelParser.isHexDigit(f)) {
                    int intValue = Integer.parseInt(new String(new char[]{e, f}).toUpperCase(), 16);
                    char charValue = (char)intValue;
                    buff.append(charValue);
                    i += 3;
                    continue;
                }
            }
            buff.append(c);
        }
        return buff.toString();
    }

    private static boolean isHexDigit(char charValue) {
        return charValue == '0' || charValue == '1' || charValue == '2' || charValue == '3' || charValue == '4' || charValue == '5' || charValue == '6' || charValue == '7' || charValue == '8' || charValue == '9' || charValue == 'a' || charValue == 'b' || charValue == 'c' || charValue == 'd' || charValue == 'e' || charValue == 'f';
    }

    private static void addMissingValues(Map<String, Object> initialValues, Map<String, Object> solution) {
        for (String otherVarName : initialValues.keySet()) {
            if (solution.containsKey(otherVarName)) continue;
            solution.put(otherVarName, initialValues.get(otherVarName));
        }
    }
}

