/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.vm;

import edu.uta.cse.dsc.AbstractVM;
import edu.uta.cse.dsc.instrument.DscInstrumentingClassLoader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.evosuite.symbolic.expr.bv.IntegerConstant;
import org.evosuite.symbolic.expr.fp.RealConstant;
import org.evosuite.symbolic.vm.ConstructorFrame;
import org.evosuite.symbolic.vm.DoubleWordOperand;
import org.evosuite.symbolic.vm.ExceptionReference;
import org.evosuite.symbolic.vm.ExpressionFactory;
import org.evosuite.symbolic.vm.FakeBottomFrame;
import org.evosuite.symbolic.vm.Frame;
import org.evosuite.symbolic.vm.MethodFrame;
import org.evosuite.symbolic.vm.Operand;
import org.evosuite.symbolic.vm.Reference;
import org.evosuite.symbolic.vm.ReferenceOperand;
import org.evosuite.symbolic.vm.SingleWordOperand;
import org.evosuite.symbolic.vm.StaticInitializerFrame;
import org.evosuite.symbolic.vm.SymbolicEnvironment;
import org.objectweb.asm.Type;

public final class CallVM
extends AbstractVM {
    private final SymbolicEnvironment env;
    private final HashMap<Member, MemberInfo> memberInfos = new HashMap();
    private final DscInstrumentingClassLoader classLoader;
    int stackParamCount = 0;

    public CallVM(SymbolicEnvironment env, DscInstrumentingClassLoader classLoader) {
        this.env = env;
        this.classLoader = classLoader;
    }

    private void CLINIT_BEGIN(String className) {
        this.env.ensurePrepared(className);
        StaticInitializerFrame frame = new StaticInitializerFrame(className);
        this.env.pushFrame(frame);
    }

    private boolean discardFrames(String className, String methName, Member function) {
        if (function == null) {
            throw new IllegalArgumentException("function should be non null");
        }
        if (this.env.topFrame() instanceof FakeBottomFrame) {
            return false;
        }
        Frame topFrame = this.env.topFrame();
        if (topFrame instanceof StaticInitializerFrame) {
            StaticInitializerFrame clinitFrame = (StaticInitializerFrame)topFrame;
            this.conf.getClass();
            if (methName.equals("<init>") && clinitFrame.getClassName().equals(className)) {
                return true;
            }
        }
        if (function != null && function.equals(topFrame.getMember())) {
            return true;
        }
        this.env.popFrame();
        return this.discardFrames(className, methName, function);
    }

    public void HANDLER_BEGIN(int access, String className, String methName, String methDesc) {
        this.conf.getClass();
        if ("<clinit>".equals(methName)) {
            this.discardFramesClassInitializer(className, methName);
        } else {
            Executable function = null;
            this.conf.getClass();
            function = "<init>".equals(methName) ? this.resolveConstructorOverloading(className, methDesc) : this.resolveMethodOverloading(className, methName, methDesc);
            this.discardFrames(className, methName, function);
        }
        this.env.topFrame().operandStack.clearOperands();
        this.env.topFrame().operandStack.pushRef(ExceptionReference.getInstance());
    }

    private boolean discardFramesClassInitializer(String className, String methName) {
        this.conf.getClass();
        if (!"<clinit>".equals(methName)) {
            throw new IllegalArgumentException("methName should be <clinit>");
        }
        if (this.env.topFrame() instanceof FakeBottomFrame) {
            return false;
        }
        Frame topFrame = this.env.topFrame();
        if (topFrame instanceof StaticInitializerFrame) {
            StaticInitializerFrame clinitFrame = (StaticInitializerFrame)topFrame;
            this.conf.getClass();
            if (methName.equals("<clinit>") && clinitFrame.getClassName().equals(className)) {
                return true;
            }
        }
        this.env.popFrame();
        return this.discardFramesClassInitializer(className, methName);
    }

    public void METHOD_MAXS(String className, String methName, String methDesc, int maxStack, int maxLocals) {
        this.conf.getClass();
        if ("<clinit>".equals(methName)) {
            return;
        }
        Executable member = null;
        this.conf.getClass();
        member = "<init>".equals(methName) ? this.resolveConstructorOverloading(className, methDesc) : this.resolveMethodOverloading(className, methName, methDesc);
        if (member == null) {
            return;
        }
        if (this.memberInfos.containsKey(member)) {
            return;
        }
        this.memberInfos.put(member, new MemberInfo(maxStack, maxLocals));
    }

    public void METHOD_BEGIN(int access, String className, String methName, String methDesc) {
        Operand param;
        Frame frame;
        MemberInfo memberInfo;
        int maxLocals;
        this.conf.getClass();
        if ("<clinit>".equals(methName)) {
            this.CLINIT_BEGIN(className);
            return;
        }
        this.prepareStackIfNeeded(className, methName, methDesc);
        boolean calleeNeedsThis = false;
        this.conf.getClass();
        if ("<init>".equals(methName)) {
            Constructor<?> constructor = this.resolveConstructorOverloading(className, methDesc);
            maxLocals = this.conf.MAX_LOCALS_DEFAULT;
            memberInfo = this.memberInfos.get(constructor);
            if (memberInfo != null) {
                maxLocals = memberInfo.maxLocals;
            }
            frame = new ConstructorFrame(constructor, maxLocals);
            calleeNeedsThis = true;
        } else {
            Method method = this.resolveMethodOverloading(className, methName, methDesc);
            maxLocals = this.conf.MAX_LOCALS_DEFAULT;
            memberInfo = this.memberInfos.get(method);
            if (memberInfo != null) {
                maxLocals = memberInfo.maxLocals;
            }
            frame = new MethodFrame(method, maxLocals);
            boolean bl = calleeNeedsThis = !Modifier.isStatic(method.getModifiers());
        }
        if (!this.env.topFrame().weInvokedInstrumentedCode()) {
            this.env.pushFrame(frame);
            return;
        }
        Class<?>[] paramTypes = this.getArgumentClasses(methDesc);
        LinkedList<Operand> params = new LinkedList<Operand>();
        Iterator<Operand> it = this.env.topFrame().operandStack.iterator();
        for (int i = paramTypes.length - 1; i >= 0; --i) {
            param = it.next();
            params.push(param);
        }
        int index = 0;
        for (Operand param2 : params) {
            frame.localsTable.setOperand(index + (calleeNeedsThis ? 1 : 0), param2);
            if (param2 instanceof SingleWordOperand) {
                ++index;
                continue;
            }
            if (param2 instanceof DoubleWordOperand) {
                index += 2;
                continue;
            }
            throw new IllegalStateException("Unknown operand type " + param2.getClass().getName());
        }
        if (calleeNeedsThis) {
            param = it.next();
            ReferenceOperand refOperand = (ReferenceOperand)param;
            frame.localsTable.setRefLocal(0, refOperand.getReference());
        }
        this.env.pushFrame(frame);
    }

    private void prepareStackIfNeeded(String className, String methName, String methDesc) {
        Method method = null;
        if (this.env.isEmpty()) {
            Method[] declMeths;
            Class claz = this.classLoader.getClassForName(className);
            for (Method declMeth : declMeths = claz.getDeclaredMethods()) {
                if (!Modifier.isPublic(declMeth.getModifiers()) || !declMeth.getName().equals(methName)) continue;
                method = declMeth;
            }
            if (method != null) {
                this.env.prepareStack(method);
            }
        }
        if (this.env.isEmpty()) {
            throw new IllegalStateException();
        }
    }

    public void METHOD_BEGIN_RECEIVER(Object value) {
        if (!this.env.callerFrame().weInvokedInstrumentedCode()) {
            Reference ref = this.env.heap.getReference(value);
            this.env.topFrame().localsTable.setRefLocal(0, ref);
        }
    }

    public void METHOD_BEGIN_PARAM(int nr, int index, int value) {
        if (!this.env.callerFrame().weInvokedInstrumentedCode()) {
            IntegerConstant literal_value = ExpressionFactory.buildNewIntegerConstant(value);
            this.env.topFrame().localsTable.setBv32Local(index, literal_value);
        }
    }

    public void METHOD_BEGIN_PARAM(int nr, int index, boolean value) {
        if (!this.env.callerFrame().weInvokedInstrumentedCode()) {
            this.METHOD_BEGIN_PARAM(nr, index, value ? 1 : 0);
        }
    }

    public void METHOD_BEGIN_PARAM(int nr, int index, byte value) {
        if (!this.env.callerFrame().weInvokedInstrumentedCode()) {
            this.METHOD_BEGIN_PARAM(nr, index, (int)value);
        }
    }

    public void METHOD_BEGIN_PARAM(int nr, int index, char value) {
        if (!this.env.callerFrame().weInvokedInstrumentedCode()) {
            this.METHOD_BEGIN_PARAM(nr, index, (int)value);
        }
    }

    public void METHOD_BEGIN_PARAM(int nr, int index, short value) {
        if (!this.env.callerFrame().weInvokedInstrumentedCode()) {
            this.METHOD_BEGIN_PARAM(nr, index, (int)value);
        }
    }

    public void METHOD_BEGIN_PARAM(int nr, int index, long value) {
        if (!this.env.callerFrame().weInvokedInstrumentedCode()) {
            IntegerConstant literal_value = ExpressionFactory.buildNewIntegerConstant(value);
            this.env.topFrame().localsTable.setBv64Local(index, literal_value);
        }
    }

    public void METHOD_BEGIN_PARAM(int nr, int index, double value) {
        if (!this.env.callerFrame().weInvokedInstrumentedCode()) {
            RealConstant literal_value = ExpressionFactory.buildNewRealConstant(value);
            this.env.topFrame().localsTable.setFp64Local(index, literal_value);
        }
    }

    public void METHOD_BEGIN_PARAM(int nr, int index, float value) {
        if (!this.env.callerFrame().weInvokedInstrumentedCode()) {
            RealConstant literal_value = ExpressionFactory.buildNewRealConstant(value);
            this.env.topFrame().localsTable.setFp32Local(index, literal_value);
        }
    }

    public void METHOD_BEGIN_PARAM(int nr, int index, Object conc_ref) {
        if (!this.env.callerFrame().weInvokedInstrumentedCode()) {
            Reference symb_ref = this.env.heap.getReference(conc_ref);
            this.env.topFrame().localsTable.setRefLocal(index, symb_ref);
        }
    }

    private Class<?>[] getArgumentClasses(String methDesc) {
        Type[] asmTypes = Type.getArgumentTypes((String)methDesc);
        Class[] classes = new Class[asmTypes.length];
        for (int i = 0; i < classes.length; ++i) {
            classes[i] = this.classLoader.getClassForType(asmTypes[i]);
        }
        return classes;
    }

    private Method resolveMethodOverloading(String owner, String name, String methDesc) {
        Method method = null;
        LinkedList interfaces = new LinkedList();
        Class claz = this.env.ensurePrepared(owner);
        Class<?>[] argTypes = this.getArgumentClasses(methDesc);
        while (method == null && claz != null) {
            Class<?>[] ifaces;
            for (Class<?> iface : ifaces = claz.getInterfaces()) {
                interfaces.add(iface);
            }
            try {
                method = claz.getDeclaredMethod(name, argTypes);
            }
            catch (NoSuchMethodException nsme) {
                claz = claz.getSuperclass();
            }
            if (claz != null || interfaces.isEmpty()) continue;
            claz = (Class)interfaces.pop();
        }
        if (method == null) {
            throw new IllegalArgumentException("Failed to resolve " + owner + "." + name);
        }
        return method;
    }

    private Constructor<?> resolveConstructorOverloading(String owner, String desc) {
        Constructor<?> constructor = null;
        Class<?> claz = this.env.ensurePrepared(owner);
        Class<?>[] argTypes = this.getArgumentClasses(desc);
        try {
            constructor = claz.getDeclaredConstructor(argTypes);
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalArgumentException("Failed to resolve constructor of " + owner);
        }
        return constructor;
    }

    private boolean isIgnored(Method method) {
        if (Modifier.isNative(method.getModifiers())) {
            return false;
        }
        if (method.getDeclaringClass().isAnonymousClass()) {
            int indexOf;
            String name = method.getDeclaringClass().getName();
            String fullyQualifiedTopLevelClassName = name.substring(0, indexOf = name.indexOf("$"));
            return !this.conf.isIgnored(fullyQualifiedTopLevelClassName);
        }
        String declClass = method.getDeclaringClass().getCanonicalName();
        return !this.conf.isIgnored(declClass);
    }

    private Method methodCall(String className, String methName, String methDesc) {
        Method method = this.resolveMethodOverloading(className, methName, methDesc);
        boolean instrumented = this.isIgnored(method);
        this.env.topFrame().invokeInstrumentedCode(instrumented);
        return method;
    }

    public void INVOKESTATIC(String className, String methName, String methDesc) {
        this.stackParamCount = 0;
        this.env.topFrame().invokeNeedsThis = false;
        this.methodCall(className, methName, methDesc);
    }

    public void INVOKESPECIAL(String className, String methName, String methDesc) {
        this.stackParamCount = 0;
        this.env.topFrame().invokeNeedsThis = true;
        this.conf.getClass();
        if ("<init>".equals(methName)) {
            boolean instrumented = !this.conf.isIgnored(className);
            this.env.topFrame().invokeInstrumentedCode(instrumented);
        } else {
            this.methodCall(className, methName, methDesc);
        }
    }

    public void INVOKESPECIAL(Object conc_receiver, String className, String methName, String methDesc) {
        String concreteClassName = conc_receiver.getClass().getName();
        if (concreteClassName != null) {
            this.INVOKESPECIAL(concreteClassName, methName, methDesc);
        } else {
            this.INVOKESPECIAL(className, methName, methDesc);
        }
    }

    public void INVOKEVIRTUAL(Object conc_receiver, String className, String methName, String methDesc) {
        this.stackParamCount = 0;
        this.env.topFrame().invokeNeedsThis = true;
        Iterator<Operand> it = this.env.topFrame().operandStack.iterator();
        Type[] argTypes = Type.getArgumentTypes((String)methDesc);
        for (int i = 0; i < argTypes.length; ++i) {
            it.next();
        }
        ReferenceOperand ref_operand = (ReferenceOperand)it.next();
        Reference symb_receiver = ref_operand.getReference();
        this.env.heap.initializeReference(conc_receiver, symb_receiver);
        if (this.nullReferenceViolation(conc_receiver, symb_receiver)) {
            return;
        }
        String concreteClassName = conc_receiver.getClass().getName();
        Method virtualMethod = this.methodCall(concreteClassName, methName, methDesc);
        this.chooseReceiverType(className, conc_receiver, methDesc, virtualMethod);
    }

    private boolean nullReferenceViolation(Object conc_receiver, Reference symb_receiver) {
        return conc_receiver == null;
    }

    public void INVOKEINTERFACE(Object conc_receiver, String className, String methName, String methDesc) {
        this.stackParamCount = 0;
        this.env.topFrame().invokeNeedsThis = true;
        if (this.nullReferenceViolation(conc_receiver, null)) {
            return;
        }
        String concreteClassName = conc_receiver.getClass().getName();
        Method method = this.methodCall(concreteClassName, methName, methDesc);
        this.chooseReceiverType(className, conc_receiver, methDesc, method);
    }

    private void chooseReceiverType(String className, Object receiver, String methDesc, Method staticMethod) {
        if (this.nullReferenceViolation(receiver, null)) {
            throw new IllegalArgumentException("we are post null-deref check");
        }
        Class<?> staticReceiver = this.env.ensurePrepared(className);
        if (Modifier.isFinal(staticReceiver.getModifiers())) {
            return;
        }
        int methodModifiers = staticMethod.getModifiers();
        if (Modifier.isNative(methodModifiers) && Modifier.isFinal(methodModifiers)) {
            return;
        }
    }

    private Frame popFrameAndDisposeCallerParams() {
        Frame frame = this.env.popFrame();
        if (!this.env.isEmpty() && this.env.topFrame().weInvokedInstrumentedCode()) {
            this.env.topFrame().disposeMethInvokeArgs(frame);
        }
        return frame;
    }

    public void RETURN() {
        this.popFrameAndDisposeCallerParams();
    }

    public void IRETURN() {
        Frame returningFrame = this.popFrameAndDisposeCallerParams();
        if (this.env.topFrame().weInvokedInstrumentedCode()) {
            Operand ret_val = returningFrame.operandStack.popOperand();
            this.env.topFrame().operandStack.pushOperand(ret_val);
        }
    }

    public void LRETURN() {
        this.IRETURN();
    }

    public void FRETURN() {
        this.IRETURN();
    }

    public void DRETURN() {
        this.IRETURN();
    }

    public void ARETURN() {
        this.IRETURN();
    }

    public void CALL_RESULT(String owner, String name, String desc) {
        if (this.env.topFrame().weInvokedInstrumentedCode()) {
            return;
        }
        this.env.topFrame().disposeMethInvokeArgs(desc);
    }

    public void CALL_RESULT(boolean res, String owner, String name, String desc) {
        this.CALL_RESULT(owner, name, desc);
        if (this.env.topFrame().weInvokedInstrumentedCode()) {
            return;
        }
        int i = res ? 1 : 0;
        IntegerConstant value = ExpressionFactory.buildNewIntegerConstant(i);
        this.env.topFrame().operandStack.pushBv32(value);
    }

    public void CALL_RESULT(int res, String owner, String name, String desc) {
        this.CALL_RESULT(owner, name, desc);
        if (this.env.topFrame().weInvokedInstrumentedCode()) {
            return;
        }
        IntegerConstant value = ExpressionFactory.buildNewIntegerConstant(res);
        this.env.topFrame().operandStack.pushBv32(value);
    }

    public void CALL_RESULT(Object res, String owner, String name, String desc) {
        this.CALL_RESULT(owner, name, desc);
        if (this.env.topFrame().weInvokedInstrumentedCode()) {
            return;
        }
        Reference symb_ref = this.env.heap.getReference(res);
        this.env.topFrame().operandStack.pushRef(symb_ref);
    }

    public void CALL_RESULT(long res, String owner, String name, String desc) {
        this.CALL_RESULT(owner, name, desc);
        if (this.env.topFrame().weInvokedInstrumentedCode()) {
            return;
        }
        IntegerConstant value = ExpressionFactory.buildNewIntegerConstant(res);
        this.env.topFrame().operandStack.pushBv64(value);
    }

    public void CALL_RESULT(double res, String owner, String name, String desc) {
        this.CALL_RESULT(owner, name, desc);
        if (this.env.topFrame().weInvokedInstrumentedCode()) {
            return;
        }
        RealConstant value = ExpressionFactory.buildNewRealConstant(res);
        this.env.topFrame().operandStack.pushFp64(value);
    }

    public void CALL_RESULT(float res, String owner, String name, String desc) {
        this.CALL_RESULT(owner, name, desc);
        if (this.env.topFrame().weInvokedInstrumentedCode()) {
            return;
        }
        RealConstant value = ExpressionFactory.buildNewRealConstant(res);
        this.env.topFrame().operandStack.pushFp32(value);
    }

    public void CALLER_STACK_PARAM(int nr, int calleeLocalsIndex, int value) {
        ++this.stackParamCount;
    }

    public void CALLER_STACK_PARAM(int nr, int calleeLocalsIndex, boolean value) {
        ++this.stackParamCount;
    }

    public void CALLER_STACK_PARAM(int nr, int calleeLocalsIndex, short value) {
        ++this.stackParamCount;
    }

    public void CALLER_STACK_PARAM(int nr, int calleeLocalsIndex, byte value) {
        ++this.stackParamCount;
    }

    public void CALLER_STACK_PARAM(int nr, int calleeLocalsIndex, char value) {
        ++this.stackParamCount;
    }

    public void CALLER_STACK_PARAM(int nr, int calleeLocalsIndex, long value) {
        ++this.stackParamCount;
    }

    public void CALLER_STACK_PARAM(int nr, int calleeLocalsIndex, float value) {
        ++this.stackParamCount;
    }

    public void CALLER_STACK_PARAM(int nr, int calleeLocalsIndex, double value) {
        ++this.stackParamCount;
    }

    public void CALLER_STACK_PARAM(int nr, int calleeLocalsIndex, Object conc_ref) {
        ++this.stackParamCount;
        int operand_index = this.stackParamCount - 1;
        Operand op = this.getOperand(operand_index);
        ReferenceOperand ref_op = (ReferenceOperand)op;
        Reference symb_ref = ref_op.getReference();
        this.env.heap.initializeReference(conc_ref, symb_ref);
    }

    private Operand getOperand(int index) {
        Iterator<Operand> it = this.env.topFrame().operandStack.iterator();
        for (int i = 0; i < index + 1; ++i) {
            Operand op = it.next();
            if (i != index) continue;
            return op;
        }
        return null;
    }

    private static final class MemberInfo {
        final int maxStack;
        final int maxLocals;

        MemberInfo(int maxStack, int maxLocals) {
            this.maxStack = maxStack;
            this.maxLocals = maxLocals;
        }
    }
}

