/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.vm;

import edu.uta.cse.dsc.AbstractVM;
import java.util.Vector;
import org.evosuite.symbolic.expr.IntegerConstraint;
import org.evosuite.symbolic.expr.bv.IntegerConstant;
import org.evosuite.symbolic.expr.bv.IntegerValue;
import org.evosuite.symbolic.vm.ConstraintFactory;
import org.evosuite.symbolic.vm.ExpressionFactory;
import org.evosuite.symbolic.vm.PathConstraint;
import org.evosuite.symbolic.vm.Reference;
import org.evosuite.symbolic.vm.SymbolicEnvironment;

public final class JumpVM
extends AbstractVM {
    private final SymbolicEnvironment env;
    private final PathConstraint pc;

    public JumpVM(SymbolicEnvironment env, PathConstraint pc) {
        this.env = env;
        this.pc = pc;
    }

    public void IFEQ(String className, String methName, int branchIndex, int p) {
        this.env.topFrame().operandStack.pushBv32(ExpressionFactory.ICONST_0);
        this.IF_ICMPEQ(className, methName, branchIndex, p, 0);
    }

    public void IFNE(String className, String methName, int branchIndex, int p) {
        this.IFEQ(className, methName, branchIndex, p);
    }

    public void IFLT(String className, String methName, int branchIndex, int p) {
        this.env.topFrame().operandStack.pushBv32(ExpressionFactory.ICONST_0);
        this.IF_ICMPLT(className, methName, branchIndex, p, 0);
    }

    public void IFGE(String className, String methName, int branchIndex, int p) {
        this.IFLT(className, methName, branchIndex, p);
    }

    public void IFGT(String className, String methName, int branchIndex, int p) {
        IntegerValue rightBv = this.env.topFrame().operandStack.popBv32();
        this.env.topFrame().operandStack.pushBv32(ExpressionFactory.ICONST_0);
        this.env.topFrame().operandStack.pushBv32(rightBv);
        this.IF_ICMPLT(className, methName, branchIndex, 0, p);
    }

    public void IFLE(String className, String methName, int branchIndex, int p) {
        this.IFGT(className, methName, branchIndex, p);
    }

    public void IF_ICMPEQ(String className, String methName, int branchIndex, int left, int right) {
        IntegerValue rightOp = this.env.topFrame().operandStack.popBv32();
        IntegerValue leftOp = this.env.topFrame().operandStack.popBv32();
        IntegerConstraint cnstr = left == right ? ConstraintFactory.eq(leftOp, rightOp) : ConstraintFactory.neq(leftOp, rightOp);
        if (cnstr.getLeftOperand().containsSymbolicVariable() || cnstr.getRightOperand().containsSymbolicVariable()) {
            this.pc.pushBranchCondition(className, methName, branchIndex, cnstr);
        }
    }

    public void IF_ICMPNE(String className, String methName, int branchIndex, int left, int right) {
        this.IF_ICMPEQ(className, methName, branchIndex, left, right);
    }

    public void IF_ICMPLT(String className, String methName, int branchIndex, int left, int right) {
        IntegerValue rightBv = this.env.topFrame().operandStack.popBv32();
        IntegerValue leftBv = this.env.topFrame().operandStack.popBv32();
        IntegerConstraint cnstr = left < right ? ConstraintFactory.lt(leftBv, rightBv) : ConstraintFactory.gte(leftBv, rightBv);
        if (cnstr.getLeftOperand().containsSymbolicVariable() || cnstr.getRightOperand().containsSymbolicVariable()) {
            this.pc.pushBranchCondition(className, methName, branchIndex, cnstr);
        }
    }

    public void IF_ICMPGE(String className, String methName, int branchIndex, int left, int right) {
        this.IF_ICMPLT(className, methName, branchIndex, left, right);
    }

    public void IF_ICMPGT(String className, String methName, int branchIndex, int left, int right) {
        IntegerValue rightBv = this.env.topFrame().operandStack.popBv32();
        IntegerValue leftBv = this.env.topFrame().operandStack.popBv32();
        this.env.topFrame().operandStack.pushBv32(rightBv);
        this.env.topFrame().operandStack.pushBv32(leftBv);
        this.IF_ICMPLT(className, methName, branchIndex, right, left);
    }

    public void IF_ICMPLE(String className, String methName, int branchIndex, int left, int right) {
        this.IF_ICMPGT(className, methName, branchIndex, left, right);
    }

    public void IF_ACMPEQ(String className, String methName, int branchIndex, Object conc_left, Object conc_right) {
        Reference right_ref = this.env.topFrame().operandStack.popRef();
        Reference left_ref = this.env.topFrame().operandStack.popRef();
        this.env.heap.initializeReference(conc_left, left_ref);
        this.env.heap.initializeReference(conc_right, right_ref);
    }

    public void IF_ACMPNE(String className, String methName, int branchIndex, Object left, Object right) {
        this.IF_ACMPEQ(className, methName, branchIndex, left, right);
    }

    public void IFNULL(String className, String methName, int branchIndex, Object p) {
        this.env.topFrame().operandStack.pushNullRef();
        this.IF_ACMPEQ(className, methName, branchIndex, p, null);
    }

    public void IFNONNULL(String className, String methName, int branchIndex, Object p) {
        this.IFNULL(className, methName, branchIndex, p);
    }

    public void TABLESWITCH(String className, String methName, int branchIndex, int goalConcrete, int min, int max) {
        int i;
        IntegerValue value = this.env.topFrame().operandStack.popBv32();
        Vector<IntegerConstraint> constraints = new Vector<IntegerConstraint>();
        for (i = min; i <= max; ++i) {
            IntegerConstraint constraint;
            IntegerConstant literal = ExpressionFactory.buildNewIntegerConstant(i);
            if (goalConcrete == i) {
                constraint = ConstraintFactory.eq(value, literal);
                constraints.add(constraint);
                break;
            }
            constraint = ConstraintFactory.neq(value, literal);
            constraints.add(constraint);
        }
        for (i = 0; i < constraints.size() - 1; ++i) {
            IntegerConstraint cnstrt = (IntegerConstraint)constraints.get(i);
            if (!cnstrt.getLeftOperand().containsSymbolicVariable() && !cnstrt.getRightOperand().containsSymbolicVariable()) continue;
            this.pc.pushSupportingConstraint(cnstrt);
        }
        IntegerConstraint cnstr = (IntegerConstraint)constraints.get(constraints.size() - 1);
        if (cnstr.getLeftOperand().containsSymbolicVariable() || cnstr.getRightOperand().containsSymbolicVariable()) {
            this.pc.pushBranchCondition(className, methName, branchIndex, cnstr);
        }
    }

    public void LOOKUPSWITCH(String className, String methName, int branchIndex, int goalConcrete, int[] targetsConcrete) {
        IntegerValue goal = this.env.topFrame().operandStack.popBv32();
        Vector<IntegerConstraint> constraints = new Vector<IntegerConstraint>();
        for (int targetConcrete : targetsConcrete) {
            IntegerConstraint constraint;
            IntegerConstant integerConstant = ExpressionFactory.buildNewIntegerConstant(targetConcrete);
            if (goalConcrete == targetConcrete) {
                constraint = ConstraintFactory.eq(goal, integerConstant);
                constraints.add(constraint);
                break;
            }
            constraint = ConstraintFactory.neq(goal, integerConstant);
            constraints.add(constraint);
        }
        for (int i = 0; i < constraints.size() - 1; ++i) {
            IntegerConstraint cnstrnt = (IntegerConstraint)constraints.get(i);
            if (!cnstrnt.getLeftOperand().containsSymbolicVariable() && !cnstrnt.getRightOperand().containsSymbolicVariable()) continue;
            this.pc.pushSupportingConstraint(cnstrnt);
        }
        IntegerConstraint cnstr = (IntegerConstraint)constraints.get(constraints.size() - 1);
        if (cnstr.getLeftOperand().containsSymbolicVariable() || cnstr.getRightOperand().containsSymbolicVariable()) {
            this.pc.pushBranchCondition(className, methName, branchIndex, cnstr);
        }
    }

    public void GOTO() {
    }

    public void GOTO_W() {
        this.GOTO();
    }

    public void ATHROW(Throwable throwable) {
        this.env.topFrame().operandStack.popRef();
    }

    public void JSR() {
        throw new UnsupportedOperationException("Implement ME!");
    }

    public void JSR_W() {
        this.JSR();
    }

    public void RET() {
    }
}

