/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.vm;

import edu.uta.cse.dsc.AbstractVM;
import org.evosuite.symbolic.expr.bv.IntegerConstant;
import org.evosuite.symbolic.expr.bv.IntegerValue;
import org.evosuite.symbolic.expr.fp.RealConstant;
import org.evosuite.symbolic.expr.fp.RealValue;
import org.evosuite.symbolic.vm.ExpressionFactory;
import org.evosuite.symbolic.vm.NonNullReference;
import org.evosuite.symbolic.vm.Operand;
import org.evosuite.symbolic.vm.Reference;
import org.evosuite.symbolic.vm.SymbolicEnvironment;

public final class LocalsVM
extends AbstractVM {
    private final SymbolicEnvironment env;

    public LocalsVM(SymbolicEnvironment env) {
        this.env = env;
    }

    public void NOP() {
    }

    public void ACONST_NULL() {
        this.env.topFrame().operandStack.pushNullRef();
    }

    public void ICONST_M1() {
        this.env.topFrame().operandStack.pushBv32(ExpressionFactory.ICONST_M1);
    }

    public void ICONST_0() {
        this.env.topFrame().operandStack.pushBv32(ExpressionFactory.ICONST_0);
    }

    public void ICONST_1() {
        this.env.topFrame().operandStack.pushBv32(ExpressionFactory.ICONST_1);
    }

    public void ICONST_2() {
        this.env.topFrame().operandStack.pushBv32(ExpressionFactory.ICONST_2);
    }

    public void ICONST_3() {
        this.env.topFrame().operandStack.pushBv32(ExpressionFactory.ICONST_3);
    }

    public void ICONST_4() {
        this.env.topFrame().operandStack.pushBv32(ExpressionFactory.ICONST_4);
    }

    public void ICONST_5() {
        this.env.topFrame().operandStack.pushBv32(ExpressionFactory.ICONST_5);
    }

    public void LCONST_0() {
        this.env.topFrame().operandStack.pushBv64(ExpressionFactory.ICONST_0);
    }

    public void LCONST_1() {
        this.env.topFrame().operandStack.pushBv64(ExpressionFactory.ICONST_1);
    }

    public void FCONST_0() {
        this.env.topFrame().operandStack.pushFp32(ExpressionFactory.RCONST_0);
    }

    public void FCONST_1() {
        this.env.topFrame().operandStack.pushFp32(ExpressionFactory.RCONST_1);
    }

    public void FCONST_2() {
        this.env.topFrame().operandStack.pushFp32(ExpressionFactory.RCONST_2);
    }

    public void DCONST_0() {
        this.env.topFrame().operandStack.pushFp64(ExpressionFactory.RCONST_0);
    }

    public void DCONST_1() {
        this.env.topFrame().operandStack.pushFp64(ExpressionFactory.RCONST_1);
    }

    public void BIPUSH(int value) {
        IntegerConstant intConstant = ExpressionFactory.buildNewIntegerConstant(value);
        this.env.topFrame().operandStack.pushBv32(intConstant);
    }

    public void SIPUSH(int value) {
        this.env.topFrame().operandStack.pushBv32(ExpressionFactory.buildNewIntegerConstant(value));
    }

    public void LDC(int x) {
        this.env.topFrame().operandStack.pushBv32(ExpressionFactory.buildNewIntegerConstant(x));
    }

    public void LDC(String x) {
        if (x == null) {
            this.env.topFrame().operandStack.pushNullRef();
        } else {
            NonNullReference stringRef = (NonNullReference)this.env.heap.getReference(x);
            this.env.topFrame().operandStack.pushRef(stringRef);
        }
    }

    public void LDC(Class<?> x) {
        Reference ref = this.env.heap.getReference(x);
        this.env.topFrame().operandStack.pushRef(ref);
    }

    public void LDC2_W(long x) {
        this.env.topFrame().operandStack.pushBv64(ExpressionFactory.buildNewIntegerConstant(x));
    }

    public void LDC(float x) {
        RealConstant realConstant = ExpressionFactory.buildNewRealConstant(x);
        this.env.topFrame().operandStack.pushFp32(realConstant);
    }

    public void LDC2_W(double x) {
        this.env.topFrame().operandStack.pushFp64(new RealConstant(x));
    }

    public void ILOAD(int i) {
        IntegerValue integerExpression = this.env.topFrame().localsTable.getBv32Local(i);
        this.env.topFrame().operandStack.pushBv32(integerExpression);
    }

    public void LLOAD(int i) {
        IntegerValue integerExpression = this.env.topFrame().localsTable.getBv64Local(i);
        this.env.topFrame().operandStack.pushBv64(integerExpression);
    }

    public void FLOAD(int i) {
        RealValue realExpr = this.env.topFrame().localsTable.getFp32Local(i);
        this.env.topFrame().operandStack.pushFp32(realExpr);
    }

    public void DLOAD(int i) {
        RealValue realExpr = this.env.topFrame().localsTable.getFp64Local(i);
        this.env.topFrame().operandStack.pushFp64(realExpr);
    }

    public void ALOAD(int i) {
        Operand local = this.env.topFrame().localsTable.getOperand(i);
        this.env.topFrame().operandStack.pushOperand(local);
    }

    public void ISTORE(int i) {
        IntegerValue integerExpr = this.env.topFrame().operandStack.popBv32();
        this.env.topFrame().localsTable.setBv32Local(i, integerExpr);
    }

    public void LSTORE(int i) {
        IntegerValue integerExpr = this.env.topFrame().operandStack.popBv64();
        this.env.topFrame().localsTable.setBv64Local(i, integerExpr);
    }

    public void FSTORE(int i) {
        RealValue realExpr = this.env.topFrame().operandStack.popFp32();
        this.env.topFrame().localsTable.setFp32Local(i, realExpr);
    }

    public void DSTORE(int i) {
        RealValue realExpr = this.env.topFrame().operandStack.popFp64();
        this.env.topFrame().localsTable.setFp64Local(i, realExpr);
    }

    public void ASTORE(int i) {
        Operand operand = this.env.topFrame().operandStack.popOperand();
        this.env.topFrame().localsTable.setOperand(i, operand);
    }
}

