/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.vm;

import java.lang.ref.WeakReference;
import org.evosuite.symbolic.vm.Reference;
import org.objectweb.asm.Type;

public class NonNullReference
implements Reference {
    private final int instanceId;
    private final Type objectType;
    private WeakReference<Object> weakReference;
    private int concIdentityHashCode;

    public NonNullReference(Type objectType, int instanceId) {
        this.objectType = objectType;
        this.instanceId = instanceId;
        this.weakReference = null;
        this.concIdentityHashCode = -1;
    }

    public String toString() {
        return this.getClassName() + "$" + this.instanceId;
    }

    public void initializeReference(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Cannot initialize a NonNullReference with the null value");
        }
        if (this.weakReference != null) {
            throw new IllegalStateException("Reference already initialized!");
        }
        this.weakReference = new WeakReference<Object>(obj);
        this.concIdentityHashCode = System.identityHashCode(obj);
    }

    public boolean isInitialized() {
        return this.weakReference != null;
    }

    public Object getWeakConcreteObject() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Object has to be initialized==true for this method to be invoked");
        }
        return this.weakReference.get();
    }

    public int getConcIdentityHashCode() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Object has to be initialized==true for this method to be invoked");
        }
        return this.concIdentityHashCode;
    }

    public boolean isCollectable() {
        return this.isInitialized() && this.getWeakConcreteObject() == null;
    }

    public String getClassName() {
        return this.objectType.getClassName();
    }

    public boolean isString() {
        Type stringType = Type.getType(String.class);
        return this.objectType.equals((Object)stringType);
    }
}

