/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.vm;

import edu.uta.cse.dsc.MainConfig;
import edu.uta.cse.dsc.instrument.DscInstrumentingClassLoader;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.evosuite.symbolic.vm.FakeBottomFrame;
import org.evosuite.symbolic.vm.FakeMainCallerFrame;
import org.evosuite.symbolic.vm.Frame;
import org.evosuite.symbolic.vm.Reference;
import org.evosuite.symbolic.vm.SymbolicHeap;
import org.evosuite.testcase.execution.EvosuiteError;
import org.objectweb.asm.Type;

public final class SymbolicEnvironment {
    public final SymbolicHeap heap = new SymbolicHeap();
    private final Deque<Frame> stackFrame = new LinkedList<Frame>();
    private final Set<Class<?>> preparedClasses = new HashSet();
    private final DscInstrumentingClassLoader classLoader;

    public SymbolicEnvironment(DscInstrumentingClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Frame topFrame() {
        return this.stackFrame.peek();
    }

    public void pushFrame(Frame frame) {
        this.stackFrame.push(frame);
    }

    public Frame callerFrame() {
        Frame top = this.stackFrame.pop();
        Frame res = this.stackFrame.peek();
        this.stackFrame.push(top);
        return res;
    }

    public Frame popFrame() {
        return this.stackFrame.pop();
    }

    public Class<?> ensurePrepared(String className) {
        Type ownerType = Type.getType((String)className);
        if (ownerType.getSort() == 9) {
            Type elemType = ownerType.getElementType();
            if (this.isValueType(elemType)) {
                return this.primitiveClassType(elemType);
            }
            className = elemType.getClassName();
            Class claz = this.classLoader.getClassForName(className);
            this.ensurePrepared(claz);
            Class<?> arrayClaz = Array.newInstance(claz, 0).getClass();
            return arrayClaz;
        }
        Class claz = this.classLoader.getClassForName(className);
        this.ensurePrepared(claz);
        return claz;
    }

    private Class<?> primitiveClassType(Type t) {
        if (t.equals((Object)Type.BOOLEAN_TYPE)) {
            return boolean[].class;
        }
        if (t.equals((Object)Type.CHAR_TYPE)) {
            return char[].class;
        }
        if (t.equals((Object)Type.SHORT_TYPE)) {
            return short[].class;
        }
        if (t.equals((Object)Type.BYTE_TYPE)) {
            return byte[].class;
        }
        if (t.equals((Object)Type.INT_TYPE)) {
            return int[].class;
        }
        if (t.equals((Object)Type.LONG_TYPE)) {
            return long[].class;
        }
        if (t.equals((Object)Type.FLOAT_TYPE)) {
            return float[].class;
        }
        if (t.equals((Object)Type.DOUBLE_TYPE)) {
            return double[].class;
        }
        throw new EvosuiteError(t.toString() + " is not a primitive value class!");
    }

    private boolean isValueType(Type t) {
        return t.equals((Object)Type.BOOLEAN_TYPE) || t.equals((Object)Type.CHAR_TYPE) || t.equals((Object)Type.SHORT_TYPE) || t.equals((Object)Type.BYTE_TYPE) || t.equals((Object)Type.INT_TYPE) || t.equals((Object)Type.LONG_TYPE) || t.equals((Object)Type.FLOAT_TYPE) || t.equals((Object)Type.DOUBLE_TYPE);
    }

    public void ensurePrepared(Class<?> claz) {
        String className;
        if (this.preparedClasses.contains(claz)) {
            return;
        }
        Class<?> superClass = claz.getSuperclass();
        if (superClass != null) {
            this.ensurePrepared(superClass);
        }
        if ((className = claz.getCanonicalName()) == null) {
            // empty if block
        }
        this.preparedClasses.add(claz);
    }

    public void prepareStack(Method mainMethod) {
        this.stackFrame.clear();
        this.pushFrame(new FakeBottomFrame());
        FakeMainCallerFrame fakeMainCallerFrame = new FakeMainCallerFrame(mainMethod, MainConfig.get().MAX_LOCALS_DEFAULT);
        if (mainMethod != null) {
            boolean isInstrumented = SymbolicEnvironment.isInstrumented(mainMethod);
            fakeMainCallerFrame.invokeInstrumentedCode(isInstrumented);
            String[] emptyStringArray = new String[]{};
            Reference emptyStringRef = this.heap.getReference(emptyStringArray);
            fakeMainCallerFrame.operandStack.pushRef(emptyStringRef);
        }
        this.pushFrame(fakeMainCallerFrame);
    }

    private static boolean isInstrumented(Method method) {
        if (Modifier.isNative(method.getModifiers())) {
            return false;
        }
        String declClass = method.getDeclaringClass().getCanonicalName();
        return !MainConfig.get().isIgnored(declClass);
    }

    public boolean isEmpty() {
        return this.stackFrame.isEmpty();
    }
}

