/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.vm.math;

import org.evosuite.symbolic.expr.Operator;
import org.evosuite.symbolic.expr.fp.RealUnaryExpression;
import org.evosuite.symbolic.expr.fp.RealValue;
import org.evosuite.symbolic.vm.SymbolicEnvironment;
import org.evosuite.symbolic.vm.SymbolicFunction;
import org.evosuite.symbolic.vm.math.Types;

public abstract class NextUp {
    private static final String NEXT_UP = "nextUp";

    public static final class NextUp_F
    extends SymbolicFunction {
        public NextUp_F(SymbolicEnvironment env) {
            super(env, Types.JAVA_LANG_MATH, NextUp.NEXT_UP, Types.F2F_DESCRIPTOR);
        }

        @Override
        public Object executeFunction() {
            RealValue nextUpExpr;
            float res = this.getConcFloatRetVal();
            RealValue realExpression = this.getSymbRealArgument(0);
            if (realExpression.containsSymbolicVariable()) {
                Operator op = Operator.NEXTUP;
                nextUpExpr = new RealUnaryExpression(realExpression, op, Double.valueOf(res));
            } else {
                nextUpExpr = this.getSymbRealRetVal();
            }
            return nextUpExpr;
        }
    }

    public static final class NextUp_D
    extends SymbolicFunction {
        public NextUp_D(SymbolicEnvironment env) {
            super(env, Types.JAVA_LANG_MATH, NextUp.NEXT_UP, Types.D2D_DESCRIPTOR);
        }

        @Override
        public Object executeFunction() {
            RealValue nextUpExpr;
            double res = this.getConcDoubleRetVal();
            RealValue realExpression = this.getSymbRealArgument(0);
            if (realExpression.containsSymbolicVariable()) {
                Operator op = Operator.NEXTUP;
                nextUpExpr = new RealUnaryExpression(realExpression, op, res);
            } else {
                nextUpExpr = this.getSymbRealRetVal();
            }
            return nextUpExpr;
        }
    }
}

