/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.vm.string;

import org.evosuite.symbolic.expr.Operator;
import org.evosuite.symbolic.expr.str.StringBinaryExpression;
import org.evosuite.symbolic.expr.str.StringValue;
import org.evosuite.symbolic.vm.NonNullReference;
import org.evosuite.symbolic.vm.SymbolicEnvironment;
import org.evosuite.symbolic.vm.SymbolicFunction;
import org.evosuite.symbolic.vm.string.Types;

public final class Concat
extends SymbolicFunction {
    private static final String CONCAT = "concat";

    public Concat(SymbolicEnvironment env) {
        super(env, Types.JAVA_LANG_STRING, CONCAT, Types.STR_TO_STR_DESCRIPTOR);
    }

    @Override
    public Object executeFunction() {
        String conc_left = (String)this.getConcReceiver();
        NonNullReference symb_left = this.getSymbReceiver();
        StringValue left_expr = this.env.heap.getField(Types.JAVA_LANG_STRING, "$stringValue", (Object)conc_left, symb_left, conc_left);
        String conc_right = (String)this.getConcArgument(0);
        NonNullReference symb_right = (NonNullReference)this.getSymbArgument(0);
        StringValue right_expr = this.env.heap.getField(Types.JAVA_LANG_STRING, "$stringValue", (Object)conc_right, symb_right, conc_right);
        String res = (String)this.getConcRetVal();
        if (res != null) {
            StringBinaryExpression symb_value = new StringBinaryExpression(left_expr, Operator.CONCAT, right_expr, res);
            NonNullReference symb_receiver = (NonNullReference)this.env.topFrame().operandStack.peekRef();
            String conc_receiver = res;
            this.env.heap.putField(Types.JAVA_LANG_STRING, "$stringValue", conc_receiver, symb_receiver, symb_value);
        }
        return this.getSymbRetVal();
    }
}

