/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcarver.capture;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.evosuite.TimeController;
import org.evosuite.testcarver.capture.CaptureLog;
import org.evosuite.testcarver.capture.FieldRegistry;
import org.evosuite.testcarver.exception.CapturerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Capturer {
    private static CaptureLog currentLog;
    private static boolean isCaptureStarted;
    private static boolean isShutdownHookAdded;
    private static final ArrayList<CaptureLog> logs;
    public static final String DEFAULT_SAVE_LOC = "captured.log";
    private static final ArrayList<String[]> classesToBeObserved;
    private static final transient Logger logger;

    @Deprecated
    private static void initShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                logger.info("shutting down...");
                Capturer.stopCapture();
                Capturer.postProcess();
                logger.info("shut down");
            }
        }));
    }

    @Deprecated
    public static void postProcess() {
    }

    public static void save(OutputStream out) throws IOException {
        if (out == null) {
            throw new NullPointerException("given OutputStream must not be null");
        }
        XStream xstream = new XStream();
        xstream.toXML(logs, out);
        out.close();
    }

    public static void load(InputStream in) {
        if (in == null) {
            throw new NullPointerException("given InputStream must not be null");
        }
        XStream xstream = new XStream((HierarchicalStreamDriver)new StaxDriver());
        logs.addAll((ArrayList)xstream.fromXML(in));
    }

    public static void clear() {
        currentLog = null;
        logs.clear();
        classesToBeObserved.clear();
        isCaptureStarted = false;
        FieldRegistry.clear();
    }

    public static void startCapture() {
        logger.info("Starting Capturer...");
        if (isCaptureStarted) {
            throw new IllegalStateException("Capture has already been started");
        }
        currentLog = new CaptureLog();
        isCaptureStarted = true;
        FieldRegistry.restoreForegoingGETSTATIC();
        logger.info("Capturer has been started successfully");
    }

    public static void startCapture(String classesToBeObservedString) {
        if (classesToBeObservedString == null) {
            String msg = "no arguments specified";
            logger.error("no arguments specified");
            throw new CapturerException("no arguments specified");
        }
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(classesToBeObservedString.split("\\s+")));
        if (args.isEmpty()) {
            String msg = "no class to be observed specified";
            logger.error("no class to be observed specified");
            throw new CapturerException("no class to be observed specified");
        }
        Capturer.startCapture(args);
    }

    public static void startCapture(List<String> classesToBeObserved) {
        logger.info("Starting Capturer...");
        if (isCaptureStarted) {
            throw new IllegalStateException("Capture has already been started");
        }
        currentLog = new CaptureLog();
        isCaptureStarted = true;
        int size = classesToBeObserved.size();
        String[] clazzes = new String[size];
        for (int i = 0; i < size; ++i) {
            clazzes[i] = classesToBeObserved.get(i);
        }
        Capturer.classesToBeObserved.add(clazzes);
        FieldRegistry.restoreForegoingGETSTATIC();
        logger.info("Capturer has been started successfully");
    }

    public static CaptureLog stopCapture() {
        logger.info("Stopping Capturer...");
        if (isCaptureStarted) {
            isCaptureStarted = false;
            logs.add(currentLog);
            CaptureLog log = currentLog;
            currentLog = null;
            logger.info("Capturer has been stopped successfully");
            FieldRegistry.clear();
            logger.debug("Done");
            return log;
        }
        logger.debug("Done");
        return null;
    }

    public static boolean isCapturing() {
        return isCaptureStarted;
    }

    public static void setCapturing(boolean isCapturing) {
        isCaptureStarted = isCapturing;
    }

    public static void capture(int captureId, Object receiver, String methodName, String methodDesc, Object[] methodParams) {
        try {
            if (Capturer.isCapturing()) {
                Capturer.setCapturing(false);
                if (logger.isDebugEnabled()) {
                    logger.debug("captured:  captureId={} receiver={} type={} method={} methodDesc={} " + Arrays.toString(methodParams), new Object[]{captureId, System.identityHashCode(receiver), receiver.getClass().getName(), methodName, methodDesc});
                }
                currentLog.log(captureId, receiver, methodName, methodDesc, methodParams);
                if (TimeController.getInstance().isThereStillTimeInThisPhase()) {
                    Capturer.setCapturing(true);
                }
            }
        }
        catch (Throwable t) {
            logger.debug(t.toString());
        }
    }

    public static List<CaptureLog> getCaptureLogs() {
        return (List)logs.clone();
    }

    public static void enable(int captureId, Object receiver, Object returnValue) {
        try {
            if (Capturer.isCapturing()) {
                Capturer.setCapturing(false);
                if (logger.isDebugEnabled()) {
                    logger.debug("enabled: capturedId={}", (Object)captureId);
                }
                currentLog.logEnd(captureId, receiver, returnValue);
                Capturer.setCapturing(true);
            }
        }
        catch (Throwable t) {
            logger.debug(t.toString());
        }
    }

    static {
        isCaptureStarted = false;
        isShutdownHookAdded = false;
        logs = new ArrayList();
        classesToBeObserved = new ArrayList();
        logger = LoggerFactory.getLogger(Capturer.class);
    }
}

