/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcarver.capture;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.testcarver.capture.CaptureLog;
import org.evosuite.testcarver.capture.Capturer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FieldRegistry {
    private static final Map<String, ReferenceQueue<?>> classRefQueueMapping = new LinkedHashMap();
    private static final Map<String, List<MyWeakRef<?>>> classInstanceMapping = new LinkedHashMap();
    private static final Map<Integer, Map<String, WeakReference<?>>> instanceRecentFieldValuesMapping = new LinkedHashMap();
    private static final Map<String, Map<String, Field>> classFieldsMapping = new LinkedHashMap<String, Map<String, Field>>();
    private static final Set<Class<?>> CLASSES = new LinkedHashSet();
    private static final Set<Integer> registeredObjects = new LinkedHashSet<Integer>();
    private static final Logger logger = LoggerFactory.getLogger(FieldRegistry.class);
    private static int captureId = Integer.MAX_VALUE;
    public static ClassLoader carvingClassLoader = null;

    private FieldRegistry() {
    }

    public static synchronized void register(Object instance) {
        if (!Capturer.isCapturing()) {
            return;
        }
        try {
            Class<?> clazz = instance instanceof Class ? (Class<?>)instance : instance.getClass();
            String internalClassName = clazz.getName().replace('.', '/');
            registeredObjects.add(System.identityHashCode(instance));
            FieldRegistry.cleanUpReferences(internalClassName);
            Map<String, Field> observedFields = classFieldsMapping.get(internalClassName);
            if (observedFields == null) {
                observedFields = new LinkedHashMap<String, Field>();
                FieldRegistry.collectAccessibleFields(observedFields, clazz, null);
            }
        }
        catch (Throwable t) {
            logger.debug("ARgh");
        }
    }

    private static Map<String, Field> collectAccessibleFields(Map<String, Field> accessibleFields, Class<?> clazz, Package childPackage) {
        if (clazz == null || Object.class.equals(clazz)) {
            logger.debug("Trying to get fields for null class");
            return new LinkedHashMap<String, Field>();
        }
        logger.debug("Getting fields for {} " + clazz);
        LinkedHashMap<String, Field> currentAccessibleFields = new LinkedHashMap<String, Field>();
        try {
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                try {
                    Field f = fields[i];
                    int modifier = f.getModifiers();
                    if (!Modifier.isPublic(modifier) && (!Modifier.isProtected(modifier) || childPackage != null && !childPackage.equals(clazz.getPackage()))) continue;
                    f.setAccessible(true);
                    currentAccessibleFields.put(f.getName(), f);
                    continue;
                }
                catch (Throwable t) {
                    logger.debug("AHA " + t.toString());
                }
            }
        }
        catch (Throwable t) {
            logger.debug("Arglquargl " + t.toString());
        }
        logger.debug("Looking at fields of superclass " + clazz.getSuperclass());
        Map<String, Field> superFieldMap = FieldRegistry.collectAccessibleFields(accessibleFields, clazz.getSuperclass(), clazz.getPackage());
        currentAccessibleFields.putAll(superFieldMap);
        classFieldsMapping.put(clazz.getName().replace('.', '/'), currentAccessibleFields);
        logger.debug("Storing fields for {} to {}", (Object)clazz.getName().replace('.', '/'), currentAccessibleFields);
        return currentAccessibleFields;
    }

    private static void cleanUpReferences(String internalClassName) {
        List<MyWeakRef<?>> instances = classInstanceMapping.get(internalClassName);
        if (instances != null) {
            Reference<?> ref;
            ReferenceQueue<?> refQueue = classRefQueueMapping.get(internalClassName);
            while ((ref = refQueue.poll()) != null) {
                instances.remove(ref);
                instanceRecentFieldValuesMapping.remove(((MyWeakRef)ref).oid);
            }
            if (instances.isEmpty()) {
                classRefQueueMapping.remove(internalClassName);
                classInstanceMapping.remove(internalClassName);
                classFieldsMapping.remove(internalClassName);
            }
        }
    }

    public static synchronized void notifyModification(Object receiver, int captureId, String internalClassName, String fieldName, String desc) {
        FieldRegistry.cleanUpReferences(internalClassName);
        if (!Capturer.isCapturing()) {
            return;
        }
        Map<String, Field> observedFields = classFieldsMapping.get(internalClassName);
        if (observedFields == null) {
            FieldRegistry.populateFieldMap(internalClassName, fieldName);
        }
        try {
            Map<String, Field> fields = classFieldsMapping.get(internalClassName);
            if (fields == null) {
                logger.error("Fields map for class {} should not be null", (Object)internalClassName);
                throw new IllegalStateException("Fields map for class " + internalClassName + " should not be null");
            }
            if (fields.isEmpty()) {
                logger.debug(classFieldsMapping.toString());
                logger.debug("Done modify - no fields");
                return;
            }
            Field targetField = fields.get(fieldName);
            if (targetField == null) {
                logger.debug("Could not find field {} for class {}", (Object)fieldName, (Object)internalClassName);
            } else {
                Object currentValue;
                if (Modifier.isStatic(targetField.getModifiers())) {
                    currentValue = targetField.get(null);
                } else {
                    if (receiver instanceof Class) {
                        return;
                    }
                    if (!registeredObjects.contains(System.identityHashCode(receiver))) {
                        return;
                    }
                    currentValue = targetField.get(receiver);
                }
                logger.debug("Notify modification of field " + fieldName + " on class " + internalClassName);
                if (Modifier.isStatic(targetField.getModifiers())) {
                    Capturer.capture(captureId, receiver, "PUTSTATIC", desc, new Object[]{fieldName, currentValue});
                    Capturer.enable(captureId, receiver, CaptureLog.RETURN_TYPE_VOID);
                } else {
                    Capturer.capture(captureId, receiver, "PUTFIELD", desc, new Object[]{fieldName, currentValue});
                    Capturer.enable(captureId, receiver, CaptureLog.RETURN_TYPE_VOID);
                }
            }
        }
        catch (Throwable e) {
            logger.error("an error occurred while comparing field values for class {}", (Object)internalClassName, (Object)e);
            throw new RuntimeException(e);
        }
        logger.debug("Done field write");
    }

    private static void populateFieldMap(String internalClassName, String fieldName) {
        block6: {
            LinkedHashMap<String, Field> observedFields = new LinkedHashMap<String, Field>();
            try {
                Class<?> clazz = Class.forName(internalClassName.replace('/', '.'), true, carvingClassLoader);
                logger.debug("Collecting fields for {}", clazz);
                FieldRegistry.collectAccessibleFields(observedFields, clazz, null);
                if (!observedFields.containsKey(fieldName)) {
                    logger.debug("Not observed: " + fieldName);
                    return;
                }
                logger.debug("Trying to get field {} for class {}", (Object)fieldName, (Object)internalClassName);
                if (!Modifier.isStatic(((Field)observedFields.get(fieldName)).getModifiers())) break block6;
                FieldRegistry.register(clazz);
            }
            catch (ClassNotFoundException e) {
                logger.info("Error loading class " + internalClassName + ": " + e);
            }
            catch (Throwable e) {
                logger.debug("Carving classloader: " + carvingClassLoader);
                logger.info("TODO Error loading class " + internalClassName + ": " + e);
                logger.info("TODO Error loading class " + internalClassName + ": " + e.getCause());
                for (StackTraceElement elem : e.getStackTrace()) {
                    logger.debug(elem.toString());
                }
                if (e.getCause() == null) break block6;
                for (StackTraceElement elem : e.getCause().getStackTrace()) {
                    logger.debug(elem.toString());
                }
            }
        }
    }

    public static synchronized void notifyReadAccess(Object receiver, int captureId, String internalClassName, String fieldName, String desc) {
        FieldRegistry.cleanUpReferences(internalClassName);
        if (!Capturer.isCapturing()) {
            return;
        }
        Map<String, Field> observedFields = classFieldsMapping.get(internalClassName);
        if (observedFields == null) {
            logger.debug("Haven't seen {} {} yet", (Object)internalClassName, (Object)fieldName);
            FieldRegistry.populateFieldMap(internalClassName, fieldName);
        }
        try {
            Object currentValue;
            Map<String, Field> fields = classFieldsMapping.get(internalClassName);
            if (fields == null) {
                logger.error("Fields map for class {} should not be null", (Object)internalClassName);
                throw new IllegalStateException("Fields map for class " + internalClassName + " should not be null");
            }
            if (fields.isEmpty()) {
                logger.debug("Done read - no fields");
                return;
            }
            Field targetField = fields.get(fieldName);
            if (targetField == null) {
                logger.debug("Could not find field {} for class {}", (Object)fieldName, (Object)internalClassName);
                return;
            }
            if (Modifier.isStatic(targetField.getModifiers())) {
                currentValue = targetField.get(null);
            } else {
                if (receiver instanceof Class) {
                    logger.debug("WTF read");
                    return;
                }
                if (!registeredObjects.contains(System.identityHashCode(receiver))) {
                    return;
                }
                currentValue = targetField.get(receiver);
            }
            logger.debug("Notify read access {}, {}, {}", new Object[]{internalClassName, fieldName, receiver == null ? "null" : receiver.getClass()});
            if (receiver instanceof Class) {
                Capturer.capture(captureId, receiver, "GETSTATIC", desc, new Object[]{fieldName});
                Capturer.enable(captureId, receiver, currentValue);
            } else if (receiver == null) {
                Capturer.capture(captureId, targetField.getDeclaringClass(), "GETSTATIC", desc, new Object[]{fieldName});
                Capturer.enable(captureId, targetField.getDeclaringClass(), currentValue);
            } else {
                Capturer.capture(captureId, receiver, "GETFIELD", desc, new Object[]{fieldName});
                Capturer.enable(captureId, receiver, currentValue);
            }
            logger.debug("Done field read");
        }
        catch (Throwable e) {
            logger.error("an error occurred while comparing field values for class {}", (Object)internalClassName, (Object)e);
            throw new RuntimeException(e);
        }
    }

    public static synchronized void clear() {
        classInstanceMapping.clear();
        classFieldsMapping.clear();
        instanceRecentFieldValuesMapping.clear();
        classRefQueueMapping.clear();
        registeredObjects.clear();
        captureId = Integer.MAX_VALUE;
    }

    public static synchronized void restoreForegoingGETSTATIC() {
        for (Class<?> c : CLASSES) {
            FieldRegistry.register(c);
        }
    }

    public static String classFieldsMappinString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, Map<String, Field>> entry : classFieldsMapping.entrySet()) {
            String c = entry.getKey();
            Map<String, Field> fieldMap = entry.getValue();
            for (Map.Entry<String, Field> entry2 : fieldMap.entrySet()) {
                int fieldModifiers = entry2.getValue().getModifiers();
                builder.append(c).append('.').append(entry2.getKey()).append(" public=" + Modifier.isPublic(fieldModifiers)).append(" private=" + Modifier.isPrivate(fieldModifiers)).append(" protected=" + Modifier.isProtected(fieldModifiers)).append('\n');
            }
        }
        return builder.toString();
    }

    public static boolean isKnownObject(Object obj) {
        return registeredObjects.contains(obj);
    }

    public static class MyWeakRef<T>
    extends WeakReference<T> {
        public final int oid;

        public MyWeakRef(T referent, ReferenceQueue<? super T> q) {
            super(referent, q);
            this.oid = System.identityHashCode(referent);
        }
    }
}

