/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcarver.instrument;

import java.io.PrintWriter;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import org.evosuite.Properties;
import org.evosuite.testcarver.instrument.TransformerUtil;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.util.TraceClassVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Instrumenter {
    private int captureId = -2147483644;
    public static final int CAPTURE_ID_JAVA_UTIL_DATE = Integer.MIN_VALUE;
    public static final int CAPTURE_ID_JAVA_UTIL_CALENDAR = -2147483647;
    public static final int CAPTURE_ID_JAVA_TEXT_DATEFORMAT = -2147483646;
    public static final int CAPTURE_ID_JAVA_TEXT_SIMPLEDATEFORMAT = -2147483645;
    public static final String WRAP_NAME_PREFIX = "_sw_prototype_original_";
    private static final Logger logger = LoggerFactory.getLogger(Instrumenter.class);

    public void instrument(String className, ClassNode cn) {
        if (!TransformerUtil.isClassConsideredForInstrumentation(className)) {
            logger.debug("class {} has not been instrumented because its name is on the blacklist", (Object)className);
            return;
        }
        try {
            this.transformClassNode(cn, className);
        }
        catch (Throwable t) {
            logger.error("An errorn occurred while instrumenting class {} -> returning unmodified version", (Object)className, (Object)t);
        }
    }

    public byte[] instrument(String className, byte[] classfileBuffer) throws IllegalClassFormatException {
        logger.debug("start instrumenting class {}", (Object)className);
        ClassReader cr = new ClassReader(classfileBuffer);
        ClassWriter cw = new ClassWriter(1);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 2);
        if (!TransformerUtil.isClassConsideredForInstrumentation(className)) {
            logger.debug("class {} has not been instrumented because its name is on the blacklist", (Object)className);
            return classfileBuffer;
        }
        try {
            this.transformClassNode(cn, className);
            cn.accept((ClassVisitor)cw);
            return cw.toByteArray();
        }
        catch (Throwable t) {
            logger.error("An errorn occurred while instrumenting class {} -> returning unmodified version", (Object)className, (Object)t);
            return classfileBuffer;
        }
    }

    private void addFieldRegistryRegisterCall(MethodNode methodNode) {
        AbstractInsnNode ins = null;
        ListIterator iter = methodNode.instructions.iterator();
        int numInvokeSpecials = 0;
        while (iter.hasNext()) {
            TypeInsnNode typeIns;
            ins = (AbstractInsnNode)iter.next();
            if (ins instanceof MethodInsnNode) {
                MethodInsnNode mins = (MethodInsnNode)ins;
                if (ins.getOpcode() != 183 || !mins.name.startsWith("<init>")) continue;
                if (numInvokeSpecials == 0) break;
                --numInvokeSpecials;
                continue;
            }
            if (!(ins instanceof TypeInsnNode) || (typeIns = (TypeInsnNode)ins).getOpcode() != 187 && typeIns.getOpcode() != 188) continue;
            ++numInvokeSpecials;
        }
        InsnList instructions = new InsnList();
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        instructions.add((AbstractInsnNode)new MethodInsnNode(184, "org/evosuite/testcarver/capture/FieldRegistry", "register", "(Ljava/lang/Object;)V"));
        methodNode.instructions.insert(ins, instructions);
    }

    public void transformClassNode(ClassNode cn, String internalClassName) {
        if (!TransformerUtil.isClassConsideredForInstrumentation(internalClassName)) {
            logger.debug("class {} has not been instrumented because its name is on the blacklist", (Object)internalClassName);
            return;
        }
        if ((cn.access & 0x200) != 0) {
            return;
        }
        if ((cn.access & 2) != 0) {
            logger.debug("Ignoring private class: " + cn.name);
            return;
        }
        String packageName = internalClassName.replace('/', '.');
        if (packageName.contains(".")) {
            packageName = packageName.substring(0, packageName.lastIndexOf(46));
        }
        List in = cn.innerClasses;
        for (InnerClassNode inc : in) {
            if (!cn.name.equals(inc.name)) continue;
            logger.info("ASM Bug: Inner class equals class.");
            if ((inc.access & 4) == 4 && !Properties.CLASS_PREFIX.equals(packageName)) {
                return;
            }
            if ((inc.access & 2) == 2) {
                return;
            }
            logger.debug("Can use inner class: " + inc.name);
        }
        logger.info("Checking package: " + packageName + " for class " + cn.name);
        if ((cn.access & 1) == 0) {
            if (!Properties.CLASS_PREFIX.equals(packageName)) {
                logger.info("Not using protected/default class because package name does not match");
                return;
            }
            logger.info("Using protected/default class because package name matches");
        }
        ArrayList<MethodNode> wrappedMethods = new ArrayList<MethodNode>();
        for (MethodNode methodNode : cn.methods) {
            if (!(TransformerUtil.isPrivate(methodNode.access) || TransformerUtil.isAbstract(methodNode.access) || TransformerUtil.isNative(methodNode.access) || methodNode.name.equals("<clinit>"))) {
                if (!TransformerUtil.isPublic(methodNode.access)) {
                    this.transformWrapperCalls(methodNode);
                    continue;
                }
                if (methodNode.name.equals("<init>")) {
                    if (TransformerUtil.isAbstract(cn.access)) continue;
                    this.addFieldRegistryRegisterCall(methodNode);
                }
                this.instrumentPUTXXXFieldAccesses(cn, internalClassName, methodNode);
                this.instrumentGETXXXFieldAccesses(cn, internalClassName, methodNode);
                this.instrumentMethod(cn, internalClassName, methodNode, wrappedMethods);
                continue;
            }
            this.transformWrapperCalls(methodNode);
        }
        int numWM = wrappedMethods.size();
        for (int i = 0; i < numWM; ++i) {
            cn.methods.add(wrappedMethods.get(i));
        }
        TraceClassVisitor tcv = new TraceClassVisitor(new PrintWriter(System.err));
        cn.accept((ClassVisitor)tcv);
    }

    private void instrumentGETXXXFieldAccesses(ClassNode cn, String internalClassName, MethodNode methodNode) {
        InsnList instructions = methodNode.instructions;
        AbstractInsnNode ins = null;
        FieldInsnNode fieldIns = null;
        for (int i = 0; i < instructions.size(); ++i) {
            int opcode;
            ins = instructions.get(i);
            if (!(ins instanceof FieldInsnNode)) continue;
            fieldIns = (FieldInsnNode)ins;
            if (fieldIns.name.endsWith("$0") || (opcode = ins.getOpcode()) != 180 && opcode != 178) continue;
            InsnList il = new InsnList();
            if (opcode == 180) {
                Type fieldType = Type.getType((String)fieldIns.desc);
                if (fieldType.getSize() == 1) {
                    instructions.insertBefore((AbstractInsnNode)fieldIns, (AbstractInsnNode)new InsnNode(89));
                    il.add((AbstractInsnNode)new InsnNode(95));
                } else if (fieldType.getSize() == 2) {
                    instructions.insertBefore((AbstractInsnNode)fieldIns, (AbstractInsnNode)new InsnNode(89));
                    il.add((AbstractInsnNode)new InsnNode(93));
                    il.add((AbstractInsnNode)new InsnNode(88));
                }
            } else {
                il.add((AbstractInsnNode)new InsnNode(1));
            }
            il.add((AbstractInsnNode)new LdcInsnNode((Object)this.captureId));
            il.add((AbstractInsnNode)new LdcInsnNode((Object)fieldIns.owner));
            il.add((AbstractInsnNode)new LdcInsnNode((Object)fieldIns.name));
            il.add((AbstractInsnNode)new LdcInsnNode((Object)fieldIns.desc));
            il.add((AbstractInsnNode)new MethodInsnNode(184, "org/evosuite/testcarver/capture/FieldRegistry", "notifyReadAccess", "(Ljava/lang/Object;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V"));
            i += il.size();
            instructions.insert((AbstractInsnNode)fieldIns, il);
            ++this.captureId;
        }
    }

    private void instrumentPUTXXXFieldAccesses(ClassNode cn, String internalClassName, MethodNode methodNode) {
        InsnList instructions = methodNode.instructions;
        AbstractInsnNode ins = null;
        FieldInsnNode fieldIns = null;
        for (int i = 0; i < instructions.size(); ++i) {
            int opcode;
            ins = instructions.get(i);
            if (!(ins instanceof FieldInsnNode)) continue;
            fieldIns = (FieldInsnNode)ins;
            if (fieldIns.name.endsWith("$0") || (opcode = ins.getOpcode()) != 181 && opcode != 179) continue;
            InsnList il = new InsnList();
            if (opcode == 181) {
                Type fieldType = Type.getType((String)fieldIns.desc);
                if (fieldType.getSize() == 1) {
                    instructions.insertBefore((AbstractInsnNode)fieldIns, (AbstractInsnNode)new InsnNode(92));
                    il.add((AbstractInsnNode)new InsnNode(87));
                } else if (fieldType.getSize() == 2) {
                    InsnList uglyList = new InsnList();
                    uglyList.add((AbstractInsnNode)new InsnNode(93));
                    uglyList.add((AbstractInsnNode)new InsnNode(88));
                    uglyList.add((AbstractInsnNode)new InsnNode(89));
                    uglyList.add((AbstractInsnNode)new InsnNode(94));
                    uglyList.add((AbstractInsnNode)new InsnNode(88));
                    instructions.insertBefore((AbstractInsnNode)fieldIns, uglyList);
                }
            } else {
                il.add((AbstractInsnNode)new InsnNode(1));
            }
            il.add((AbstractInsnNode)new LdcInsnNode((Object)this.captureId));
            il.add((AbstractInsnNode)new LdcInsnNode((Object)fieldIns.owner));
            il.add((AbstractInsnNode)new LdcInsnNode((Object)fieldIns.name));
            il.add((AbstractInsnNode)new LdcInsnNode((Object)fieldIns.desc));
            il.add((AbstractInsnNode)new MethodInsnNode(184, "org/evosuite/testcarver/capture/FieldRegistry", "notifyModification", "(Ljava/lang/Object;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V"));
            ++this.captureId;
            i += il.size();
            instructions.insert((AbstractInsnNode)fieldIns, il);
            ++this.captureId;
        }
    }

    private void instrumentMethod(ClassNode cn, String internalClassName, MethodNode methodNode, List<MethodNode> wrappedMethods) {
        wrappedMethods.add(this.wrapMethod(cn, internalClassName, methodNode));
        ++this.captureId;
    }

    private InsnList addCaptureCall(boolean isStatic, String internalClassName, String methodName, String methodDesc, Type[] argTypes) {
        int varIndex;
        InsnList il = new InsnList();
        il.add((AbstractInsnNode)new LdcInsnNode((Object)this.captureId));
        if (isStatic) {
            il.add((AbstractInsnNode)new LdcInsnNode((Object)internalClassName));
            il.add((AbstractInsnNode)new MethodInsnNode(184, "org/evosuite/testcarver/capture/CaptureUtil", "loadClass", "(Ljava/lang/String;)Ljava/lang/Class;"));
            varIndex = 0;
        } else {
            il.add((AbstractInsnNode)new VarInsnNode(25, 0));
            varIndex = 1;
        }
        il.add((AbstractInsnNode)new LdcInsnNode((Object)methodName));
        il.add((AbstractInsnNode)new LdcInsnNode((Object)methodDesc));
        il.add((AbstractInsnNode)new IntInsnNode(16, argTypes.length));
        il.add((AbstractInsnNode)new TypeInsnNode(189, "java/lang/Object"));
        for (int i = 0; i < argTypes.length; ++i) {
            il.add((AbstractInsnNode)new InsnNode(89));
            il.add((AbstractInsnNode)new IntInsnNode(16, i));
            this.loadAndConvertToObject(il, argTypes[i], varIndex++);
            il.add((AbstractInsnNode)new InsnNode(83));
            if (!argTypes[i].equals((Object)Type.LONG_TYPE) && !argTypes[i].equals((Object)Type.DOUBLE_TYPE)) continue;
            ++varIndex;
        }
        il.add((AbstractInsnNode)new MethodInsnNode(184, "org/evosuite/testcarver/capture/Capturer", "capture", "(ILjava/lang/Object;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)V"));
        return il;
    }

    private void addCaptureEnableStatement(String className, MethodNode mn, InsnList il, int returnValueVar) {
        il.add((AbstractInsnNode)new LdcInsnNode((Object)this.captureId));
        if (TransformerUtil.isStatic(mn.access)) {
            il.add((AbstractInsnNode)new LdcInsnNode((Object)className));
            il.add((AbstractInsnNode)new MethodInsnNode(184, "org/evosuite/testcarver/capture/CaptureUtil", "loadClass", "(Ljava/lang/String;)Ljava/lang/Class;"));
        } else {
            il.add((AbstractInsnNode)new VarInsnNode(25, 0));
        }
        Type returnType = Type.getReturnType((String)mn.desc);
        if (returnType.equals((Object)Type.VOID_TYPE)) {
            il.add((AbstractInsnNode)new FieldInsnNode(178, "org/evosuite/testcarver/capture/CaptureLog", "RETURN_TYPE_VOID", Type.getDescriptor(Object.class)));
        } else {
            il.add((AbstractInsnNode)new VarInsnNode(25, returnValueVar));
        }
        il.add((AbstractInsnNode)new MethodInsnNode(184, "org/evosuite/testcarver/capture/Capturer", "enable", "(ILjava/lang/Object;Ljava/lang/Object;)V"));
    }

    private MethodNode wrapMethod(ClassNode classNode, String className, MethodNode methodNode) {
        methodNode.maxStack += 4;
        MethodNode wrappingMethodNode = new MethodNode(methodNode.access, methodNode.name, methodNode.desc, methodNode.signature, methodNode.exceptions.toArray(new String[methodNode.exceptions.size()]));
        wrappingMethodNode.maxStack = methodNode.maxStack;
        wrappingMethodNode.visibleAnnotations = methodNode.visibleAnnotations;
        wrappingMethodNode.visibleParameterAnnotations = methodNode.visibleParameterAnnotations;
        methodNode.visibleAnnotations = null;
        methodNode.visibleParameterAnnotations = null;
        methodNode.access = TransformerUtil.modifyVisibility(methodNode.access, 2);
        LabelNode l0 = new LabelNode();
        LabelNode l1 = new LabelNode();
        LabelNode l2 = new LabelNode();
        InsnList wInstructions = wrappingMethodNode.instructions;
        if ("<init>".equals(methodNode.name)) {
            methodNode.name = "_sw_prototype_original_init_sw_prototype_original_";
            AbstractInsnNode ins = null;
            ListIterator iter = methodNode.instructions.iterator();
            int numInvokeSpecials = 0;
            while (iter.hasNext()) {
                TypeInsnNode typeIns;
                ins = (AbstractInsnNode)iter.next();
                iter.remove();
                wInstructions.add(ins);
                if (ins instanceof MethodInsnNode) {
                    MethodInsnNode mins = (MethodInsnNode)ins;
                    if (ins.getOpcode() != 183 || !mins.name.startsWith("<init>")) continue;
                    if (numInvokeSpecials != 0) {
                        --numInvokeSpecials;
                        continue;
                    }
                    break;
                }
                if (!(ins instanceof TypeInsnNode) || (typeIns = (TypeInsnNode)ins).getOpcode() != 187 && typeIns.getOpcode() != 188) continue;
                ++numInvokeSpecials;
            }
        } else {
            methodNode.name = WRAP_NAME_PREFIX + methodNode.name;
        }
        int varReturnValue = 0;
        Type returnType = Type.getReturnType((String)methodNode.desc);
        if (returnType.equals((Object)Type.VOID_TYPE)) {
            wrappingMethodNode.tryCatchBlocks.add(new TryCatchBlockNode(l0, l1, l1, "java/lang/Throwable"));
        } else {
            wrappingMethodNode.tryCatchBlocks.add(new TryCatchBlockNode(l0, l1, l2, "java/lang/Throwable"));
            if (!TransformerUtil.isStatic(methodNode.access)) {
                ++varReturnValue;
            }
            Type[] argTypes = Type.getArgumentTypes((String)methodNode.desc);
            for (int i = 0; i < argTypes.length; ++i) {
                ++varReturnValue;
                if (!argTypes[i].equals((Object)Type.LONG_TYPE) && !argTypes[i].equals((Object)Type.DOUBLE_TYPE)) continue;
                ++varReturnValue;
            }
            wInstructions.add((AbstractInsnNode)new InsnNode(1));
            wInstructions.add((AbstractInsnNode)new VarInsnNode(58, varReturnValue));
        }
        int var = 0;
        wInstructions.add((AbstractInsnNode)l0);
        wInstructions.add(this.addCaptureCall(TransformerUtil.isStatic(methodNode.access), className, wrappingMethodNode.name, wrappingMethodNode.desc, Type.getArgumentTypes((String)methodNode.desc)));
        if (!TransformerUtil.isStatic(methodNode.access)) {
            wInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            ++var;
        }
        Type[] argTypes = Type.getArgumentTypes((String)methodNode.desc);
        for (int i = 0; i < argTypes.length; ++i) {
            this.addLoadInsn(wInstructions, argTypes[i], var++);
            if (!argTypes[i].equals((Object)Type.LONG_TYPE) && !argTypes[i].equals((Object)Type.DOUBLE_TYPE)) continue;
            ++var;
        }
        if (TransformerUtil.isStatic(methodNode.access)) {
            wInstructions.add((AbstractInsnNode)new MethodInsnNode(184, classNode.name, methodNode.name, methodNode.desc));
        } else {
            wInstructions.add((AbstractInsnNode)new MethodInsnNode(182, classNode.name, methodNode.name, methodNode.desc));
        }
        ++var;
        if (returnType.equals((Object)Type.VOID_TYPE)) {
            wInstructions.add((AbstractInsnNode)new JumpInsnNode(167, l2));
            wInstructions.add((AbstractInsnNode)l1);
            wInstructions.add((AbstractInsnNode)new FrameNode(4, 0, null, 1, new Object[]{"java/lang/Throwable"}));
            wInstructions.add((AbstractInsnNode)new VarInsnNode(58, --var));
            this.addCaptureEnableStatement(className, methodNode, wInstructions, -1);
            wInstructions.add((AbstractInsnNode)new VarInsnNode(25, var));
            wInstructions.add((AbstractInsnNode)new InsnNode(191));
            wInstructions.add((AbstractInsnNode)l2);
            wInstructions.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
            this.addCaptureEnableStatement(className, methodNode, wInstructions, -1);
            wInstructions.add((AbstractInsnNode)new InsnNode(177));
        } else {
            this.addBoxingStmt(wInstructions, returnType);
            wInstructions.add((AbstractInsnNode)new VarInsnNode(58, varReturnValue));
            wInstructions.add((AbstractInsnNode)new VarInsnNode(25, varReturnValue));
            this.addUnBoxingStmt(wInstructions, returnType);
            int storeOpcode = returnType.getOpcode(54);
            wInstructions.add((AbstractInsnNode)new VarInsnNode(storeOpcode, ++var));
            wInstructions.add((AbstractInsnNode)l1);
            this.addCaptureEnableStatement(className, methodNode, wInstructions, varReturnValue);
            int loadOpcode = returnType.getOpcode(21);
            wInstructions.add((AbstractInsnNode)new VarInsnNode(loadOpcode, var));
            this.addReturnInsn(wInstructions, returnType);
            wInstructions.add((AbstractInsnNode)l2);
            wInstructions.add((AbstractInsnNode)new FrameNode(0, 2, new Object[]{className, this.getInternalName(returnType)}, 1, new Object[]{"java/lang/Throwable"}));
            wInstructions.add((AbstractInsnNode)new VarInsnNode(58, --var));
            this.addCaptureEnableStatement(className, methodNode, wInstructions, varReturnValue);
            wInstructions.add((AbstractInsnNode)new VarInsnNode(25, var));
            wInstructions.add((AbstractInsnNode)new InsnNode(191));
        }
        this.transformWrapperCalls(methodNode);
        return wrappingMethodNode;
    }

    private void transformWrapperCalls(MethodNode mn) {
        ListIterator iterator = mn.instructions.iterator();
        List<Class<?>> wrapperClasses = this.getWrapperClasses();
        block13: while (iterator.hasNext()) {
            AbstractInsnNode insn = (AbstractInsnNode)iterator.next();
            if (insn instanceof MethodInsnNode) {
                String ownerName;
                MethodInsnNode methodInsnNode = (MethodInsnNode)insn;
                if (methodInsnNode.name.equals("<init>")) {
                    ownerName = methodInsnNode.owner.replace('/', '.');
                    for (Class<?> wrapperClass : wrapperClasses) {
                        if (!wrapperClass.getName().equals(ownerName)) continue;
                        logger.debug("Replacing call " + methodInsnNode.name);
                        methodInsnNode.owner = "org/evosuite/testcarver/wrapper/" + methodInsnNode.owner;
                        continue block13;
                    }
                    continue;
                }
                ownerName = methodInsnNode.owner.replace('/', '.');
                for (Class<?> wrapperClass : wrapperClasses) {
                    if (!wrapperClass.getName().equals(ownerName)) continue;
                    if (methodInsnNode.getOpcode() == 184) {
                        logger.debug("Replacing call " + methodInsnNode.name);
                        methodInsnNode.owner = "org/evosuite/testcarver/wrapper/" + methodInsnNode.owner;
                    }
                    Type[] parameterTypes = Type.getArgumentTypes((String)methodInsnNode.desc);
                    try {
                        Class[] parameterClasses = new Class[parameterTypes.length];
                        int pos = 0;
                        block16: for (Type parameter : parameterTypes) {
                            switch (parameter.getSort()) {
                                case 10: {
                                    parameterClasses[pos++] = Class.forName(parameter.getClassName());
                                    continue block16;
                                }
                                case 1: {
                                    parameterClasses[pos++] = Boolean.TYPE;
                                    continue block16;
                                }
                                case 3: {
                                    parameterClasses[pos++] = Byte.TYPE;
                                    continue block16;
                                }
                                case 2: {
                                    parameterClasses[pos++] = Character.TYPE;
                                    continue block16;
                                }
                                case 8: {
                                    parameterClasses[pos++] = Double.TYPE;
                                    continue block16;
                                }
                                case 6: {
                                    parameterClasses[pos++] = Float.TYPE;
                                    continue block16;
                                }
                                case 5: {
                                    parameterClasses[pos++] = Integer.TYPE;
                                    continue block16;
                                }
                                case 7: {
                                    parameterClasses[pos++] = Long.TYPE;
                                    continue block16;
                                }
                                case 4: {
                                    parameterClasses[pos++] = Short.TYPE;
                                }
                            }
                        }
                        Method method = wrapperClass.getMethod(methodInsnNode.name, parameterClasses);
                        if (Modifier.isFinal(method.getModifiers())) {
                            if (methodInsnNode.getOpcode() != 184) {
                                methodInsnNode.setOpcode(184);
                                Type[] args = Type.getArgumentTypes((String)methodInsnNode.desc);
                                Type returnType = Type.getReturnType((String)methodInsnNode.desc);
                                Type[] newargs = new Type[args.length + 1];
                                newargs[0] = Type.getObjectType((String)methodInsnNode.owner);
                                for (int i = 0; i < args.length; ++i) {
                                    newargs[i + 1] = args[i];
                                }
                                methodInsnNode.desc = Type.getMethodDescriptor((Type)returnType, (Type[])newargs);
                                methodInsnNode.owner = "org/evosuite/testcarver/wrapper/" + methodInsnNode.owner;
                            } else {
                                methodInsnNode.name = methodInsnNode.name + "_final";
                            }
                            logger.debug("Method is final: " + methodInsnNode.owner + "." + methodInsnNode.name);
                            continue block13;
                        }
                        logger.debug("Method is not final: " + methodInsnNode.owner + "." + methodInsnNode.name);
                    }
                    catch (Exception e) {
                        logger.warn("Error while instrumenting: " + e);
                    }
                    continue block13;
                }
                continue;
            }
            if (insn.getOpcode() != 187 && insn.getOpcode() != 192) continue;
            TypeInsnNode typeInsnNode = (TypeInsnNode)insn;
            Type generatedType = Type.getType((String)typeInsnNode.desc);
            String name = generatedType.getInternalName().replace('/', '.');
            logger.debug("Checking for replacement of " + name);
            for (Class<?> wrapperClass : wrapperClasses) {
                if (!wrapperClass.getName().equals(name)) continue;
                logger.debug("Replacing new " + name);
                typeInsnNode.desc = "org/evosuite/testcarver/wrapper/" + generatedType.getInternalName();
                continue block13;
            }
        }
    }

    private void addReturnInsn(InsnList il, Type type) {
        if (type.equals((Object)Type.BOOLEAN_TYPE)) {
            il.add((AbstractInsnNode)new InsnNode(172));
        } else if (type.equals((Object)Type.CHAR_TYPE)) {
            il.add((AbstractInsnNode)new InsnNode(172));
        } else if (type.equals((Object)Type.BYTE_TYPE)) {
            il.add((AbstractInsnNode)new InsnNode(172));
        } else if (type.equals((Object)Type.SHORT_TYPE)) {
            il.add((AbstractInsnNode)new InsnNode(172));
        } else if (type.equals((Object)Type.INT_TYPE)) {
            il.add((AbstractInsnNode)new InsnNode(172));
        } else if (type.equals((Object)Type.FLOAT_TYPE)) {
            il.add((AbstractInsnNode)new InsnNode(174));
        } else if (type.equals((Object)Type.LONG_TYPE)) {
            il.add((AbstractInsnNode)new InsnNode(173));
        } else if (type.equals((Object)Type.DOUBLE_TYPE)) {
            il.add((AbstractInsnNode)new InsnNode(175));
        } else {
            il.add((AbstractInsnNode)new InsnNode(176));
        }
    }

    private void addLoadInsn(InsnList il, Type type, int argLocation) {
        if (type.equals((Object)Type.BOOLEAN_TYPE)) {
            il.add((AbstractInsnNode)new VarInsnNode(21, argLocation));
        } else if (type.equals((Object)Type.CHAR_TYPE)) {
            il.add((AbstractInsnNode)new VarInsnNode(21, argLocation));
        } else if (type.equals((Object)Type.BYTE_TYPE)) {
            il.add((AbstractInsnNode)new VarInsnNode(21, argLocation));
        } else if (type.equals((Object)Type.SHORT_TYPE)) {
            il.add((AbstractInsnNode)new VarInsnNode(21, argLocation));
        } else if (type.equals((Object)Type.INT_TYPE)) {
            il.add((AbstractInsnNode)new VarInsnNode(21, argLocation));
        } else if (type.equals((Object)Type.FLOAT_TYPE)) {
            il.add((AbstractInsnNode)new VarInsnNode(23, argLocation));
        } else if (type.equals((Object)Type.LONG_TYPE)) {
            il.add((AbstractInsnNode)new VarInsnNode(22, argLocation));
        } else if (type.equals((Object)Type.DOUBLE_TYPE)) {
            il.add((AbstractInsnNode)new VarInsnNode(24, argLocation));
        } else {
            il.add((AbstractInsnNode)new VarInsnNode(25, argLocation));
        }
    }

    private String getInternalName(Type type) {
        if (type.equals((Object)Type.BOOLEAN_TYPE)) {
            return "java/lang/Boolean";
        }
        if (type.equals((Object)Type.CHAR_TYPE)) {
            return "java/lang/Character";
        }
        if (type.equals((Object)Type.BYTE_TYPE)) {
            return "java/lang/Byte";
        }
        if (type.equals((Object)Type.SHORT_TYPE)) {
            return "java/lang/Short";
        }
        if (type.equals((Object)Type.INT_TYPE)) {
            return "java/lang/Integer";
        }
        if (type.equals((Object)Type.FLOAT_TYPE)) {
            return "java/lang/Float";
        }
        if (type.equals((Object)Type.LONG_TYPE)) {
            return "java/lang/Long";
        }
        if (type.equals((Object)Type.DOUBLE_TYPE)) {
            return "java/lang/Double";
        }
        return type.getInternalName();
    }

    private void loadAndConvertToObject(InsnList il, Type type, int argLocation) {
        if (type.equals((Object)Type.BOOLEAN_TYPE)) {
            il.add((AbstractInsnNode)new VarInsnNode(21, argLocation));
            il.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;"));
        } else if (type.equals((Object)Type.CHAR_TYPE)) {
            il.add((AbstractInsnNode)new VarInsnNode(21, argLocation));
            il.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;"));
        } else if (type.equals((Object)Type.BYTE_TYPE)) {
            il.add((AbstractInsnNode)new VarInsnNode(21, argLocation));
            il.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;"));
        } else if (type.equals((Object)Type.SHORT_TYPE)) {
            il.add((AbstractInsnNode)new VarInsnNode(21, argLocation));
            il.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;"));
        } else if (type.equals((Object)Type.INT_TYPE)) {
            il.add((AbstractInsnNode)new VarInsnNode(21, argLocation));
            il.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;"));
        } else if (type.equals((Object)Type.FLOAT_TYPE)) {
            il.add((AbstractInsnNode)new VarInsnNode(23, argLocation));
            il.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;"));
        } else if (type.equals((Object)Type.LONG_TYPE)) {
            il.add((AbstractInsnNode)new VarInsnNode(22, argLocation));
            il.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;"));
        } else if (type.equals((Object)Type.DOUBLE_TYPE)) {
            il.add((AbstractInsnNode)new VarInsnNode(24, argLocation));
            il.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;"));
        } else {
            il.add((AbstractInsnNode)new VarInsnNode(25, argLocation));
        }
    }

    private void addBoxingStmt(InsnList il, Type type) {
        if (type.equals((Object)Type.BOOLEAN_TYPE)) {
            il.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;"));
        } else if (type.equals((Object)Type.CHAR_TYPE)) {
            il.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;"));
        } else if (type.equals((Object)Type.BYTE_TYPE)) {
            il.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;"));
        } else if (type.equals((Object)Type.SHORT_TYPE)) {
            il.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;"));
        } else if (type.equals((Object)Type.INT_TYPE)) {
            il.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;"));
        } else if (type.equals((Object)Type.FLOAT_TYPE)) {
            il.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;"));
        } else if (type.equals((Object)Type.LONG_TYPE)) {
            il.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;"));
        } else if (type.equals((Object)Type.DOUBLE_TYPE)) {
            il.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;"));
        }
    }

    private void addUnBoxingStmt(InsnList il, Type type) {
        if (type.equals((Object)Type.BOOLEAN_TYPE)) {
            il.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Boolean", "booleanValue", "()Z"));
        } else if (type.equals((Object)Type.CHAR_TYPE)) {
            il.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Character", "charValue", "()C"));
        } else if (type.equals((Object)Type.BYTE_TYPE)) {
            il.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Byte", "byteValue", "()B"));
        } else if (type.equals((Object)Type.SHORT_TYPE)) {
            il.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Short", "shortValue", "()S"));
        } else if (type.equals((Object)Type.INT_TYPE)) {
            il.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Integer", "intValue", "()I"));
        } else if (type.equals((Object)Type.FLOAT_TYPE)) {
            il.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Float", "floatValue", "()F"));
        } else if (type.equals((Object)Type.LONG_TYPE)) {
            il.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Long", "longValue", "()J"));
        } else if (type.equals((Object)Type.DOUBLE_TYPE)) {
            il.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Double", "doubleValue", "()D"));
        }
    }

    private List<Class<?>> getWrapperClasses() {
        return Arrays.asList(Date.class, Calendar.class, DateFormat.class, SimpleDateFormat.class);
    }
}

