/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcarver.testcase;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.classpath.ResourceList;
import org.evosuite.testcarver.capture.CaptureLog;
import org.evosuite.testcarver.capture.CaptureUtil;
import org.evosuite.testcarver.codegen.ICodeGenerator;
import org.evosuite.testcarver.testcase.CodeGeneratorException;
import org.evosuite.testcarver.testcase.EvoSuiteXStream;
import org.evosuite.testcase.DefaultTestCase;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.statements.ArrayStatement;
import org.evosuite.testcase.statements.AssignmentStatement;
import org.evosuite.testcase.statements.ClassPrimitiveStatement;
import org.evosuite.testcase.statements.ConstructorStatement;
import org.evosuite.testcase.statements.FieldStatement;
import org.evosuite.testcase.statements.ImmutableStringPrimitiveStatement;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.NullStatement;
import org.evosuite.testcase.statements.PrimitiveStatement;
import org.evosuite.testcase.variable.ArrayIndex;
import org.evosuite.testcase.variable.ArrayReference;
import org.evosuite.testcase.variable.FieldReference;
import org.evosuite.testcase.variable.NullReference;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.utils.GenericConstructor;
import org.evosuite.utils.GenericField;
import org.evosuite.utils.GenericMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EvoTestCaseCodeGenerator
implements ICodeGenerator<TestCase> {
    private static final Logger logger = LoggerFactory.getLogger(EvoTestCaseCodeGenerator.class);
    private TestCase testCase;
    private final Map<Integer, VariableReference> oidToVarRefMap = new HashMap<Integer, VariableReference>();

    @Override
    public boolean isMaximumLengthReached() {
        return this.testCase.size() > Properties.CHROMOSOME_LENGTH;
    }

    @Override
    public void createMethodCallStmt(CaptureLog log, int logRecNo) {
        if (log == null) {
            throw new IllegalArgumentException("captured log must not be null");
        }
        if (logRecNo <= -1) {
            throw new IllegalArgumentException("log record number is invalid: " + logRecNo);
        }
        if (this.isMaximumLengthReached()) {
            return;
        }
        int oid = log.objectIds.get(logRecNo);
        Object[] methodArgs = log.params.get(logRecNo);
        String methodName = log.methodNames.get(logRecNo);
        try {
            Class<?>[] methodParamTypeClasses = this.getMethodParamTypeClasses(log, logRecNo);
            ArrayList<VariableReference> args = this.getArguments(methodArgs, methodParamTypeClasses);
            String typeName = log.getTypeName(oid);
            Class<?> type = this.getClassForName(typeName);
            if ("<init>".equals(methodName)) {
                ConstructorStatement constStmt = new ConstructorStatement(this.testCase, new GenericConstructor(type.getDeclaredConstructor(methodParamTypeClasses), type), args);
                this.oidToVarRefMap.put(oid, this.testCase.addStatement(constStmt));
            } else {
                Object returnValue = log.returnValues.get(logRecNo);
                if (CaptureLog.RETURN_TYPE_VOID.equals(returnValue)) {
                    GenericMethod genericMethod = new GenericMethod(this.getDeclaredMethod(type, methodName, methodParamTypeClasses), type);
                    MethodStatement m = new MethodStatement(this.testCase, genericMethod, this.oidToVarRefMap.get(oid), args);
                    this.testCase.addStatement(m);
                } else {
                    logger.debug("Callee: {} ({})", (Object)this.oidToVarRefMap.get(oid), this.oidToVarRefMap.keySet());
                    MethodStatement m = new MethodStatement(this.testCase, new GenericMethod(this.getDeclaredMethod(type, methodName, methodParamTypeClasses), type), this.oidToVarRefMap.get(oid), args);
                    Integer returnValueOID = (Integer)returnValue;
                    this.oidToVarRefMap.put(returnValueOID, this.testCase.addStatement(m));
                }
            }
        }
        catch (Exception e) {
            logger.info("Error at log record number {}: {}", (Object)logRecNo, (Object)e.toString());
            logger.info("Test case so far: " + this.testCase.toCode());
            logger.info(log.toString());
            CodeGeneratorException.propagateError(e, "[logRecNo = %s] - an unexpected error occurred while creating method call stmt.", logRecNo);
        }
    }

    private Class<?>[] getMethodParamTypeClasses(CaptureLog log, int logRecNo) {
        String methodDesc = log.descList.get(logRecNo);
        org.objectweb.asm.Type[] methodParamTypes = org.objectweb.asm.Type.getArgumentTypes((String)methodDesc);
        Class[] methodParamTypeClasses = new Class[methodParamTypes.length];
        for (int i = 0; i < methodParamTypes.length; ++i) {
            methodParamTypeClasses[i] = this.getClassFromType(methodParamTypes[i]);
        }
        return methodParamTypeClasses;
    }

    private ArrayList<VariableReference> getArguments(Object[] methodArgs, Class<?>[] methodParamTypeClasses) throws IllegalArgumentException {
        ArrayList<VariableReference> args = new ArrayList<VariableReference>();
        for (int i = 0; i < methodArgs.length; ++i) {
            Integer argOID = (Integer)methodArgs[i];
            if (argOID == null) {
                args.add(this.testCase.addStatement(new NullStatement(this.testCase, methodParamTypeClasses[i])));
                continue;
            }
            VariableReference ref = this.oidToVarRefMap.get(argOID);
            if (ref == null) {
                throw new RuntimeException("VariableReference is null for argOID " + argOID + "; have oids: " + this.oidToVarRefMap.keySet());
            }
            args.add(ref);
        }
        return args;
    }

    @Override
    public void createPlainInitStmt(CaptureLog log, int logRecNo) {
        VariableReference varRef;
        int oid = log.objectIds.get(logRecNo);
        if (this.oidToVarRefMap.containsKey(oid)) {
            return;
        }
        String type = log.getTypeName(oid);
        Object value = log.params.get(logRecNo)[0];
        if (value instanceof Class) {
            ClassPrimitiveStatement cps = new ClassPrimitiveStatement(this.testCase, this.getClassForName(type));
            cps.setValue(value);
            varRef = this.testCase.addStatement(cps);
        } else {
            PrimitiveStatement<?> primitiveValue = PrimitiveStatement.getPrimitiveStatement(this.testCase, this.getClassForName(type));
            primitiveValue.setValue(value);
            varRef = this.testCase.addStatement(primitiveValue);
        }
        this.oidToVarRefMap.put(oid, varRef);
    }

    @Override
    public void createUnobservedInitStmt(CaptureLog log, int logRecNo) {
        int oid = log.objectIds.get(logRecNo);
        try {
            Object value = log.params.get(logRecNo)[0];
            ImmutableStringPrimitiveStatement stringRep = new ImmutableStringPrimitiveStatement(this.testCase, (String)value);
            VariableReference stringRepRef = this.testCase.addStatement(stringRep);
            MethodStatement m = new MethodStatement(this.testCase, new GenericMethod(EvoSuiteXStream.class.getMethod("fromString", String.class), EvoSuiteXStream.class), null, Arrays.asList(stringRepRef));
            this.oidToVarRefMap.put(oid, this.testCase.addStatement(m));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void createFieldWriteAccessStmt(CaptureLog log, int logRecNo) {
        Object[] methodArgs = log.params.get(logRecNo);
        int oid = log.objectIds.get(logRecNo);
        int captureId = log.captureIds.get(logRecNo);
        String fieldName = log.getNameOfAccessedFields(captureId);
        String typeName = log.getTypeName(oid);
        try {
            AssignmentStatement assignment;
            Class<?> type = this.getClassForName(typeName);
            String fieldDesc = log.descList.get(logRecNo);
            Class<?> fieldType = CaptureUtil.getClassFromDesc(fieldDesc);
            FieldReference targetFieldRef = new FieldReference(this.testCase, new GenericField(this.getDeclaredField(type, fieldName), type), this.oidToVarRefMap.get(oid));
            Integer arg = (Integer)methodArgs[0];
            if (arg == null) {
                NullStatement nullStmt = new NullStatement(this.testCase, fieldType);
                VariableReference nullReference = this.testCase.addStatement(nullStmt);
                assignment = new AssignmentStatement(this.testCase, targetFieldRef, nullReference);
            } else {
                assignment = new AssignmentStatement(this.testCase, targetFieldRef, this.oidToVarRefMap.get(arg));
            }
            logger.debug("Adding assignment statement: " + assignment.getCode());
            VariableReference varRef = this.testCase.addStatement(assignment);
            if (arg != null) {
                this.oidToVarRefMap.put(arg, varRef);
            }
        }
        catch (Exception e) {
            CodeGeneratorException.propagateError(e, "[logRecNo = %s] - an unexpected error occurred while creating field write access stmt. Log: %s", logRecNo, log);
        }
    }

    @Override
    public void createFieldReadAccessStmt(CaptureLog log, int logRecNo) {
        int oid = log.objectIds.get(logRecNo);
        int captureId = log.captureIds.get(logRecNo);
        Object returnValue = log.returnValues.get(logRecNo);
        if (!CaptureLog.RETURN_TYPE_VOID.equals(returnValue)) {
            Integer returnValueOID = (Integer)returnValue;
            String typeName = log.getTypeName(oid);
            String fieldName = log.getNameOfAccessedFields(captureId);
            try {
                Class<?> type = this.getClassForName(typeName);
                FieldStatement fieldStatement = new FieldStatement(this.testCase, new GenericField(FieldUtils.getField(type, (String)fieldName, (boolean)true), type), this.oidToVarRefMap.get(oid));
                VariableReference varRef = this.testCase.addStatement(fieldStatement);
                this.oidToVarRefMap.put(returnValueOID, varRef);
            }
            catch (Exception e) {
                logger.debug("Error while trying to get field " + fieldName + " of class " + this.getClassForName(typeName) + ": " + e);
                CodeGeneratorException.propagateError(e, "[logRecNo = %s] - an unexpected error occurred while creating field read access stmt. Log: %s", logRecNo, log);
            }
        }
    }

    private final Class<?> getClassFromType(org.objectweb.asm.Type type) {
        if (type.equals((Object)org.objectweb.asm.Type.BOOLEAN_TYPE)) {
            return Boolean.TYPE;
        }
        if (type.equals((Object)org.objectweb.asm.Type.BYTE_TYPE)) {
            return Byte.TYPE;
        }
        if (type.equals((Object)org.objectweb.asm.Type.CHAR_TYPE)) {
            return Character.TYPE;
        }
        if (type.equals((Object)org.objectweb.asm.Type.DOUBLE_TYPE)) {
            return Double.TYPE;
        }
        if (type.equals((Object)org.objectweb.asm.Type.FLOAT_TYPE)) {
            return Float.TYPE;
        }
        if (type.equals((Object)org.objectweb.asm.Type.INT_TYPE)) {
            return Integer.TYPE;
        }
        if (type.equals((Object)org.objectweb.asm.Type.LONG_TYPE)) {
            return Long.TYPE;
        }
        if (type.equals((Object)org.objectweb.asm.Type.SHORT_TYPE)) {
            return Short.TYPE;
        }
        if (type.getSort() == 9) {
            org.objectweb.asm.Type elementType = type.getElementType();
            int[] dimensions = new int[type.getDimensions()];
            if (elementType.equals((Object)org.objectweb.asm.Type.BOOLEAN_TYPE)) {
                return Array.newInstance(Boolean.TYPE, dimensions).getClass();
            }
            if (elementType.equals((Object)org.objectweb.asm.Type.BYTE_TYPE)) {
                return Array.newInstance(Byte.TYPE, dimensions).getClass();
            }
            if (elementType.equals((Object)org.objectweb.asm.Type.CHAR_TYPE)) {
                return Array.newInstance(Character.TYPE, dimensions).getClass();
            }
            if (elementType.equals((Object)org.objectweb.asm.Type.DOUBLE_TYPE)) {
                return Array.newInstance(Double.TYPE, dimensions).getClass();
            }
            if (elementType.equals((Object)org.objectweb.asm.Type.FLOAT_TYPE)) {
                return Array.newInstance(Float.TYPE, dimensions).getClass();
            }
            if (elementType.equals((Object)org.objectweb.asm.Type.INT_TYPE)) {
                return Array.newInstance(Integer.TYPE, dimensions).getClass();
            }
            if (elementType.equals((Object)org.objectweb.asm.Type.LONG_TYPE)) {
                return Array.newInstance(Long.TYPE, dimensions).getClass();
            }
            if (elementType.equals((Object)org.objectweb.asm.Type.SHORT_TYPE)) {
                return Array.newInstance(Short.TYPE, dimensions).getClass();
            }
        }
        return this.getClassForName(type.getClassName());
    }

    private final Class<?> getClassForName(String type) {
        try {
            if (type.equals("boolean") || type.equals("java.lang.Boolean")) {
                return Boolean.TYPE;
            }
            if (type.equals("byte") || type.equals("java.lang.Byte")) {
                return Byte.TYPE;
            }
            if (type.equals("char") || type.equals("java.lang.Character")) {
                return Character.TYPE;
            }
            if (type.equals("double") || type.equals("java.lang.Double")) {
                return Double.TYPE;
            }
            if (type.equals("float") || type.equals("java.lang.Float")) {
                return Float.TYPE;
            }
            if (type.equals("int") || type.equals("java.lang.Integer")) {
                return Integer.TYPE;
            }
            if (type.equals("long") || type.equals("java.lang.Long")) {
                return Long.TYPE;
            }
            if (type.equals("short") || type.equals("java.lang.Short")) {
                return Short.TYPE;
            }
            if (type.equals("String")) {
                return Class.forName("java.lang." + type, true, TestGenerationContext.getInstance().getClassLoaderForSUT());
            }
            if (type.endsWith("[]")) {
                StringBuilder arrayTypeNameBuilder = new StringBuilder(30);
                int index = 0;
                while ((index = type.indexOf(91, index)) != -1) {
                    arrayTypeNameBuilder.append('[');
                    ++index;
                }
                arrayTypeNameBuilder.append('L');
                type = type.replace("[]", "");
                arrayTypeNameBuilder.append(type);
                arrayTypeNameBuilder.append(';');
                return Class.forName(arrayTypeNameBuilder.toString(), true, TestGenerationContext.getInstance().getClassLoaderForSUT());
            }
            return Class.forName(ResourceList.getClassNameFromResourcePath(type), true, TestGenerationContext.getInstance().getClassLoaderForSUT());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private Field getDeclaredField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        if (clazz == null || Object.class.equals(clazz)) {
            throw new NoSuchFieldException(fieldName);
        }
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            return this.getDeclaredField(clazz.getSuperclass(), fieldName);
        }
    }

    private Method getDeclaredMethod(Class<?> clazz, String methodName, Class<?>[] paramTypes) throws NoSuchMethodException {
        if (clazz == null || Object.class.equals(clazz)) {
            throw new NoSuchMethodException(methodName + "(" + Arrays.toString(paramTypes) + ")");
        }
        try {
            Method m = clazz.getDeclaredMethod(methodName, paramTypes);
            m.setAccessible(true);
            return m;
        }
        catch (NoSuchMethodException e) {
            return this.getDeclaredMethod(clazz.getSuperclass(), methodName, paramTypes);
        }
    }

    @Override
    public void createArrayInitStmt(CaptureLog log, int logRecNo) {
        ArrayReference arrRef;
        int oid = log.objectIds.get(logRecNo);
        Object[] params = log.params.get(logRecNo);
        String arrTypeName = log.getTypeName(oid);
        Class<?> arrType = this.getClassForName(arrTypeName);
        if (this.oidToVarRefMap.containsKey(oid)) {
            arrRef = (ArrayReference)this.oidToVarRefMap.get(oid);
        } else {
            arrRef = new ArrayReference(this.testCase, arrType);
            ArrayStatement arrStmt = new ArrayStatement(this.testCase, arrRef);
            arrStmt.setSize(params.length);
            this.testCase.addStatement(arrStmt);
            this.oidToVarRefMap.put(oid, arrRef);
        }
        Class<?> arrCompClass = arrType.getComponentType();
        for (int i = 0; i < params.length; ++i) {
            VariableReference valueRef;
            Integer argOID = (Integer)params[i];
            if (argOID == null) {
                valueRef = this.testCase.addStatement(new NullStatement(this.testCase, arrCompClass));
            } else {
                valueRef = this.oidToVarRefMap.get(argOID);
                if (valueRef == null) {
                    logger.info("ValueREF is NULL for " + argOID);
                    continue;
                }
            }
            ArrayIndex arrIndex = new ArrayIndex(this.testCase, arrRef, i);
            AssignmentStatement assignStmt = new AssignmentStatement(this.testCase, arrIndex, valueRef);
            this.testCase.addStatement(assignStmt);
            logger.debug("Adding assignment (array): " + assignStmt.getCode());
        }
    }

    private boolean hasDefaultConstructor(Class<?> clazz) {
        for (Constructor<?> c : clazz.getConstructors()) {
            if (c.getParameterTypes().length != 0 || !Modifier.isPublic(c.getModifiers())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void createCollectionInitStmt(CaptureLog log, int logRecNo) {
        try {
            int oid = log.objectIds.get(logRecNo);
            Object[] params = log.params.get(logRecNo);
            String collTypeName = log.getTypeName(oid);
            Class<Object> collType = this.getClassForName(collTypeName);
            boolean isPublic = Modifier.isPublic(collType.getModifiers());
            if (!isPublic || !this.hasDefaultConstructor(collType)) {
                if (Set.class.isAssignableFrom(collType)) {
                    collTypeName = HashSet.class.getName();
                    collType = HashSet.class;
                } else if (List.class.isAssignableFrom(collType)) {
                    collTypeName = ArrayList.class.getName();
                    collType = ArrayList.class;
                } else if (Queue.class.isAssignableFrom(collType)) {
                    collTypeName = ArrayDeque.class.getName();
                    collType = ArrayDeque.class;
                } else {
                    CodeGeneratorException.propagateError("[logRecNo = %s] - collection %s is not supported", logRecNo, collType);
                }
            }
            List<VariableReference> noParams = Collections.emptyList();
            ConstructorStatement constrStmt = new ConstructorStatement(this.testCase, new GenericConstructor(collType.getConstructor(new Class[0]), collType), noParams);
            VariableReference collRef = this.testCase.addStatement(constrStmt);
            this.oidToVarRefMap.put(oid, collRef);
            for (int i = 0; i < params.length; ++i) {
                VariableReference var;
                ArrayList<VariableReference> paramList = new ArrayList<VariableReference>(1);
                Integer argOID = (Integer)params[i];
                if (argOID == null || !this.oidToVarRefMap.containsKey(argOID)) {
                    var = this.testCase.addStatement(new NullStatement(this.testCase, (Type)((Object)Object.class)));
                    paramList.add(var);
                } else {
                    var = this.oidToVarRefMap.get(argOID);
                    paramList.add(var);
                }
                Method method = collType.getMethod("add", Object.class);
                MethodStatement methodStmt = new MethodStatement(this.testCase, new GenericMethod(method, collType), collRef, paramList);
                this.testCase.addStatement(methodStmt);
            }
        }
        catch (Exception e) {
            CodeGeneratorException.propagateError("[logRecNo = %s] - an unexpected error occurred while creating collection init stmt", logRecNo, e);
        }
    }

    private void replaceNullWithNullReferences(List<VariableReference> paramList, Class<?> ... paramTypes) {
        CodeGeneratorException.check(paramList.size() == paramTypes.length, "[paramList = %s, paramTypes] - number of params does not correspond number of paramTypes", paramList, Arrays.toString(paramTypes));
        for (int j = 0; j < paramList.size(); ++j) {
            VariableReference v = paramList.get(j);
            if (v != null) continue;
            paramList.set(j, new NullReference(this.testCase, paramTypes[j]));
        }
    }

    @Override
    public void createMapInitStmt(CaptureLog log, int logRecNo) {
        try {
            int oid = log.objectIds.get(logRecNo);
            Object[] params = log.params.get(logRecNo);
            String collTypeName = log.getTypeName(oid);
            Class<Object> collType = this.getClassForName(collTypeName);
            boolean isPublic = Modifier.isPublic(collType.getModifiers());
            if (!isPublic || !this.hasDefaultConstructor(collType)) {
                collType = HashMap.class;
            }
            List<VariableReference> noParams = Collections.emptyList();
            ConstructorStatement constrStmt = new ConstructorStatement(this.testCase, new GenericConstructor(collType.getConstructor(new Class[0]), collType), noParams);
            VariableReference collRef = this.testCase.addStatement(constrStmt);
            this.oidToVarRefMap.put(oid, collRef);
            ArrayList<VariableReference> paramList = new ArrayList<VariableReference>();
            for (int i = 0; i < params.length; ++i) {
                Integer argOID = (Integer)params[i];
                if (argOID == null) {
                    paramList.add(this.testCase.addStatement(new NullStatement(this.testCase, (Type)((Object)Object.class))));
                } else {
                    paramList.add(this.oidToVarRefMap.get(argOID));
                }
                if (i % 2 != 1) continue;
                Method method = collType.getMethod("put", Object.class, Object.class);
                this.replaceNullWithNullReferences(paramList, Object.class, Object.class);
                MethodStatement methodStmt = new MethodStatement(this.testCase, new GenericMethod(method, collType), collRef, paramList);
                this.testCase.addStatement(methodStmt);
                paramList = new ArrayList(2);
            }
        }
        catch (Exception e) {
            CodeGeneratorException.propagateError(e, "[logRecNo = %s] - an unexpected error occurred while creating map init stmt", logRecNo);
        }
    }

    @Override
    public void before(CaptureLog log) {
        this.testCase = new DefaultTestCase();
    }

    @Override
    public void after(CaptureLog log) {
    }

    @Override
    public TestCase getCode() {
        return this.testCase;
    }

    @Override
    public void clear() {
        this.testCase = null;
        this.oidToVarRefMap.clear();
    }
}

