/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang3.StringEscapeUtils;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.ExecutionObserver;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.execution.TestCaseExecutor;
import org.evosuite.testcase.statements.PrimitiveStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.ConstantValue;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstantInliner
extends ExecutionObserver {
    private TestCase test = null;
    private static final Logger logger = LoggerFactory.getLogger(ConstantInliner.class);

    public void inline(TestCase test) {
        this.test = test;
        TestCaseExecutor executor = TestCaseExecutor.getInstance();
        executor.addObserver(this);
        executor.execute(test);
        executor.removeObserver(this);
        this.removeUnusedVariables(test);
        assert (test.isValid());
    }

    public void inline(TestChromosome test) {
        this.inline(test.test);
    }

    public void inline(TestSuiteChromosome suite) {
        for (TestCase test : suite.getTests()) {
            this.inline(test);
        }
    }

    public boolean removeUnusedVariables(TestCase t) {
        ArrayList<Integer> to_delete = new ArrayList<Integer>();
        boolean has_deleted = false;
        int num = 0;
        for (Statement s : t) {
            VariableReference var;
            if (s instanceof PrimitiveStatement && !t.hasReferences(var = s.getReturnValue())) {
                to_delete.add(num);
                has_deleted = true;
            }
            ++num;
        }
        Collections.sort(to_delete, Collections.reverseOrder());
        for (Integer position : to_delete) {
            t.remove(position);
        }
        return has_deleted;
    }

    @Override
    public void output(int position, String output) {
    }

    @Override
    public void afterStatement(Statement statement, Scope scope, Throwable exception) {
        try {
            block6: for (VariableReference var : statement.getVariableReferences()) {
                ConstantValue value;
                if (var.equals(statement.getReturnValue()) || var.equals(statement.getReturnValue().getAdditionalVariableReference())) continue;
                Object object = var.getObject(scope);
                if (var.isPrimitive()) {
                    value = new ConstantValue(this.test, var.getGenericClass());
                    value.setValue(object);
                    statement.replace(var, value);
                    continue;
                }
                if (var.isString() && object != null) {
                    value = new ConstantValue(this.test, var.getGenericClass());
                    try {
                        String val = StringEscapeUtils.unescapeJava((String)object.toString());
                        value.setValue(val);
                        statement.replace(var, value);
                    }
                    catch (IllegalArgumentException e) {
                        logger.info("Cannot escape invalid string: " + object);
                    }
                    continue;
                }
                if (var.isArrayIndex()) {
                    for (VariableReference otherVar : scope.getElements(var.getType())) {
                        Object otherObject = scope.getObject(otherVar);
                        if (otherObject != object || otherVar.isArrayIndex()) continue;
                        statement.replace(var, otherVar);
                        continue block6;
                    }
                    continue;
                }
                try {
                    if (object != null) continue;
                    value = new ConstantValue(this.test, var.getGenericClass());
                    value.setValue(var.getObject(scope));
                    statement.replace(var, value);
                }
                catch (CodeUnderTestException e) {
                }
            }
        }
        catch (CodeUnderTestException e) {
            logger.warn("Not inlining test: " + e.getCause());
        }
    }

    @Override
    public void beforeStatement(Statement statement, Scope scope) {
    }

    @Override
    public void clear() {
    }

    @Override
    public void testExecutionFinished(ExecutionResult r) {
    }
}

