/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import org.evosuite.ga.SecondaryObjective;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.execution.ExecutionResult;

public class MinimizeExceptionsSecondaryObjective
extends SecondaryObjective<TestChromosome> {
    private static final long serialVersionUID = -4405276303273532040L;

    private int getNumExceptions(TestChromosome chromosome) {
        ExecutionResult result = chromosome.getLastExecutionResult();
        if (result != null) {
            return result.getNumberOfThrownExceptions();
        }
        return 0;
    }

    @Override
    public int compareChromosomes(TestChromosome chromosome1, TestChromosome chromosome2) {
        return this.getNumExceptions(chromosome1) - this.getNumExceptions(chromosome2);
    }

    @Override
    public int compareGenerations(TestChromosome parent1, TestChromosome parent2, TestChromosome child1, TestChromosome child2) {
        return Math.min(this.getNumExceptions(parent1), this.getNumExceptions(parent2)) - Math.min(this.getNumExceptions(child1), this.getNumExceptions(child2));
    }
}

