/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import com.googlecode.gentyref.CaptureType;
import com.googlecode.gentyref.GenericTypeReflector;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.evosuite.Properties;
import org.evosuite.assertion.ArrayEqualsAssertion;
import org.evosuite.assertion.Assertion;
import org.evosuite.assertion.CompareAssertion;
import org.evosuite.assertion.EqualsAssertion;
import org.evosuite.assertion.Inspector;
import org.evosuite.assertion.InspectorAssertion;
import org.evosuite.assertion.NullAssertion;
import org.evosuite.assertion.PrimitiveAssertion;
import org.evosuite.assertion.PrimitiveFieldAssertion;
import org.evosuite.assertion.SameAssertion;
import org.evosuite.classpath.ResourceList;
import org.evosuite.parameterize.InputVariable;
import org.evosuite.runtime.mock.EvoSuiteMock;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestVisitor;
import org.evosuite.testcase.statements.AbstractStatement;
import org.evosuite.testcase.statements.ArrayStatement;
import org.evosuite.testcase.statements.AssignmentStatement;
import org.evosuite.testcase.statements.ClassPrimitiveStatement;
import org.evosuite.testcase.statements.ConstructorStatement;
import org.evosuite.testcase.statements.EnumPrimitiveStatement;
import org.evosuite.testcase.statements.FieldStatement;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.NullStatement;
import org.evosuite.testcase.statements.PrimitiveExpression;
import org.evosuite.testcase.statements.PrimitiveStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.statements.StringPrimitiveStatement;
import org.evosuite.testcase.statements.environment.EnvironmentDataStatement;
import org.evosuite.testcase.variable.ArrayIndex;
import org.evosuite.testcase.variable.ArrayReference;
import org.evosuite.testcase.variable.ConstantValue;
import org.evosuite.testcase.variable.FieldReference;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.utils.GenericClass;
import org.evosuite.utils.GenericConstructor;
import org.evosuite.utils.GenericField;
import org.evosuite.utils.GenericMethod;
import org.evosuite.utils.NumberFormatter;
import org.evosuite.utils.StringUtil;

public class TestCodeVisitor
extends TestVisitor {
    protected String testCode = "";
    protected final Map<Integer, Throwable> exceptions = new HashMap<Integer, Throwable>();
    protected TestCase test = null;
    protected final Map<VariableReference, String> variableNames = new HashMap<VariableReference, String>();
    protected final Map<Class<?>, String> classNames = new HashMap();
    protected final Map<String, Integer> nextIndices = new HashMap<String, Integer>();

    public String getCode() {
        return this.testCode;
    }

    public Set<Class<?>> getImports() {
        HashSet imports = new HashSet();
        for (Class<?> clazz : this.classNames.keySet()) {
            String name = this.classNames.get(clazz);
            if (name.contains(".")) continue;
            imports.add(clazz);
        }
        return imports;
    }

    public void clearExceptions() {
        this.exceptions.clear();
    }

    public void setExceptions(Map<Integer, Throwable> exceptions) {
        this.exceptions.putAll(exceptions);
    }

    public void setException(Statement statement, Throwable exception) {
        this.exceptions.put(statement.getPosition(), exception);
    }

    protected Throwable getException(Statement statement) {
        if (this.exceptions != null && this.exceptions.containsKey(statement.getPosition())) {
            return this.exceptions.get(statement.getPosition());
        }
        return null;
    }

    public String getClassName(VariableReference var) {
        return this.getTypeName(var.getType());
    }

    private String getTypeName(ParameterizedType type) {
        String name = this.getClassName((Class)type.getRawType());
        Type[] types = type.getActualTypeArguments();
        boolean isDefined = false;
        for (Type parameterType : types) {
            if (!(parameterType instanceof Class) && !(parameterType instanceof ParameterizedType) && !(parameterType instanceof WildcardType) && !(parameterType instanceof GenericArrayType)) continue;
            isDefined = true;
            break;
        }
        if (isDefined && types.length > 0) {
            name = name + "<";
            for (int i = 0; i < types.length; ++i) {
                if (i != 0) {
                    name = name + ", ";
                }
                name = name + this.getTypeName(types[i]);
            }
            name = name + ">";
        }
        return name;
    }

    public String getTypeName(Type type) {
        if (type instanceof Class) {
            return this.getClassName((Class)type);
        }
        if (type instanceof ParameterizedType) {
            return this.getTypeName((ParameterizedType)type);
        }
        if (type instanceof WildcardType) {
            String ret = "?";
            boolean first = true;
            for (Type bound : ((WildcardType)type).getLowerBounds()) {
                if (bound == null) continue;
                if (!first) {
                    ret = ret + ", ";
                }
                ret = ret + " super " + this.getTypeName(bound);
                first = false;
            }
            for (Type bound : ((WildcardType)type).getUpperBounds()) {
                if (bound == null || !(bound instanceof CaptureType) && GenericTypeReflector.erase((Type)bound).equals(Object.class)) continue;
                if (!first) {
                    ret = ret + ", ";
                }
                ret = ret + " extends " + this.getTypeName(bound);
                first = false;
            }
            return ret;
        }
        if (type instanceof TypeVariable) {
            return "?";
        }
        if (type instanceof CaptureType) {
            CaptureType captureType = (CaptureType)type;
            if (captureType.getLowerBounds().length == 0) {
                return "?";
            }
            return this.getTypeName(captureType.getLowerBounds()[0]);
        }
        if (type instanceof GenericArrayType) {
            return this.getTypeName(((GenericArrayType)type).getGenericComponentType()) + "[]";
        }
        throw new RuntimeException("Unsupported type:" + type + ", class" + type.getClass());
    }

    public String getTypeName(VariableReference var) {
        GenericClass clazz = var.getGenericClass();
        return this.getTypeName(clazz.getType());
    }

    public String getClassName(Class<?> clazz) {
        Class<?> declaringClass;
        if (this.classNames.containsKey(clazz)) {
            return this.classNames.get(clazz);
        }
        if (clazz.isArray()) {
            return this.getClassName(clazz.getComponentType()) + "[]";
        }
        GenericClass c = new GenericClass(clazz);
        String name = c.getSimpleName();
        if (this.classNames.values().contains(name)) {
            name = clazz.getCanonicalName();
        } else {
            String fullName = Properties.CLASS_PREFIX + "." + name;
            if (!fullName.equals(clazz.getCanonicalName())) {
                try {
                    if (ResourceList.hasClass(fullName)) {
                        name = clazz.getCanonicalName();
                    }
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
        }
        Class<?> outerClass = clazz.getEnclosingClass();
        if (outerClass != null) {
            String enclosingName = this.getClassName(outerClass);
            String simpleOuterName = outerClass.getSimpleName();
            if (simpleOuterName.equals(enclosingName)) {
                name = enclosingName + name.substring(simpleOuterName.length());
            }
        }
        if ((declaringClass = clazz.getDeclaringClass()) != null) {
            this.getClassName(declaringClass);
        }
        if (name.equals("Test")) {
            name = clazz.getCanonicalName();
        }
        this.classNames.put(clazz, name);
        return name;
    }

    public String getVariableName(VariableReference var) {
        if (var instanceof ConstantValue) {
            return var.getName();
        }
        if (var instanceof InputVariable) {
            return var.getName();
        }
        if (var instanceof FieldReference) {
            VariableReference source = ((FieldReference)var).getSource();
            GenericField field = ((FieldReference)var).getField();
            if (source != null) {
                return this.getVariableName(source) + "." + field.getName();
            }
            return this.getClassName(field.getField().getDeclaringClass()) + "." + field.getName();
        }
        if (var instanceof ArrayIndex) {
            ArrayReference array = ((ArrayIndex)var).getArray();
            List<Integer> indices = ((ArrayIndex)var).getArrayIndices();
            String result = this.getVariableName(array);
            for (Integer index : indices) {
                result = result + "[" + index + "]";
            }
            return result;
        }
        if (var instanceof ArrayReference) {
            String className = var.getSimpleClassName();
            String variableName = className.substring(0, 1).toLowerCase() + className.substring(1) + "Array";
            variableName = variableName.replace(".", "_").replace("[]", "");
            if (!this.variableNames.containsKey(var)) {
                if (!this.nextIndices.containsKey(variableName)) {
                    this.nextIndices.put(variableName, 0);
                }
                int index = this.nextIndices.get(variableName);
                this.nextIndices.put(variableName, index + 1);
                variableName = variableName + index;
                this.variableNames.put(var, variableName);
            }
        } else if (!this.variableNames.containsKey(var)) {
            String className = var.getSimpleClassName();
            String variableName = className.substring(0, 1).toLowerCase() + className.substring(1);
            if (variableName.contains("[]")) {
                variableName = variableName.replace("[]", "Array");
            }
            if (CharUtils.isAsciiNumeric((char)(variableName = variableName.replace(".", "_")).charAt(variableName.length() - 1))) {
                variableName = variableName + "_";
            }
            if (!this.nextIndices.containsKey(variableName)) {
                this.nextIndices.put(variableName, 0);
            }
            int index = this.nextIndices.get(variableName);
            this.nextIndices.put(variableName, index + 1);
            variableName = variableName + index;
            this.variableNames.put(var, variableName);
        }
        return this.variableNames.get(var);
    }

    public Collection<String> getVariableNames() {
        return this.variableNames.values();
    }

    public Collection<String> getClassNames() {
        return this.classNames.values();
    }

    @Override
    public void visitTestCase(TestCase test) {
        this.test = test;
        this.testCode = "";
        this.variableNames.clear();
        this.nextIndices.clear();
    }

    protected void visitPrimitiveAssertion(PrimitiveAssertion assertion) {
        VariableReference source = assertion.getSource();
        Object value = assertion.getValue();
        String stmt = "";
        if (value == null) {
            stmt = stmt + "assertNull(" + this.getVariableName(source) + ");";
        } else if (source.getVariableClass().equals(Float.TYPE)) {
            stmt = stmt + "assertEquals(" + NumberFormatter.getNumberString(value) + ", " + this.getVariableName(source) + ", 0.01F);";
        } else if (source.getVariableClass().equals(Double.TYPE)) {
            stmt = stmt + "assertEquals(" + NumberFormatter.getNumberString(value) + ", " + this.getVariableName(source) + ", 0.01D);";
        } else if (value.getClass().isEnum()) {
            stmt = stmt + "assertEquals(" + NumberFormatter.getNumberString(value) + ", " + this.getVariableName(source) + ");";
            this.getClassName(value.getClass());
        } else if (source.getVariableClass().equals(Boolean.TYPE) || source.getVariableClass().equals(Boolean.class)) {
            Boolean flag = (Boolean)value;
            stmt = flag != false ? stmt + "assertTrue(" : stmt + "assertFalse(";
            stmt = stmt + "" + this.getVariableName(source) + ");";
        } else {
            stmt = source.isWrapperType() ? (source.getVariableClass().equals(Float.class) ? stmt + "assertEquals(" + NumberFormatter.getNumberString(value) + ", (float)" + this.getVariableName(source) + ", 0.01F);" : (source.getVariableClass().equals(Double.class) ? stmt + "assertEquals(" + NumberFormatter.getNumberString(value) + ", (double)" + this.getVariableName(source) + ", 0.01D);" : (value.getClass().isEnum() ? stmt + "assertEquals(" + NumberFormatter.getNumberString(value) + ", " + this.getVariableName(source) + ");" : stmt + "assertEquals(" + NumberFormatter.getNumberString(value) + ", (" + NumberFormatter.getBoxedClassName(value) + ")" + this.getVariableName(source) + ");"))) : stmt + "assertEquals(" + NumberFormatter.getNumberString(value) + ", " + this.getVariableName(source) + ");";
        }
        this.testCode = this.testCode + stmt;
    }

    protected void visitArrayEqualsAssertion(ArrayEqualsAssertion assertion) {
        VariableReference source = assertion.getSource();
        Object[] value = (Object[])assertion.getValue();
        String stmt = "";
        if (source.getComponentClass().equals(Boolean.class) || source.getComponentClass().equals(Boolean.TYPE)) {
            stmt = stmt + "assertTrue(Arrays.equals(";
            this.getClassName(Arrays.class);
        } else {
            stmt = stmt + "assertArrayEquals(";
        }
        stmt = stmt + "new " + this.getTypeName(source.getComponentType()) + "[] {";
        boolean first = true;
        for (Object o : value) {
            if (!first) {
                stmt = stmt + ", ";
            } else {
                first = false;
            }
            stmt = stmt + NumberFormatter.getNumberString(o);
        }
        stmt = stmt + "}, " + this.getVariableName(source);
        stmt = source.getComponentClass().equals(Float.class) || source.getComponentClass().equals(Float.TYPE) ? stmt + ", 0.01F);" : (source.getComponentClass().equals(Double.class) || source.getComponentClass().equals(Double.TYPE) ? stmt + ", 0.01);" : (source.getComponentClass().equals(Boolean.class) || source.getComponentClass().equals(Boolean.TYPE) ? stmt + "));" : stmt + ");"));
        this.testCode = this.testCode + stmt;
    }

    protected void visitPrimitiveFieldAssertion(PrimitiveFieldAssertion assertion) {
        VariableReference source = assertion.getSource();
        Object value = assertion.getValue();
        Field field = assertion.getField();
        if (value == null) {
            this.testCode = this.testCode + "assertNull(" + this.getVariableName(source) + "." + field.getName() + ");";
        } else if (value.getClass().equals(Long.class)) {
            this.testCode = this.testCode + "assertEquals(" + NumberFormatter.getNumberString(value) + ", " + this.getVariableName(source) + "." + field.getName() + ");";
        } else if (value.getClass().equals(Float.class)) {
            this.testCode = this.testCode + "assertEquals(" + NumberFormatter.getNumberString(value) + ", " + this.getVariableName(source) + "." + field.getName() + ", 0.01F);";
        } else if (value.getClass().equals(Double.class)) {
            this.testCode = this.testCode + "assertEquals(" + NumberFormatter.getNumberString(value) + ", " + this.getVariableName(source) + "." + field.getName() + ", 0.01D);";
        } else if (value.getClass().equals(Character.class)) {
            this.testCode = this.testCode + "assertEquals(" + NumberFormatter.getNumberString(value) + ", " + this.getVariableName(source) + "." + field.getName() + ");";
        } else if (value.getClass().equals(String.class)) {
            this.testCode = this.testCode + "assertEquals(" + NumberFormatter.getNumberString(value) + ", " + this.getVariableName(source) + "." + field.getName() + ");";
        } else if (value.getClass().equals(Boolean.class)) {
            Boolean flag = (Boolean)value;
            this.testCode = flag != false ? this.testCode + "assertTrue(" : this.testCode + "assertFalse(";
            this.testCode = this.testCode + "" + this.getVariableName(source) + "." + field.getName() + ");";
        } else if (value.getClass().isEnum()) {
            this.testCode = this.testCode + "assertEquals(" + NumberFormatter.getNumberString(value) + ", " + this.getVariableName(source) + "." + field.getName() + ");";
            this.getClassName(value.getClass());
        } else {
            this.testCode = this.testCode + "assertEquals(" + NumberFormatter.getNumberString(value) + ", " + this.getVariableName(source) + "." + field.getName() + ");";
        }
    }

    protected void visitInspectorAssertion(InspectorAssertion assertion) {
        VariableReference source = assertion.getSource();
        Object value = assertion.getValue();
        Inspector inspector = assertion.getInspector();
        if (value == null) {
            this.testCode = this.testCode + "assertNull(" + this.getVariableName(source) + "." + inspector.getMethodCall() + "());";
        } else if (value.getClass().equals(Long.class)) {
            this.testCode = this.testCode + "assertEquals(" + NumberFormatter.getNumberString(value) + ", " + this.getVariableName(source) + "." + inspector.getMethodCall() + "());";
        } else if (value.getClass().equals(Float.class)) {
            this.testCode = this.testCode + "assertEquals(" + NumberFormatter.getNumberString(value) + ", " + this.getVariableName(source) + "." + inspector.getMethodCall() + "(), 0.01F);";
        } else if (value.getClass().equals(Double.class)) {
            this.testCode = this.testCode + "assertEquals(" + NumberFormatter.getNumberString(value) + ", " + this.getVariableName(source) + "." + inspector.getMethodCall() + "(), 0.01D);";
        } else if (value.getClass().equals(Character.class)) {
            this.testCode = this.testCode + "assertEquals(" + NumberFormatter.getNumberString(value) + ", " + this.getVariableName(source) + "." + inspector.getMethodCall() + "());";
        } else if (value.getClass().equals(String.class)) {
            this.testCode = this.testCode + "assertEquals(" + NumberFormatter.getNumberString(value) + ", " + this.getVariableName(source) + "." + inspector.getMethodCall() + "());";
        } else if (value.getClass().isEnum() || value instanceof Enum) {
            this.testCode = this.testCode + "assertEquals(" + NumberFormatter.getNumberString(value) + ", " + this.getVariableName(source) + "." + inspector.getMethodCall() + "());";
            this.getClassName(value.getClass());
        } else {
            this.testCode = value.getClass().equals(Boolean.TYPE) || value.getClass().equals(Boolean.class) ? (((Boolean)value).booleanValue() ? this.testCode + "assertTrue(" + this.getVariableName(source) + "." + inspector.getMethodCall() + "());" : this.testCode + "assertFalse(" + this.getVariableName(source) + "." + inspector.getMethodCall() + "());") : this.testCode + "assertEquals(" + value + ", " + this.getVariableName(source) + "." + inspector.getMethodCall() + "());";
        }
    }

    protected void visitNullAssertion(NullAssertion assertion) {
        VariableReference source = assertion.getSource();
        Boolean value = (Boolean)assertion.getValue();
        this.testCode = value != false ? this.testCode + "assertNull(" + this.getVariableName(source) + ");" : this.testCode + "assertNotNull(" + this.getVariableName(source) + ");";
    }

    protected void visitCompareAssertion(CompareAssertion assertion) {
        VariableReference source = assertion.getSource();
        VariableReference dest = assertion.getDest();
        Object value = assertion.getValue();
        this.testCode = source.getType().equals(Integer.class) ? ((Integer)value == 0 ? this.testCode + "assertTrue(" + this.getVariableName(source) + " == " + this.getVariableName(dest) + ");" : ((Integer)value < 0 ? this.testCode + "assertTrue(" + this.getVariableName(source) + " < " + this.getVariableName(dest) + ");" : this.testCode + "assertTrue(" + this.getVariableName(source) + " > " + this.getVariableName(dest) + ");")) : this.testCode + "assertEquals(" + this.getVariableName(source) + ".compareTo(" + this.getVariableName(dest) + "), " + value + ");";
    }

    protected void visitEqualsAssertion(EqualsAssertion assertion) {
        VariableReference source = assertion.getSource();
        VariableReference dest = assertion.getDest();
        Object value = assertion.getValue();
        this.testCode = source.isPrimitive() && dest.isPrimitive() ? (((Boolean)value).booleanValue() ? this.testCode + "assertTrue(" + this.getVariableName(source) + " == " + this.getVariableName(dest) + ");" : this.testCode + "assertFalse(" + this.getVariableName(source) + " == " + this.getVariableName(dest) + ");") : ((Boolean)value != false ? this.testCode + "assertTrue(" + this.getVariableName(source) + ".equals((" + this.getClassName(Object.class) + ")" + this.getVariableName(dest) + "));" : this.testCode + "assertFalse(" + this.getVariableName(source) + ".equals((" + this.getClassName(Object.class) + ")" + this.getVariableName(dest) + "));");
    }

    protected void visitSameAssertion(SameAssertion assertion) {
        VariableReference source = assertion.getSource();
        VariableReference dest = assertion.getDest();
        Object value = assertion.getValue();
        this.testCode = (Boolean)value != false ? this.testCode + "assertSame(" + this.getVariableName(source) + ", " + this.getVariableName(dest) + ");" : this.testCode + "assertNotSame(" + this.getVariableName(source) + ", " + this.getVariableName(dest) + ");";
    }

    private String getUnstableTestComment() {
        return " // Unstable assertion";
    }

    private boolean isTestUnstable() {
        return this.test != null && this.test.isUnstable();
    }

    protected void visitAssertion(Assertion assertion) {
        if (this.isTestUnstable()) {
            this.testCode = this.testCode + "// " + this.getUnstableTestComment() + ": ";
        }
        if (assertion instanceof PrimitiveAssertion) {
            this.visitPrimitiveAssertion((PrimitiveAssertion)assertion);
        } else if (assertion instanceof PrimitiveFieldAssertion) {
            this.visitPrimitiveFieldAssertion((PrimitiveFieldAssertion)assertion);
        } else if (assertion instanceof InspectorAssertion) {
            this.visitInspectorAssertion((InspectorAssertion)assertion);
        } else if (assertion instanceof NullAssertion) {
            this.visitNullAssertion((NullAssertion)assertion);
        } else if (assertion instanceof CompareAssertion) {
            this.visitCompareAssertion((CompareAssertion)assertion);
        } else if (assertion instanceof EqualsAssertion) {
            this.visitEqualsAssertion((EqualsAssertion)assertion);
        } else if (assertion instanceof SameAssertion) {
            this.visitSameAssertion((SameAssertion)assertion);
        } else if (assertion instanceof ArrayEqualsAssertion) {
            this.visitArrayEqualsAssertion((ArrayEqualsAssertion)assertion);
        } else {
            throw new RuntimeException("Unknown assertion type: " + assertion);
        }
    }

    private void addAssertions(Statement statement) {
        boolean assertionAdded = false;
        if (this.getException(statement) != null) {
            VariableReference returnValue = statement.getReturnValue();
            for (Assertion assertion : statement.getAssertions()) {
                if (assertion == null || assertion.getReferencedVariables().contains(returnValue)) continue;
                this.visitAssertion(assertion);
                this.testCode = this.testCode + "\n";
                assertionAdded = true;
            }
        } else {
            for (Assertion assertion : statement.getAssertions()) {
                if (assertion == null) continue;
                this.visitAssertion(assertion);
                this.testCode = this.testCode + "\n";
                assertionAdded = true;
            }
        }
        if (assertionAdded) {
            this.testCode = this.testCode + "\n";
        }
    }

    protected String getEnumValue(EnumPrimitiveStatement<?> statement) {
        Object value = statement.getValue();
        Class<?> clazz = statement.getEnumClass();
        String className = this.getClassName(clazz);
        try {
            if (value.getClass().getField(value.toString()) != null) {
                return className + "." + value;
            }
        }
        catch (NoSuchFieldException e) {
            // empty catch block
        }
        for (Field field : value.getClass().getDeclaredFields()) {
            if (!field.isEnumConstant()) continue;
            try {
                if (!field.get(value).equals(value)) continue;
                return className + "." + field.getName();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return className + ".valueOf(\"" + value + "\")";
    }

    @Override
    public void visitPrimitiveStatement(PrimitiveStatement<?> statement) {
        VariableReference retval = statement.getReturnValue();
        Object value = statement.getValue();
        if (statement instanceof StringPrimitiveStatement) {
            if (value == null) {
                this.testCode = this.testCode + ((Class)retval.getType()).getSimpleName() + " " + this.getVariableName(retval) + " = null;\n";
            } else {
                String escapedString = StringUtil.getEscapedString((String)value);
                this.testCode = this.testCode + ((Class)retval.getType()).getSimpleName() + " " + this.getVariableName(retval) + " = \"" + escapedString + "\";\n";
            }
        } else if (statement instanceof EnvironmentDataStatement) {
            this.testCode = this.testCode + ((EnvironmentDataStatement)statement).getTestCode(this.getVariableName(retval));
        } else if (statement instanceof ClassPrimitiveStatement) {
            StringBuilder builder = new StringBuilder();
            String className = this.getClassName(retval);
            className = className.replaceAll("Class<(.*)(<.*>)>", "Class<$1>");
            builder.append(className);
            builder.append(" ");
            builder.append(this.getVariableName(retval));
            builder.append(" = ");
            builder.append(this.getClassName((Class)value));
            builder.append(".class;\n");
            this.testCode = this.testCode + builder.toString();
        } else {
            this.testCode = this.testCode + this.getClassName(retval) + " " + this.getVariableName(retval) + " = " + NumberFormatter.getNumberString(value) + ";\n";
        }
        this.addAssertions(statement);
    }

    @Override
    public void visitPrimitiveExpression(PrimitiveExpression statement) {
        VariableReference retval = statement.getReturnValue();
        String expression = ((Class)retval.getType()).getSimpleName() + " " + this.getVariableName(retval) + " = ";
        expression = expression + this.getVariableName(statement.getLeftOperand()) + " " + statement.getOperator().toCode() + " " + this.getVariableName(statement.getRightOperand());
        this.testCode = this.testCode + expression + ";\n";
        this.addAssertions(statement);
    }

    @Override
    public void visitFieldStatement(FieldStatement statement) {
        GenericField field;
        Throwable exception = this.getException(statement);
        String cast_str = "";
        StringBuilder builder = new StringBuilder();
        VariableReference retval = statement.getReturnValue();
        if (!retval.isAssignableFrom((field = statement.getField()).getFieldType())) {
            cast_str = cast_str + "(" + this.getClassName(retval) + ")";
        }
        if (exception != null) {
            builder.append(this.getClassName(retval));
            builder.append(" ");
            builder.append(this.getVariableName(retval));
            builder.append(" = null;\n");
            builder.append("try {\n  ");
        } else {
            builder.append(this.getClassName(retval));
            builder.append(" ");
        }
        if (!field.isStatic()) {
            VariableReference source = statement.getSource();
            builder.append(this.getVariableName(retval));
            builder.append(" = ");
            builder.append(cast_str);
            builder.append(this.getVariableName(source));
            builder.append(".");
            builder.append(field.getName());
            builder.append(";");
        } else {
            builder.append(this.getVariableName(retval));
            builder.append(" = ");
            builder.append(cast_str);
            builder.append(this.getClassName(field.getField().getDeclaringClass()));
            builder.append(".");
            builder.append(field.getName());
            builder.append(";");
        }
        if (exception != null) {
            Class<?> ex = exception.getClass();
            while (!Modifier.isPublic(ex.getModifiers())) {
                ex = ex.getSuperclass();
            }
            builder.append("\n} catch(");
            builder.append(this.getClassName(ex));
            builder.append(" e) {}");
        }
        builder.append("\n");
        this.testCode = this.testCode + builder.toString();
        this.addAssertions(statement);
    }

    private String getPrimitiveNullCast(Class<?> declaredParamType) {
        String castString = "";
        castString = castString + "(" + this.getTypeName(declaredParamType) + ") ";
        castString = castString + "(" + this.getTypeName(ClassUtils.primitiveToWrapper(declaredParamType)) + ") ";
        return castString;
    }

    private String getParameterString(Type[] parameterTypes, List<VariableReference> parameters, boolean isGenericMethod, boolean isOverloaded, int startPos) {
        String parameterString = "";
        for (int i = startPos; i < parameters.size(); ++i) {
            if (i > startPos) {
                parameterString = parameterString + ", ";
            }
            Type declaredParamType = parameterTypes[i];
            Type actualParamType = parameters.get(i).getType();
            String name = this.getVariableName(parameters.get(i));
            Class rawParamClass = GenericTypeReflector.erase((Type)declaredParamType);
            if (rawParamClass.isPrimitive() && name.equals("null")) {
                parameterString = parameterString + this.getPrimitiveNullCast(rawParamClass);
            } else if (isGenericMethod) {
                if (!declaredParamType.equals(actualParamType) || name.equals("null")) {
                    parameterString = parameterString + "(" + this.getTypeName(declaredParamType) + ") ";
                    if (name.contains("(short")) {
                        name = name.replace("(short)", "");
                    }
                    if (name.contains("(byte")) {
                        name = name.replace("(byte)", "");
                    }
                }
            } else if (name.equals("null")) {
                parameterString = parameterString + "(" + this.getTypeName(declaredParamType) + ") ";
            } else if (!GenericClass.isAssignable(declaredParamType, actualParamType)) {
                if (TypeUtils.isArrayType((Type)declaredParamType) && TypeUtils.isArrayType((Type)actualParamType)) {
                    Class<?> componentClass = GenericTypeReflector.erase((Type)declaredParamType).getComponentType();
                    if (componentClass.equals(Object.class)) {
                        GenericClass genericComponentClass = new GenericClass(componentClass);
                        if (!genericComponentClass.hasWildcardOrTypeVariables()) {
                            parameterString = parameterString + "(" + this.getTypeName(declaredParamType) + ") ";
                        }
                    } else {
                        parameterString = parameterString + "(" + this.getTypeName(declaredParamType) + ") ";
                    }
                } else if (!(actualParamType instanceof ParameterizedType)) {
                    parameterString = parameterString + "(" + this.getTypeName(declaredParamType) + ") ";
                }
                if (name.contains("(short")) {
                    name = name.replace("(short)", "");
                }
                if (name.contains("(byte")) {
                    name = name.replace("(byte)", "");
                }
            } else {
                GenericClass parameterClass = new GenericClass(declaredParamType);
                if (parameterClass.isWrapperType() && parameters.get(i).isPrimitive()) {
                    parameterString = parameterString + "(" + this.getTypeName(declaredParamType) + ") ";
                } else if (parameterClass.isPrimitive() && parameters.get(i).isWrapperType()) {
                    parameterString = parameterString + "(" + this.getTypeName(declaredParamType) + ") ";
                } else if (isOverloaded && !declaredParamType.equals(actualParamType)) {
                    parameterString = parameterString + "(" + this.getTypeName(declaredParamType) + ") ";
                }
            }
            parameterString = parameterString + name;
        }
        return parameterString;
    }

    @Override
    public void visitMethodStatement(MethodStatement statement) {
        String name;
        boolean unused;
        boolean lastStatement;
        String result = "";
        VariableReference retval = statement.getReturnValue();
        GenericMethod method = statement.getMethod();
        Throwable exception = this.getException(statement);
        List<VariableReference> parameters = statement.getParameterReferences();
        boolean isGenericMethod = method.hasTypeParameters();
        if (exception != null && !statement.isDeclaredException(exception)) {
            result = result + "// Undeclared exception!\n";
        }
        boolean bl = lastStatement = statement.getPosition() == statement.getTestCase().size() - 1;
        boolean bl2 = !Properties.ASSERTIONS ? exception != null : (unused = this.test != null && !this.test.hasReferences(retval));
        if (!retval.isVoid() && retval.getAdditionalVariableReference() == null && !unused) {
            if (exception != null) {
                if (!lastStatement || statement.hasAssertions()) {
                    result = result + this.getClassName(retval) + " " + this.getVariableName(retval) + " = " + retval.getDefaultValueString() + ";\n";
                }
            } else {
                result = result + this.getClassName(retval) + " ";
            }
        }
        if (exception != null && !this.test.isFailing()) {
            result = result + "try {\n  ";
        }
        String parameter_string = this.getParameterString(method.getParameterTypes(), parameters, isGenericMethod, method.isOverloaded(parameters), 0);
        String callee_str = "";
        if (!(retval.isAssignableFrom(method.getReturnType()) || retval.getVariableClass().isAnonymousClass() || isGenericMethod && method.getParameterTypes().length == 0 && method.isStatic() || (name = this.getClassName(retval)).matches(".*\\.\\d+$"))) {
            callee_str = "(" + name + ")";
        }
        if (method.isStatic()) {
            callee_str = callee_str + this.getClassName(method.getMethod().getDeclaringClass());
        } else {
            VariableReference callee = statement.getCallee();
            if (callee instanceof ConstantValue) {
                callee_str = callee_str + "((" + this.getClassName(method.getMethod().getDeclaringClass()) + ")" + this.getVariableName(callee) + ")";
            } else if (!callee.isAssignableTo(method.getMethod().getDeclaringClass())) {
                try {
                    callee.getVariableClass().getMethod(method.getName(), method.getRawParameterTypes());
                    callee_str = callee_str + this.getVariableName(callee);
                }
                catch (NoSuchMethodException e) {
                    callee_str = callee_str + "((" + this.getTypeName(method.getMethod().getDeclaringClass()) + ") " + this.getVariableName(callee) + ")";
                }
            } else {
                callee_str = callee_str + this.getVariableName(callee);
            }
        }
        if (retval.isVoid()) {
            result = result + callee_str + "." + method.getName() + "(" + parameter_string + ");";
        } else {
            result = !unused ? result + this.getVariableName(retval) + " = " : result + this.getClassName(retval) + " " + this.getVariableName(retval) + " = ";
            result = result + callee_str + "." + method.getName() + "(" + parameter_string + ");";
        }
        if (exception != null && !this.test.isFailing()) {
            if (Properties.ASSERTIONS) {
                result = result + this.generateFailAssertion(statement, exception);
            }
            result = result + "\n}";
            result = result + this.generateCatchBlock(statement, exception);
        }
        this.testCode = this.testCode + result + "\n";
        this.addAssertions(statement);
    }

    public String generateCatchBlock(AbstractStatement statement, Throwable exception) {
        String result = "";
        Class<?> ex = this.getExceptionClassToUse(exception);
        result = result + " catch(" + this.getClassName(ex) + " e) {\n";
        String exceptionMessage = "";
        exceptionMessage = exception.getMessage() != null ? exception.getMessage().replace("*/", "*_/") : "no message in exception (getMessage() returned null)";
        result = result + "   //\n";
        for (String msg : exceptionMessage.split("\n")) {
            result = result + "   // " + StringEscapeUtils.escapeJava((String)msg) + "\n";
        }
        result = result + "   //\n";
        result = result + "}\n";
        return result;
    }

    private Class<?> getExceptionClassToUse(Throwable exception) {
        Class<?> ex = exception.getClass();
        while (!Modifier.isPublic(ex.getModifiers()) || EvoSuiteMock.class.isAssignableFrom(ex)) {
            ex = ex.getSuperclass();
        }
        return ex;
    }

    private String getSimpleTypeName(Type type) {
        String typeName = this.getTypeName(type);
        int dotIndex = typeName.lastIndexOf(".");
        if (dotIndex >= 0 && dotIndex + 1 < typeName.length()) {
            typeName = typeName.substring(dotIndex + 1);
        }
        return typeName;
    }

    @Override
    public void visitConstructorStatement(ConstructorStatement statement) {
        String result = "";
        GenericConstructor constructor = statement.getConstructor();
        VariableReference retval = statement.getReturnValue();
        Throwable exception = this.getException(statement);
        boolean isGenericConstructor = constructor.hasTypeParameters();
        boolean isNonStaticMemberClass = constructor.getConstructor().getDeclaringClass().isMemberClass() && !constructor.isStatic() && !Modifier.isStatic(constructor.getConstructor().getDeclaringClass().getModifiers());
        List<VariableReference> parameters = statement.getParameterReferences();
        int startPos = 0;
        if (isNonStaticMemberClass) {
            startPos = 1;
        }
        Type[] parameterTypes = constructor.getParameterTypes();
        String parameterString = this.getParameterString(parameterTypes, parameters, isGenericConstructor, constructor.isOverloaded(parameters), startPos);
        if (exception != null) {
            String className = this.getClassName(retval);
            if (retval.isPrimitive()) {
                className = retval.getGenericClass().getUnboxedType().getSimpleName();
            }
            result = className + " " + this.getVariableName(retval) + " = null;\n";
            result = result + "try {\n  ";
        } else {
            result = result + this.getClassName(retval) + " ";
        }
        result = isNonStaticMemberClass ? result + this.getVariableName(retval) + " = " + this.getVariableName(parameters.get(0)) + ".new " + this.getSimpleTypeName(constructor.getOwnerType()) + "(" + parameterString + ");" : result + this.getVariableName(retval) + " = new " + this.getTypeName(constructor.getOwnerType()) + "(" + parameterString + ");";
        if (exception != null) {
            if (Properties.ASSERTIONS) {
                result = result + this.generateFailAssertion(statement, exception);
            }
            result = result + "\n}";
            result = result + this.generateCatchBlock(statement, exception);
        }
        this.testCode = this.testCode + result + "\n";
        this.addAssertions(statement);
    }

    public String generateFailAssertion(AbstractStatement statement, Throwable exception) {
        Class<?> ex = this.getExceptionClassToUse(exception);
        String stmt = " fail(\"Expecting exception: " + this.getClassName(ex) + "\");\n";
        if (this.isTestUnstable()) {
            stmt = "// " + stmt + this.getUnstableTestComment();
        }
        return "\n " + stmt;
    }

    @Override
    public void visitArrayStatement(ArrayStatement statement) {
        VariableReference retval = statement.getReturnValue();
        List<Integer> lengths = statement.getLengths();
        String type = this.getClassName(retval);
        String multiDimensions = "";
        if (lengths.size() == 1) {
            type = type.replaceFirst("\\[\\]", "");
            multiDimensions = "[" + lengths.get(0) + "]";
            while (type.contains("[]")) {
                multiDimensions = multiDimensions + "[]";
                type = type.replaceFirst("\\[\\]", "");
            }
        } else {
            type = type.replaceAll("\\[\\]", "");
            for (int length : lengths) {
                multiDimensions = multiDimensions + "[" + length + "]";
            }
        }
        if (retval.getGenericClass().isGenericArray()) {
            if (lengths.size() > 1) {
                multiDimensions = "new int[] {" + lengths.get(0);
                for (int i = 1; i < lengths.size(); ++i) {
                    multiDimensions = multiDimensions + ", " + lengths.get(i);
                }
                multiDimensions = multiDimensions + "}";
            } else {
                multiDimensions = "" + lengths.get(0);
            }
            this.testCode = this.testCode + this.getClassName(retval) + " " + this.getVariableName(retval) + " = (" + this.getClassName(retval) + ") " + this.getClassName(Array.class) + ".newInstance(" + this.getClassName(retval.getComponentClass()).replaceAll("\\[\\]", "") + ".class, " + multiDimensions + ");\n";
        } else {
            this.testCode = this.testCode + this.getClassName(retval) + " " + this.getVariableName(retval) + " = new " + type + multiDimensions + ";\n";
        }
        this.addAssertions(statement);
    }

    @Override
    public void visitAssignmentStatement(AssignmentStatement statement) {
        String cast = "";
        VariableReference retval = statement.getReturnValue();
        VariableReference parameter = statement.getValue();
        if (!retval.getVariableClass().equals(parameter.getVariableClass())) {
            cast = "(" + this.getClassName(retval) + ") ";
        }
        this.testCode = this.testCode + this.getVariableName(retval) + " = " + cast + this.getVariableName(parameter) + ";\n";
        this.addAssertions(statement);
    }

    @Override
    public void visitNullStatement(NullStatement statement) {
        VariableReference retval = statement.getReturnValue();
        this.testCode = this.testCode + this.getClassName(retval) + " " + this.getVariableName(retval) + " = null;\n";
    }

    @Override
    public void visitStatement(Statement statement) {
        if (!statement.getComment().isEmpty()) {
            String comment = statement.getComment();
            for (String line : comment.split("\n")) {
                this.testCode = this.testCode + "// " + line + "\n";
            }
        }
        super.visitStatement(statement);
    }
}

