/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import com.googlecode.gentyref.CaptureType;
import com.googlecode.gentyref.GenericTypeReflector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import org.evosuite.Properties;
import org.evosuite.TimeController;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.seeding.CastClassManager;
import org.evosuite.seeding.ObjectPoolManager;
import org.evosuite.setup.TestCluster;
import org.evosuite.setup.TestClusterGenerator;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.statements.ArrayStatement;
import org.evosuite.testcase.statements.AssignmentStatement;
import org.evosuite.testcase.statements.ConstructorStatement;
import org.evosuite.testcase.statements.FieldStatement;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.NullStatement;
import org.evosuite.testcase.statements.PrimitiveStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.statements.environment.EnvironmentStatements;
import org.evosuite.testcase.statements.reflection.PrivateFieldStatement;
import org.evosuite.testcase.statements.reflection.PrivateMethodStatement;
import org.evosuite.testcase.statements.reflection.ReflectionFactory;
import org.evosuite.testcase.variable.ArrayIndex;
import org.evosuite.testcase.variable.ArrayReference;
import org.evosuite.testcase.variable.FieldReference;
import org.evosuite.testcase.variable.NullReference;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.utils.GenericAccessibleObject;
import org.evosuite.utils.GenericClass;
import org.evosuite.utils.GenericConstructor;
import org.evosuite.utils.GenericField;
import org.evosuite.utils.GenericMethod;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFactory {
    private static final Logger logger = LoggerFactory.getLogger(TestFactory.class);
    private transient Set<GenericAccessibleObject<?>> currentRecursion = new HashSet();
    private static TestFactory instance = null;
    private ReflectionFactory reflectionFactory;

    private TestFactory() {
        this.reset();
    }

    public void reset() {
        this.currentRecursion.clear();
        this.reflectionFactory = null;
    }

    public static TestFactory getInstance() {
        if (instance == null) {
            instance = new TestFactory();
        }
        return instance;
    }

    private boolean addCallFor(TestCase test, VariableReference callee, GenericAccessibleObject<?> call, int position) {
        logger.trace("addCallFor " + callee.getName());
        int previousLength = test.size();
        this.currentRecursion.clear();
        try {
            if (call.isMethod()) {
                this.addMethodFor(test, callee, (GenericMethod)call.copyWithNewOwner(callee.getGenericClass()), position);
            } else if (call.isField()) {
                this.addFieldFor(test, callee, (GenericField)call.copyWithNewOwner(callee.getGenericClass()), position);
            }
            return true;
        }
        catch (ConstructionFailedException e) {
            logger.debug("Inserting call " + call + " has failed. Removing statements");
            int lengthDifference = test.size() - previousLength;
            for (int i = lengthDifference - 1; i >= 0; --i) {
                logger.debug("  Removing statement: " + test.getStatement(position + i).getCode());
                test.remove(position + i);
            }
            logger.debug("Test after removal: " + test.toCode());
            return false;
        }
    }

    public VariableReference addConstructor(TestCase test, GenericConstructor constructor, int position, int recursionDepth) throws ConstructionFailedException {
        return this.addConstructor(test, constructor, null, position, recursionDepth);
    }

    public VariableReference addConstructor(TestCase test, GenericConstructor constructor, Type exactType, int position, int recursionDepth) throws ConstructionFailedException {
        if (recursionDepth > Properties.MAX_RECURSION) {
            logger.debug("Max recursion depth reached");
            throw new ConstructionFailedException("Max recursion depth reached");
        }
        int length = test.size();
        try {
            List<VariableReference> parameters = this.satisfyParameters(test, null, Arrays.asList(constructor.getParameterTypes()), position, recursionDepth + 1);
            int newLength = test.size();
            ConstructorStatement st = new ConstructorStatement(test, constructor, parameters);
            return test.addStatement(st, position += newLength - length);
        }
        catch (Exception e) {
            throw new ConstructionFailedException(e.getMessage());
        }
    }

    public VariableReference addField(TestCase test, GenericField field, int position, int recursionDepth) throws ConstructionFailedException {
        logger.debug("Adding field " + field);
        if (recursionDepth > Properties.MAX_RECURSION) {
            logger.debug("Max recursion depth reached");
            throw new ConstructionFailedException("Max recursion depth reached");
        }
        VariableReference callee = null;
        int length = test.size();
        if (!field.isStatic()) {
            callee = this.createOrReuseVariable(test, field.getOwnerType(), position, recursionDepth, null, false);
            position += test.size() - length;
            length = test.size();
            if (!TestClusterGenerator.canUse(field.getField(), callee.getVariableClass())) {
                logger.debug("Cannot call field " + field + " with callee of type " + callee.getClassName());
                throw new ConstructionFailedException("Cannot apply field to this callee");
            }
            if (!field.getOwnerClass().equals(callee.getGenericClass())) {
                try {
                    if (!TestClusterGenerator.canUse(callee.getVariableClass().getField(field.getName()))) {
                        throw new ConstructionFailedException("Cannot access field in subclass");
                    }
                }
                catch (NoSuchFieldException fe) {
                    throw new ConstructionFailedException("Cannot access field in subclass");
                }
            }
        }
        FieldStatement st = new FieldStatement(test, field, callee);
        return test.addStatement(st, position);
    }

    public VariableReference addFieldAssignment(TestCase test, GenericField field, int position, int recursionDepth) throws ConstructionFailedException {
        logger.debug("Recursion depth: " + recursionDepth);
        if (recursionDepth > Properties.MAX_RECURSION) {
            logger.debug("Max recursion depth reached");
            throw new ConstructionFailedException("Max recursion depth reached");
        }
        logger.debug("Adding field " + field);
        int length = test.size();
        VariableReference callee = null;
        if (!field.isStatic()) {
            callee = this.createOrReuseVariable(test, field.getOwnerType(), position, recursionDepth, null, false);
            position += test.size() - length;
            length = test.size();
            if (!TestClusterGenerator.canUse(field.getField(), callee.getVariableClass())) {
                logger.debug("Cannot call field " + field + " with callee of type " + callee.getClassName());
                throw new ConstructionFailedException("Cannot apply field to this callee");
            }
        }
        VariableReference var = this.createOrReuseVariable(test, field.getFieldType(), position, recursionDepth, callee, true);
        int newLength = test.size();
        position += newLength - length;
        FieldReference f = new FieldReference(test, field, callee);
        if (f.equals(var)) {
            throw new ConstructionFailedException("Self assignment");
        }
        AssignmentStatement st = new AssignmentStatement(test, f, var);
        VariableReference ret = test.addStatement(st, position);
        assert (test.isValid());
        return ret;
    }

    public VariableReference addFieldFor(TestCase test, VariableReference callee, GenericField field, int position) throws ConstructionFailedException {
        logger.debug("Adding field " + field + " for variable " + callee);
        if (position <= callee.getStPosition()) {
            throw new ConstructionFailedException("Cannot insert call on object before the object is defined");
        }
        this.currentRecursion.clear();
        FieldReference fieldVar = new FieldReference(test, field, callee);
        int length = test.size();
        VariableReference value = this.createOrReuseVariable(test, fieldVar.getType(), position, 0, callee, true);
        int newLength = test.size();
        AssignmentStatement st = new AssignmentStatement(test, fieldVar, value);
        VariableReference ret = test.addStatement(st, position += newLength - length);
        ret.setDistance(callee.getDistance() + 1);
        assert (test.isValid());
        return ret;
    }

    public VariableReference addMethod(TestCase test, GenericMethod method, int position, int recursionDepth) throws ConstructionFailedException {
        logger.debug("Recursion depth: " + recursionDepth);
        if (recursionDepth > Properties.MAX_RECURSION) {
            logger.debug("Max recursion depth reached");
            throw new ConstructionFailedException("Max recursion depth reached");
        }
        logger.debug("Adding method " + method);
        int length = test.size();
        VariableReference callee = null;
        List<VariableReference> parameters = null;
        if (!method.isStatic()) {
            callee = this.createOrReuseVariable(test, method.getOwnerType(), position, recursionDepth, null, false);
            position += test.size() - length;
            length = test.size();
            logger.debug("Found callee of type " + method.getOwnerType() + ": " + callee.getName());
            if (!TestClusterGenerator.canUse(method.getMethod(), callee.getVariableClass())) {
                logger.debug("Cannot call method " + method + " with callee of type " + callee.getClassName());
                throw new ConstructionFailedException("Cannot apply method to this callee");
            }
        }
        parameters = this.satisfyParameters(test, callee, Arrays.asList(method.getParameterTypes()), position, recursionDepth + 1);
        int newLength = test.size();
        MethodStatement st = new MethodStatement(test, method, callee, parameters);
        VariableReference ret = test.addStatement(st, position += newLength - length);
        if (callee != null) {
            ret.setDistance(callee.getDistance() + 1);
        }
        return ret;
    }

    public VariableReference addMethodFor(TestCase test, VariableReference callee, GenericMethod method, int position) throws ConstructionFailedException {
        logger.debug("Adding method " + method + " for " + callee + "(Generating " + method.getGeneratedClass() + ")");
        if (position <= callee.getStPosition()) {
            throw new ConstructionFailedException("Cannot insert call on object before the object is defined");
        }
        this.currentRecursion.clear();
        int length = test.size();
        List<VariableReference> parameters = null;
        parameters = this.satisfyParameters(test, callee, Arrays.asList(method.getParameterTypes()), position, 1);
        int newLength = test.size();
        MethodStatement st = new MethodStatement(test, method, callee, parameters);
        VariableReference ret = test.addStatement(st, position += newLength - length);
        ret.setDistance(callee.getDistance() + 1);
        logger.debug("Success: Adding method " + method);
        return ret;
    }

    private VariableReference addPrimitive(TestCase test, PrimitiveStatement<?> old, int position) throws ConstructionFailedException {
        logger.debug("Adding primitive");
        Statement st = old.clone(test);
        return test.addStatement(st, position);
    }

    public void appendStatement(TestCase test, Statement statement) throws ConstructionFailedException {
        this.currentRecursion.clear();
        if (statement instanceof ConstructorStatement) {
            this.addConstructor(test, ((ConstructorStatement)statement).getConstructor(), test.size(), 0);
        } else if (statement instanceof MethodStatement) {
            GenericMethod method = ((MethodStatement)statement).getMethod();
            this.addMethod(test, method, test.size(), 0);
        } else if (statement instanceof PrimitiveStatement) {
            this.addPrimitive(test, (PrimitiveStatement)statement, test.size());
        } else if (statement instanceof FieldStatement) {
            this.addField(test, ((FieldStatement)statement).getField(), test.size(), 0);
        }
    }

    public void assignArray(TestCase test, VariableReference array, int arrayIndex, int position) throws ConstructionFailedException {
        List<VariableReference> objects = test.getObjects(array.getComponentType(), position);
        Iterator<VariableReference> iterator = objects.iterator();
        GenericClass componentClass = new GenericClass(array.getComponentType());
        while (iterator.hasNext()) {
            VariableReference var = iterator.next();
            if (var instanceof ArrayIndex) {
                if (((ArrayIndex)var).getArray().equals(array)) {
                    iterator.remove();
                } else if (((ArrayIndex)var).getArray().getType().equals(array.getType())) {
                    iterator.remove();
                }
            }
            if (!componentClass.isWrapperType()) continue;
            Class rawClass = ClassUtils.wrapperToPrimitive(componentClass.getRawClass());
            if (var.getVariableClass().equals(rawClass) || var.getVariableClass().equals(componentClass.getRawClass())) continue;
            iterator.remove();
        }
        logger.debug("Reusable objects: " + objects);
        this.assignArray(test, array, arrayIndex, position, objects);
    }

    protected void assignArray(TestCase test, VariableReference array, int arrayIndex, int position, List<VariableReference> objects) throws ConstructionFailedException {
        assert (array instanceof ArrayReference);
        ArrayReference arrRef = (ArrayReference)array;
        if (!objects.isEmpty() && Randomness.nextDouble() <= Properties.OBJECT_REUSE_PROBABILITY) {
            VariableReference choice = Randomness.choice(objects);
            logger.debug("Reusing value: " + choice);
            ArrayIndex index = new ArrayIndex(test, arrRef, arrayIndex);
            AssignmentStatement st = new AssignmentStatement(test, index, choice);
            test.addStatement(st, position);
        } else {
            int oldLength = test.size();
            logger.debug("Attempting generation of object of type " + array.getComponentType());
            VariableReference var = this.attemptGeneration(test, array.getComponentType(), position);
            if (!var.isAssignableTo(arrRef.getComponentType())) {
                throw new ConstructionFailedException("Error");
            }
            ArrayIndex index = new ArrayIndex(test, arrRef, arrayIndex);
            AssignmentStatement st = new AssignmentStatement(test, index, var);
            test.addStatement(st, position += test.size() - oldLength);
        }
    }

    public VariableReference attemptGeneration(TestCase test, Type type, int position) throws ConstructionFailedException {
        return this.attemptGeneration(test, type, position, 0, false);
    }

    public VariableReference attemptGenerationOrNull(TestCase test, Type type, int position) throws ConstructionFailedException {
        return this.attemptGeneration(test, type, position, 0, true);
    }

    protected VariableReference attemptGeneration(TestCase test, Type type, int position, int recursionDepth, boolean allowNull) throws ConstructionFailedException {
        GenericClass clazz = new GenericClass(type);
        if (clazz.isEnum()) {
            if (!TestClusterGenerator.canUse(clazz.getRawClass())) {
                throw new ConstructionFailedException("Cannot generate unaccessible enum " + clazz);
            }
            return this.createPrimitive(test, clazz, position, recursionDepth);
        }
        if (clazz.isPrimitive() || clazz.isClass() || EnvironmentStatements.isEnvironmentData(clazz.getRawClass())) {
            return this.createPrimitive(test, clazz, position, recursionDepth);
        }
        if (clazz.isString()) {
            if (allowNull && Randomness.nextDouble() <= Properties.NULL_PROBABILITY) {
                logger.debug("Using a null reference to satisfy the type: " + type);
                return this.createNull(test, type, position, recursionDepth);
            }
            return this.createPrimitive(test, clazz, position, recursionDepth);
        }
        if (clazz.isArray()) {
            return this.createArray(test, clazz, position, recursionDepth);
        }
        if (allowNull && Randomness.nextDouble() <= Properties.NULL_PROBABILITY) {
            logger.debug("Using a null reference to satisfy the type: " + type);
            return this.createNull(test, type, position, recursionDepth);
        }
        ObjectPoolManager objectPool = ObjectPoolManager.getInstance();
        if (Randomness.nextDouble() <= Properties.P_OBJECT_POOL && objectPool.hasSequence(clazz)) {
            TestCase sequence = objectPool.getRandomSequence(clazz);
            logger.debug("Using a sequence from the object pool to satisfy the type: " + type);
            VariableReference targetObject = sequence.getLastObject(type);
            int returnPos = position + targetObject.getStPosition();
            for (int i = 0; i < sequence.size(); ++i) {
                Statement s = sequence.getStatement(i);
                test.addStatement(s.copy(test, position), position + i);
            }
            logger.debug("Return type of object sequence: " + test.getStatement(returnPos).getReturnValue().getClassName());
            return test.getStatement(returnPos).getReturnValue();
        }
        return this.createObject(test, type, position, recursionDepth);
    }

    protected VariableReference attemptObjectGeneration(TestCase test, int position, int recursionDepth, boolean allowNull) throws ConstructionFailedException {
        if (allowNull && Randomness.nextDouble() <= Properties.NULL_PROBABILITY) {
            logger.debug("Using a null reference to satisfy the type: " + Object.class);
            return this.createNull(test, (Type)((Object)Object.class), position, recursionDepth);
        }
        ArrayList<GenericClass> classes = new ArrayList<GenericClass>(CastClassManager.getInstance().getCastClasses());
        classes.add(new GenericClass(Object.class));
        GenericClass choice = Randomness.choice(classes);
        logger.debug("Chosen class for Object: " + choice);
        if (choice.isString()) {
            return this.createOrReuseVariable(test, (Type)((Object)String.class), position, recursionDepth, null, true);
        }
        GenericAccessibleObject<?> o = TestCluster.getInstance().getRandomGenerator(choice);
        this.currentRecursion.add(o);
        if (o == null) {
            if (!TestCluster.getInstance().hasGenerator((Type)((Object)Object.class))) {
                logger.debug("We have no generator for Object.class ");
            }
            throw new ConstructionFailedException("Generator is null");
        }
        if (o.isField()) {
            logger.debug("Attempting generating of Object.class via field of type Object.class");
            VariableReference ret = this.addField(test, (GenericField)o, position, recursionDepth + 1);
            ret.setDistance(recursionDepth + 1);
            logger.debug("Success in generating type Object.class");
            return ret;
        }
        if (o.isMethod()) {
            logger.debug("Attempting generating of Object.class via method " + o + " of type Object.class");
            VariableReference ret = this.addMethod(test, (GenericMethod)o, position, recursionDepth + 1);
            logger.debug("Success in generating type Object.class");
            ret.setDistance(recursionDepth + 1);
            return ret;
        }
        if (o.isConstructor()) {
            logger.debug("Attempting generating of Object.class via constructor " + o + " of type Object.class");
            VariableReference ret = this.addConstructor(test, (GenericConstructor)o, position, recursionDepth + 1);
            logger.debug("Success in generating Object.class");
            ret.setDistance(recursionDepth + 1);
            return ret;
        }
        logger.debug("No generators found for Object.class");
        throw new ConstructionFailedException("No generator found for Object.class");
    }

    public void changeCall(TestCase test, Statement statement, GenericAccessibleObject<?> call) throws ConstructionFailedException {
        int position = statement.getReturnValue().getStPosition();
        logger.debug("Changing call " + test.getStatement(position) + " with " + call);
        if (call.isMethod()) {
            GenericMethod method = (GenericMethod)call;
            if (method.hasTypeParameters()) {
                throw new ConstructionFailedException("Cannot handle generic methods properly");
            }
            VariableReference retval = statement.getReturnValue();
            VariableReference callee = null;
            if (!method.isStatic()) {
                callee = test.getRandomNonNullNonPrimitiveObject(method.getOwnerType(), position);
            }
            ArrayList<VariableReference> parameters = new ArrayList<VariableReference>();
            for (Type type : method.getParameterTypes()) {
                parameters.add(test.getRandomObject(type, position));
            }
            MethodStatement m = new MethodStatement(test, method, callee, parameters, retval);
            test.setStatement(m, position);
            logger.debug("Using method " + m.getCode());
        } else if (call.isConstructor()) {
            GenericConstructor constructor = (GenericConstructor)call;
            VariableReference retval = statement.getReturnValue();
            ArrayList<VariableReference> parameters = new ArrayList<VariableReference>();
            for (Type type : constructor.getParameterTypes()) {
                parameters.add(test.getRandomObject(type, position));
            }
            ConstructorStatement c = new ConstructorStatement(test, constructor, retval, parameters);
            test.setStatement(c, position);
            logger.debug("Using constructor " + c.getCode());
        } else if (call.isField()) {
            GenericField field = (GenericField)call;
            VariableReference retval = statement.getReturnValue();
            VariableReference source = null;
            if (!field.isStatic()) {
                source = test.getRandomNonNullNonPrimitiveObject(field.getOwnerType(), position);
            }
            try {
                FieldStatement f = new FieldStatement(test, field, source, retval);
                test.setStatement(f, position);
                logger.debug("Using field " + f.getCode());
            }
            catch (Throwable e) {
                logger.error("Error: " + e + " , Field: " + field + " , Test: " + test);
                throw new Error(e);
            }
        }
    }

    public boolean changeRandomCall(TestCase test, Statement statement) {
        logger.debug("Changing statement ", (Object)statement.getCode());
        List<VariableReference> objects = test.getObjects(statement.getReturnValue().getStPosition());
        objects.remove(statement.getReturnValue());
        List<GenericAccessibleObject<?>> calls = this.getPossibleCalls(statement.getReturnType(), objects);
        GenericAccessibleObject<?> ao = statement.getAccessibleObject();
        if (ao != null) {
            calls.remove(ao);
        }
        logger.debug("Got " + calls.size() + " possible calls for " + objects.size() + " objects");
        calls.clear();
        if (calls.isEmpty()) {
            return false;
        }
        GenericAccessibleObject<?> call = Randomness.choice(calls);
        try {
            this.changeCall(test, statement, call);
            return true;
        }
        catch (ConstructionFailedException e) {
            logger.info("Change failed for statement " + statement.getCode() + " -> " + call + ": " + e.getMessage() + " " + test.toCode());
            return false;
        }
    }

    private VariableReference createArray(TestCase test, GenericClass arrayClass, int position, int recursionDepth) throws ConstructionFailedException {
        logger.debug("Creating array of type " + arrayClass.getTypeName());
        if (arrayClass.hasWildcardOrTypeVariables()) {
            arrayClass = arrayClass.getGenericInstantiation();
            logger.debug("Setting generic array to type " + arrayClass.getTypeName());
        }
        ArrayStatement statement = new ArrayStatement(test, arrayClass.getType());
        VariableReference reference = test.addStatement(statement, position);
        logger.debug("Array length: " + statement.size());
        logger.debug("Array component type: " + reference.getComponentType());
        List<VariableReference> objects = test.getObjects(reference.getComponentType(), ++position);
        Iterator<VariableReference> iterator = objects.iterator();
        while (iterator.hasNext()) {
            VariableReference current = iterator.next();
            if (!(current instanceof ArrayIndex)) continue;
            ArrayIndex index = (ArrayIndex)current;
            if (index.getArray().equals(statement.getReturnValue())) {
                iterator.remove();
                continue;
            }
            if (!index.getArray().getType().equals(arrayClass.getType())) continue;
            iterator.remove();
        }
        objects.remove(statement.getReturnValue());
        logger.debug("Found assignable objects: " + objects.size());
        HashSet currentArrayRecursion = new HashSet(this.currentRecursion);
        for (int i = 0; i < statement.size(); ++i) {
            this.currentRecursion.clear();
            this.currentRecursion.addAll(currentArrayRecursion);
            logger.debug("Assigning array index " + i);
            int oldLength = test.size();
            this.assignArray(test, reference, i, position, objects);
            position += test.size() - oldLength;
        }
        reference.setDistance(recursionDepth);
        return reference;
    }

    private VariableReference createPrimitive(TestCase test, GenericClass clazz, int position, int recursionDepth) throws ConstructionFailedException {
        if (clazz.isClass()) {
            Type parameterType;
            if (clazz.hasWildcardOrTypeVariables()) {
                logger.debug("Getting generic instantiation of class");
                clazz = clazz.getGenericInstantiation();
                logger.debug("Chosen: " + clazz);
            }
            if (GenericTypeReflector.erase((Type)(parameterType = clazz.getParameterTypes().get(0))).equals(Class.class)) {
                throw new ConstructionFailedException("Cannot instantiate a class with a class");
            }
        }
        PrimitiveStatement<?> st = PrimitiveStatement.getRandomStatement(test, clazz, position);
        VariableReference ret = test.addStatement(st, position);
        ret.setDistance(recursionDepth);
        return ret;
    }

    private VariableReference createNull(TestCase test, Type type, int position, int recursionDepth) throws ConstructionFailedException {
        GenericClass genericType = new GenericClass(type);
        if (!TestClusterGenerator.canUse(genericType.getRawClass())) {
            throw new ConstructionFailedException("Cannot use class " + type);
        }
        if (genericType.hasWildcardOrTypeVariables()) {
            type = genericType.getGenericInstantiation().getType();
        }
        NullStatement st = new NullStatement(test, type);
        test.addStatement(st, position);
        VariableReference ret = test.getStatement(position).getReturnValue();
        ret.setDistance(recursionDepth);
        return ret;
    }

    public VariableReference createObject(TestCase test, Type type, int position, int recursionDepth) throws ConstructionFailedException {
        GenericClass clazz = new GenericClass(type);
        GenericAccessibleObject<?> o = TestCluster.getInstance().getRandomGenerator(clazz, this.currentRecursion);
        this.currentRecursion.add(o);
        if (o == null) {
            if (!TestCluster.getInstance().hasGenerator(clazz)) {
                logger.debug("We have no generator for class " + type);
            }
            throw new ConstructionFailedException("Generator is null");
        }
        if (o.isField()) {
            logger.debug("Attempting generating of " + type + " via field of type " + type);
            VariableReference ret = this.addField(test, (GenericField)o, position, recursionDepth + 1);
            ret.setDistance(recursionDepth + 1);
            logger.debug("Success in generating type " + type);
            return ret;
        }
        if (o.isMethod()) {
            logger.debug("Attempting generating of " + type + " via method " + o + " of type " + type);
            VariableReference ret = this.addMethod(test, (GenericMethod)o, position, recursionDepth + 1);
            logger.debug("Success in generating type " + type);
            ret.setDistance(recursionDepth + 1);
            return ret;
        }
        if (o.isConstructor()) {
            logger.debug("Attempting generating of " + type + " via constructor " + o + " of type " + type + ", with constructor type " + o.getOwnerType());
            VariableReference ret = this.addConstructor(test, (GenericConstructor)o, type, position, recursionDepth + 1);
            logger.debug("Success in generating type " + type);
            ret.setDistance(recursionDepth + 1);
            return ret;
        }
        logger.debug("No generators found for type " + type);
        throw new ConstructionFailedException("No generator found for type " + type);
    }

    private VariableReference createOrReuseVariable(TestCase test, Type parameterType, int position, int recursionDepth, VariableReference exclude, boolean allowNull) throws ConstructionFailedException {
        GenericClass clazz;
        boolean isPrimitiveOrSimilar;
        if (Properties.SEED_TYPES && parameterType.equals(Object.class)) {
            return this.createOrReuseObjectVariable(test, position, recursionDepth, exclude);
        }
        double reuse = Randomness.nextDouble();
        List<VariableReference> objects = test.getObjects(parameterType, position);
        if (exclude != null) {
            objects.remove(exclude);
            if (exclude.getAdditionalVariableReference() != null) {
                objects.remove(exclude.getAdditionalVariableReference());
            }
            Iterator<VariableReference> it = objects.iterator();
            while (it.hasNext()) {
                VariableReference v = it.next();
                if (!exclude.equals(v.getAdditionalVariableReference())) continue;
                it.remove();
            }
        }
        boolean bl = isPrimitiveOrSimilar = (clazz = new GenericClass(parameterType)).isPrimitive() || clazz.isWrapperType() || clazz.isEnum() || clazz.isClass() || clazz.isString();
        if (isPrimitiveOrSimilar && !objects.isEmpty() && reuse <= Properties.PRIMITIVE_REUSE_PROBABILITY) {
            logger.debug(" Looking for existing object of type " + parameterType);
            VariableReference reference = Randomness.choice(objects);
            return reference;
        }
        if (!isPrimitiveOrSimilar && !objects.isEmpty() && reuse <= Properties.OBJECT_REUSE_PROBABILITY) {
            logger.debug(" Choosing from " + objects.size() + " existing objects");
            VariableReference reference = Randomness.choice(objects);
            logger.debug(" Using existing object of type " + parameterType + ": " + reference);
            return reference;
        }
        if (clazz.hasWildcardOrTypeVariables()) {
            logger.debug("Getting generic instantiation of " + clazz);
            clazz = exclude != null ? clazz.getGenericInstantiation(exclude.getGenericClass().getTypeVariableMap()) : clazz.getGenericInstantiation();
            parameterType = clazz.getType();
        }
        if (clazz.isEnum() || clazz.isPrimitive() || clazz.isWrapperType() || clazz.isObject() || clazz.isClass() || EnvironmentStatements.isEnvironmentData(clazz.getRawClass()) || clazz.isString() || clazz.isArray() || TestCluster.getInstance().hasGenerator(parameterType)) {
            logger.debug(" Generating new object of type " + parameterType);
            VariableReference reference = this.attemptGeneration(test, parameterType, position, recursionDepth, allowNull);
            return reference;
        }
        if (objects.isEmpty()) {
            throw new ConstructionFailedException("Have no objects and generators");
        }
        logger.debug(" Choosing from " + objects.size() + " existing objects");
        VariableReference reference = Randomness.choice(objects);
        logger.debug(" Using existing object of type " + parameterType + ": " + reference);
        return reference;
    }

    private VariableReference createOrReuseObjectVariable(TestCase test, int position, int recursionDepth, VariableReference exclude) throws ConstructionFailedException {
        double reuse = Randomness.nextDouble();
        if (reuse <= Properties.PRIMITIVE_REUSE_PROBABILITY) {
            List<VariableReference> candidates = test.getObjects((Type)((Object)Object.class), position);
            TestFactory.filterVariablesByCastClasses(candidates);
            logger.debug("Choosing object from: " + candidates);
            if (!candidates.isEmpty()) {
                return Randomness.choice(candidates);
            }
        }
        logger.debug("Attempting object generation");
        return this.attemptObjectGeneration(test, position, recursionDepth, true);
    }

    public void deleteStatement(TestCase test, int position) throws ConstructionFailedException {
        logger.debug("Deleting target statement - " + position);
        LinkedHashSet<VariableReference> references = new LinkedHashSet<VariableReference>();
        LinkedHashSet<Integer> positions = new LinkedHashSet<Integer>();
        positions.add(position);
        references.add(test.getReturnValue(position));
        for (int i = position; i < test.size(); ++i) {
            LinkedHashSet<VariableReference> temp = new LinkedHashSet<VariableReference>();
            for (VariableReference v : references) {
                if (!test.getStatement(i).references(v)) continue;
                temp.add(test.getStatement(i).getReturnValue());
                positions.add(i);
            }
            references.addAll(temp);
        }
        ArrayList pos = new ArrayList(positions);
        Collections.sort(pos, Collections.reverseOrder());
        for (Integer i : pos) {
            logger.debug("Deleting statement: " + i);
            test.remove(i);
        }
    }

    private static void filterVariablesByCastClasses(Collection<VariableReference> variables) {
        Set<GenericClass> castClasses = CastClassManager.getInstance().getCastClasses();
        Iterator<VariableReference> replacement = variables.iterator();
        while (replacement.hasNext()) {
            VariableReference r = replacement.next();
            boolean isAssignable = false;
            for (GenericClass clazz : castClasses) {
                if (r.isPrimitive() || !clazz.isAssignableFrom(r.getVariableClass())) continue;
                isAssignable = true;
                break;
            }
            if (isAssignable || r.getVariableClass().equals(Object.class)) continue;
            replacement.remove();
        }
    }

    private static void filterVariablesByClass(Collection<VariableReference> variables, Class<?> clazz) {
        Iterator<VariableReference> replacement = variables.iterator();
        while (replacement.hasNext()) {
            VariableReference r = replacement.next();
            if (r.getVariableClass().equals(clazz)) continue;
            replacement.remove();
        }
    }

    public void deleteStatementGracefully(TestCase test, int position) throws ConstructionFailedException {
        Statement s;
        ConstructorStatement cs;
        VariableReference var = test.getReturnValue(position);
        if (var instanceof ArrayIndex) {
            this.deleteStatement(test, position);
            return;
        }
        boolean replacingPrimitive = test.getStatement(position) instanceof PrimitiveStatement;
        List<VariableReference> alternatives = test.getObjects(var.getType(), position);
        int maxIndex = 0;
        if (var instanceof ArrayReference) {
            maxIndex = ((ArrayReference)var).getMaximumIndex();
        }
        if (test.getStatement(position) instanceof MethodStatement) {
            MethodStatement ms = (MethodStatement)test.getStatement(position);
            if (ms.getReturnType().equals(Object.class)) {
                TestFactory.filterVariablesByClass(alternatives, Object.class);
            }
        } else if (test.getStatement(position) instanceof ConstructorStatement && (cs = (ConstructorStatement)test.getStatement(position)).getReturnType().equals(Object.class)) {
            TestFactory.filterVariablesByClass(alternatives, Object.class);
        }
        alternatives.remove(var);
        Iterator<VariableReference> replacement = alternatives.iterator();
        while (replacement.hasNext()) {
            VariableReference r = replacement.next();
            if (var.equals(r.getAdditionalVariableReference())) {
                replacement.remove();
                continue;
            }
            if (r instanceof ArrayReference) {
                if (maxIndex < ((ArrayReference)r).getArrayLength()) continue;
                replacement.remove();
                continue;
            }
            if (replacingPrimitive || !(test.getStatement(r.getStPosition()) instanceof PrimitiveStatement)) continue;
            replacement.remove();
        }
        if (!alternatives.isEmpty()) {
            for (int i = position + 1; i < test.size(); ++i) {
                s = test.getStatement(i);
                if (!s.references(var)) continue;
                if (s.isAssignmentStatement()) {
                    VariableReference replacementVar;
                    AssignmentStatement assignment = (AssignmentStatement)s;
                    if (assignment.getValue() == var) {
                        replacementVar = Randomness.choice(alternatives);
                        if (!assignment.getReturnValue().isAssignableFrom(replacementVar)) continue;
                        s.replace(var, replacementVar);
                        continue;
                    }
                    if (assignment.getReturnValue() != var || !(replacementVar = Randomness.choice(alternatives)).isAssignableFrom(assignment.getValue())) continue;
                    s.replace(var, replacementVar);
                    continue;
                }
                s.replace(var, Randomness.choice(alternatives));
            }
        }
        if (var instanceof ArrayReference) {
            alternatives = test.getObjects(var.getComponentType(), position);
            alternatives.remove(var);
            replacement = alternatives.iterator();
            while (replacement.hasNext()) {
                VariableReference r = replacement.next();
                if (var.equals(r.getAdditionalVariableReference())) {
                    replacement.remove();
                    continue;
                }
                if (!(r instanceof ArrayReference) || maxIndex < ((ArrayReference)r).getArrayLength()) continue;
                replacement.remove();
            }
            if (!alternatives.isEmpty()) {
                for (int i = position; i < test.size(); ++i) {
                    s = test.getStatement(i);
                    for (VariableReference var2 : s.getVariableReferences()) {
                        ArrayIndex ai;
                        if (!(var2 instanceof ArrayIndex) || !(ai = (ArrayIndex)var2).getArray().equals(var)) continue;
                        s.replace(var2, Randomness.choice(alternatives));
                    }
                }
            }
        }
        this.deleteStatement(test, position);
    }

    private static boolean dependenciesSatisfied(Set<Type> dependencies, List<VariableReference> objects) {
        for (Type type : dependencies) {
            boolean found = false;
            for (VariableReference var : objects) {
                if (!var.getType().equals(type)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private static Set<Type> getDependencies(GenericConstructor constructor) {
        LinkedHashSet<Type> dependencies = new LinkedHashSet<Type>();
        for (Type type : constructor.getParameterTypes()) {
            dependencies.add(type);
        }
        return dependencies;
    }

    private static Set<Type> getDependencies(GenericField field) {
        LinkedHashSet<Type> dependencies = new LinkedHashSet<Type>();
        if (!field.isStatic()) {
            dependencies.add(field.getOwnerType());
        }
        return dependencies;
    }

    private static Set<Type> getDependencies(GenericMethod method) {
        LinkedHashSet<Type> dependencies = new LinkedHashSet<Type>();
        if (!method.isStatic()) {
            dependencies.add(method.getOwnerType());
        }
        for (Type type : method.getParameterTypes()) {
            dependencies.add(type);
        }
        return dependencies;
    }

    private List<GenericAccessibleObject<?>> getPossibleCalls(Type returnType, List<VariableReference> objects) {
        Set<GenericAccessibleObject<?>> allCalls;
        ArrayList calls = new ArrayList();
        try {
            allCalls = TestCluster.getInstance().getGenerators(new GenericClass(returnType), true);
        }
        catch (ConstructionFailedException e) {
            return calls;
        }
        for (GenericAccessibleObject<Object> call : allCalls) {
            Set<Type> dependencies = null;
            if (call.isMethod()) {
                GenericMethod method = (GenericMethod)call;
                if (method.hasTypeParameters()) {
                    try {
                        call = method.getGenericInstantiation(new GenericClass(returnType));
                    }
                    catch (ConstructionFailedException e) {
                        continue;
                    }
                }
                if (!((GenericMethod)call).getReturnType().equals(returnType)) continue;
                dependencies = TestFactory.getDependencies((GenericMethod)call);
            } else if (call.isConstructor()) {
                dependencies = TestFactory.getDependencies((GenericConstructor)call);
            } else if (call.isField()) {
                if (!((GenericField)call).getFieldType().equals(returnType)) continue;
                dependencies = TestFactory.getDependencies((GenericField)call);
            } else assert (false);
            if (!TestFactory.dependenciesSatisfied(dependencies, objects)) continue;
            calls.add(call);
        }
        return calls;
    }

    private boolean insertRandomReflectionCall(TestCase test, int position, int recursionDepth) throws ConstructionFailedException {
        logger.debug("Recursion depth: " + recursionDepth);
        if (recursionDepth > Properties.MAX_RECURSION) {
            logger.debug("Max recursion depth reached");
            throw new ConstructionFailedException("Max recursion depth reached");
        }
        int length = test.size();
        List<VariableReference> parameters = null;
        MethodStatement st = null;
        if (this.reflectionFactory.nextUseField()) {
            Field field = this.reflectionFactory.nextField();
            parameters = this.satisfyParameters(test, null, Arrays.asList(this.reflectionFactory.getReflectedClass(), field.getType()), position, recursionDepth + 1);
            try {
                st = new PrivateFieldStatement(test, this.reflectionFactory.getReflectedClass(), field.getName(), parameters.get(0), parameters.get(1));
            }
            catch (NoSuchFieldException e) {
                logger.error("Reflection problem: " + e, (Throwable)e);
                throw new ConstructionFailedException("Reflection problem");
            }
        }
        Method method = this.reflectionFactory.nextMethod();
        ArrayList<Type> list = new ArrayList<Type>();
        list.add(this.reflectionFactory.getReflectedClass());
        list.addAll(Arrays.asList(method.getParameterTypes()));
        parameters = this.satisfyParameters(test, null, list, position, recursionDepth + 1);
        VariableReference callee = parameters.remove(0);
        try {
            st = new PrivateMethodStatement(test, this.reflectionFactory.getReflectedClass(), method.getName(), callee, parameters);
        }
        catch (NoSuchFieldException e) {
            logger.error("Reflection problem: " + e, (Throwable)e);
            throw new ConstructionFailedException("Reflection problem");
        }
        int newLength = test.size();
        test.addStatement(st, position += newLength - length);
        return true;
    }

    public boolean insertRandomCall(TestCase test, int position) {
        int previousLength = test.size();
        String name = "";
        this.currentRecursion.clear();
        logger.debug("Inserting random call at position " + position);
        try {
            if (this.reflectionFactory == null) {
                this.reflectionFactory = new ReflectionFactory(Properties.getTargetClass());
            }
            if (this.reflectionFactory.hasPrivateFieldsOrMethods() && TimeController.getInstance().getPhasePercentage() >= Properties.REFLECTION_START_PERCENT && Randomness.nextDouble() < Properties.P_REFLECTION_ON_PRIVATE) {
                return this.insertRandomReflectionCall(test, position, 0);
            }
            GenericAccessibleObject<?> o = TestCluster.getInstance().getRandomTestCall();
            if (o == null) {
                logger.warn("Have no target methods to test");
                return false;
            }
            if (o.isConstructor()) {
                GenericConstructor c = (GenericConstructor)o;
                logger.debug("Adding constructor call " + c.getName());
                name = c.getName();
                this.addConstructor(test, c, position, 0);
            } else if (o.isMethod()) {
                GenericMethod m = (GenericMethod)o;
                logger.debug("Adding method call " + m.getName());
                name = m.getName();
                if (!m.isStatic()) {
                    logger.debug("Getting callee of type " + m.getOwnerClass().getTypeName());
                    VariableReference callee = null;
                    Type target = m.getOwnerType();
                    if (!test.hasObject(target, position)) {
                        callee = this.createObject(test, target, position, 0);
                        position += test.size() - previousLength;
                        previousLength = test.size();
                    } else {
                        callee = test.getRandomNonNullObject(target, position);
                    }
                    logger.debug("Got callee of type " + callee.getGenericClass().getTypeName());
                    if (!TestClusterGenerator.canUse(m.getMethod(), callee.getVariableClass())) {
                        logger.debug("Cannot call method " + m + " with callee of type " + callee.getClassName());
                        throw new ConstructionFailedException("Cannot apply method to this callee");
                    }
                    this.addMethodFor(test, callee, m.copyWithNewOwner(callee.getGenericClass()), position);
                } else {
                    this.addMethod(test, m, position, 0);
                }
            } else if (o.isField()) {
                GenericField f = (GenericField)o;
                name = f.getName();
                logger.debug("Adding field " + f.getName());
                if (Randomness.nextBoolean()) {
                    this.addFieldAssignment(test, f, position, 0);
                } else {
                    this.addField(test, f, position, 0);
                }
            } else {
                logger.error("Got type other than method or constructor!");
                return false;
            }
            return true;
        }
        catch (ConstructionFailedException e) {
            logger.debug("Inserting statement " + name + " has failed. Removing statements: " + e);
            int lengthDifference = test.size() - previousLength;
            for (int i = lengthDifference - 1; i >= 0; --i) {
                logger.debug("  Removing statement: " + test.getStatement(position + i).getCode());
                test.remove(position + i);
            }
            return false;
        }
    }

    public boolean insertRandomCallOnObject(TestCase test, int position) {
        VariableReference var = this.selectVariableForCall(test, position);
        boolean success = false;
        if (var != null) {
            logger.debug("Inserting call at position " + position + ", chosen var: " + var.getName() + ", distance: " + var.getDistance() + ", class: " + var.getClassName());
            success = this.insertRandomCallOnObjectAt(test, var, position);
        }
        if (!success && TestCluster.getInstance().getNumTestCalls() > 0) {
            logger.debug("Adding new call on UUT because var was null");
            success = this.insertRandomCall(test, position);
        }
        return success;
    }

    public boolean insertRandomCallOnObjectAt(TestCase test, VariableReference var, int position) {
        logger.debug("Chosen object: " + var.getName());
        if (var instanceof ArrayReference) {
            logger.debug("Chosen object is array ");
            ArrayReference array = (ArrayReference)var;
            if (array.getArrayLength() > 0) {
                for (int i = 0; i < array.getArrayLength(); ++i) {
                    logger.debug("Assigning array index " + i);
                    int old_len = test.size();
                    try {
                        this.assignArray(test, array, i, position);
                        position += test.size() - old_len;
                        continue;
                    }
                    catch (ConstructionFailedException e) {
                        // empty catch block
                    }
                }
                return true;
            }
        } else if (var.getGenericClass().hasWildcardOrTypeVariables()) {
            logger.debug("Cannot add calls on unknown type");
        } else {
            logger.debug("Getting calls for object " + var.toString());
            try {
                GenericAccessibleObject<?> call = TestCluster.getInstance().getRandomCallFor(var.getGenericClass());
                logger.debug("Chosen call " + call);
                return this.addCallFor(test, var, call, position);
            }
            catch (ConstructionFailedException e) {
                logger.debug("Found no modifier: " + e);
            }
        }
        return false;
    }

    public int insertRandomStatement(TestCase test, int lastPosition) {
        double P = Properties.INSERTION_SCORE_UUT + Properties.INSERTION_SCORE_OBJECT + Properties.INSERTION_SCORE_PARAMETER;
        double P_UUT = (double)Properties.INSERTION_SCORE_UUT / P;
        double P_OBJECT = P_UUT + (double)Properties.INSERTION_SCORE_OBJECT / P;
        int oldSize = test.size();
        double r = Randomness.nextDouble();
        int max = lastPosition;
        if (max == test.size()) {
            ++max;
        }
        if (max <= 0) {
            max = 1;
        }
        int position = Randomness.nextInt(max);
        if (logger.isDebugEnabled()) {
            logger.debug(test.toCode());
        }
        boolean success = false;
        if (r <= Properties.INSERTION_UUT && TestCluster.getInstance().getNumTestCalls() > 0) {
            logger.debug("Adding new call on UUT");
            success = this.insertRandomCall(test, position);
            if (test.size() - oldSize > 1) {
                position += test.size() - oldSize - 1;
            }
        } else {
            logger.debug("Adding new call on existing object");
            success = this.insertRandomCallOnObject(test, position);
            if (test.size() - oldSize > 1) {
                position += test.size() - oldSize - 1;
            }
        }
        if (success) {
            return position;
        }
        return -1;
    }

    private List<VariableReference> satisfyParameters(TestCase test, VariableReference callee, List<Type> parameterTypes, int position, int recursionDepth) throws ConstructionFailedException {
        ArrayList<VariableReference> parameters = new ArrayList<VariableReference>();
        logger.debug("Trying to satisfy " + parameterTypes.size() + " parameters");
        for (Type parameterType : parameterTypes) {
            logger.debug("Current parameter type: " + parameterType);
            if (parameterType instanceof CaptureType) {
                throw new ConstructionFailedException("Cannot satisfy capture type");
            }
            GenericClass parameterClass = new GenericClass(parameterType);
            if (parameterClass.hasTypeVariables()) {
                logger.debug("Parameter has type variables, replacing with wildcard");
                parameterType = parameterClass.getWithWildcardTypes().getType();
            }
            int previousLength = test.size();
            VariableReference var = this.createOrReuseVariable(test, parameterType, position, recursionDepth, callee, true);
            if (!var.isAssignableTo(parameterType)) {
                throw new ConstructionFailedException("Error");
            }
            parameters.add(var);
            int currentLength = test.size();
            position += currentLength - previousLength;
        }
        logger.debug("Satisfied " + parameterTypes.size() + " parameters");
        return parameters;
    }

    private VariableReference selectVariableForCall(TestCase test, int position) {
        VariableReference var;
        if (test.isEmpty() || position == 0) {
            return null;
        }
        double sum = 0.0;
        for (int i = 0; i < position; ++i) {
            sum += 1.0 / ((double)test.getStatement(i).getReturnValue().getDistance() + 1.0);
            if (!logger.isDebugEnabled()) continue;
            logger.debug(test.getStatement(i).getCode() + ": Distance = " + test.getStatement(i).getReturnValue().getDistance());
        }
        double rnd = Randomness.nextDouble() * sum;
        for (int i = 0; i < position; ++i) {
            double dist = 1.0 / ((double)test.getStatement(i).getReturnValue().getDistance() + 1.0);
            if (!(!(dist >= rnd) || test.getStatement(i).getReturnValue() instanceof NullReference || test.getStatement(i).getReturnValue().isPrimitive() || test.getStatement(i).getReturnValue().isVoid() || test.getStatement(i) instanceof PrimitiveStatement)) {
                return test.getStatement(i).getReturnValue();
            }
            rnd -= dist;
        }
        if (position > 0) {
            position = Randomness.nextInt(position);
        }
        if (!((var = test.getStatement(position).getReturnValue()) instanceof NullReference || var.isVoid() || test.getStatement(position) instanceof PrimitiveStatement || var.isPrimitive())) {
            return var;
        }
        return null;
    }

    private VariableReference selectRandomVariableForCall(TestCase test, int position) {
        if (test.isEmpty() || position == 0) {
            return null;
        }
        List<VariableReference> allVariables = test.getObjects(position);
        LinkedHashSet<VariableReference> candidateVariables = new LinkedHashSet<VariableReference>();
        for (VariableReference var : allVariables) {
            if (var instanceof NullReference || var.isVoid() || test.getStatement(var.getStPosition()) instanceof PrimitiveStatement || var.isPrimitive()) continue;
            candidateVariables.add(var);
        }
        if (candidateVariables.isEmpty()) {
            return null;
        }
        VariableReference choice = (VariableReference)Randomness.choice(candidateVariables);
        return choice;
    }
}

