/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.TestVisitor;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.statements.ArrayStatement;
import org.evosuite.testcase.statements.AssignmentStatement;
import org.evosuite.testcase.statements.ConstructorStatement;
import org.evosuite.testcase.statements.FieldStatement;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.NullStatement;
import org.evosuite.testcase.statements.PrimitiveExpression;
import org.evosuite.testcase.statements.PrimitiveStatement;
import org.evosuite.testcase.statements.StringPrimitiveStatement;
import org.evosuite.testcase.statements.numeric.BooleanPrimitiveStatement;
import org.evosuite.testcase.statements.numeric.NumericalPrimitiveStatement;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueMinimizer
extends TestVisitor {
    private static Logger logger = LoggerFactory.getLogger(ValueMinimizer.class);
    private Minimization objective;

    public void minimize(TestChromosome test, TestFitnessFunction objective) {
        this.objective = new TestMinimization(objective, test);
        test.test.accept(this);
    }

    public void minimize(TestSuiteChromosome suite, TestSuiteFitnessFunction objective) {
        int i = 0;
        for (TestChromosome test : suite.getTestChromosomes()) {
            this.objective = new SuiteMinimization(objective, suite, i);
            test.test.accept(this);
            ++i;
        }
    }

    private <T> void binarySearch(NumericalPrimitiveStatement<T> statement) {
        PrimitiveStatement<?> zero = PrimitiveStatement.getPrimitiveStatement(statement.getTestCase(), statement.getReturnValue().getGenericClass());
        Object max = statement.getValue();
        Object min = zero.getValue();
        boolean positive = statement.isPositive();
        Object lastValue = null;
        boolean done = false;
        while (!done) {
            double oldVal;
            Object oldValue = statement.getValue();
            statement.setMid(min, max);
            Object newValue = statement.getValue();
            if (oldValue.equals(newValue) || lastValue != null && lastValue.equals(newValue)) break;
            if (lastValue instanceof Double && (oldVal = Math.abs((Double)lastValue)) < 1.0) {
                newValue = new Double(0.0);
                statement.setValue(newValue);
                if (this.objective.isNotWorse()) break;
                statement.setValue(lastValue);
                break;
            }
            if (lastValue instanceof Float && (oldVal = (double)Math.abs(((Float)lastValue).floatValue())) < 1.0) {
                newValue = new Float(0.0f);
                statement.setValue(newValue);
                if (this.objective.isNotWorse()) break;
                statement.setValue(lastValue);
                break;
            }
            lastValue = newValue;
            logger.info("Trying " + statement.getValue() + " " + min + "/" + max + " - " + statement.getClass());
            if (min.equals(max) || statement.getValue().equals(min) || statement.getValue().equals(max)) {
                done = true;
                logger.info("Fixpoint.");
            }
            if (this.objective.isNotWorse()) {
                logger.info("Fitness hasn't decreased");
                max = statement.getValue();
                continue;
            }
            logger.info("Fitness has decreased!");
            if (positive) {
                statement.increment();
            } else {
                statement.decrement();
            }
            min = statement.getValue();
            statement.setValue(max);
        }
    }

    private void removeCharacters(StringPrimitiveStatement p) {
        String oldString = (String)p.getValue();
        for (int i = oldString.length() - 1; i >= 0; --i) {
            String newString = oldString.substring(0, i) + oldString.substring(i + 1);
            p.setValue(newString);
            if (this.objective.isNotWorse()) {
                oldString = (String)p.getValue();
                continue;
            }
            p.setValue(oldString);
        }
    }

    private void cleanString(StringPrimitiveStatement statement) {
        String oldString = (String)statement.getValue();
        String newString = oldString.replaceAll("[^\\p{ASCII}]", "").replaceAll("\\p{Cntrl}", "");
        statement.setValue(newString);
        if (!this.objective.isNotWorse()) {
            statement.setValue(oldString);
            newString = oldString;
        }
        oldString = newString;
        newString = newString.replaceAll("[^\\p{L}\\p{N}]", "");
        statement.setValue(newString);
        if (!this.objective.isNotWorse()) {
            statement.setValue(oldString);
        }
        this.removeCharacters(statement);
    }

    @Override
    public void visitTestCase(TestCase test) {
    }

    @Override
    public void visitPrimitiveStatement(PrimitiveStatement<?> statement) {
        if (statement instanceof NumericalPrimitiveStatement) {
            if (statement instanceof BooleanPrimitiveStatement) {
                return;
            }
            logger.info("Statement before minimization: " + statement.getCode());
            this.binarySearch((NumericalPrimitiveStatement)statement);
            logger.info("Statement after minimization: " + statement.getCode());
        } else if (statement instanceof StringPrimitiveStatement) {
            logger.info("Statement before minimization: " + statement.getCode());
            this.cleanString((StringPrimitiveStatement)statement);
            logger.info("Statement after minimization: " + statement.getCode());
        }
    }

    @Override
    public void visitFieldStatement(FieldStatement statement) {
    }

    @Override
    public void visitMethodStatement(MethodStatement statement) {
    }

    @Override
    public void visitConstructorStatement(ConstructorStatement statement) {
    }

    @Override
    public void visitArrayStatement(ArrayStatement statement) {
    }

    @Override
    public void visitAssignmentStatement(AssignmentStatement statement) {
    }

    @Override
    public void visitNullStatement(NullStatement statement) {
    }

    @Override
    public void visitPrimitiveExpression(PrimitiveExpression primitiveExpression) {
        logger.warn("Method visitPrimitiveExpression not implemented!");
    }

    private static class SuiteMinimization
    implements Minimization {
        private final TestSuiteFitnessFunction fitness;
        private final TestSuiteChromosome suite;
        private final TestChromosome individual;
        private final int testIndex;
        private double lastFitness;
        private double lastCoverage;

        public SuiteMinimization(TestSuiteFitnessFunction fitness, TestSuiteChromosome suite, int index) {
            this.fitness = fitness;
            this.suite = suite;
            this.individual = (TestChromosome)suite.getTestChromosome(index);
            this.testIndex = index;
            this.lastFitness = suite.getFitness(fitness);
            this.lastCoverage = suite.getCoverage();
        }

        @Override
        public boolean isNotWorse() {
            ExecutionResult lastResult = this.individual.getLastExecutionResult().clone();
            this.individual.setChanged(true);
            this.suite.setTestChromosome(this.testIndex, this.individual);
            double newFitness = this.fitness.getFitness(this.suite);
            if (newFitness <= this.lastFitness) {
                logger.debug("Fitness changed from " + this.lastFitness + " to " + newFitness);
                this.lastFitness = newFitness;
                this.lastCoverage = this.suite.getCoverage();
                this.suite.setFitness(this.fitness, this.lastFitness);
                return true;
            }
            this.individual.setLastExecutionResult(lastResult);
            this.suite.setFitness(this.fitness, this.lastFitness);
            this.suite.setCoverage(this.fitness, this.lastCoverage);
            return false;
        }
    }

    private static class TestMinimization
    implements Minimization {
        private final TestFitnessFunction fitness;
        private final TestChromosome individual;
        private double lastFitness;

        public TestMinimization(TestFitnessFunction fitness, TestChromosome test) {
            this.fitness = fitness;
            this.individual = test;
            this.lastFitness = test.getFitness(fitness);
        }

        @Override
        public boolean isNotWorse() {
            this.individual.setChanged(true);
            double newFitness = this.fitness.getFitness(this.individual);
            if (newFitness <= this.lastFitness) {
                this.lastFitness = newFitness;
                this.individual.setFitness(this.fitness, this.lastFitness);
                return true;
            }
            this.individual.setFitness(this.fitness, this.lastFitness);
            return false;
        }
    }

    private static interface Minimization {
        public boolean isNotWorse();
    }
}

