/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.execution;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.evosuite.assertion.OutputTrace;
import org.evosuite.coverage.mutation.Mutation;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.ExecutionTrace;
import org.evosuite.testcase.execution.TestCaseExecutor;
import org.evosuite.testcase.statements.MethodStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionResult
implements Cloneable {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionResult.class);
    public TestCase test;
    public Mutation mutation;
    protected Map<Integer, Throwable> exceptions = new HashMap<Integer, Throwable>();
    public Map<Integer, Boolean> explicitExceptions = new HashMap<Integer, Boolean>();
    protected ExecutionTrace trace = null;
    protected long executionTime = 0L;
    protected int executedStatements = 0;
    protected boolean hasSecurityException = false;
    protected Set<String> readProperties;
    protected boolean wasAnyPropertyWritten;
    protected final Map<Class<?>, OutputTrace<?>> traces = new HashMap();
    private Map<MethodStatement, Object> returnValues;

    public int getExecutedStatements() {
        return this.executedStatements;
    }

    public void setExecutedStatements(int executedStatements) {
        this.executedStatements = executedStatements;
    }

    public ExecutionResult(TestCase t) {
        this.mutation = null;
        this.test = t;
    }

    public void setThrownExceptions(Map<Integer, Throwable> data) {
        this.exceptions.clear();
        for (Integer position : data.keySet()) {
            this.reportNewThrownException(position, data.get(position));
        }
    }

    public Integer getFirstPositionOfThrownException() {
        Integer min = null;
        for (Integer position : this.exceptions.keySet()) {
            if (min != null && position >= min) continue;
            min = position;
        }
        return min;
    }

    public void reportNewThrownException(Integer position, Throwable t) {
        this.exceptions.put(position, t);
    }

    public Set<Integer> getPositionsWhereExceptionsWereThrown() {
        return this.exceptions.keySet();
    }

    public Collection<Throwable> getAllThrownExceptions() {
        return this.exceptions.values();
    }

    public boolean isThereAnExceptionAtPosition(Integer position) {
        return this.exceptions.containsKey(position);
    }

    public boolean noThrownExceptions() {
        return this.exceptions.isEmpty();
    }

    public Throwable getExceptionThrownAtPosition(Integer position) {
        return this.exceptions.get(position);
    }

    public int getNumberOfThrownExceptions() {
        return this.exceptions.size();
    }

    @Deprecated
    public Map<Integer, Throwable> exposeExceptionMapping() {
        return this.exceptions;
    }

    public Map<Integer, Throwable> getCopyOfExceptionMapping() {
        HashMap<Integer, Throwable> copy = new HashMap<Integer, Throwable>();
        copy.putAll(this.exceptions);
        return copy;
    }

    public ExecutionResult(TestCase t, Mutation m) {
        this.mutation = m;
        this.test = t;
    }

    public ExecutionTrace getTrace() {
        return this.trace;
    }

    public void setTrace(ExecutionTrace trace) throws IllegalArgumentException {
        if (trace == null) {
            throw new IllegalArgumentException("Trace cannot be null");
        }
        this.trace = trace;
    }

    public void setTrace(OutputTrace<?> trace, Class<?> clazz) {
        this.traces.put(clazz, trace);
    }

    public OutputTrace<?> getTrace(Class<?> clazz) {
        return this.traces.get(clazz);
    }

    public Collection<OutputTrace<?>> getTraces() {
        return this.traces.values();
    }

    public boolean hasTimeout() {
        if (this.test == null) {
            return false;
        }
        int size = this.test.size();
        return this.exceptions.containsKey(size) && this.exceptions.get(size) instanceof TestCaseExecutor.TimeoutExceeded;
    }

    public boolean hasTestException() {
        if (this.test == null) {
            return false;
        }
        for (Throwable t : this.exceptions.values()) {
            if (!(t instanceof CodeUnderTestException)) continue;
            return true;
        }
        return false;
    }

    public boolean hasUndeclaredException() {
        if (this.test == null) {
            return false;
        }
        for (Integer i : this.exceptions.keySet()) {
            Throwable t = this.exceptions.get(i);
            assert (i >= 0 && i < this.test.size());
            if (i >= this.test.size() || this.test.getStatement(i).getDeclaredExceptions().contains(t.getClass())) continue;
            return true;
        }
        return false;
    }

    public boolean hasSecurityException() {
        return this.hasSecurityException;
    }

    public void setSecurityException(boolean value) {
        logger.debug("Changing hasSecurityException from " + this.hasSecurityException + " to " + value);
        this.hasSecurityException = value;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public void setExecutionTime(long executionTime) {
        this.executionTime = executionTime;
    }

    public ExecutionResult clone() {
        ExecutionResult copy = new ExecutionResult(this.test, this.mutation);
        copy.exceptions.putAll(this.exceptions);
        copy.trace = this.trace.lazyClone();
        copy.explicitExceptions.putAll(this.explicitExceptions);
        copy.executionTime = this.executionTime;
        for (Class<?> clazz : this.traces.keySet()) {
            copy.traces.put(clazz, (OutputTrace<?>)this.traces.get(clazz).clone());
        }
        if (this.readProperties != null) {
            copy.readProperties = new LinkedHashSet<String>();
            copy.readProperties.addAll(this.readProperties);
        }
        copy.wasAnyPropertyWritten = this.wasAnyPropertyWritten;
        return copy;
    }

    public String toString() {
        String result = "";
        result = result + "Trace:";
        result = result + this.trace;
        return result;
    }

    public Set<String> getReadProperties() {
        return this.readProperties;
    }

    public void setReadProperties(Set<String> readProperties) {
        this.readProperties = readProperties;
    }

    public boolean wasAnyPropertyWritten() {
        return this.wasAnyPropertyWritten;
    }

    public void setWasAnyPropertyWritten(boolean wasAnyPropertyWritten) {
        this.wasAnyPropertyWritten = wasAnyPropertyWritten;
    }

    public Map<MethodStatement, Object> getReturnValues() {
        if (this.returnValues == null) {
            this.returnValues = new HashMap<MethodStatement, Object>();
        }
        return this.returnValues;
    }

    public void setReturnValues(Map<MethodStatement, Object> returnValues) {
        this.returnValues = returnValues;
    }
}

