/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.execution;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.coverage.dataflow.DefUse;
import org.evosuite.setup.CallContext;
import org.evosuite.testcase.execution.ExecutionTrace;
import org.evosuite.testcase.execution.ExecutionTraceImpl;
import org.evosuite.testcase.execution.MethodCall;

public class ExecutionTraceProxy
implements ExecutionTrace,
Cloneable {
    private ExecutionTraceImpl trace;

    public ExecutionTraceProxy() {
        this.trace = new ExecutionTraceImpl();
    }

    public ExecutionTraceProxy(ExecutionTraceImpl trace) {
        this.trace = trace;
    }

    @Override
    public void branchPassed(int branch, int bytecode_id, double true_distance, double false_distance) {
        this.copyOnWrite();
        this.trace.branchPassed(branch, bytecode_id, true_distance, false_distance);
    }

    @Override
    public void clear() {
        this.copyOnWrite();
        this.trace.clear();
    }

    public void copyOnWrite() {
        if (this.trace.getProxyCount() > 1) {
            this.trace.removeProxy();
            this.trace = this.trace.clone();
        }
    }

    @Override
    public void definitionPassed(Object object, Object caller, int defID) {
        this.copyOnWrite();
        this.trace.definitionPassed(object, caller, defID);
    }

    @Override
    public void enteredMethod(String className, String methodName, Object caller) {
        this.copyOnWrite();
        this.trace.enteredMethod(className, methodName, caller);
    }

    @Override
    public void exitMethod(String classname, String methodname) {
        this.copyOnWrite();
        this.trace.exitMethod(classname, methodname);
    }

    @Override
    public void finishCalls() {
        this.copyOnWrite();
        this.trace.finishCalls();
    }

    @Override
    public Map<String, Map<String, Map<Integer, Integer>>> getCoverageData() {
        return this.trace.getCoverageData();
    }

    @Override
    public Set<Integer> getCoveredFalseBranches() {
        return this.trace.getCoveredFalseBranches();
    }

    @Override
    public Set<Integer> getCoveredLines(String className) {
        return this.trace.getCoveredLines(className);
    }

    @Override
    public Set<Integer> getCoveredLines() {
        return this.trace.getCoveredLines();
    }

    @Override
    public Set<String> getCoveredMethods() {
        return this.trace.getCoveredMethods();
    }

    @Override
    public Set<String> getCoveredBranchlessMethods() {
        return this.trace.getCoveredBranchlessMethods();
    }

    @Override
    public Set<Integer> getCoveredPredicates() {
        return this.trace.getCoveredPredicates();
    }

    @Override
    public Set<Integer> getCoveredTrueBranches() {
        return this.trace.getCoveredTrueBranches();
    }

    @Override
    public Set<Integer> getCoveredDefinitions() {
        return this.trace.getCoveredDefinitions();
    }

    @Override
    public Map<Integer, Integer> getDefinitionExecutionCount() {
        return this.trace.getDefinitionExecutionCount();
    }

    @Override
    public Map<String, HashMap<Integer, HashMap<Integer, Integer>>> getDefinitionData() {
        return this.trace.getDefinitionData();
    }

    @Override
    public Map<String, HashMap<Integer, HashMap<Integer, Object>>> getDefinitionDataObjects() {
        return this.trace.getDefinitionDataObjects();
    }

    @Override
    public Throwable getExplicitException() {
        return this.trace.getExplicitException();
    }

    @Override
    public double getFalseDistance(int branchId) {
        return this.trace.getFalseDistance(branchId);
    }

    @Override
    public Map<Integer, Double> getFalseDistances() {
        return this.trace.getFalseDistances();
    }

    @Override
    public List<MethodCall> getMethodCalls() {
        return this.trace.getMethodCalls();
    }

    @Override
    public Map<String, Integer> getMethodExecutionCount() {
        return this.trace.getMethodExecutionCount();
    }

    @Override
    public double getMutationDistance(int mutationId) {
        return this.trace.getMutationDistance(mutationId);
    }

    @Override
    public Map<Integer, Double> getMutationDistances() {
        return this.trace.getMutationDistances();
    }

    @Override
    public Map<Integer, HashMap<Integer, Integer>> getPassedDefinitions(String variableName) {
        return this.trace.getPassedDefinitions(variableName);
    }

    @Override
    public Map<Integer, HashMap<Integer, Integer>> getPassedUses(String variableName) {
        return this.trace.getPassedUses(variableName);
    }

    @Override
    public Map<Integer, Integer> getPredicateExecutionCount() {
        return this.trace.getPredicateExecutionCount();
    }

    @Override
    public Map<String, Map<String, Map<Integer, Integer>>> getReturnData() {
        return this.trace.getReturnData();
    }

    @Override
    public Set<Integer> getTouchedMutants() {
        return this.trace.getTouchedMutants();
    }

    @Override
    public Set<Integer> getInfectedMutants() {
        return this.trace.getInfectedMutants();
    }

    @Override
    public ExecutionTrace getTraceForObject(int objectId) {
        return this.trace.getTraceForObject(objectId);
    }

    @Override
    public ExecutionTrace getTraceInDUCounterRange(DefUse targetDU, boolean wantToCoverTargetDU, int duCounterStart, int duCounterEnd) {
        return this.trace.getTraceInDUCounterRange(targetDU, wantToCoverTargetDU, duCounterStart, duCounterEnd);
    }

    @Override
    public double getTrueDistance(int branchId) {
        return this.trace.getTrueDistance(branchId);
    }

    @Override
    public Map<Integer, Double> getTrueDistances() {
        return this.trace.getTrueDistances();
    }

    @Override
    public Map<String, HashMap<Integer, HashMap<Integer, Integer>>> getUseData() {
        return this.trace.getUseData();
    }

    @Override
    public Map<String, HashMap<Integer, HashMap<Integer, Object>>> getUseDataObjects() {
        return this.trace.getUseDataObjects();
    }

    @Override
    public boolean hasFalseDistance(int predicateId) {
        return this.trace.hasFalseDistance(predicateId);
    }

    @Override
    public boolean hasTrueDistance(int predicateId) {
        return this.trace.hasTrueDistance(predicateId);
    }

    @Override
    public ExecutionTrace lazyClone() {
        ExecutionTraceProxy copy = new ExecutionTraceProxy(this.trace);
        this.trace.addProxy();
        return copy;
    }

    @Override
    public void linePassed(String className, String methodName, int line) {
        this.copyOnWrite();
        this.trace.linePassed(className, methodName, line);
    }

    @Override
    public void mutationPassed(int mutationId, double distance) {
        this.copyOnWrite();
        this.trace.mutationPassed(mutationId, distance);
    }

    @Override
    public void returnValue(String className, String methodName, int value) {
        this.copyOnWrite();
        this.trace.returnValue(className, methodName, value);
    }

    @Override
    public void setExplicitException(Throwable explicitException) {
        this.copyOnWrite();
        this.trace.setExplicitException(explicitException);
    }

    @Override
    public String toDefUseTraceInformation() {
        return this.trace.toDefUseTraceInformation();
    }

    @Override
    public String toDefUseTraceInformation(String targetVar) {
        return this.trace.toDefUseTraceInformation(targetVar);
    }

    @Override
    public String toDefUseTraceInformation(String var, int objectId) {
        return this.trace.toDefUseTraceInformation(var, objectId);
    }

    @Override
    public void usePassed(Object object, Object caller, int useID) {
        this.copyOnWrite();
        this.trace.usePassed(object, caller, useID);
    }

    @Override
    public boolean wasMutationTouched(int mutationId) {
        return this.trace.wasMutationTouched(mutationId);
    }

    @Override
    public List<ExecutionTraceImpl.BranchEval> getBranchesTrace() {
        return this.trace.getBranchesTrace();
    }

    @Override
    public Map<Integer, Double> getFalseDistancesSum() {
        return this.trace.getTrueDistancesSum();
    }

    @Override
    public Map<Integer, Double> getTrueDistancesSum() {
        return this.trace.getTrueDistancesSum();
    }

    @Override
    public Map<String, HashMap<Integer, HashMap<Integer, Integer>>> getPassedUses() {
        return this.trace.getPassedUses();
    }

    @Override
    public Set<Integer> getPassedDefIDs() {
        return this.trace.getPassedDefIDs();
    }

    @Override
    public Set<Integer> getPassedUseIDs() {
        return this.trace.getPassedUseIDs();
    }

    @Override
    public Map<Integer, Map<CallContext, Double>> getTrueDistancesContext() {
        return this.trace.getTrueDistancesContext();
    }

    @Override
    public Map<Integer, Map<CallContext, Double>> getFalseDistancesContext() {
        return this.trace.getFalseDistancesContext();
    }

    @Override
    public Map<Integer, Map<CallContext, Integer>> getPredicateContextExecutionCount() {
        return this.trace.getPredicateContextExecutionCount();
    }

    @Override
    public Map<String, Map<CallContext, Integer>> getMethodContextCount() {
        return this.trace.getMethodContextCount();
    }

    @Override
    public void putStaticPassed(String classNameWithDots, String fieldName) {
        this.trace.putStaticPassed(classNameWithDots, fieldName);
    }

    @Override
    public Set<String> getClassesForStaticReset() {
        return this.trace.getClassesForStaticReset();
    }
}

